/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.io;

import com.pivotal.gemfirexd.internal.impl.io.BaseStorageFactory;
import com.pivotal.gemfirexd.internal.impl.io.URLFile;
import com.pivotal.gemfirexd.internal.io.StorageFile;
import java.io.IOException;

public class URLStorageFactory
extends BaseStorageFactory {
    @Override
    StorageFile newPersistentFile(String path) {
        return new URLFile(this, path);
    }

    @Override
    StorageFile newPersistentFile(String directoryName, String fileName) {
        if (directoryName == null || directoryName.length() == 0) {
            return this.newPersistentFile(fileName);
        }
        return new URLFile(this, directoryName, fileName);
    }

    @Override
    StorageFile newPersistentFile(StorageFile directoryName, String fileName) {
        if (directoryName == null) {
            return this.newPersistentFile(fileName);
        }
        return new URLFile((URLFile)directoryName, fileName);
    }

    @Override
    void doInit() throws IOException {
        if (this.dataDirectory != null) {
            if (this.dataDirectory.endsWith("/")) {
                this.separatedDataDirectory = this.dataDirectory;
                this.dataDirectory = this.dataDirectory.substring(0, this.dataDirectory.length() - 1);
            } else {
                this.separatedDataDirectory = this.dataDirectory + '/';
            }
            this.canonicalName = this.dataDirectory;
            this.createTempDir();
        }
    }
}

