/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.io;

import com.pivotal.gemfirexd.internal.impl.io.BaseStorageFactory;
import com.pivotal.gemfirexd.internal.impl.io.InputStreamFile;
import com.pivotal.gemfirexd.internal.impl.io.URLStorageFactory;
import com.pivotal.gemfirexd.internal.io.StorageFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

class URLFile
extends InputStreamFile {
    private final URLStorageFactory storageFactory;

    URLFile(URLStorageFactory storageFactory, String path) {
        super(storageFactory, path);
        this.storageFactory = storageFactory;
    }

    URLFile(URLStorageFactory storageFactory, String parent, String name) {
        super((BaseStorageFactory)storageFactory, parent, name);
        this.storageFactory = storageFactory;
    }

    URLFile(URLFile dir, String name) {
        super(dir, name);
        this.storageFactory = dir.storageFactory;
    }

    private URLFile(URLStorageFactory storageFactory, String child, int pathLen) {
        super((BaseStorageFactory)storageFactory, child, pathLen);
        this.storageFactory = storageFactory;
    }

    @Override
    public boolean exists() {
        try {
            InputStream is = this.getInputStream();
            if (is == null) {
                return false;
            }
            is.close();
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    @Override
    StorageFile getParentDir(int pathLen) {
        return new URLFile(this.storageFactory, this.path, pathLen);
    }

    @Override
    public InputStream getInputStream() throws FileNotFoundException {
        try {
            URL url = new URL(this.path);
            return url.openStream();
        }
        catch (IOException ioe) {
            throw new FileNotFoundException(this.path);
        }
    }
}

