/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.types;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.internal.ByteArrayDataInput;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.NullDataOutputStream;
import com.gemstone.gemfire.internal.offheap.ByteSource;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.cache.ClassSize;
import com.pivotal.gemfirexd.internal.iapi.services.io.ArrayInputStream;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassInspector;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.types.BooleanDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.DataType;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLBoolean;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDate;
import com.pivotal.gemfirexd.internal.iapi.types.SQLTime;
import com.pivotal.gemfirexd.internal.iapi.types.SQLTimestamp;
import com.pivotal.gemfirexd.internal.iapi.types.UserDataValue;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class UserType
extends DataType
implements UserDataValue {
    private Object value;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(UserType.class);
    private final HeapDataOutputStream.ExpansionExceptionGenerator DISALLOW_EXPANSION = new HeapDataOutputStream.ExpansionExceptionGenerator(){

        public Error newExpansionException(String method) {
            return new InternalGemFireError("writeBytes: unexpected overflow of user-defined type " + UserType.this.toString() + " in " + method);
        }
    };

    @Override
    public int estimateMemoryUsage() {
        int sz = BASE_MEMORY_USAGE;
        if (null != this.value) {
            sz += ClassSize.estimateAndCatalogBase(this.value.getClass());
        }
        return sz;
    }

    @Override
    public String getString() {
        if (!this.isNull()) {
            return this.value.toString();
        }
        return null;
    }

    @Override
    public boolean getBoolean() throws StandardException {
        if (!this.isNull() && this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        return super.getBoolean();
    }

    @Override
    public byte getByte() throws StandardException {
        if (!this.isNull() && this.value instanceof Number) {
            return ((Number)this.value).byteValue();
        }
        return super.getByte();
    }

    @Override
    public short getShort() throws StandardException {
        if (!this.isNull() && this.value instanceof Number) {
            return ((Number)this.value).shortValue();
        }
        return super.getShort();
    }

    @Override
    public int getInt() throws StandardException {
        if (!this.isNull() && this.value instanceof Number) {
            return ((Number)this.value).intValue();
        }
        return super.getInt();
    }

    @Override
    public long getLong() throws StandardException {
        if (!this.isNull() && this.value instanceof Number) {
            return ((Number)this.value).longValue();
        }
        return super.getLong();
    }

    @Override
    public float getFloat() throws StandardException {
        if (!this.isNull() && this.value instanceof Number) {
            return ((Number)this.value).floatValue();
        }
        return super.getFloat();
    }

    @Override
    public double getDouble() throws StandardException {
        if (!this.isNull() && this.value instanceof Number) {
            return ((Number)this.value).doubleValue();
        }
        return super.getDouble();
    }

    @Override
    public byte[] getBytes() throws StandardException {
        if (!this.isNull()) {
            HeapDataOutputStream hdos = new HeapDataOutputStream();
            try {
                this.toDataForOptimizedResultHolder((DataOutput)hdos);
            }
            catch (IOException ioe) {
                throw GemFireXDRuntimeException.newRuntimeException("Exception in UserType.getBytes.", ioe);
            }
            byte[] buffer = new byte[hdos.size()];
            hdos.sendTo(buffer, 0);
            return buffer;
        }
        return null;
    }

    @Override
    public Date getDate(Calendar cal) throws StandardException {
        if (!this.isNull()) {
            if (this.value instanceof Date) {
                return (Date)this.value;
            }
            if (this.value instanceof Timestamp) {
                return new SQLTimestamp((Timestamp)this.value).getDate(cal);
            }
        }
        return super.getDate(cal);
    }

    @Override
    public Time getTime(Calendar cal) throws StandardException {
        if (!this.isNull()) {
            if (this.value instanceof Time) {
                return (Time)this.value;
            }
            if (this.value instanceof Timestamp) {
                return new SQLTimestamp((Timestamp)this.value).getTime(cal);
            }
        }
        return super.getTime(cal);
    }

    @Override
    public Timestamp getTimestamp(Calendar cal) throws StandardException {
        if (!this.isNull()) {
            if (this.value instanceof Timestamp) {
                return (Timestamp)this.value;
            }
            if (this.value instanceof Date) {
                return new SQLDate((Date)this.value).getTimestamp(cal);
            }
            if (this.value instanceof Time) {
                return new SQLTime((Time)this.value).getTimestamp(cal);
            }
        }
        return super.getTimestamp(cal);
    }

    @Override
    void setObject(Object theValue) {
        this.setValue(theValue);
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public String getTypeName() {
        return this.isNull() ? "JAVA_OBJECT" : ClassInspector.readableClassName(this.value.getClass());
    }

    @Override
    String getTypeName(String className) {
        return className;
    }

    @Override
    public int getTypeFormatId() {
        return 266;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SanityManager.ASSERT((!this.isNull() ? 1 : 0) != 0, (String)"writeExternal() is not supposed to be called for null values.");
        out.writeObject(this.value);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.value = in.readObject();
    }

    @Override
    public void readExternalFromArray(ArrayInputStream in) throws IOException, ClassNotFoundException {
        this.value = in.readObject();
    }

    @Override
    public DataValueDescriptor getClone() {
        return new UserType(this.value);
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new UserType();
    }

    @Override
    public void restoreToNull() {
        this.value = null;
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) throws SQLException {
        this.value = resultSet.getObject(colNumber);
    }

    @Override
    public int compare(DataValueDescriptor other) throws StandardException {
        int comparison;
        if (this.typePrecedence() < other.typePrecedence()) {
            return -Integer.signum(other.compare(this));
        }
        boolean thisNull = this.isNull();
        boolean otherNull = other.isNull();
        if (thisNull || otherNull) {
            if (!thisNull) {
                return -1;
            }
            if (!otherNull) {
                return 1;
            }
            return 0;
        }
        try {
            comparison = ((Comparable)this.value).compareTo(other.getObject());
        }
        catch (ClassCastException cce) {
            throw StandardException.newException("XCL15.S", (Object)this.getTypeName(), (Object)ClassInspector.readableClassName(other.getObject().getClass()));
        }
        if (comparison < 0) {
            comparison = -1;
        } else if (comparison > 0) {
            comparison = 1;
        }
        return comparison;
    }

    @Override
    public boolean compare(int op, DataValueDescriptor other, boolean orderedNulls, boolean unknownRV) throws StandardException {
        Object o;
        if (!orderedNulls && (this.isNull() || other.isNull())) {
            return unknownRV;
        }
        if (!(op != 2 || this.isNull() || other.isNull() || (o = this.getObject()) instanceof Comparable)) {
            return o.equals(other.getObject());
        }
        return super.compare(op, other, orderedNulls, unknownRV);
    }

    public UserType() {
    }

    public UserType(Object value) {
        this.value = value;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    protected void setFrom(DataValueDescriptor theValue) throws StandardException {
        this.setValue(theValue.getObject());
    }

    @Override
    public void setBigDecimal(Number theValue) {
        this.setValue(theValue);
    }

    @Override
    public void setValue(String theValue) {
        this.value = theValue == null ? null : theValue;
    }

    @Override
    public BooleanDataValue equals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.compare(2, right, true, false));
    }

    @Override
    public BooleanDataValue notEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, !left.compare(2, right, true, false));
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return this.value.toString();
    }

    public int hashCode() {
        if (this.isNull()) {
            return 0;
        }
        return this.value.hashCode();
    }

    @Override
    public int typePrecedence() {
        return 1000;
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public int writeBytes(byte[] outBytes, int offset, DataTypeDescriptor dtd) {
        SanityManager.ASSERT((!this.isNull() ? 1 : 0) != 0, (String)"writeBytes() is not supposed to be called for null values.");
        HeapDataOutputStream hdos = new HeapDataOutputStream(outBytes, offset, outBytes.length - offset);
        hdos.disallowExpansion(this.DISALLOW_EXPANSION);
        try {
            this.toDataForOptimizedResultHolder((DataOutput)hdos);
        }
        catch (IOException ioe) {
            throw GemFireXDRuntimeException.newRuntimeException("Exception in UserType.writeBytes.", ioe);
        }
        return hdos.size();
    }

    @Override
    public int getLengthInBytes(DataTypeDescriptor dtd) throws StandardException {
        if (!this.isNull()) {
            NullDataOutputStream ndos = new NullDataOutputStream();
            try {
                this.toDataForOptimizedResultHolder((DataOutput)ndos);
            }
            catch (IOException ioe) {
                throw GemFireXDRuntimeException.newRuntimeException("Exception in UserType.getLengthInBytes.", ioe);
            }
            return ndos.size();
        }
        return 0;
    }

    @Override
    public int readBytes(byte[] inBytes, int offset, int columnWidth) {
        if (columnWidth > 0) {
            try {
                ByteArrayDataInput dis = new ByteArrayDataInput();
                dis.initialize(inBytes, offset, columnWidth, null);
                this.value = DataSerializer.readObject((DataInput)dis);
            }
            catch (Exception ex) {
                throw GemFireXDRuntimeException.newRuntimeException("Exception in UserType.readBytes.", ex);
            }
            return columnWidth;
        }
        this.value = null;
        return 0;
    }

    @Override
    public int readBytes(long memOffset, int columnWidth, ByteSource bs) {
        if (columnWidth > 0) {
            OffHeapByteSource obs = (OffHeapByteSource)bs;
            try {
                DataInput dis = obs.getDataInputStreamWrapper((int)(memOffset - obs.getUnsafeAddress(0, columnWidth)), columnWidth);
                this.value = DataSerializer.readObject((DataInput)dis);
            }
            catch (Exception ex) {
                throw GemFireXDRuntimeException.newRuntimeException("Exception in UserType.readBytes.", ex);
            }
            return columnWidth;
        }
        this.value = null;
        return 0;
    }

    @Override
    public int computeHashCode(int maxWidth, int hash) {
        if (this.value != null) {
            HeapDataOutputStream hdos = new HeapDataOutputStream();
            try {
                this.toDataForOptimizedResultHolder((DataOutput)hdos);
            }
            catch (IOException ioe) {
                throw GemFireXDRuntimeException.newRuntimeException("Exception in UserType.writeBytes.", ioe);
            }
            byte[] bytes = hdos.toByteArray();
            return ResolverUtils.addBytesToHash((byte[])bytes, (int)hash);
        }
        return hash;
    }

    @Override
    public final void toData(DataOutput out) throws IOException {
        if (!this.isNull()) {
            out.writeByte(this.getTypeId());
            this.toDataForOptimizedResultHolder(out);
        } else {
            this.writeNullDVD(out);
        }
    }

    @Override
    public final void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.fromDataForOptimizedResultHolder(in);
    }

    @Override
    public void toDataForOptimizedResultHolder(DataOutput dos) throws IOException {
        assert (!this.isNull());
        DataSerializer.writeObject((Object)this.value, (DataOutput)dos);
    }

    @Override
    public void fromDataForOptimizedResultHolder(DataInput in) throws IOException, ClassNotFoundException {
        this.value = DataSerializer.readObject((DataInput)in);
    }

    @Override
    public byte getTypeId() {
        return 39;
    }
}

