/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.sql.dictionary;

import com.pivotal.gemfirexd.internal.catalog.DependableFinder;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.DependencyManager;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.Dependent;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.Provider;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TupleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.UniqueTupleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;

public final class ViewDescriptor
extends TupleDescriptor
implements UniqueTupleDescriptor,
Dependent,
Provider {
    private final int checkOption;
    private String viewName;
    private final String viewText;
    private UUID uuid;
    private final UUID compSchemaId;
    public static final int NO_CHECK_OPTION = 0;

    public ViewDescriptor(DataDictionary dataDictionary, UUID viewID, String viewName, String viewText, int checkOption, UUID compSchemaId) {
        super(dataDictionary);
        this.uuid = viewID;
        this.viewText = viewText;
        this.viewName = viewName;
        if (checkOption != 0) {
            SanityManager.THROWASSERT((String)("checkOption (" + checkOption + ") expected to be " + 0));
        }
        this.checkOption = checkOption;
        this.compSchemaId = compSchemaId;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    public void setUUID(UUID uuid) {
        this.uuid = uuid;
    }

    public String getViewText() {
        return this.viewText;
    }

    public void setViewName(String name) {
        this.viewName = name;
    }

    public int getCheckOptionType() {
        return this.checkOption;
    }

    public UUID getCompSchemaId() {
        return this.compSchemaId;
    }

    @Override
    public DependableFinder getDependableFinder() {
        return this.getDependableFinder(145);
    }

    @Override
    public String getObjectName() {
        return this.viewName;
    }

    @Override
    public UUID getObjectID() {
        return this.uuid;
    }

    @Override
    public String getClassType() {
        return "View";
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void prepareToInvalidate(Provider p, int action, LanguageConnectionContext lcc) throws StandardException {
        switch (action) {
            case 2: 
            case 3: 
            case 12: 
            case 15: 
            case 20: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: {
                break;
            }
            default: {
                DependencyManager dm = this.getDataDictionary().getDependencyManager();
                throw StandardException.newException("X0Y23.S", (Object)dm.getActionString(action), (Object)p.getObjectName(), (Object)this.viewName);
            }
        }
    }

    @Override
    public void makeInvalid(int action, LanguageConnectionContext lcc) throws StandardException {
        switch (action) {
            case 2: 
            case 3: 
            case 12: 
            case 15: 
            case 20: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                break;
            }
            case 37: 
            case 44: {
                this.drop(lcc, this.getDataDictionary().getTableDescriptor(this.uuid).getSchemaDescriptor(), this.getDataDictionary().getTableDescriptor(this.uuid));
                lcc.getLastActivation().addWarning(StandardException.newWarning("01501", this.getObjectName()));
                return;
            }
            default: {
                SanityManager.THROWASSERT((String)"did not expect to get called");
            }
        }
    }

    public String toString() {
        return "uuid: " + this.uuid + " viewName: " + this.viewName + "\nviewText: " + this.viewText + "\ncheckOption: " + this.checkOption + "\ncompSchemaId: " + this.compSchemaId + "\n";
    }

    public void drop(LanguageConnectionContext lcc, SchemaDescriptor sd, TableDescriptor td) throws StandardException {
        DataDictionary dd = this.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        dd.dropAllColumnDescriptors(td.getUUID(), tc);
        dm.invalidateFor(td, 9, lcc);
        dm.clearDependencies(lcc, this);
        dd.dropViewDescriptor(this, tc);
        dd.dropAllTableAndColPermDescriptors(td.getUUID(), tc);
        dd.dropTableDescriptor(td, sd, tc);
    }
}

