/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.sql.dictionary;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColPermsDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.PermissionsDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.StatementTablePermission;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;

public class StatementColumnPermission
extends StatementTablePermission {
    private FormatableBitSet columns;

    public StatementColumnPermission(UUID tableUUID, int privType, FormatableBitSet columns) {
        super(tableUUID, privType);
        this.columns = columns;
    }

    public FormatableBitSet getColumns() {
        return this.columns;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof StatementColumnPermission) {
            StatementColumnPermission other = (StatementColumnPermission)obj;
            if (!this.columns.equals(other.columns)) {
                return false;
            }
            return super.equals(obj);
        }
        return false;
    }

    @Override
    public void check(LanguageConnectionContext lcc, String authorizationId, boolean forGrant) throws StandardException {
        DataDictionary dd = lcc.getDataDictionary();
        if (GemFireXDUtils.TraceAuthentication) {
            SanityManager.DEBUG_PRINT((String)"TraceAuthentication", (String)("building permitted columns from column permissions [" + dd.getColumnPermissions(this.tableUUID, this.privType, false, authorizationId) + "] on table " + this.getTableDescriptor(dd).getDescriptorName() + " authorizationId=" + authorizationId + " " + this));
        }
        if (this.hasPermissionOnTable(dd, authorizationId, forGrant) || this.isSelectOnHiveMetastore(this.getTableDescriptor(dd))) {
            return;
        }
        FormatableBitSet permittedColumns = null;
        if (!forGrant) {
            permittedColumns = this.addPermittedColumns(dd, false, "PUBLIC", permittedColumns);
            permittedColumns = this.addPermittedColumns(dd, false, authorizationId, permittedColumns);
        }
        permittedColumns = this.addPermittedColumns(dd, true, "PUBLIC", permittedColumns);
        permittedColumns = this.addPermittedColumns(dd, true, authorizationId, permittedColumns);
        int i = this.columns.anySetBit();
        while (i >= 0) {
            if (permittedColumns == null || !permittedColumns.get(i)) {
                TableDescriptor td = this.getTableDescriptor(dd);
                ColumnDescriptor cd = td.getColumnDescriptor(i + 1);
                if (cd == null) {
                    throw StandardException.newException("4250E", "column");
                }
                throw StandardException.newException(forGrant ? "42503" : "42502", authorizationId, (Object)this.getPrivName(), (Object)cd.getColumnName(), (Object)td.getSchemaName(), (Object)td.getName());
            }
            i = this.columns.anySetBit(i);
        }
    }

    private FormatableBitSet addPermittedColumns(DataDictionary dd, boolean forGrant, String authorizationId, FormatableBitSet permittedColumns) throws StandardException {
        if (permittedColumns != null && permittedColumns.getNumBitsSet() == permittedColumns.getLength()) {
            return permittedColumns;
        }
        ColPermsDescriptor perms = dd.getColumnPermissions(this.tableUUID, this.privType, false, authorizationId);
        if (perms != null) {
            if (permittedColumns == null) {
                return perms.getColumns();
            }
            permittedColumns.or(perms.getColumns());
        }
        return permittedColumns;
    }

    @Override
    public PermissionsDescriptor getPermissionDescriptor(String authid, DataDictionary dd) throws StandardException {
        if (this.oneAuthHasPermissionOnTable(dd, authid, false)) {
            return dd.getTablePermissions(this.tableUUID, authid);
        }
        if (this.oneAuthHasPermissionOnTable(dd, "PUBLIC", false)) {
            return dd.getTablePermissions(this.tableUUID, "PUBLIC");
        }
        ColPermsDescriptor colsPermsDesc = dd.getColumnPermissions(this.tableUUID, this.privType, false, authid);
        if (colsPermsDesc != null && colsPermsDesc.getColumns() != null) {
            FormatableBitSet permittedColumns = colsPermsDesc.getColumns();
            int i = this.columns.anySetBit();
            while (i >= 0) {
                if (permittedColumns.get(i)) {
                    return colsPermsDesc;
                }
                i = this.columns.anySetBit(i);
            }
        }
        return null;
    }

    public PermissionsDescriptor getPUBLIClevelColPermsDescriptor(String authid, DataDictionary dd) throws StandardException {
        ColPermsDescriptor colsPermsDesc = dd.getColumnPermissions(this.tableUUID, this.privType, false, authid);
        FormatableBitSet permittedColumns = colsPermsDesc.getColumns();
        boolean allColumnsCoveredByUserLevelPrivilege = true;
        int i = this.columns.anySetBit();
        while (i >= 0 && allColumnsCoveredByUserLevelPrivilege) {
            if (!permittedColumns.get(i)) {
                allColumnsCoveredByUserLevelPrivilege = false;
            }
            i = this.columns.anySetBit(i);
        }
        if (allColumnsCoveredByUserLevelPrivilege) {
            return null;
        }
        return dd.getColumnPermissions(this.tableUUID, this.privType, false, "PUBLIC");
    }

    @Override
    public String toString() {
        return "StatementColumnPermission@" + Integer.toHexString(System.identityHashCode(this)) + " permitted columns " + this.columns;
    }
}

