/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.services.io;

import com.pivotal.gemfirexd.internal.io.StorageFactory;
import com.pivotal.gemfirexd.internal.io.StorageFile;
import com.pivotal.gemfirexd.internal.io.WritableStorageFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class FileUtil {
    private static final int BUFFER_SIZE = 16384;
    public static final int MAX_FILE_CREATE_RETRY = 10;

    public static boolean removeDirectory(File directory) {
        if (directory == null) {
            return false;
        }
        if (!directory.exists()) {
            return true;
        }
        if (!directory.isDirectory()) {
            return false;
        }
        String[] list = directory.list();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                File entry = new File(directory, list[i]);
                if (!(entry.isDirectory() ? !FileUtil.removeDirectory(entry) : !entry.delete())) continue;
                return false;
            }
        }
        return directory.delete();
    }

    public static boolean removeDirectory(String directory) {
        return FileUtil.removeDirectory(new File(directory));
    }

    public static boolean copyDirectory(File from, File to) {
        return FileUtil.copyDirectory(from, to, null, null);
    }

    public static boolean copyDirectory(String from, String to) {
        return FileUtil.copyDirectory(new File(from), new File(to));
    }

    public static boolean copyDirectory(File from, File to, byte[] buffer, String[] filter) {
        if (from == null) {
            return false;
        }
        if (!from.exists()) {
            return true;
        }
        if (!from.isDirectory()) {
            return false;
        }
        if (to.exists()) {
            return false;
        }
        if (!to.mkdirs()) {
            return false;
        }
        String[] list = from.list();
        if (list != null) {
            if (buffer == null) {
                buffer = new byte[16384];
            }
            block0: for (int i = 0; i < list.length; ++i) {
                File entry;
                String fileName = list[i];
                if (filter != null) {
                    for (int j = 0; j < filter.length; ++j) {
                        if (fileName.equals(filter[j])) continue block0;
                    }
                }
                if (!((entry = new File(from, fileName)).isDirectory() ? !FileUtil.copyDirectory(entry, new File(to, fileName), buffer, filter) : !FileUtil.copyFile(entry, new File(to, fileName), buffer))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean copyFile(File from, File to) {
        return FileUtil.copyFile(from, to, (byte[])null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File from, File to, byte[] buf) {
        if (buf == null) {
            buf = new byte[16384];
        }
        FileInputStream from_s = null;
        FileOutputStream to_s = null;
        try {
            from_s = new FileInputStream(from);
            to_s = new FileOutputStream(to);
            int bytesRead = from_s.read(buf);
            while (bytesRead != -1) {
                to_s.write(buf, 0, bytesRead);
                bytesRead = from_s.read(buf);
            }
            from_s.close();
            from_s = null;
            to_s.getFD().sync();
            to_s.close();
            to_s = null;
        }
        catch (IOException ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (from_s != null) {
                try {
                    from_s.close();
                }
                catch (IOException iOException) {}
            }
            if (to_s != null) {
                try {
                    to_s.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    public static boolean copyDirectory(StorageFactory storageFactory, StorageFile from, File to) {
        return FileUtil.copyDirectory(storageFactory, from, to, null, null, true);
    }

    public static boolean copyDirectory(StorageFactory storageFactory, StorageFile from, File to, byte[] buffer, String[] filter, boolean copySubDirs) {
        if (from == null) {
            return false;
        }
        if (!from.exists()) {
            return true;
        }
        if (!from.isDirectory()) {
            return false;
        }
        if (to.exists()) {
            return false;
        }
        if (!to.mkdirs()) {
            return false;
        }
        String[] list = from.list();
        if (list != null) {
            if (buffer == null) {
                buffer = new byte[16384];
            }
            block0: for (int i = 0; i < list.length; ++i) {
                StorageFile entry;
                String fileName = list[i];
                if (filter != null) {
                    for (int j = 0; j < filter.length; ++j) {
                        if (fileName.equals(filter[j])) continue block0;
                    }
                }
                if (!((entry = storageFactory.newStorageFile(from, fileName)).isDirectory() ? copySubDirs && !FileUtil.copyDirectory(storageFactory, entry, new File(to, fileName), buffer, filter, copySubDirs) : !FileUtil.copyFile(storageFactory, entry, new File(to, fileName), buffer))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean copyFile(StorageFactory storageFactory, StorageFile from, File to) {
        return FileUtil.copyFile(storageFactory, from, to, (byte[])null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(StorageFactory storageFactory, StorageFile from, File to, byte[] buf) {
        InputStream from_s = null;
        FileOutputStream to_s = null;
        try {
            from_s = from.getInputStream();
            to_s = new FileOutputStream(to);
            if (buf == null) {
                buf = new byte[16384];
            }
            int bytesRead = from_s.read(buf);
            while (bytesRead != -1) {
                to_s.write(buf, 0, bytesRead);
                bytesRead = from_s.read(buf);
            }
            from_s.close();
            from_s = null;
            to_s.getFD().sync();
            to_s.close();
            to_s = null;
        }
        catch (IOException ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (from_s != null) {
                try {
                    from_s.close();
                }
                catch (IOException iOException) {}
            }
            if (to_s != null) {
                try {
                    to_s.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    public static boolean copyDirectory(WritableStorageFactory storageFactory, File from, StorageFile to) {
        return FileUtil.copyDirectory(storageFactory, from, to, null, null);
    }

    public static boolean copyDirectory(WritableStorageFactory storageFactory, File from, StorageFile to, byte[] buffer, String[] filter) {
        if (from == null) {
            return false;
        }
        if (!from.exists()) {
            return true;
        }
        if (!from.isDirectory()) {
            return false;
        }
        if (to.exists()) {
            return false;
        }
        if (!to.mkdirs()) {
            return false;
        }
        String[] list = from.list();
        if (list != null) {
            if (buffer == null) {
                buffer = new byte[16384];
            }
            block0: for (int i = 0; i < list.length; ++i) {
                File entry;
                String fileName = list[i];
                if (filter != null) {
                    for (int j = 0; j < filter.length; ++j) {
                        if (fileName.equals(filter[j])) continue block0;
                    }
                }
                if (!((entry = new File(from, fileName)).isDirectory() ? !FileUtil.copyDirectory(storageFactory, entry, storageFactory.newStorageFile(to, fileName), buffer, filter) : !FileUtil.copyFile(storageFactory, entry, storageFactory.newStorageFile(to, fileName), buffer))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean copyFile(WritableStorageFactory storageFactory, File from, StorageFile to) {
        return FileUtil.copyFile(storageFactory, from, to, (byte[])null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(WritableStorageFactory storageFactory, File from, StorageFile to, byte[] buf) {
        FileInputStream from_s = null;
        OutputStream to_s = null;
        try {
            from_s = new FileInputStream(from);
            to_s = to.getOutputStream();
            if (buf == null) {
                buf = new byte[16384];
            }
            int bytesRead = ((InputStream)from_s).read(buf);
            while (bytesRead != -1) {
                to_s.write(buf, 0, bytesRead);
                bytesRead = ((InputStream)from_s).read(buf);
            }
            ((InputStream)from_s).close();
            from_s = null;
            storageFactory.sync(to_s, false);
            to_s.close();
            to_s = null;
        }
        catch (IOException ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (from_s != null) {
                try {
                    ((InputStream)from_s).close();
                }
                catch (IOException iOException) {}
            }
            if (to_s != null) {
                try {
                    to_s.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    public static boolean copyFile(WritableStorageFactory storageFactory, StorageFile from, StorageFile to) {
        return FileUtil.copyFile(storageFactory, from, to, (byte[])null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(WritableStorageFactory storageFactory, StorageFile from, StorageFile to, byte[] buf) {
        InputStream from_s = null;
        OutputStream to_s = null;
        try {
            from_s = from.getInputStream();
            to_s = to.getOutputStream();
            if (buf == null) {
                buf = new byte[16384];
            }
            int bytesRead = from_s.read(buf);
            while (bytesRead != -1) {
                to_s.write(buf, 0, bytesRead);
                bytesRead = from_s.read(buf);
            }
            from_s.close();
            from_s = null;
            storageFactory.sync(to_s, false);
            to_s.close();
            to_s = null;
        }
        catch (IOException ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (from_s != null) {
                try {
                    from_s.close();
                }
                catch (IOException iOException) {}
            }
            if (to_s != null) {
                try {
                    to_s.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    public static File getAbsoluteFile(File root, String path) {
        File file = new File(path);
        if (file.isAbsolute()) {
            return file;
        }
        if (root == null) {
            return null;
        }
        return new File(root, path);
    }

    public static File newFile(File parent, String name) {
        if (parent == null) {
            return new File(name);
        }
        return new File(parent, name);
    }
}

