/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.services.io;

import com.pivotal.gemfirexd.internal.iapi.services.io.ArrayInputStream;
import com.pivotal.gemfirexd.internal.iapi.services.io.ArrayOutputStream;
import com.pivotal.gemfirexd.internal.iapi.services.io.InputStreamUtil;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class CompressedNumber {
    public static final int MAX_INT_STORED_SIZE = 4;
    public static final int MAX_LONG_STORED_SIZE = 8;
    public static final int MAX_COMPRESSED_INT_ONE_BYTE = 63;
    public static final int MAX_COMPRESSED_INT_TWO_BYTES = 16383;
    private static byte[] holder = new byte[8];
    private static ArrayOutputStream aos = new ArrayOutputStream(holder);
    private static DataOutput out = new DataOutputStream(aos);
    private static ArrayInputStream ais = new ArrayInputStream(holder);
    private static DataInput in = new DataInputStream(ais);
    private static InputStream in_stream = ais;

    public static final int writeInt(DataOutput out, int value) throws IOException {
        if (value < 0) {
            throw new IOException();
        }
        if (value <= 63) {
            out.writeByte(value);
            return 1;
        }
        if (value <= 16383) {
            out.writeByte(0x40 | value >>> 8);
            out.writeByte(value & 0xFF);
            return 2;
        }
        out.writeByte((value >>> 24 | 0x80) & 0xFF);
        out.writeByte(value >>> 16 & 0xFF);
        out.writeByte(value >>> 8 & 0xFF);
        out.writeByte(value & 0xFF);
        return 4;
    }

    public static final int writeInt(OutputStream out, int value) throws IOException {
        if (value < 0) {
            throw new IOException();
        }
        if (value <= 63) {
            out.write(value);
            return 1;
        }
        if (value <= 16383) {
            out.write(0x40 | value >>> 8);
            out.write(value & 0xFF);
            return 2;
        }
        out.write((value >>> 24 | 0x80) & 0xFF);
        out.write(value >>> 16 & 0xFF);
        out.write(value >>> 8 & 0xFF);
        out.write(value & 0xFF);
        return 4;
    }

    public static final int readInt(DataInput in) throws IOException {
        int value = in.readUnsignedByte();
        if ((value & 0xFFFFFFC0) == 0) {
            return value;
        }
        if ((value & 0x80) == 0) {
            SanityManager.ASSERT(((value & 0x40) == 64 ? 1 : 0) != 0);
            return (value & 0x3F) << 8 | in.readUnsignedByte();
        }
        SanityManager.ASSERT(((value & 0x80) == 128 ? 1 : 0) != 0);
        return (value & 0x7F) << 24 | in.readUnsignedByte() << 16 | in.readUnsignedByte() << 8 | in.readUnsignedByte();
    }

    public static final int readInt(InputStream in) throws IOException {
        int value = InputStreamUtil.readUnsignedByte((InputStream)in);
        if ((value & 0xFFFFFFC0) == 0) {
            return value;
        }
        if ((value & 0x80) == 0) {
            return (value & 0x3F) << 8 | InputStreamUtil.readUnsignedByte((InputStream)in);
        }
        return (value & 0x7F) << 24 | InputStreamUtil.readUnsignedByte((InputStream)in) << 16 | InputStreamUtil.readUnsignedByte((InputStream)in) << 8 | InputStreamUtil.readUnsignedByte((InputStream)in);
    }

    public static final int readInt(byte[] data, int offset) {
        byte value;
        if (((value = data[offset++]) & 0xFFFFFFC0) == 0) {
            return value;
        }
        if ((value & 0x80) == 0) {
            SanityManager.ASSERT(((value & 0x40) == 64 ? 1 : 0) != 0);
            return (value & 0x3F) << 8 | data[offset] & 0xFF;
        }
        SanityManager.ASSERT(((value & 0x80) == 128 ? 1 : 0) != 0);
        return (value & 0x7F) << 24 | (data[offset++] & 0xFF) << 16 | (data[offset++] & 0xFF) << 8 | data[offset] & 0xFF;
    }

    public static final int readIntAndReturnIntPlusOverhead(byte[] data, int offset) {
        byte value = data[offset];
        if ((value & 0xFFFFFFC0) == 0) {
            return value + 2;
        }
        if ((value & 0x80) == 0) {
            SanityManager.ASSERT(((value & 0x40) == 64 ? 1 : 0) != 0);
            return ((value & 0x3F) << 8 | data[offset + 1] & 0xFF) + 3;
        }
        SanityManager.ASSERT(((value & 0x80) == 128 ? 1 : 0) != 0);
        return ((value & 0x7F) << 24 | (data[offset + 1] & 0xFF) << 16 | (data[offset + 2] & 0xFF) << 8 | data[offset + 3] & 0xFF) + 5;
    }

    public static final int skipInt(DataInput in) throws IOException {
        int value = in.readUnsignedByte();
        if ((value & 0x80) == 128) {
            in.skipBytes(3);
            return 4;
        }
        if ((value & 0x40) == 64) {
            in.skipBytes(1);
            return 2;
        }
        return 1;
    }

    public static final int skipInt(InputStream in) throws IOException {
        int value = InputStreamUtil.readUnsignedByte((InputStream)in);
        int skipBytes = 0;
        if ((value & 0x80) == 128) {
            skipBytes = 3;
        } else if ((value & 0x40) == 64) {
            skipBytes = 1;
        }
        if (skipBytes != 0 && in.skip(skipBytes) != (long)skipBytes) {
            throw new EOFException();
        }
        return skipBytes + 1;
    }

    public static final int sizeInt(int value) {
        if (value <= 63) {
            return 1;
        }
        if (value <= 16383) {
            return 2;
        }
        return 4;
    }

    public static final int writeLong(DataOutput out, long value) throws IOException {
        if (value < 0L) {
            throw new IOException();
        }
        if (value <= 16383L) {
            out.writeByte((int)(value >>> 8 & 0xFFL));
            out.writeByte((int)(value & 0xFFL));
            return 2;
        }
        if (value <= 0x3FFFFFFFL) {
            out.writeByte((int)((value >>> 24 | 0x40L) & 0xFFL));
            out.writeByte((int)(value >>> 16 & 0xFFL));
            out.writeByte((int)(value >>> 8 & 0xFFL));
            out.writeByte((int)(value & 0xFFL));
            return 4;
        }
        out.writeByte((int)((value >>> 56 | 0x80L) & 0xFFL));
        out.writeByte((int)(value >>> 48 & 0xFFL));
        out.writeByte((int)(value >>> 40 & 0xFFL));
        out.writeByte((int)(value >>> 32 & 0xFFL));
        out.writeByte((int)(value >>> 24 & 0xFFL));
        out.writeByte((int)(value >>> 16 & 0xFFL));
        out.writeByte((int)(value >>> 8 & 0xFFL));
        out.writeByte((int)(value & 0xFFL));
        return 8;
    }

    public static final int writeLong(OutputStream out, long value) throws IOException {
        if (value < 0L) {
            throw new IOException();
        }
        if (value <= 16383L) {
            out.write((int)(value >>> 8 & 0xFFL));
            out.write((int)(value & 0xFFL));
            return 2;
        }
        if (value <= 0x3FFFFFFFL) {
            out.write((int)((value >>> 24 | 0x40L) & 0xFFL));
            out.write((int)(value >>> 16 & 0xFFL));
            out.write((int)(value >>> 8 & 0xFFL));
            out.write((int)(value & 0xFFL));
            return 4;
        }
        out.write((int)((value >>> 56 | 0x80L) & 0xFFL));
        out.write((int)(value >>> 48 & 0xFFL));
        out.write((int)(value >>> 40 & 0xFFL));
        out.write((int)(value >>> 32 & 0xFFL));
        out.write((int)(value >>> 24 & 0xFFL));
        out.write((int)(value >>> 16 & 0xFFL));
        out.write((int)(value >>> 8 & 0xFFL));
        out.write((int)(value & 0xFFL));
        return 8;
    }

    public static final long readLong(DataInput in) throws IOException {
        int int_value = in.readUnsignedByte();
        if ((int_value & 0xFFFFFFC0) == 0) {
            return int_value << 8 | in.readUnsignedByte();
        }
        if ((int_value & 0x80) == 0) {
            return (int_value & 0x3F) << 24 | in.readUnsignedByte() << 16 | in.readUnsignedByte() << 8 | in.readUnsignedByte();
        }
        return (long)(int_value & 0x7F) << 56 | (long)in.readUnsignedByte() << 48 | (long)in.readUnsignedByte() << 40 | (long)in.readUnsignedByte() << 32 | (long)in.readUnsignedByte() << 24 | (long)in.readUnsignedByte() << 16 | (long)in.readUnsignedByte() << 8 | (long)in.readUnsignedByte();
    }

    public static final long readLong(InputStream in) throws IOException {
        int int_value = InputStreamUtil.readUnsignedByte((InputStream)in);
        if ((int_value & 0xFFFFFFC0) == 0) {
            return int_value << 8 | InputStreamUtil.readUnsignedByte((InputStream)in);
        }
        if ((int_value & 0x80) == 0) {
            return (int_value & 0x3F) << 24 | InputStreamUtil.readUnsignedByte((InputStream)in) << 16 | InputStreamUtil.readUnsignedByte((InputStream)in) << 8 | InputStreamUtil.readUnsignedByte((InputStream)in);
        }
        long value = int_value;
        return (value & 0x7FL) << 56 | (long)InputStreamUtil.readUnsignedByte((InputStream)in) << 48 | (long)InputStreamUtil.readUnsignedByte((InputStream)in) << 40 | (long)InputStreamUtil.readUnsignedByte((InputStream)in) << 32 | (long)InputStreamUtil.readUnsignedByte((InputStream)in) << 24 | (long)InputStreamUtil.readUnsignedByte((InputStream)in) << 16 | (long)InputStreamUtil.readUnsignedByte((InputStream)in) << 8 | (long)InputStreamUtil.readUnsignedByte((InputStream)in);
    }

    public static final long readLong(byte[] data, int offset) {
        byte int_value;
        if (((int_value = data[offset++]) & 0xFFFFFFC0) == 0) {
            return int_value << 8 | data[offset] & 0xFF;
        }
        if ((int_value & 0x80) == 0) {
            return (int_value & 0x3F) << 24 | (data[offset++] & 0xFF) << 16 | (data[offset++] & 0xFF) << 8 | data[offset] & 0xFF;
        }
        return (long)(int_value & 0x7F) << 56 | (long)(data[offset++] & 0xFF) << 48 | (long)(data[offset++] & 0xFF) << 40 | (long)(data[offset++] & 0xFF) << 32 | (long)(data[offset++] & 0xFF) << 24 | (long)(data[offset++] & 0xFF) << 16 | (long)(data[offset++] & 0xFF) << 8 | (long)(data[offset] & 0xFF);
    }

    public static final int skipLong(DataInput in) throws IOException {
        long value = in.readUnsignedByte();
        if ((value & 0x80L) == 128L) {
            in.skipBytes(7);
            return 8;
        }
        if ((value & 0x40L) == 64L) {
            in.skipBytes(3);
            return 4;
        }
        in.skipBytes(1);
        return 2;
    }

    public static final int skipLong(InputStream in) throws IOException {
        int value = InputStreamUtil.readUnsignedByte((InputStream)in);
        int skipBytes = (value & 0x80) == 128 ? 7 : ((value & 0x40) == 64 ? 3 : 1);
        if (in.skip(skipBytes) != (long)skipBytes) {
            throw new EOFException();
        }
        return skipBytes + 1;
    }

    public static final int sizeLong(long value) {
        if (value <= 16383L) {
            return 2;
        }
        if (value <= 0x3FFFFFFFL) {
            return 4;
        }
        return 8;
    }

    private static short checkInt(int i, short oldLength) throws IOException {
        int skipPosition;
        int value_plus_int_length;
        int writtenBytes;
        aos.setPosition(0);
        int length = CompressedNumber.writeInt(out, i);
        if (length != oldLength) {
            System.out.println("changing length to " + length + " at value " + i + " 0x" + Integer.toHexString(i));
            oldLength = (short)length;
        }
        if ((writtenBytes = aos.getPosition()) != length) {
            System.out.println("MISMATCH written bytes  expected " + length + " got " + writtenBytes);
            System.exit(1);
        }
        if (length != CompressedNumber.sizeInt(i)) {
            System.out.println("MISMATCH sizeInt() bytes  expected " + length + " got " + CompressedNumber.sizeInt(i));
            System.exit(1);
        }
        ais.setPosition(0);
        int value = CompressedNumber.readInt(in);
        if (value != i) {
            System.out.println("MISMATCH value readInt(DataInput) expected " + i + " got " + value);
            System.exit(1);
        }
        ais.setPosition(0);
        value = ais.readCompressedInt();
        if (value != i) {
            System.out.println("MISMATCH value readInt(DataInput) expected " + i + " got " + value);
            System.exit(1);
        }
        ais.setPosition(0);
        value = CompressedNumber.readInt(in_stream);
        if (value != i) {
            System.out.println("MISMATCH value in readInt(InputStream) expected " + i + " got " + value);
            System.exit(1);
        }
        if ((value = CompressedNumber.readInt(holder, 0)) != i) {
            System.out.println("MISMATCH frome readInt(byte[], offset) value expected " + i + " got " + value);
            System.exit(1);
        }
        ais.setPosition(0);
        int skipLength = CompressedNumber.skipInt(in);
        if (skipLength != length) {
            System.out.println("MISMATCH skip length expected " + length + " got " + skipLength);
            System.exit(1);
        }
        if ((value_plus_int_length = CompressedNumber.readIntAndReturnIntPlusOverhead(holder, 0)) != length + i + 1) {
            System.out.println("MISMATCH readIntAndReturnIntPlusOverhead() return expected " + (length + i) + " got " + value_plus_int_length);
            System.exit(1);
        }
        if ((skipPosition = ais.getPosition()) != length) {
            System.out.println("MISMATCH skip position expected " + length + " got " + skipPosition);
            System.exit(1);
        }
        return oldLength;
    }

    private static short checkLong(long i, short oldLength) throws IOException {
        int skipPosition;
        int j;
        long value;
        int writtenBytes;
        aos.setPosition(0);
        int length = CompressedNumber.writeLong(out, i);
        if (length != oldLength) {
            System.out.println("changing length to " + length + " at value " + i + " 0x" + Long.toHexString(i));
            oldLength = (short)length;
        }
        if ((writtenBytes = aos.getPosition()) != length) {
            System.out.println("MISMATCH written bytes  expected " + length + " got " + writtenBytes);
            System.exit(1);
        }
        if (length != CompressedNumber.sizeLong(i)) {
            System.out.println("MISMATCH sizeLong() bytes  expected " + length + " got " + CompressedNumber.sizeLong(i));
            System.exit(1);
        }
        if ((value = CompressedNumber.readLong(holder, 0)) != i) {
            for (j = 0; j < 8; ++j) {
                System.out.println(Integer.toHexString(holder[j]));
            }
            System.out.println("MISMATCH in readLong(byte[], offset) value expected " + Long.toHexString(i) + " got " + value);
            System.exit(1);
        }
        ais.setPosition(0);
        value = CompressedNumber.readLong(in_stream);
        if (value != i) {
            for (j = 0; j < 8; ++j) {
                System.out.println(Integer.toHexString(holder[j]));
            }
            System.out.println("MISMATCH value in readLong(InputStream) expected " + Long.toHexString(i) + " got " + value);
            System.exit(1);
        }
        ais.setPosition(0);
        value = ais.readCompressedLong();
        if (value != i) {
            for (j = 0; j < 8; ++j) {
                System.out.println(Integer.toHexString(holder[j]));
            }
            System.out.println("MISMATCH value in readLong(InputStream) expected " + Long.toHexString(i) + " got " + value);
            System.exit(1);
        }
        ais.setPosition(0);
        value = CompressedNumber.readLong(in);
        if (value != i) {
            for (j = 0; j < 8; ++j) {
                System.out.println(Integer.toHexString(holder[j]));
            }
            System.out.println("MISMATCH value in readLong(DataInput) expected " + Long.toHexString(i) + " got " + value);
            System.exit(1);
        }
        ais.setPosition(0);
        int skipLength = CompressedNumber.skipLong(in);
        if (skipLength != length) {
            System.out.println("MISMATCH skip length expected " + length + " got " + skipLength);
            System.exit(1);
        }
        if ((skipPosition = ais.getPosition()) != length) {
            System.out.println("MISMATCH skip position expected " + length + " got " + skipPosition);
            System.exit(1);
        }
        return oldLength;
    }

    public static void main(String[] args) throws IOException {
        int i;
        short oldLength = -1;
        System.out.println("** Testing Int");
        oldLength = CompressedNumber.checkInt(0, oldLength);
        oldLength = CompressedNumber.checkInt(1, oldLength);
        oldLength = CompressedNumber.checkInt(2, oldLength);
        oldLength = CompressedNumber.checkInt(59, oldLength);
        oldLength = CompressedNumber.checkInt(60, oldLength);
        oldLength = CompressedNumber.checkInt(61, oldLength);
        oldLength = CompressedNumber.checkInt(62, oldLength);
        oldLength = CompressedNumber.checkInt(63, oldLength);
        oldLength = CompressedNumber.checkInt(64, oldLength);
        oldLength = CompressedNumber.checkInt(65, oldLength);
        oldLength = CompressedNumber.checkInt(66, oldLength);
        oldLength = CompressedNumber.checkInt(67, oldLength);
        oldLength = CompressedNumber.checkInt(16252, oldLength);
        oldLength = CompressedNumber.checkInt(16253, oldLength);
        oldLength = CompressedNumber.checkInt(16254, oldLength);
        oldLength = CompressedNumber.checkInt(16255, oldLength);
        oldLength = CompressedNumber.checkInt(16256, oldLength);
        oldLength = CompressedNumber.checkInt(16257, oldLength);
        oldLength = CompressedNumber.checkInt(16258, oldLength);
        oldLength = CompressedNumber.checkInt(16259, oldLength);
        oldLength = CompressedNumber.checkInt(16260, oldLength);
        oldLength = CompressedNumber.checkInt(16379, oldLength);
        oldLength = CompressedNumber.checkInt(16380, oldLength);
        oldLength = CompressedNumber.checkInt(16381, oldLength);
        oldLength = CompressedNumber.checkInt(16382, oldLength);
        oldLength = CompressedNumber.checkInt(16383, oldLength);
        oldLength = CompressedNumber.checkInt(16384, oldLength);
        oldLength = CompressedNumber.checkInt(16385, oldLength);
        oldLength = CompressedNumber.checkInt(16386, oldLength);
        oldLength = CompressedNumber.checkInt(16387, oldLength);
        oldLength = CompressedNumber.checkInt(0x7FFFFFFB, oldLength);
        oldLength = CompressedNumber.checkInt(0x7FFFFFFC, oldLength);
        oldLength = CompressedNumber.checkInt(0x7FFFFFFD, oldLength);
        oldLength = CompressedNumber.checkInt(0x7FFFFFFE, oldLength);
        oldLength = CompressedNumber.checkInt(Integer.MAX_VALUE, oldLength);
        oldLength = -1;
        for (i = 0; i < 983040; ++i) {
            oldLength = CompressedNumber.checkInt(i, oldLength);
        }
        System.out.println("** Testing Long");
        oldLength = -1;
        for (i = 0; i < 983040; ++i) {
            oldLength = CompressedNumber.checkLong(i, oldLength);
        }
        oldLength = -1;
        oldLength = CompressedNumber.checkLong(0L, oldLength);
        oldLength = CompressedNumber.checkLong(1L, oldLength);
        oldLength = CompressedNumber.checkLong(2L, oldLength);
        oldLength = CompressedNumber.checkLong(16381L, oldLength);
        oldLength = CompressedNumber.checkLong(16382L, oldLength);
        oldLength = CompressedNumber.checkLong(16383L, oldLength);
        oldLength = CompressedNumber.checkLong(16384L, oldLength);
        oldLength = CompressedNumber.checkLong(16385L, oldLength);
        oldLength = CompressedNumber.checkLong(0x3FFFFFFBL, oldLength);
        oldLength = CompressedNumber.checkLong(0x3FFFFFFCL, oldLength);
        oldLength = CompressedNumber.checkLong(0x3FFFFFFDL, oldLength);
        oldLength = CompressedNumber.checkLong(0x3FFFFFFEL, oldLength);
        oldLength = CompressedNumber.checkLong(0x3FFFFFFFL, oldLength);
        oldLength = CompressedNumber.checkLong(0x40000000L, oldLength);
        oldLength = CompressedNumber.checkLong(0x40000001L, oldLength);
        oldLength = CompressedNumber.checkLong(0x40000002L, oldLength);
        oldLength = CompressedNumber.checkLong(0x40000003L, oldLength);
        oldLength = CompressedNumber.checkLong(0x6FFFFFFEL, oldLength);
        oldLength = CompressedNumber.checkLong(0x6FFFFFFFL, oldLength);
        oldLength = CompressedNumber.checkLong(0x70000000L, oldLength);
        oldLength = CompressedNumber.checkLong(0x70000001L, oldLength);
        oldLength = CompressedNumber.checkLong(0x70000002L, oldLength);
        oldLength = CompressedNumber.checkLong(0x7FFFFFFFFFFFFFFDL, oldLength);
        oldLength = CompressedNumber.checkLong(0x7FFFFFFFFFFFFFFEL, oldLength);
        oldLength = CompressedNumber.checkLong(Long.MAX_VALUE, oldLength);
    }
}

