/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.services.cache;

import com.gemstone.gemfire.internal.SharedLibrary;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Hashtable;

public class ClassSize {
    public static final int refSize;
    private static final int objectOverhead = 2;
    private static final int booleanSize = 4;
    private static final int charSize = 4;
    private static final int shortSize = 4;
    private static final int intSize = 4;
    private static final int longSize = 8;
    private static final int floatSize = 4;
    private static final int doubleSize = 8;
    private static final int minObjectSize;
    private static boolean dummyCatalog;
    static boolean noGuess;
    static boolean unitTest;
    private static final int[] wildGuess;
    @SuppressWarnings(value={"DM_GC"})
    private static Hashtable catalog;

    public static void setDummyCatalog() {
        dummyCatalog = true;
    }

    public static int getRefSize() {
        return refSize;
    }

    public static int getIntSize() {
        return 4;
    }

    public static int[] getSizeCoefficients(Class cl) {
        int[] coeff = new int[]{0, 2};
        while (null != cl) {
            Field[] field = cl.getDeclaredFields();
            if (null != field) {
                for (int i = 0; i < field.length; ++i) {
                    if (Modifier.isStatic(field[i].getModifiers())) continue;
                    Class<?> fieldClass = field[i].getType();
                    if (fieldClass.isArray() || !fieldClass.isPrimitive()) {
                        coeff[1] = coeff[1] + 1;
                        continue;
                    }
                    String name = fieldClass.getName();
                    if (name.equals("int") || name.equals("I")) {
                        coeff[0] = coeff[0] + 4;
                        continue;
                    }
                    if (name.equals("long") || name.equals("J")) {
                        coeff[0] = coeff[0] + 8;
                        continue;
                    }
                    if (name.equals("boolean") || name.equals("Z")) {
                        coeff[0] = coeff[0] + 4;
                        continue;
                    }
                    if (name.equals("short") || name.equals("S")) {
                        coeff[0] = coeff[0] + 4;
                        continue;
                    }
                    if (name.equals("byte") || name.equals("B")) {
                        coeff[0] = coeff[0] + 1;
                        continue;
                    }
                    if (name.equals("char") || name.equals("C")) {
                        coeff[0] = coeff[0] + 4;
                        continue;
                    }
                    if (name.equals("float") || name.equals("F")) {
                        coeff[0] = coeff[0] + 4;
                        continue;
                    }
                    if (name.equals("double") || name.equals("D")) {
                        coeff[0] = coeff[0] + 8;
                        continue;
                    }
                    coeff[1] = coeff[1] + 1;
                }
            }
            cl = cl.getSuperclass();
        }
        return coeff;
    }

    public static int estimateBaseFromCoefficients(int[] coeff) {
        int size = coeff[0] + coeff[1] * refSize;
        size = (size + 7) / 8;
        return (size *= 8) < minObjectSize ? minObjectSize : size;
    }

    public static int estimateBaseFromCatalog(Class cls) {
        return ClassSize.estimateBaseFromCatalog(cls, false);
    }

    private static int estimateBaseFromCatalog(Class cls, boolean addToCatalog) {
        if (dummyCatalog) {
            return 0;
        }
        SanityManager.ASSERT((catalog != null ? 1 : 0) != 0, (String)"The class size catalog could not be initialized.");
        int[] coeff = (int[])catalog.get(cls.getName());
        if (coeff == null) {
            try {
                coeff = ClassSize.getSizeCoefficients(cls);
            }
            catch (Throwable t) {
                if (noGuess) {
                    return -2;
                }
                coeff = wildGuess;
            }
            if (addToCatalog) {
                catalog.put(cls.getName(), coeff);
            }
        }
        return ClassSize.estimateBaseFromCoefficients(coeff);
    }

    public static int estimateAndCatalogBase(Class cls) {
        return ClassSize.estimateBaseFromCatalog(cls, true);
    }

    public static int estimateBase(Class cl) {
        return ClassSize.estimateBaseFromCoefficients(ClassSize.getSizeCoefficients(cl));
    }

    public static int estimateArrayOverhead() {
        return minObjectSize;
    }

    public static int estimateHashEntrySize() {
        return 2 + 3 * refSize;
    }

    public static int estimateMemoryUsage(String str) {
        if (null == str) {
            return 0;
        }
        return 2 * str.length();
    }

    static {
        dummyCatalog = false;
        noGuess = false;
        unitTest = false;
        wildGuess = new int[]{0, 16};
        try {
            catalog = (Hashtable)Class.forName("com.pivotal.gemfirexd.internal.iapi.services.cache.ClassSizeCatalog").newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        refSize = SharedLibrary.getReferenceSize();
        minObjectSize = 4 * refSize;
    }
}

