/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.execute;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.internal.cache.TXState;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.compile.types.DVDSet;
import com.pivotal.gemfirexd.internal.engine.sql.compile.types.DVDSetHashingStrategy;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ParameterValueSet;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.GenericParameterValueSet;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.execute.NoPutResultSetImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class NcjPullResultSet
extends NoPutResultSetImpl {
    private final String sourceString;
    private ResultSet source = null;
    private List<ExecRow> rowsCached;
    private boolean isCacheComplete = false;
    private Iterator<ExecRow> cacheIter = null;
    private boolean keepNcjRSOpen = false;
    private final GenericPreparedStatement ps;
    private final List<Integer> params;
    private final List<ArrayList<DataValueDescriptor>> extraParams = new ArrayList<ArrayList<DataValueDescriptor>>();
    private final int prID;
    private boolean openedOnce = false;
    private Activation childActivation = null;
    private boolean execNotNeeded = false;
    private final boolean isRemoteScan;
    private final boolean hasVarLengthInList;

    public NcjPullResultSet(String ncjSql, Activation parentActivation, List<Integer> params, GenericPreparedStatement ps, int rsNum, boolean isRemoteScan, boolean hasVarLengthInList, int prId) {
        super(parentActivation, rsNum, 0.0, 0.0);
        this.ps = ps;
        this.params = params;
        this.sourceString = ncjSql;
        this.isRemoteScan = isRemoteScan;
        this.hasVarLengthInList = hasVarLengthInList;
        this.prID = prId;
        if (GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("NcjPullResultSet created for " + this.sourceString + " ,isRemoteScan=" + this.isRemoteScan + " ,hasVarLengthInList=" + this.hasVarLengthInList + " ,prID=" + prId));
        }
        this.printResultSetHierarchy();
    }

    @Override
    public void openCore() throws StandardException {
        GemFireXDQueryObserver observer;
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        this.isOpen = true;
        if (this.openedOnce) {
            this.cacheIter = this.rowsCached.iterator();
            ++this.numOpens;
            if (this.statisticsTimingOn) {
                this.openTime += this.getElapsedNanos(this.beginTime);
            }
            return;
        }
        this.rowsCached = new ArrayList<ExecRow>();
        this.cacheIter = this.rowsCached.iterator();
        int batchSize = 0;
        int cacheSize = 0;
        LanguageConnectionContext lcc = this.activation.getLanguageConnectionContext();
        if (lcc != null) {
            batchSize = lcc.getNcjBatchSize();
            cacheSize = lcc.getNcjCacheSize();
        }
        if (GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("NcjPullResultSet::openCore Sql=" + this.sourceString + " ,execNotNeeded=" + this.execNotNeeded + " ,isRemoteScan=" + this.isRemoteScan + " ,hasVarLengthInList=" + this.hasVarLengthInList + " ,batchSize=" + batchSize + " ,cacheSize=" + cacheSize));
        }
        this.childActivation = NcjPullResultSet.getChildActivation(this.activation, this.ps);
        NcjPullResultSet.setParametersOnChildActivation(this.childActivation, this.activation.getParameterValueSet(), this.params, this.extraParams, lcc);
        this.source = NcjPullResultSet.executeSqlAsPreparedStatement(this.activation, this.childActivation, this.ps, this.execNotNeeded, this.prID);
        if (GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("NcjPullResultSet::openCore. Done with execution of Sql=" + this.sourceString + " ,childActivation=" + this.childActivation));
        }
        if ((observer = GemFireXDQueryObserverHolder.getInstance()) != null) {
            observer.ncjPullResultSetOpenCoreInvoked();
            observer.ncjPullResultSetVerifyBatchSize(batchSize);
            observer.ncjPullResultSetVerifyCacheSize(cacheSize);
            observer.ncjPullResultSetVerifyVarInList(this.hasVarLengthInList);
        }
        this.openedOnce = true;
        ++this.numOpens;
        if (this.statisticsTimingOn) {
            this.openTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public void reopenCore() throws StandardException {
        this.openCore();
    }

    @Override
    public void forceReOpenCore() {
        this.openedOnce = false;
        this.isCacheComplete = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecRow getNextRowCore() throws StandardException {
        ExecRow row;
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (this.isCacheComplete) {
            if (this.cacheIter.hasNext()) {
                ExecRow row2 = this.cacheIter.next();
                if (row2 != null) {
                    this.getActivation().setCurrentRow(row2, this.resultSetNumber);
                    ++this.rowsSeen;
                } else {
                    row2 = null;
                }
                if (this.statisticsTimingOn) {
                    this.nextTime += this.getElapsedNanos(this.beginTime);
                }
                return row2;
            }
            if (this.statisticsTimingOn) {
                this.nextTime += this.getElapsedNanos(this.beginTime);
            }
            return null;
        }
        if (this.cacheIter != null && this.cacheIter.hasNext()) {
            ExecRow row3 = this.cacheIter.next();
            if (row3 != null) {
                this.getActivation().setCurrentRow(row3, this.resultSetNumber);
                ++this.rowsSeen;
            } else {
                row3 = null;
            }
            if (this.statisticsTimingOn) {
                this.nextTime += this.getElapsedNanos(this.beginTime);
            }
            return row3;
        }
        if (this.cacheIter != null) {
            this.cacheIter = null;
        }
        if ((row = this.execNotNeeded ? null : this.source.getNextRow()) != null) {
            this.getActivation().setCurrentRow(row, this.resultSetNumber);
            this.rowsCached.add(row);
        } else {
            this.isCacheComplete = true;
            try {
                this.keepNcjRSOpen = true;
                if (this.source != null) {
                    this.source.close(false);
                }
            }
            catch (Exception ignore) {
                LogWriter logger = Misc.getCacheLogWriterNoThrow();
                logger.warning("Exception in closing Ncj Pull resultset", (Throwable)ignore);
            }
            finally {
                this.keepNcjRSOpen = false;
            }
        }
        if (row != null) {
            ++this.rowsSeen;
        }
        if (this.statisticsTimingOn) {
            this.nextTime += this.getElapsedNanos(this.beginTime);
        }
        return row;
    }

    @Override
    public void close(boolean cleanupOnError) throws StandardException {
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (this.isOpen && !this.keepNcjRSOpen) {
            if (this.source != null) {
                this.childActivation.close();
                this.source.close(cleanupOnError);
                this.rowsCached = null;
                this.cacheIter = null;
                this.isCacheComplete = false;
                this.openedOnce = false;
            }
            this.localTXState = null;
            this.localTXStateSet = false;
        }
        this.execNotNeeded = false;
        this.isOpen = false;
        if (this.statisticsTimingOn) {
            this.closeTime += this.getElapsedNanos(this.beginTime);
        }
    }

    public long estimateMemoryUsage() throws StandardException {
        long memory = 0L;
        if (this.rowsCached != null) {
            for (ExecRow row : this.rowsCached) {
                memory += row.estimateRowSize();
            }
        }
        if (!this.isCacheComplete) {
            memory += this.lcc.getLanguageConnectionFactory().getExecutionFactory().getResultSetStatisticsFactory().getResultSetMemoryUsage(this.source);
        }
        return memory;
    }

    @Override
    public void updateRowLocationPostRead() throws StandardException {
    }

    @Override
    public void filteredRowLocationPostRead(TXState localTXState) throws StandardException {
    }

    @Override
    public final long getTimeSpent(int type, int timeType) {
        long time = PlanUtils.getTimeSpent(this.constructorTime, this.openTime, this.nextTime, this.closeTime, timeType);
        if (GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("NcjPullResultSet totalTime = " + time));
        }
        if (type == 0) {
            return time - this.source.getTimeSpent(1, 0);
        }
        return timeType == 0 ? time - this.constructorTime : time;
    }

    @Override
    public void accept(ResultSetStatisticsVisitor visitor) {
        visitor.setNumberOfChildren(1);
        visitor.visit(this);
        this.source.accept(visitor);
    }

    @Override
    public StringBuilder buildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
        super.buildQueryPlan(builder, context);
        PlanUtils.xmlTermTag(builder, context, "NCJ-PULL");
        if (this.source != null && this.source instanceof NoPutResultSet) {
            ((NoPutResultSet)this.source).buildQueryPlan(builder, context.pushContext());
        }
        PlanUtils.xmlCloseTag(builder, context, this);
        return builder;
    }

    @Override
    public void setGfKeysForNCJoin(ArrayList<DataValueDescriptor> inlist) throws StandardException {
        if (this.hasVarLengthInList) {
            if (inlist.size() == 0) {
                this.execNotNeeded = true;
            }
            this.extraParams.add(inlist);
        }
        if (GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("NcjPullResultSet::setGfKeysForNCJoin called with keys-size " + inlist.size() + " ,execNotNeeded" + this.execNotNeeded + " ,hasVarLengthInList" + this.hasVarLengthInList));
        }
        if (GemFireXDUtils.TraceNCJIter) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJIter", (String)("NcjPullResultSet::setGfKeysForNCJoin called with keys " + inlist));
        }
    }

    private static Activation getChildActivation(Activation activation, GenericPreparedStatement ps) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        Activation childActivation = ps.getActivation(lcc, false, ps.getSource(), true);
        if (GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("NcjPullResultSet::getChildActivation. activation =" + activation + " ;stmtID(act)=" + activation.getStatementID() + " ;stmtID(lcc)=" + lcc.getStatementId() + " ;rootID(act)=" + activation.getRootID() + " ;level(act)=" + activation.getStatementLevel()));
        }
        childActivation.setTimeOutMillis(activation.getTimeOutMillis());
        childActivation.setMaxRows(0);
        childActivation.setIsPrepStmntQuery(true);
        childActivation.setConnectionID(-2L);
        childActivation.setStatementID(lcc.getStatementId());
        childActivation.setExecutionID(activation.getExecutionID());
        childActivation.setRootID(activation.getStatementID());
        childActivation.setStatementLevel(activation.getStatementLevel() + 1);
        if (activation.getStatementLevel() != 1) {
            SanityManager.ASSERT((activation.getStatementLevel() == 1 ? 1 : 0) != 0, (String)("Statement level should be one, but its " + activation.getStatementLevel()));
        }
        childActivation.setFunctionContext(activation.getFunctionContext());
        return childActivation;
    }

    private static void setParametersOnChildActivation(Activation childActivation, ParameterValueSet allPvs, List<Integer> paramsIndexList, List<ArrayList<DataValueDescriptor>> extraParams, LanguageConnectionContext lcc) throws StandardException {
        if (childActivation.getParameterValueSet() != null) {
            if (GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("NcjPullResultSet::setParametersOnChildActivation left param count=" + childActivation.getParameterValueSet().getParameterCount() + " ,right-params-index=" + paramsIndexList + " ,right-param-count=" + paramsIndexList.size() + " ,extra-param-count=" + extraParams.size()));
            }
            if (childActivation.getParameterValueSet().getParameterCount() != paramsIndexList.size() + extraParams.size()) {
                throw new AssertionError((Object)("NcjPullResultSet::setParametersOnChildActivation Parameter Value Set do not have all required parameters. left param count=" + childActivation.getParameterValueSet().getParameterCount() + " ,right param count=" + paramsIndexList.size() + " ,extra param count=" + extraParams.size()));
            }
            Vector<DataValueDescriptor> paramDVDs = new Vector<DataValueDescriptor>(paramsIndexList.size() + extraParams.size());
            for (int paramIndex : paramsIndexList) {
                paramDVDs.add(allPvs.getParameter(paramIndex));
            }
            if (extraParams.size() > 0) {
                int missingParamIndex = paramsIndexList.size();
                ParameterValueSet childPvs = childActivation.getParameterValueSet();
                for (ArrayList<DataValueDescriptor> inlist : extraParams) {
                    DVDSet nullDVDSet = (DVDSet)childPvs.getParameter(missingParamIndex++);
                    DataTypeDescriptor dtp = nullDVDSet.getResultDescriptor();
                    DVDSet newDVDSet = new DVDSet(dtp, DVDSetHashingStrategy.getInstance());
                    for (DataValueDescriptor val : inlist) {
                        if (val.isNull()) continue;
                        newDVDSet.addValueAndCheckType(val);
                    }
                    paramDVDs.add(newDVDSet);
                }
                extraParams.clear();
            }
            GenericParameterValueSet ncjPvs = (GenericParameterValueSet)lcc.getLanguageFactory().newParameterValueSet(lcc.getLanguageConnectionFactory().getClassFactory().getClassInspector(), paramDVDs.size(), false);
            ncjPvs.initialize(paramDVDs);
            childActivation.setParameters(ncjPvs, null);
            if (GemFireXDUtils.TraceNCJIter) {
                SanityManager.DEBUG_PRINT((String)"TraceNCJIter", (String)("NcjPullResultSet::setParametersOnChildActivation Params set=" + paramDVDs));
            }
        } else {
            if (GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("NcjPullResultSet::setParametersOnChildActivation. Activation ==" + childActivation + "  has Null params."));
            }
            if (paramsIndexList != null && paramsIndexList.size() > 0 || extraParams.size() > 0) {
                throw new AssertionError((Object)("NcjPullResultSet::setParametersOnChildActivation. Activation ==" + childActivation + "  has Null params but got list of parameters   with right param count=" + paramsIndexList.size() + " ,extra param count=" + extraParams.size()));
            }
        }
    }

    private static ResultSet executeSqlAsPreparedStatement(Activation parentActivation, Activation childActivation, GenericPreparedStatement ps, boolean execNotNeeded, int prID) throws StandardException {
        ResultSet rSet = null;
        if (!execNotNeeded) {
            ps.setFlags(true, true);
            rSet = ps.execute(childActivation, true, childActivation.getTimeOutMillis(), true, true);
            if (GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("NcjPullResultSet::executeSqlAsPreparedStatement. Using activation ==" + childActivation + " for fetching results.  Create-query-info=" + ps.createQueryInfo() + " ,query-info=" + ps.getQueryInfo()));
            }
        } else if (GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)"NcjPullResultSet::executeSqlAsPreparedStatement. Execution not needed");
        }
        return rSet;
    }

    @Override
    public void printResultSetHierarchy() {
        if (GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("ResultSet Created: " + this.getClass().getSimpleName() + " with resultSetNumber=" + this.resultSetNumber + " with source = " + (this.source != null ? this.source.getClass().getSimpleName() : null) + " and source ResultSetNumber = " + (this.source != null && this.source instanceof NoPutResultSetImpl ? ((NoPutResultSetImpl)this.source).resultSetNumber() : -1)));
        }
    }
}

