/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.execute;

import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.HostStatHelper;
import com.gemstone.gemfire.internal.LinuxSystemStats;
import com.gemstone.gemfire.internal.PureJavaMode;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.SolarisSystemStats;
import com.gemstone.gemfire.internal.WindowsSystemStats;
import com.gemstone.gemfire.internal.cache.DirectoryHolder;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.shared.NativeCalls;
import com.gemstone.gemfire.internal.snappy.StoreCallbacks;
import com.gemstone.gemfire.internal.statistics.VMStats;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdDistributionAdvisor;
import com.pivotal.gemfirexd.internal.engine.distributed.message.GfxdFunctionMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.message.MemberExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.management.NetworkServerConnectionStats;
import com.pivotal.gemfirexd.internal.engine.stats.ConnectionStats;
import com.pivotal.gemfirexd.internal.engine.store.ServerGroupUtils;
import com.pivotal.gemfirexd.internal.snappy.CallbackFactoryProvider;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Logger;

public class MemberStatisticsMessage
extends MemberExecutorMessage {
    private static final long MBFactor = 0x100000L;
    private GemFireCacheImpl gemFireCache;
    private Statistics vmStats;
    private Statistics vmHeapStats;
    private Statistics systemStat;
    private UUID diskStoreUUID;
    private String diskStoreName;
    private long diskStoreDiskSpace;

    public MemberStatisticsMessage() {
        super(true);
    }

    public MemberStatisticsMessage(ResultCollector<Object, Object> rc) {
        super(rc, null, false, true);
    }

    private MemberStatisticsMessage(MemberStatisticsMessage other) {
        super(other);
    }

    @Override
    protected void execute() throws Exception {
        this.gemFireCache = GemFireCacheImpl.getExisting();
        InternalDistributedSystem ids = this.gemFireCache.getDistributedSystem();
        String memberId = ids.getMemberId();
        this.updateStats(ids);
        NetworkServerConnectionStats clientConnectionStats = this.getMemberClientConnectionStats(ids);
        Map<String, Long> memoryStats = this.getMemoryStatistics();
        HashMap<String, Object> memberStatsMap = new HashMap<String, Object>();
        memberStatsMap.put("lastUpdatedOn", System.currentTimeMillis());
        memberStatsMap.put("id", memberId);
        memberStatsMap.put("name", ids.getName());
        memberStatsMap.put("host", this.getHost());
        memberStatsMap.put("userDir", this.getUserDir());
        memberStatsMap.put("logFile", this.getLogFile());
        memberStatsMap.put("processId", this.getProcessId());
        memberStatsMap.put("locator", this.isLocator());
        memberStatsMap.put("dataServer", this.isDataServer());
        memberStatsMap.put("activeLead", this.isActiveLead(ids.getDistributedMember()));
        memberStatsMap.put("lead", this.isLead());
        memberStatsMap.put("cores", Runtime.getRuntime().availableProcessors());
        memberStatsMap.put("maxMemory", this.getMaxMemory());
        memberStatsMap.put("freeMemory", this.getFreeMemory());
        memberStatsMap.put("totalMemory", this.getTotalMemory());
        memberStatsMap.put("usedMemory", this.getUsedMemory());
        int cpuActive = this.getHostCpuUsage();
        memberStatsMap.put("cpuActive", cpuActive >= 0 ? cpuActive : 0);
        memberStatsMap.put("clients", clientConnectionStats.getConnectionsOpen());
        memberStatsMap.put("diskStoreUUID", this.getDiskStoreUUID());
        memberStatsMap.put("diskStoreName", this.getDiskStoreName());
        memberStatsMap.put("diskStoreDiskSpace", this.getDiskStoreDiskSpace());
        memberStatsMap.put("heapStoragePoolUsed", memoryStats.get("heapStoragePoolUsed"));
        memberStatsMap.put("heapStoragePoolSize", memoryStats.get("heapStoragePoolSize"));
        memberStatsMap.put("heapExecutionPoolUsed", memoryStats.get("heapExecutionPoolUsed"));
        memberStatsMap.put("heapExecutionPoolSize", memoryStats.get("heapExecutionPoolSize"));
        memberStatsMap.put("offHeapStoragePoolUsed", memoryStats.get("offHeapStoragePoolUsed"));
        memberStatsMap.put("offHeapStoragePoolSize", memoryStats.get("offHeapStoragePoolSize"));
        memberStatsMap.put("offHeapExecutionPoolUsed", memoryStats.get("offHeapExecutionPoolUsed"));
        memberStatsMap.put("offHeapExecutionPoolSize", memoryStats.get("offHeapExecutionPoolSize"));
        memberStatsMap.put("heapMemorySize", memoryStats.get("heapStoragePoolSize") + memoryStats.get("heapExecutionPoolSize"));
        memberStatsMap.put("heapMemoryUsed", memoryStats.get("heapStoragePoolUsed") + memoryStats.get("heapExecutionPoolUsed"));
        memberStatsMap.put("offHeapMemorySize", memoryStats.get("offHeapStoragePoolSize") + memoryStats.get("offHeapExecutionPoolSize"));
        memberStatsMap.put("offHeapMemoryUsed", memoryStats.get("offHeapStoragePoolUsed") + memoryStats.get("offHeapExecutionPoolUsed"));
        this.lastResult(memberStatsMap);
    }

    private void updateStats(InternalDistributedSystem system) {
        VMStats vmStats;
        if (PureJavaMode.osStatsAreAvailable()) {
            Statistics[] systemStats = null;
            if (HostStatHelper.isSolaris()) {
                systemStats = system.findStatisticsByType(SolarisSystemStats.getType());
            } else if (HostStatHelper.isLinux()) {
                systemStats = system.findStatisticsByType(LinuxSystemStats.getType());
            } else if (HostStatHelper.isOSX()) {
                systemStats = null;
            } else if (HostStatHelper.isWindows()) {
                systemStats = system.findStatisticsByType(WindowsSystemStats.getType());
            }
            if (systemStats != null) {
                this.systemStat = systemStats[0];
            }
        }
        if ((vmStats = system.getStatSampler().getVMStats()) != null) {
            Statistics vmHeapStats;
            Statistics stats = vmStats.getVMStats();
            if (stats != null) {
                this.vmStats = stats;
            }
            if ((vmHeapStats = vmStats.getVMHeapStats()) != null) {
                this.vmHeapStats = vmHeapStats;
            }
            Collection diskStores = this.gemFireCache.listDiskStores();
            long totalDiskSpace = 0L;
            for (DiskStoreImpl dsi : diskStores) {
                DirectoryHolder[] directoryHolders;
                if (dsi.getName().equals(GemFireCacheImpl.getDefaultDiskStoreName())) {
                    this.diskStoreUUID = dsi.getDiskStoreUUID();
                    this.diskStoreName = dsi.getName();
                }
                long diskSpace = 0L;
                for (DirectoryHolder dr : directoryHolders = dsi.getDirectoryHolders()) {
                    diskSpace += dr.getDiskDirectoryStats().getDiskSpace();
                }
                totalDiskSpace += diskSpace;
            }
            this.diskStoreDiskSpace = totalDiskSpace;
        }
    }

    private String getHost() {
        try {
            InetAddress addr = SocketCreator.getLocalHost();
            return addr.getHostName();
        }
        catch (UnknownHostException ex) {
            return "localhost";
        }
    }

    private String getUserDir() {
        return System.getProperty("user.dir");
    }

    private String getLogFile() {
        Logger rootLogger = Logger.getRootLogger();
        if (rootLogger != null) {
            Enumeration e = rootLogger.getAllAppenders();
            while (e.hasMoreElements()) {
                Appender appender = (Appender)e.nextElement();
                if (!(appender instanceof FileAppender)) continue;
                return ((FileAppender)appender).getFile();
            }
        }
        return "";
    }

    private String getProcessId() {
        return Integer.toString(NativeCalls.getInstance().getProcessId());
    }

    private boolean isLocator() {
        return Locator.hasLocator();
    }

    private boolean isDataServer() {
        return ServerGroupUtils.isDataStore();
    }

    private boolean isActiveLead(InternalDistributedMember member) {
        GfxdDistributionAdvisor advisor = GemFireXDUtils.getGfxdAdvisor();
        GfxdDistributionAdvisor.GfxdProfile profile = advisor.getProfile(member);
        return profile != null && profile.hasSparkURL();
    }

    private boolean isLead() {
        HashSet<String> leadGroup = CallbackFactoryProvider.getClusterCallbacks().getLeaderGroup();
        boolean isLead = leadGroup != null && leadGroup.size() > 0 && ServerGroupUtils.isGroupMember(leadGroup);
        return isLead;
    }

    private int getHostCpuUsage() {
        if (this.systemStat != null) {
            return this.systemStat.get("cpuActive").intValue();
        }
        return -1;
    }

    private long getMaxMemory() {
        return this.vmStats.get("maxMemory").longValue();
    }

    private long getFreeMemory() {
        return this.vmStats.get("freeMemory").longValue();
    }

    private long getTotalMemory() {
        return this.vmStats.get("totalMemory").longValue();
    }

    public long getUsedMemory() {
        return this.vmHeapStats.get("usedMemory").longValue();
    }

    public UUID getDiskStoreUUID() {
        return this.diskStoreUUID;
    }

    public String getDiskStoreName() {
        return this.diskStoreName;
    }

    public long getDiskStoreDiskSpace() {
        return this.diskStoreDiskSpace;
    }

    public long getStoragePoolUsed() {
        StoreCallbacks callbacks = CallbackFactoryProvider.getStoreCallbacks();
        return callbacks.getStoragePoolUsedMemory(false) + callbacks.getStoragePoolUsedMemory(true);
    }

    public long getStoragePoolSize() {
        StoreCallbacks callbacks = CallbackFactoryProvider.getStoreCallbacks();
        return callbacks.getStoragePoolSize(false) + callbacks.getStoragePoolSize(true);
    }

    public long getExecutionPoolUsed() {
        StoreCallbacks callbacks = CallbackFactoryProvider.getStoreCallbacks();
        return callbacks.getExecutionPoolUsedMemory(false) + callbacks.getExecutionPoolUsedMemory(true);
    }

    public long getExecutionPoolSize() {
        StoreCallbacks callbacks = CallbackFactoryProvider.getStoreCallbacks();
        return callbacks.getExecutionPoolSize(false) + callbacks.getExecutionPoolSize(true);
    }

    public long getOffHeapMemorySize() {
        StoreCallbacks callbacks = CallbackFactoryProvider.getStoreCallbacks();
        return callbacks.getStoragePoolSize(true) + callbacks.getExecutionPoolSize(true);
    }

    public long getOffHeapMemoryUsed() {
        StoreCallbacks callbacks = CallbackFactoryProvider.getStoreCallbacks();
        return callbacks.getStoragePoolUsedMemory(true) + callbacks.getExecutionPoolUsedMemory(true);
    }

    public long getHeapMemorySize() {
        StoreCallbacks callbacks = CallbackFactoryProvider.getStoreCallbacks();
        return callbacks.getStoragePoolSize(false) + callbacks.getExecutionPoolSize(false);
    }

    public long getHeapMemoryUsed() {
        StoreCallbacks callbacks = CallbackFactoryProvider.getStoreCallbacks();
        return callbacks.getStoragePoolUsedMemory(false) + callbacks.getExecutionPoolUsedMemory(false);
    }

    private Map<String, Long> getMemoryStatistics() {
        HashMap<String, Long> memoryStats = new HashMap<String, Long>();
        StoreCallbacks callbacks = CallbackFactoryProvider.getStoreCallbacks();
        memoryStats.put("heapStoragePoolSize", callbacks.getStoragePoolSize(false));
        memoryStats.put("heapStoragePoolUsed", callbacks.getStoragePoolUsedMemory(false));
        memoryStats.put("heapExecutionPoolSize", callbacks.getExecutionPoolSize(false));
        memoryStats.put("heapExecutionPoolUsed", callbacks.getExecutionPoolUsedMemory(false));
        memoryStats.put("offHeapStoragePoolSize", callbacks.getStoragePoolSize(true));
        memoryStats.put("offHeapStoragePoolUsed", callbacks.getStoragePoolUsedMemory(true));
        memoryStats.put("offHeapExecutionPoolSize", callbacks.getExecutionPoolSize(true));
        memoryStats.put("offHeapExecutionPoolUsed", callbacks.getExecutionPoolUsedMemory(true));
        return memoryStats;
    }

    private NetworkServerConnectionStats getMemberClientConnectionStats(InternalDistributedSystem system) {
        NetworkServerConnectionStats clientConnectionStats = new NetworkServerConnectionStats("Client", 0L, 0L, 0L, 0L, 0L, 0L, 0L);
        StatisticsType connectionStatsType = system.findType(ConnectionStats.name);
        if (connectionStatsType != null) {
            Statistics[] foundStatistics;
            for (Statistics statistics : foundStatistics = system.findStatisticsByType(connectionStatsType)) {
                clientConnectionStats.updateNetworkServerConnectionStats(statistics.getLong("clientConnectionsOpened"), statistics.getLong("clientConnectionsClosed"), statistics.getLong("clientConnectionsAttempted"), statistics.getLong("clientConnectionsFailed"), statistics.getLong("clientConnectionsLifeTime"), statistics.getLong("clientConnectionsOpen"), statistics.getLong("clientConnectionsIdle"));
            }
        }
        return clientConnectionStats;
    }

    @Override
    public Set<DistributedMember> getMembers() {
        return MemberStatisticsMessage.getAllGfxdMembers();
    }

    @Override
    public void postExecutionCallback() {
    }

    @Override
    public boolean isHA() {
        return false;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    @Override
    protected GfxdFunctionMessage clone() {
        return new MemberStatisticsMessage(this);
    }

    @Override
    public byte getGfxdID() {
        return 55;
    }
}

