/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.execute;

import com.gemstone.gemfire.cache.DataPolicy;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.DMLQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.InsertQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireDistributionActivation;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireResultSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.ActivationStatisticsVisitor;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireDistributedResultSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireUpdateResultSet;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecPreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import java.util.Set;

public class GemFireSelectDistributionActivation
extends AbstractGemFireDistributionActivation {
    private final ExecRow projExecRow;

    public GemFireSelectDistributionActivation(ExecPreparedStatement st, LanguageConnectionContext _lcc, DMLQueryInfo qi) throws StandardException {
        super(st, _lcc, qi);
        this.projExecRow = ((SelectQueryInfo)this.qInfo).getProjectionExecRow();
    }

    @Override
    protected void computeNodesForStaticRoutingKeys(Set<Object> staticRoutingKeys) throws StandardException {
        if (this.qInfo.isSelectForUpdateQuery()) {
            DataPolicy dataPolicy = this.qInfo.getRegion().getDataPolicy();
            if (dataPolicy.withPartitioning()) {
                this.qInfo.computeNodes(staticRoutingKeys, this, false);
            }
        } else {
            super.computeNodesForStaticRoutingKeys(staticRoutingKeys);
        }
    }

    @Override
    protected AbstractGemFireResultSet createResultSet(int resultsetNum) throws StandardException {
        if (this.qInfo.isInsertAsSubSelect()) {
            InsertQueryInfo.checkSupportedInsertSubSelect((SelectQueryInfo)this.qInfo);
            String targetTable = this.qInfo.getTargetTableName();
            return new GemFireUpdateResultSet(this, targetTable);
        }
        return new GemFireDistributedResultSet(this);
    }

    @Override
    public final ExecRow getProjectionExecRow() throws StandardException {
        return this.projExecRow;
    }

    @Override
    public final void resetProjectionExecRow() throws StandardException {
        DataValueDescriptor[] dvds;
        for (DataValueDescriptor dvd : dvds = this.projExecRow.getRowArray()) {
            dvd.setToNull();
        }
    }

    @Override
    protected boolean enableStreaming(LanguageConnectionContext lcc) {
        return lcc.streamingEnabled() && !this.preStmt.isSubqueryPrepStatement() && !this.qInfo.isSelectForUpdateQuery() && !this.qInfo.isInsertAsSubSelect();
    }

    @Override
    public void accept(ActivationStatisticsVisitor visitor) {
        visitor.visit(this);
    }
}

