/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.catalog;

import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.index.GfxdIndexManager;
import com.pivotal.gemfirexd.internal.engine.access.operations.MemOperation;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.ExtraTableInfo;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.LimitObjectInput;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Compensation;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.IOException;

public final class TableInfoRefresh
extends MemOperation {
    final ExtraTableInfo tableInfo;
    private boolean skipRefresh;
    private ColumnDescriptor addColumn;
    private int dropColumn;
    private final boolean indexLocked;

    TableInfoRefresh(ExtraTableInfo tableInfo, boolean lockIndex, GemFireTransaction tran) {
        super(tableInfo.container);
        GfxdIndexManager indexManager;
        if (GemFireXDUtils.TraceConglom) {
            SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)("Creating TableInfoRefresh object to refresh cached table info in GemFireContainer at commit for TC " + tran));
        }
        this.tableInfo = tableInfo;
        this.skipRefresh = false;
        this.indexLocked = lockIndex && (indexManager = this.getIndexManager()) != null ? indexManager.lockForGII(true, tran) : false;
    }

    public void scheduleAddColumn(ColumnDescriptor cd) {
        this.addColumn = cd;
    }

    private GfxdIndexManager getIndexManager() {
        LocalRegion r = this.tableInfo.container.getRegion();
        if (r != null) {
            return (GfxdIndexManager)r.getIndexUpdater();
        }
        return null;
    }

    public void scheduleDropColumn(int columnPos) {
        this.dropColumn = columnPos;
    }

    @Override
    public void doMe(Transaction xact, LogInstant instant, LimitObjectInput in) throws StandardException, IOException {
        GemFireTransaction tc = (GemFireTransaction)xact;
        if (GemFireXDUtils.TraceConglom) {
            SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)("Invoked TableInfoRefresh#doMe with skipRefresh=" + this.skipRefresh + " for TX " + tc));
        }
        if (!this.skipRefresh) {
            if (this.addColumn != null || this.dropColumn > 0) {
                this.memcontainer.schemaVersionChange(this.tableInfo.dd, this.tableInfo.getTableDescriptor(), GemFireTransaction.getLanguageConnectionContext(tc));
                if (this.addColumn != null) {
                    this.memcontainer.addColumnAtCommit(this.addColumn);
                } else {
                    this.memcontainer.dropColumnAtCommit(this.dropColumn);
                }
                this.memcontainer.getExtraTableInfo().refreshCachedInfo(null, this.memcontainer);
            }
            this.tableInfo.refreshCachedInfo(null, this.memcontainer);
        }
        if (this.indexLocked) {
            this.getIndexManager().unlockForGII(true, tc);
        }
    }

    @Override
    public boolean doAtCommitOrAbort() {
        return true;
    }

    @Override
    public Compensation generateUndo(Transaction xact, LimitObjectInput in) throws StandardException, IOException {
        this.skipRefresh = true;
        return null;
    }
}

