/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.fabricservice;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.distributed.internal.AbstractDistributionConfig;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gnu.trove.THashMap;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.PublicAPI;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.util.IdUtil;
import com.pivotal.gemfirexd.internal.impl.jdbc.authentication.AuthenticationServiceBase;
import com.pivotal.gemfirexd.internal.impl.services.jmx.GfxdAgentConfigImpl;
import com.pivotal.gemfirexd.internal.impl.services.monitor.FileMonitor;
import com.pivotal.gemfirexd.internal.jdbc.InternalDriver;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public final class FabricServiceUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileMonitor initCachedMonitorLite(Properties inProps, HashMap<Object, Object> sysProps) {
        if (sysProps != null) {
            HashMap<Object, Object> hashMap = sysProps;
            synchronized (hashMap) {
                return FabricServiceUtils.initCachedMonitorLiteImpl(inProps, sysProps);
            }
        }
        return FabricServiceUtils.initCachedMonitorLiteImpl(inProps, sysProps);
    }

    private static FileMonitor initCachedMonitorLiteImpl(Properties inProps, HashMap<Object, Object> sysProps) {
        String gfxdPropFile = inProps.getProperty("gemfirexd.properties");
        boolean isSQLF = false;
        if (gfxdPropFile == null || gfxdPropFile.length() == 0) {
            gfxdPropFile = inProps.getProperty("sqlfire.properties");
            isSQLF = true;
        }
        if (gfxdPropFile != null && gfxdPropFile.length() > 0) {
            System.setProperty(isSQLF ? "sqlfire.properties" : "gemfirexd.properties", gfxdPropFile);
            if (sysProps != null) {
                sysProps.put(isSQLF ? "sqlfire.properties" : "gemfirexd.properties", gfxdPropFile);
            }
        }
        return (FileMonitor)Monitor.getCachedMonitorLite(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties preprocessProperties(Properties inProps, FileMonitor monitorlite, HashMap<Object, Object> sysProps, boolean noThrow) throws SQLException {
        if (sysProps != null) {
            HashMap<Object, Object> hashMap = sysProps;
            synchronized (hashMap) {
                return FabricServiceUtils.preprocessPropertiesImpl(inProps, monitorlite, sysProps, noThrow);
            }
        }
        return FabricServiceUtils.preprocessPropertiesImpl(inProps, monitorlite, null, noThrow);
    }

    private static Properties preprocessPropertiesImpl(Properties inProps, FileMonitor monitorlite, HashMap<Object, Object> sysProps, boolean noThrow) throws SQLException {
        String gfxdLogFile;
        String auth;
        boolean hasMcastPort;
        String flags;
        String disabledFlags;
        if (monitorlite == null) {
            monitorlite = FabricServiceUtils.initCachedMonitorLite(inProps, null);
        }
        if ((disabledFlags = inProps.getProperty("gemfirexd.debug.false")) == null) {
            disabledFlags = monitorlite.getJVMProperty("gemfirexd.debug.false");
        }
        if (disabledFlags != null) {
            SanityManager.addDebugFlags((String)disabledFlags, (boolean)false);
        }
        if ((flags = inProps.getProperty("gemfirexd.debug.true")) == null) {
            flags = monitorlite.getJVMProperty("gemfirexd.debug.true");
        }
        if (flags != null) {
            SanityManager.addDebugFlags((String)flags, (boolean)true);
        }
        Properties fileProps = monitorlite.getApplicationProperties();
        Properties outProps = null;
        Properties promoteToSystemProperties = new Properties();
        Properties inAndFileProps = inProps;
        if (fileProps != null) {
            inAndFileProps = new Properties(fileProps);
            Enumeration<?> propNames = inProps.propertyNames();
            while (propNames.hasMoreElements()) {
                String propName = (String)propNames.nextElement();
                String propValue = inProps.getProperty(propName);
                if (propValue != null) {
                    inAndFileProps.setProperty(propName, propValue);
                    continue;
                }
                inAndFileProps.put(propName, inProps.get(propName));
            }
        }
        outProps = new Properties();
        String bootIndicator = inProps.getProperty("gemfirexd.__rt.fabricapi");
        if (GfxdConstants.BT_INDIC.FABRICAGENT.toString().equals(bootIndicator)) {
            outProps.putAll((Map<?, ?>)GfxdAgentConfigImpl.gfxdFilterOutAgentProperties(outProps));
        }
        Enumeration<?> propNames = inAndFileProps.propertyNames();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            String propValue = inAndFileProps.getProperty(propName);
            if (propValue != null) {
                if (AuthenticationServiceBase.isSecurityProperty(propName, propValue, promoteToSystemProperties)) continue;
                if (propName.startsWith("gemfirexd.user.") || propName.startsWith("sqlfire.user.")) {
                    try {
                        propName = IdUtil.getDBUserId(propName, true);
                    }
                    catch (StandardException se) {
                        throw PublicAPI.wrapStandardException(se);
                    }
                }
                outProps.setProperty(propName, propValue);
                continue;
            }
            Object propObj = inAndFileProps.get(propName);
            if (propObj == null) continue;
            outProps.put(propName, propObj);
        }
        boolean hasLocators = outProps.getProperty("locators") != null || outProps.getProperty("start-locator") != null;
        boolean bl = hasMcastPort = outProps.getProperty("mcast-port") != null || outProps.getProperty("mcast-address") != null;
        if (hasLocators && !hasMcastPort) {
            outProps.setProperty("mcast-port", "0");
        }
        if (!promoteToSystemProperties.isEmpty() && Boolean.parseBoolean(auth = promoteToSystemProperties.getProperty("gemfirexd.authentication.required"))) {
            String userName;
            if (InternalDriver.activeDriver() == null || InternalDriver.activeDriver().isActive()) {
                // empty if block
            }
            String string = userName = (userName = outProps.getProperty("user")) == null ? outProps.getProperty("UserName") : userName;
            if (!noThrow && userName == null && !"NONE".equalsIgnoreCase(promoteToSystemProperties.getProperty("gemfirexd.server-auth-provider"))) {
                StandardException se = StandardException.newException("08001.C.7");
                throw PublicAPI.wrapStandardException(se);
            }
        }
        if (!((gfxdLogFile = outProps.getProperty(GfxdConstants.GFXD_LOG_FILE)) != null && gfxdLogFile.length() != 0 || (gfxdLogFile = outProps.getProperty("gemfire.log-file")) != null && gfxdLogFile.length() != 0 || (gfxdLogFile = outProps.getProperty("log-file")) != null && gfxdLogFile.length() != 0)) {
            gfxdLogFile = "gemfirexd-interface.log";
        }
        FabricServiceUtils.defineSystemPropertyIfAbsent(GfxdConstants.GFXD_PREFIX, "log-file", gfxdLogFile, monitorlite, sysProps);
        FabricServiceUtils.defineSystemPropertyIfAbsent(promoteToSystemProperties, monitorlite, sysProps);
        return outProps;
    }

    private static final void defineSystemPropertyIfAbsent(Properties prop, FileMonitor monitorlite, HashMap<Object, Object> sysProps) {
        for (Map.Entry<Object, Object> p : prop.entrySet()) {
            FabricServiceUtils.defineSystemPropertyIfAbsent(null, (String)p.getKey(), (String)p.getValue(), monitorlite, sysProps);
        }
    }

    public static final void defineSystemPropertyIfAbsent(String keyPrefix, String key, String value, FileMonitor monitorlite, HashMap<Object, Object> sysProps) {
        String sysvalue;
        String searchKey;
        if (monitorlite == null) {
            monitorlite = (FileMonitor)Monitor.getMonitorLite();
        }
        String string = searchKey = keyPrefix != null ? keyPrefix + key : key;
        if (monitorlite.getJVMProperty(searchKey) != null) {
            return;
        }
        if (keyPrefix != null && (sysvalue = monitorlite.getJVMProperty("gemfire." + key)) != null) {
            value = sysvalue;
        }
        String oldVal = monitorlite.setJVMProperty(searchKey, value);
        if (sysProps != null) {
            sysProps.put(key, oldVal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void clearSystemProperties(FileMonitor monitorlite, HashMap<Object, Object> sysProps) {
        if (sysProps != null) {
            HashMap<Object, Object> hashMap = sysProps;
            synchronized (hashMap) {
                FabricServiceUtils.clearSystemPropertiesImpl(monitorlite, sysProps);
            }
        } else {
            FabricServiceUtils.clearSystemPropertiesImpl(monitorlite, sysProps);
        }
    }

    private static void clearSystemPropertiesImpl(FileMonitor monitorlite, HashMap<Object, Object> sysProps) {
        if (monitorlite != null) {
            for (Map.Entry<Object, Object> ent : sysProps.entrySet()) {
                String msg;
                String key = (String)ent.getKey();
                String val = (String)ent.getValue();
                if (val == null) {
                    msg = "clearing " + key;
                    monitorlite.clearJVMProperty(key);
                } else {
                    msg = "restoring " + key + " to " + val;
                    monitorlite.setJVMProperty(key, val);
                }
                if (!GemFireXDUtils.TraceFabricServiceBoot) continue;
                SanityManager.DEBUG_PRINT((String)"TraceFabricServiceBoot", (String)msg);
            }
        }
        sysProps.clear();
    }

    public static final Properties filterGemFireProperties(Properties inProps, String defaultLogFileName) {
        Object[] gfeProps = FabricServiceUtils.getGFEPropNames();
        THashMap outProps = new THashMap();
        Enumeration<?> propNames = inProps.propertyNames();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            String propValue = inProps.getProperty(propName);
            if (propName.startsWith("hadoop.gemfirexd.loner.")) continue;
            if (propName.startsWith("gemfire.")) {
                outProps.put((Object)propName.substring("gemfire.".length()), (Object)propValue);
                continue;
            }
            if (propName.startsWith("custom-")) {
                outProps.put((Object)("gemfirexd.custom." + propName.substring("custom-".length())), (Object)propValue);
                continue;
            }
            if (propName.startsWith("gemfirexd.custom-")) {
                outProps.put((Object)("gemfirexd.custom." + propName.substring("gemfirexd.custom-".length())), (Object)propValue);
                continue;
            }
            if (propValue != null && Arrays.binarySearch(gfeProps, propName) >= 0) {
                outProps.put((Object)propName, (Object)propValue);
                continue;
            }
            if (propName.startsWith(GfxdConstants.GFXD_PREFIX) || propName.startsWith("sqlfire.") || propName.startsWith("custom-") || propName.startsWith("derbyTesting.") || propName.startsWith("snappydata.") || propName.startsWith("metastore-") || propName.startsWith("spark.") || propName.startsWith("jobserver.") || propName.startsWith("zeppelin.") || propName.startsWith("snappydata.connector.") || GfxdConstants.validExtraGFXDProperties.contains(propName) || "BootPassword".equalsIgnoreCase(propName) || "encryptionAlgorithm".equalsIgnoreCase(propName) || "dataEncryption".equalsIgnoreCase(propName) || "encryptionKey".equalsIgnoreCase(propName) || "newBootPassword".equalsIgnoreCase(propName) || "encryptionProvider".equalsIgnoreCase(propName) || "encryptionKeyLength".equalsIgnoreCase(propName)) continue;
            throw new IllegalArgumentException("Unknown configuration attribute name '" + propName + "'. Valid names are: " + GfxdConstants.validExtraGFXDProperties + ". Valid cluster attributes: " + Arrays.toString(gfeProps));
        }
        if (!outProps.contains((Object)"log-file")) {
            outProps.put((Object)"log-file", (Object)defaultLogFileName);
        }
        Properties props = new Properties();
        props.putAll((Map<?, ?>)outProps);
        return props;
    }

    public static InetAddress getListenAddress(String bindAddress, DistributionConfig config) throws UnknownHostException {
        if (bindAddress == null) {
            try {
                if (config == null) {
                    InternalDistributedSystem dsys = Misc.getGemFireCache().getDistributedSystem();
                    config = dsys.getConfig();
                }
                bindAddress = config.getBindAddress();
            }
            catch (CacheClosedException cacheClosedException) {
                // empty catch block
            }
        }
        InetAddress listenAddress = bindAddress != null && bindAddress.length() > 0 ? InetAddress.getByName(bindAddress) : InetAddress.getByName(null);
        return listenAddress;
    }

    public static String[] getGFEPropNames() {
        return AbstractDistributionConfig._getAttNames();
    }
}

