/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.shared.Version;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionWrapper;
import com.pivotal.gemfirexd.internal.engine.distributed.ResultHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.message.PrepStatementExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.message.StatementExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ParameterValueSet;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSet;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import java.sql.SQLException;
import java.util.Properties;

public abstract class StatementQueryExecutor {
    protected StatementQueryExecutor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void executeStatement(String defaultSchema, long connId, long stmtId, long rootID, int stmtLevel, String source, boolean isSelect, int activationFlags, boolean needGfxdSubActivation, boolean enableStats, boolean enableTimeStats, FunctionContext fc, String argsStr, TXStateInterface tx, ParameterValueSet constantValueSet, boolean flattenSubquery, boolean isInsertAsSubSelect, StatementExecutorMessage<T> msg) throws Exception {
        boolean compileOutOfDatePlan = true;
        while (compileOutOfDatePlan) {
            compileOutOfDatePlan = false;
            ResultHolder rh = null;
            boolean isPossibleDuplicate = false;
            if (fc instanceof RegionFunctionContext) {
                isPossibleDuplicate = ((RegionFunctionContext)fc).isPossibleDuplicate();
            }
            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                StringBuilder builder = new StringBuilder("StatementQueryExecutor#executeStatement: Arguments=").append(argsStr);
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)builder.append("; possibleDuplicate=").append(isPossibleDuplicate).toString());
            }
            Properties props = new Properties();
            props.setProperty("query-HDFS", Boolean.toString(msg.getQueryHDFS()));
            GfxdConnectionWrapper wrapper = GfxdConnectionHolder.getOrCreateWrapper(defaultSchema, connId, false, props);
            EmbedConnection conn = wrapper.getConnectionForSynchronization();
            Object object = conn.getConnectionSynchronization();
            synchronized (object) {
                Activation act;
                int oldLCCFlags;
                GemFireTransaction tc;
                LanguageConnectionContext lcc;
                int syncVersion;
                EmbedResultSet ers;
                EmbedStatement stmt;
                boolean needContextStackRestore;
                block49: {
                    needContextStackRestore = false;
                    stmt = null;
                    ers = null;
                    syncVersion = wrapper.convertToHardReference(conn);
                    lcc = null;
                    tc = null;
                    oldLCCFlags = 0;
                    act = null;
                    try {
                        lcc = wrapper.getLanguageConnectionContext();
                        oldLCCFlags = lcc.getFlags();
                        wrapper.setLccFlags(lcc, isPossibleDuplicate, enableStats, enableTimeStats, constantValueSet, msg);
                        tc = (GemFireTransaction)lcc.getTransactionExecute();
                        GfxdConnectionWrapper.checkForTransaction(conn, tc, tx);
                        stmt = wrapper.getStatement(source, stmtId, false, needGfxdSubActivation, flattenSubquery, false, msg.getNCJMetaDataOnRemote(), false, rootID, stmtLevel);
                        stmt.setQueryTimeout((int)(msg.getTimeOutMillis() / 1000L));
                        GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
                        if (observer != null) {
                            observer.beforeQueryExecutionByStatementQueryExecutor(wrapper, stmt, source);
                        }
                        if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("StatementQueryExecutor#executeStatement: reached data node for query=" + source + " pvs=" + constantValueSet + " isInsertAsSubSelect=" + isInsertAsSubSelect));
                        }
                        if (isSelect && !isInsertAsSubSelect) {
                            ers = (EmbedResultSet)stmt.executeQueryByPassQueryInfo(source, needGfxdSubActivation, flattenSubquery, activationFlags, fc);
                            act = ers.getSourceResultSet().getActivation();
                            act.setConnectionID(connId);
                            needContextStackRestore = true;
                            rh = new ResultHolder(ers, stmt, wrapper, oldLCCFlags, msg, (activationFlags & 7) != 0);
                            if (msg.isLocallyExecuted()) {
                                if (rh.setupResults(msg.getGfxdResultCollector(), act)) {
                                    lcc = null;
                                    act = null;
                                }
                            } else {
                                Version v;
                                InternalDistributedMember m = msg.getSenderForReply();
                                Version version = v = m != null ? m.getVersionObject() : null;
                                while (rh.prepareSend(v)) {
                                    msg.sendResult(rh);
                                }
                            }
                            msg.lastResult(rh, false, false, false);
                            msg.lastResultSent = true;
                        } else {
                            rh = null;
                            int numUpdate = stmt.executeUpdateByPassQueryInfo(source, needGfxdSubActivation, flattenSubquery, activationFlags, fc);
                            msg.lastResult(numUpdate);
                            msg.lastResultSent = true;
                        }
                        if (observer != null) {
                            observer.afterQueryExecutionByStatementQueryExecutor(wrapper, stmt, source);
                        }
                        if (msg.process_time != 0L) {
                            msg.process_time = XPLAINUtil.recordTiming(msg.process_time);
                        }
                        if (lcc != null) {
                            wrapper.process(conn, rh, stmt, msg);
                        }
                        if (rh != null) break block49;
                        stmt.close();
                    }
                    catch (SQLException se) {
                        if (!"XCL32".equals(se.getSQLState())) {
                            throw se;
                        }
                        compileOutOfDatePlan = true;
                        continue;
                    }
                    finally {
                        if (rh != null && !msg.lastResultSent && GemFireXDUtils.isOffHeapEnabled()) {
                            if (msg.isLocallyExecuted()) {
                                rh.freeOffHeapForCachedRowsAndCloseResultSet();
                            } else {
                                rh.close(null, null);
                            }
                        }
                        if (needContextStackRestore) {
                            GfxdConnectionWrapper.restoreContextStack(stmt, ers);
                        }
                        if (lcc != null) {
                            if (rh != null) {
                                rh.clear();
                            }
                            lcc.setFlags(oldLCCFlags);
                            lcc.setPossibleDuplicate(false);
                            lcc.setConstantValueSet(null, null);
                        }
                        if (act != null) {
                            act.setFlags(0);
                            act.setFunctionContext(null);
                        }
                        if (tc != null) {
                            tc.resetTXState();
                        }
                        if (!wrapper.isClosed()) {
                            if (stmt != null && !stmt.isPrepared()) {
                                wrapper.removeStmtFromMap(stmtId);
                            }
                            if (wrapper.convertToSoftReference(syncVersion)) {
                                msg.wrapperForMarkUnused = wrapper;
                            }
                        } else if (lcc != null && !wrapper.isCached()) {
                            wrapper.close(false, false);
                        }
                        msg.wrapperForMarkUnused = wrapper;
                    }
                }
                if (rh != null && !msg.lastResultSent && GemFireXDUtils.isOffHeapEnabled()) {
                    if (msg.isLocallyExecuted()) {
                        rh.freeOffHeapForCachedRowsAndCloseResultSet();
                    } else {
                        rh.close(null, null);
                    }
                }
                if (needContextStackRestore) {
                    GfxdConnectionWrapper.restoreContextStack(stmt, ers);
                }
                if (lcc != null) {
                    if (rh != null) {
                        rh.clear();
                    }
                    lcc.setFlags(oldLCCFlags);
                    lcc.setPossibleDuplicate(false);
                    lcc.setConstantValueSet(null, null);
                }
                if (act != null) {
                    act.setFlags(0);
                    act.setFunctionContext(null);
                }
                if (tc != null) {
                    tc.resetTXState();
                }
                if (!wrapper.isClosed()) {
                    if (stmt != null && !stmt.isPrepared()) {
                        wrapper.removeStmtFromMap(stmtId);
                    }
                    if (wrapper.convertToSoftReference(syncVersion)) {
                        msg.wrapperForMarkUnused = wrapper;
                    }
                } else if (lcc != null && !wrapper.isCached()) {
                    wrapper.close(false, false);
                }
                msg.wrapperForMarkUnused = wrapper;
            }
            msg.endMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, M> void executePrepStatement(String userName, long connId, long stmtId, String source, int activationFlags, boolean enableStats, boolean enableTimeStats, FunctionContext fc, String argsStr, TXStateInterface tx, PrepStatementExecutorMessage<M> msg) throws Exception {
        ResultHolder rh = null;
        boolean compileOutOfDatePlan = true;
        while (compileOutOfDatePlan) {
            compileOutOfDatePlan = false;
            boolean isPossibleDuplicate = false;
            if (fc instanceof RegionFunctionContext) {
                isPossibleDuplicate = ((RegionFunctionContext)fc).isPossibleDuplicate();
            }
            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                StringBuilder builder = new StringBuilder("StatementQueryExecutor#executePrepStatement: Arguments=").append(argsStr);
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)builder.append("; posDup = ").append(isPossibleDuplicate).toString());
            }
            ParameterValueSet pvs = null;
            GfxdConnectionWrapper wrapper = msg.getAndClearWrapper(userName, connId);
            EmbedConnection conn = wrapper.getConnectionForSynchronization();
            Object object = conn.getConnectionSynchronization();
            synchronized (object) {
                GemFireTransaction tc;
                int oldLCCFlags;
                Activation act;
                LanguageConnectionContext lcc;
                int syncVersion;
                EmbedResultSet ers;
                EmbedPreparedStatement pstmt;
                boolean needContextStackRestore;
                block54: {
                    needContextStackRestore = false;
                    pstmt = null;
                    ers = null;
                    syncVersion = wrapper.convertToHardReference(conn);
                    msg.wrapperForMarkUnused = null;
                    lcc = null;
                    act = null;
                    oldLCCFlags = 0;
                    tc = null;
                    try {
                        lcc = wrapper.getLanguageConnectionContext();
                        oldLCCFlags = lcc.getFlags();
                        wrapper.setLccFlags(lcc, isPossibleDuplicate, enableStats, enableTimeStats, msg);
                        tc = (GemFireTransaction)lcc.getTransactionExecute();
                        GfxdConnectionWrapper.checkForTransaction(conn, tc, tx);
                        pstmt = msg.getAndClearPreparedStatement();
                        pvs = pstmt.getParms();
                        GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
                        if (observer != null) {
                            observer.beforeQueryExecutionByPrepStatementQueryExecutor(wrapper, pstmt, source);
                        }
                        act = pstmt.getActivation();
                        if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("StatementQueryExecutor#executePrepStatement: Member ID of self=" + GemFireStore.getMyId() + " connID=" + connId + " statementID=" + stmtId + " query string = " + source + "; pvs=" + pvs + "; posDup=" + isPossibleDuplicate + " activation: " + act));
                        }
                        act.setFlags(activationFlags);
                        act.setFunctionContext(fc);
                        act.setConnectionID(connId);
                        pstmt.setQueryTimeout((int)(msg.getTimeOutMillis() / 1000L));
                        int statementType = pstmt.getStatementType();
                        if (statementType == 0) {
                            ers = (EmbedResultSet)pstmt.executeQueryByPassQueryInfo();
                            needContextStackRestore = true;
                            rh = new ResultHolder(ers, pstmt, wrapper, oldLCCFlags, msg, (activationFlags & 7) != 0);
                            if (msg.isLocallyExecuted()) {
                                if (rh.setupResults(msg.getGfxdResultCollector(), act)) {
                                    lcc = null;
                                    act = null;
                                }
                            } else {
                                Version v;
                                InternalDistributedMember m = msg.getSenderForReply();
                                Version version = v = m != null ? m.getVersionObject() : null;
                                while (rh.prepareSend(v)) {
                                    msg.sendResult(rh);
                                }
                            }
                            msg.lastResult(rh, false, false, false);
                            msg.lastResultSent = true;
                        } else if (statementType == 3 || statementType == 1 || statementType == 4) {
                            rh = null;
                            ers = null;
                            int numUpdate = pstmt.executeUpdate();
                            msg.lastResult(numUpdate);
                            msg.lastResultSent = true;
                        } else {
                            throw new IllegalArgumentException("The statement type = " + statementType + " not supported");
                        }
                        if (observer != null) {
                            observer.afterQueryExecutionByPrepStatementQueryExecutor(wrapper, pstmt, source);
                        }
                        if (msg.process_time != 0L) {
                            msg.process_time = XPLAINUtil.recordTiming(msg.process_time);
                        }
                        if (lcc == null) break block54;
                        wrapper.process(conn, rh, pstmt, msg);
                    }
                    catch (SQLException se) {
                        if (!"XCL32".equals(se.getSQLState())) {
                            throw se;
                        }
                        compileOutOfDatePlan = true;
                        continue;
                    }
                    finally {
                        if (!msg.lastResultSent && rh != null && GemFireXDUtils.isOffHeapEnabled()) {
                            if (msg.isLocallyExecuted()) {
                                rh.freeOffHeapForCachedRowsAndCloseResultSet();
                            } else {
                                rh.close(null, null);
                            }
                        }
                        if (needContextStackRestore) {
                            GfxdConnectionWrapper.restoreContextStack(pstmt, ers);
                        }
                        if (lcc != null) {
                            lcc.setFlags(oldLCCFlags);
                            lcc.setPossibleDuplicate(false);
                        }
                        if (act != null) {
                            act.setFlags(0);
                            act.setFunctionContext(null);
                        }
                        if (tc != null) {
                            tc.resetTXState();
                        }
                        if (!wrapper.isClosed()) {
                            if (wrapper.convertToSoftReference(syncVersion)) {
                                msg.wrapperForMarkUnused = wrapper;
                            }
                        } else if (lcc != null && !wrapper.isCached()) {
                            try {
                                if (pstmt != null && !pstmt.isClosed()) {
                                    pstmt.close();
                                }
                            }
                            catch (SQLException sQLException) {}
                            wrapper.close(false, false);
                        }
                        msg.wrapperForMarkUnused = wrapper;
                    }
                }
                if (!msg.lastResultSent && rh != null && GemFireXDUtils.isOffHeapEnabled()) {
                    if (msg.isLocallyExecuted()) {
                        rh.freeOffHeapForCachedRowsAndCloseResultSet();
                    } else {
                        rh.close(null, null);
                    }
                }
                if (needContextStackRestore) {
                    GfxdConnectionWrapper.restoreContextStack(pstmt, ers);
                }
                if (lcc != null) {
                    lcc.setFlags(oldLCCFlags);
                    lcc.setPossibleDuplicate(false);
                }
                if (act != null) {
                    act.setFlags(0);
                    act.setFunctionContext(null);
                }
                if (tc != null) {
                    tc.resetTXState();
                }
                if (!wrapper.isClosed()) {
                    if (wrapper.convertToSoftReference(syncVersion)) {
                        msg.wrapperForMarkUnused = wrapper;
                    }
                } else if (lcc != null && !wrapper.isCached()) {
                    try {
                        if (pstmt != null && !pstmt.isClosed()) {
                            pstmt.close();
                        }
                    }
                    catch (SQLException observer) {
                        // empty catch block
                    }
                    wrapper.close(false, false);
                }
                msg.wrapperForMarkUnused = wrapper;
            }
            msg.endMessage();
        }
    }

    public static GfxdConnectionWrapper getOrCreateWrapper(String defaultSchema, long connId, Properties props) throws SQLException {
        return GfxdConnectionHolder.getHolder().createWrapper(defaultSchema, connId, false, props);
    }
}

