/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ByteArrayOutput
extends OutputStream {
    protected byte[] buffer;
    protected int bufferPos;
    protected int bufferLen;
    public static final int DEFAULT_CAPACITY = 1024;

    public ByteArrayOutput() {
        this(1024);
    }

    public ByteArrayOutput(int allocSize) {
        this.buffer = new byte[allocSize < 32 ? 32 : allocSize];
        this.bufferLen = this.buffer.length;
    }

    public final int ensureCapacity(int minCapacity, int bufferPos) {
        if (bufferPos + minCapacity < this.bufferLen) {
            return bufferPos;
        }
        int newLen = bufferPos + minCapacity + (this.bufferLen >> 2);
        this.buffer = Arrays.copyOf(this.buffer, newLen);
        this.bufferLen = newLen;
        return bufferPos;
    }

    @Override
    public final void write(int b) {
        try {
            this.buffer[this.bufferPos++] = (byte)b;
            return;
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.ensureCapacity(1, this.bufferPos);
            this.buffer[this.bufferPos++] = (byte)b;
            return;
        }
    }

    @Override
    public final void write(byte[] source, int offset, int len) {
        int bufferPos = this.bufferPos;
        int remaining = this.bufferLen - bufferPos;
        if (len <= remaining) {
            System.arraycopy(source, offset, this.buffer, bufferPos, len);
            this.bufferPos += len;
        } else {
            this.ensureCapacity(len, bufferPos);
            System.arraycopy(source, offset, this.buffer, this.bufferPos, len);
            this.bufferPos += len;
        }
    }

    @Override
    public final void write(byte[] source) {
        this.write(source, 0, source.length);
    }

    public final byte[] getData() {
        return this.buffer;
    }

    public final int position() {
        return this.bufferPos;
    }

    public final void advance(int n) {
        this.bufferPos += n;
    }

    public final int size() {
        return this.bufferPos;
    }

    public final void clearForReuse() {
        this.bufferPos = 0;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        this.buffer = null;
        this.bufferPos = -1;
    }

    public final byte[] toByteArray() {
        return Arrays.copyOf(this.buffer, this.bufferPos);
    }

    public final void sendTo(ByteBuffer out) {
        int bufferPos = this.bufferPos;
        if (bufferPos > 0) {
            if (out.remaining() < bufferPos) {
                throw new BufferOverflowException();
            }
            out.put(this.buffer, 0, bufferPos);
        }
    }

    public final void sendTo(OutputStream out) throws IOException {
        int bufferPos = this.bufferPos;
        if (bufferPos > 0) {
            out.write(this.buffer, 0, bufferPos);
        }
    }

    public final void sendTo(DataOutput out) throws IOException {
        int bufferPos = this.bufferPos;
        if (bufferPos > 0) {
            out.write(this.buffer, 0, bufferPos);
        }
    }
}

