/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.gemstone.gemfire.internal.shared.unsafe.ChannelBufferUnsafeDataOutputStream;
import com.pivotal.gemfirexd.internal.engine.distributed.ByteArrayOutput;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import java.io.DataOutput;
import java.io.UTFDataFormatException;
import javax.annotation.Nonnull;
import org.apache.spark.unsafe.Platform;

public final class ByteArrayDataOutput
extends ByteArrayOutput
implements DataOutput {
    static void init() {
    }

    public ByteArrayDataOutput() {
    }

    public ByteArrayDataOutput(int allocSize) {
        super(allocSize);
    }

    @Override
    public final void writeBoolean(boolean v) {
        super.write(v ? 1 : 0);
    }

    @Override
    public final void writeByte(int v) {
        super.write(v);
    }

    @Override
    public final void writeShort(int v) {
        int pos = this.ensureCapacity(2, this.bufferPos);
        byte[] buffer = this.buffer;
        buffer[pos++] = (byte)(v >>> 8 & 0xFF);
        buffer[pos++] = (byte)(v & 0xFF);
        this.bufferPos = pos;
    }

    @Override
    public final void writeChar(int v) {
        this.writeShort(v);
    }

    @Override
    public final void writeInt(int v) {
        int pos = this.ensureCapacity(4, this.bufferPos);
        byte[] buffer = this.buffer;
        buffer[pos++] = (byte)(v >>> 24 & 0xFF);
        buffer[pos++] = (byte)(v >>> 16 & 0xFF);
        buffer[pos++] = (byte)(v >>> 8 & 0xFF);
        buffer[pos++] = (byte)(v & 0xFF);
        this.bufferPos = pos;
    }

    @Override
    public final void writeLong(long v) {
        int pos = this.ensureCapacity(8, this.bufferPos);
        byte[] buffer = this.buffer;
        buffer[pos++] = (byte)(v >>> 56 & 0xFFL);
        buffer[pos++] = (byte)(v >>> 48 & 0xFFL);
        buffer[pos++] = (byte)(v >>> 40 & 0xFFL);
        buffer[pos++] = (byte)(v >>> 32 & 0xFFL);
        buffer[pos++] = (byte)(v >>> 24 & 0xFFL);
        buffer[pos++] = (byte)(v >>> 16 & 0xFFL);
        buffer[pos++] = (byte)(v >>> 8 & 0xFFL);
        buffer[pos++] = (byte)(v & 0xFFL);
        this.bufferPos = pos;
    }

    @Override
    public final void writeFloat(float v) {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public final void writeDouble(double v) {
        this.writeLong(Double.doubleToLongBits(v));
    }

    final void writeBytes(char[] str, int strlen) {
        int pos = this.ensureCapacity(strlen, this.bufferPos);
        byte[] buffer = this.buffer;
        for (char c : str) {
            buffer[pos++] = (byte)c;
        }
        this.bufferPos = pos;
    }

    public final void writeBytes(char[] str, int offset, int end) {
        int pos = this.ensureCapacity(end - offset, this.bufferPos);
        byte[] buffer = this.buffer;
        while (offset < end) {
            buffer[pos++] = (byte)str[offset++];
        }
        this.bufferPos = pos;
    }

    public final void writeBytes(String str, int strlen) {
        char[] chars = ResolverUtils.getInternalCharsOnly((String)str, (int)strlen);
        if (chars != null) {
            this.writeBytes(chars, strlen);
            return;
        }
        int pos = this.ensureCapacity(strlen, this.bufferPos);
        byte[] buffer = this.buffer;
        for (int i = 0; i < strlen; ++i) {
            buffer[pos++] = (byte)str.charAt(i);
        }
        this.bufferPos = pos;
    }

    @Override
    public final void writeBytes(@Nonnull String str) {
        this.writeBytes(str, str.length());
    }

    @Override
    public final void writeChars(@Nonnull String str) {
        int strlen = str.length();
        int pos = this.ensureCapacity(strlen << 1, this.bufferPos);
        byte[] buffer = this.buffer;
        for (int i = 0; i < strlen; ++i) {
            char c = str.charAt(i);
            buffer[pos++] = (byte)(c >>> 8 & 0xFF);
            buffer[pos++] = (byte)(c & 0xFF);
        }
        this.bufferPos = pos;
    }

    @Override
    public final void writeUTF(@Nonnull String str) throws UTFDataFormatException {
        int strLen = str.length();
        int utfLen = ClientSharedUtils.getUTFLength((String)str, (int)strLen);
        if (utfLen <= 65535) {
            this.ensureCapacity(2 + utfLen, this.bufferPos);
            this.writeShort(utfLen);
            ChannelBufferUnsafeDataOutputStream.writeUTFSegmentNoOverflow((String)str, (int)0, (int)strLen, (int)utfLen, (Object)this.buffer, (long)(Platform.BYTE_ARRAY_OFFSET + this.bufferPos));
            this.bufferPos += utfLen;
        } else {
            throw new UTFDataFormatException("ByteArrayDataOutput#writeUTF: encoded string too long: " + utfLen + " bytes");
        }
    }
}

