/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ddl.callbacks.messages;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.internal.cache.execute.InternalFunctionInvocationTargetException;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.callbacks.CallbackProcedures;
import com.pivotal.gemfirexd.internal.engine.ddl.wan.messages.AbstractGfxdReplayableMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.FunctionExecutionException;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;

public class GfxdRemoveGatewayEventErrorHandlerMessage
extends AbstractGfxdReplayableMessage {
    private static final long serialVersionUID = -7742282110492617492L;

    @Override
    public void execute() throws StandardException {
        LogWriter logger = Misc.getGemFireCache().getLoggerI18n().convertToLogWriter();
        EmbedConnection conn = null;
        boolean contextSet = false;
        try {
            conn = GemFireXDUtils.getTSSConnection(true, true, false);
            conn.getTR().setupContextStack();
            contextSet = true;
            if (logger.infoEnabled()) {
                logger.info("GfxdRemoveGatewayEventErrorHandlerMessage: Executing with fields as: " + this.toString());
            }
            CallbackProcedures.removeGfxdGatewayEventErrorHandlerLocally();
        }
        catch (Exception ex) {
            if (logger.fineEnabled()) {
                logger.fine("GfxdRemoveGatewayEventErrorHandlerMessage#execute: exception encountered", (Throwable)ex);
            }
            if (GemFireXDUtils.retryToBeDone(ex)) {
                throw new InternalFunctionInvocationTargetException((Throwable)ex);
            }
            throw new FunctionExecutionException(ex);
        }
        finally {
            if (contextSet) {
                block14: {
                    try {
                        conn.internalCommit();
                    }
                    catch (SQLException ex) {
                        if (!logger.fineEnabled()) break block14;
                        logger.fine("GfxdRemoveGatewayEventErrorHandlerMessage#execute: exception encountered", (Throwable)ex);
                    }
                }
                conn.getTR().restoreContextStack();
            }
        }
    }

    @Override
    public byte getGfxdID() {
        return 52;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
    }

    @Override
    public void appendFields(StringBuilder sb) {
        super.appendFields(sb);
    }

    public boolean shouldBeConflated() {
        return true;
    }

    public String getRegionToConflate() {
        return "SYS";
    }

    public Object getKeyToConflate() {
        return "__GFXD_INTERNAL_GFXDGATEWAYEVENTERRORHANDLER.";
    }

    public Object getValueToConflate() {
        return null;
    }

    @Override
    public String getSQLStatement() {
        return "CALL SYS.REMOVE_GATEWAY_EVENT_ERROR_HANDLER()";
    }
}

