/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access.operations;

import com.gemstone.gemfire.cache.ConflictException;
import com.gemstone.gemfire.cache.query.IndexMaintenanceException;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.cache.AbstractRegionEntry;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.ObjectEqualsHashingStrategy;
import com.gemstone.gemfire.internal.cache.OffHeapRegionEntry;
import com.gemstone.gemfire.internal.cache.TXEntryState;
import com.gemstone.gemfire.internal.cache.TXId;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.cache.locks.ExclusiveSharedSynchronizer;
import com.gemstone.gemfire.internal.cache.locks.LockMode;
import com.gemstone.gemfire.internal.cache.locks.LockingPolicy;
import com.gemstone.gemfire.internal.concurrent.ConcurrentSkipListMap;
import com.gemstone.gemfire.internal.concurrent.ConcurrentTHashSet;
import com.gemstone.gemfire.internal.concurrent.MapCallback;
import com.gemstone.gemfire.internal.concurrent.MapCallbackAdapter;
import com.gemstone.gemfire.internal.concurrent.MapResult;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.gemstone.gnu.trove.HashingStats;
import com.gemstone.gnu.trove.TObjectHashingStrategy;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.index.GfxdIndexManager;
import com.pivotal.gemfirexd.internal.engine.access.operations.MemIndexOperation;
import com.pivotal.gemfirexd.internal.engine.access.operations.SortedMap2IndexDeleteOperation;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeIndexKey;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.entry.GfxdTXEntryState;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.LimitObjectInput;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Compensation;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.iapi.types.WrapperRowLocationForTxn;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.IOException;

public final class SortedMap2IndexInsertOperation
extends MemIndexOperation {
    protected final boolean isUnique;
    protected boolean result;
    public static final InsertOrUpdateValue insertOrUpdateValue = new InsertOrUpdateValue(false);
    public static final InsertOrUpdateValue insertOrUpdateValueForPut = new InsertOrUpdateValue(true);
    static final ReplaceValue replaceValue = new ReplaceValue(false);
    static final ReplaceValue replaceValuePut = new ReplaceValue(false);

    public SortedMap2IndexInsertOperation(GemFireContainer container, Object key, RowLocation value, boolean isUnique) {
        super(container, key, value);
        this.isUnique = isUnique;
    }

    @Override
    public void doMe(Transaction tran, LogInstant instant, LimitObjectInput in) throws StandardException, IOException {
        this.result = SortedMap2IndexInsertOperation.doMe(null, null, this.memcontainer, this.key, this.row, this.isUnique, null, false);
    }

    public static boolean doMe(GemFireTransaction tran, TXStateInterface tx, GemFireContainer container, Object key, RowLocation value, boolean isUnique, WrapperRowLocationForTxn wrapperToReplaceUniqEntry, boolean isPutDML) throws StandardException {
        if (tran != null && tran.needLogging()) {
            SortedMap2IndexInsertOperation op = new SortedMap2IndexInsertOperation(container, key, value, isUnique);
            tran.logAndDo(op);
            return op.result;
        }
        return SortedMap2IndexInsertOperation.insertIntoSkipListMap(tx, container, key, value, isUnique, wrapperToReplaceUniqEntry, isPutDML);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean insertIntoSkipListMap(TXStateInterface tx, GemFireContainer container, Object key, RowLocation value, boolean isUnique, WrapperRowLocationForTxn wrapperToReplaceUniqEntry, boolean isPutDML) throws StandardException {
        GemFireXDQueryObserver observer;
        block22: {
            ConcurrentSkipListMap<Object, Object> skipListMap = container.getSkipListMap();
            long lockTimeout = -1L;
            int waitThreshold = -1;
            if (GemFireXDUtils.TraceIndex) {
                if (wrapperToReplaceUniqEntry == null) {
                    GfxdIndexManager.traceIndex("SortedMap2IndexInsertOp: inserting key=(%s) value=%s into (%s)", key, value, container);
                } else {
                    GfxdIndexManager.traceIndex("SortedMap2IndexInsertOp: replacing for key=(%s) value=%s to wrappervalue=%s into (%s)", key, value, wrapperToReplaceUniqEntry, container);
                }
            }
            assert (skipListMap != null);
            assert (key != null) : "The key for index operation cannot be null";
            assert ((!(key instanceof DataValueDescriptor[]) || ((DataValueDescriptor[])key).length >= 2) && (key instanceof DataValueDescriptor[] || key instanceof DataValueDescriptor) || key instanceof CompactCompositeIndexKey) : "unexpected key " + key;
            assert (value != null) : "The value for index operation cannot be null";
            observer = GemFireXDQueryObserverHolder.getInstance();
            if (observer != null && value.getTXId() != null) {
                observer = null;
            }
            while (true) {
                TXId txId;
                RowLocation rl;
                TXId rlTXId;
                Object oldValue;
                if (!isUnique) {
                    try {
                        oldValue = skipListMap.put(key, (MapCallback)insertOrUpdateValue, (Object)value, (Object)container, null);
                        break block22;
                    }
                    catch (IndexMaintenanceException ime) {
                        if (!isPutDML) throw (StandardException)ime.getCause();
                        return false;
                    }
                }
                oldValue = skipListMap.putIfAbsent(key, (Object)value);
                if (oldValue == TOK_INDEX_KEY_DEL) continue;
                if (oldValue == value && isPutDML) {
                    return false;
                }
                if (oldValue == null) break block22;
                if (tx != null && oldValue instanceof RowLocation && (rlTXId = (rl = (RowLocation)oldValue).getTXId()) != null && !rlTXId.equals(txId = tx.getTransactionId())) {
                    LockingPolicy lockPolicy = tx.getLockingPolicy();
                    if (lockTimeout < 0L) {
                        LockMode currentMode;
                        AbstractRegionEntry re = (AbstractRegionEntry)rl.getUnderlyingRegionEntry();
                        if (re == null || (currentMode = ExclusiveSharedSynchronizer.getLockModeFromState((int)re.getState())) == null) {
                            throw GemFireXDUtils.newDuplicateKeyViolation("unique constraint", container.getQualifiedTableName(), "key=" + key.toString() + ", row=" + value, rl, null, null);
                        }
                        lockTimeout = lockPolicy.getTimeout((Object)rl, lockPolicy.getWriteLockMode(), currentMode, 0, 0L);
                        waitThreshold = re.getWaitThreshold() * 1000;
                        if (lockTimeout >= 0L) continue;
                        lockTimeout = ExclusiveSharedSynchronizer.getMaxMillis();
                        continue;
                    }
                    if (lockTimeout > 0L) {
                        long sleepTime = lockTimeout < 5L ? lockTimeout : 5L;
                        long start = System.nanoTime();
                        GemFireCacheImpl cache = Misc.getGemFireCache();
                        try {
                            long quotient;
                            long origQuotient;
                            Thread.sleep(sleepTime);
                            long elapsed = (System.nanoTime() - start + 500000L) / 1000000L;
                            if (elapsed <= 0L) {
                                elapsed = 1L;
                            }
                            long origLockTimeout = lockTimeout;
                            lockTimeout = lockTimeout < elapsed ? 0L : (lockTimeout -= elapsed);
                            if (waitThreshold <= 0 || (origQuotient = origLockTimeout / (long)waitThreshold) <= (quotient = lockTimeout / (long)waitThreshold) && origLockTimeout % (long)waitThreshold != 0L) continue;
                            LogWriterI18n logger = cache.getLoggerI18n();
                            if (logger.warningEnabled()) {
                                logger.warning(LocalizedStrings.LocalLock_Waiting, new Object[]{"SortedMap2IndexInsertOperation", Double.toString((double)waitThreshold / 1000.0), lockPolicy.getWriteLockMode().toString(), "index key with oldValue=" + ArrayUtils.objectStringNonRecursive((Object)oldValue) + ", owner=" + rlTXId, ArrayUtils.objectString((Object)key), lockTimeout});
                            }
                            waitThreshold <<= 1;
                        }
                        catch (InterruptedException ie) {
                            cache.getCancelCriterion().checkCancelInProgress((Throwable)ie);
                        }
                        continue;
                    }
                    ConflictException ce = new ConflictException(LocalizedStrings.TX_CONFLICT_ON_OBJECT.toLocalizedString(new Object[]{"index=" + container + "; indexKey=" + ArrayUtils.objectString((Object)key) + "; having oldValue=" + ArrayUtils.objectStringNonRecursive((Object)oldValue) + "; owner TX=" + rlTXId + "; requested for TX=" + txId, lockPolicy.getWriteLockMode().toString()}));
                    throw StandardException.newException("X0Z02.T", (Throwable)ce, (Object)ce.getMessage());
                }
                if (wrapperToReplaceUniqEntry == null) throw GemFireXDUtils.newDuplicateKeyViolation("unique constraint", container.getQualifiedTableName(), "key=" + key.toString() + ", row=" + value, oldValue, null, null);
                if (oldValue instanceof WrapperRowLocationForTxn) break block22;
                if (skipListMap.replace(key, oldValue, (Object)wrapperToReplaceUniqEntry)) break;
            }
            GfxdTXEntryState stxe = wrapperToReplaceUniqEntry.getWrappedRowLocation();
            stxe.addUniqIdxInfosForReplacedEntries(container, key, wrapperToReplaceUniqEntry);
        }
        if (observer != null) {
            observer.keyAndContainerAfterLocalIndexInsert(key, value, container);
        }
        container.runEstimation();
        if (!(GemFireXDUtils.TraceIndex | GemFireXDUtils.TraceQuery)) return true;
        GfxdIndexManager.traceIndex("SortedMap2IndexInsertOp: successfully inserted key=(%s) value=(%s) into %s", key, GemFireXDUtils.TraceIndex ? value : ArrayUtils.objectRefString((Object)value), container);
        return true;
    }

    public static boolean replaceInSkipListMap(GemFireContainer container, Object key, RowLocation oldValue, RowLocation value, boolean isUnique, Object deletedValue, boolean isPutDML) throws StandardException {
        boolean success;
        ConcurrentSkipListMap<Object, Object> skipListMap = container.getSkipListMap();
        if (GemFireXDUtils.TraceIndex) {
            GfxdIndexManager.traceIndex("SortedMap2IndexInsertOp: replacing key=(%s) value=%s into (%s)", key, value, container);
        }
        assert (skipListMap != null);
        assert (key != null) : "The key for index operation cannot be null";
        assert ((!(key instanceof DataValueDescriptor[]) || ((DataValueDescriptor[])key).length >= 2) && (key instanceof DataValueDescriptor[] || key instanceof DataValueDescriptor) || key instanceof CompactCompositeIndexKey) : "unexpected key " + key;
        assert (value != null) : "The value for index operation cannot be null";
        GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
        if (observer != null && value.getTXId() != null) {
            observer = null;
        }
        oldValue.markDeleteFromIndexInProgress();
        try {
            Object cbArg = SortedMap2IndexDeleteOperation.getRowByteSource(deletedValue);
            success = skipListMap.replace(key, (Object)oldValue, (Object)value, (MapCallback)(isPutDML ? replaceValuePut : replaceValue), (Object)container, cbArg, null);
            if (observer != null && oldValue instanceof TXEntryState && value instanceof RowLocation) {
                observer.keyAndContainerAfterLocalIndexInsert(key, value, container);
            }
            if (success) {
                container.runEstimation();
            }
            if (GemFireXDUtils.TraceIndex | GemFireXDUtils.TraceQuery) {
                GfxdIndexManager.traceIndex("SortedMap2IndexInsertOp: successfully replace key=(%s) value=(%s) with oldValue=(%s) into %s", key, GemFireXDUtils.TraceIndex ? value : ArrayUtils.objectRefString((Object)value), GemFireXDUtils.TraceIndex ? oldValue : ArrayUtils.objectRefString((Object)oldValue), container);
            }
        }
        catch (IndexMaintenanceException ime) {
            if (isPutDML) {
                boolean bl = false;
                return bl;
            }
            throw (StandardException)ime.getCause();
        }
        finally {
            oldValue.unmarkDeleteFromIndexInProgress();
        }
        return success;
    }

    private static Object insertToRowLocation(GemFireContainer container, Object key, RowLocation insertedValue, RowLocation oldValue, boolean isPutDML) throws IndexMaintenanceException {
        if (insertedValue == oldValue) {
            GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
            if (observer != null) {
                observer.callAtOldValueSameAsNewValueCheckInSM2IIOp();
            }
            if (isPutDML) {
                return oldValue;
            }
            throw new IndexMaintenanceException((Throwable)GemFireXDUtils.newDuplicateEntryViolation(container.getQualifiedTableName(), oldValue, insertedValue));
        }
        RowLocation[] newValues = new RowLocation[]{oldValue, insertedValue};
        return newValues;
    }

    private static Object insertToRowLocationArray(GemFireContainer container, Object key, RowLocation insertedValue, RowLocation[] existingValues, boolean isPutDML) throws IndexMaintenanceException {
        int numExistingValues = existingValues.length;
        if (numExistingValues + 1 >= 100) {
            ConcurrentTHashSet set = new ConcurrentTHashSet(8, numExistingValues + 1, 0.6f, (TObjectHashingStrategy)ObjectEqualsHashingStrategy.getInstance(), (HashingStats)container.getBaseContainer().getRegion().getRegionPerfStats());
            for (int i = 0; i < numExistingValues; ++i) {
                if (insertedValue == existingValues[i]) {
                    if (isPutDML) {
                        return existingValues;
                    }
                    throw new IndexMaintenanceException((Throwable)GemFireXDUtils.newDuplicateEntryViolation(container.getQualifiedTableName(), existingValues[i], insertedValue));
                }
                set.add((Object)existingValues[i]);
            }
            set.add((Object)insertedValue);
            return set;
        }
        RowLocation[] newValues = new RowLocation[numExistingValues + 1];
        for (int i = 0; i < numExistingValues; ++i) {
            if (insertedValue == existingValues[i]) {
                if (isPutDML) {
                    return existingValues;
                }
                throw new IndexMaintenanceException((Throwable)GemFireXDUtils.newDuplicateEntryViolation(container.getQualifiedTableName(), existingValues[i], insertedValue));
            }
            newValues[i] = existingValues[i];
        }
        newValues[numExistingValues] = insertedValue;
        return newValues;
    }

    private static Object insertToHashSet(GemFireContainer container, Object key, RowLocation insertedValue, Object oldValue, boolean isPutDML) throws IndexMaintenanceException {
        ConcurrentTHashSet set = (ConcurrentTHashSet)oldValue;
        Object oldRowLocObj = set.addKey((Object)insertedValue);
        if (oldRowLocObj == null || isPutDML) {
            return set;
        }
        assert (oldRowLocObj.equals(insertedValue));
        throw new IndexMaintenanceException((Throwable)GemFireXDUtils.newDuplicateEntryViolation(container.getQualifiedTableName(), oldRowLocObj, insertedValue));
    }

    private static RowLocation[] replaceRowLocationArray(GemFireContainer container, Object key, Object oldValue, RowLocation insertedValue, RowLocation[] existingValues, boolean isPutDML) throws IndexMaintenanceException {
        RowLocation[] newValues = new RowLocation[existingValues.length];
        boolean foundOldValue = false;
        int index = 0;
        for (RowLocation existingValue : existingValues) {
            if (insertedValue != existingValue) {
                if (oldValue != existingValue) {
                    try {
                        newValues[++index] = existingValue;
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException ae) {
                        throw new IndexMaintenanceException((Throwable)GemFireXDUtils.newOldValueNotFoundException(key, oldValue, existingValues, container));
                    }
                }
                if (!foundOldValue) {
                    foundOldValue = true;
                    continue;
                }
                SanityManager.DEBUG_PRINT((String)"severe:TraceIndex", (String)("duplicate entry for tuple (" + oldValue + "), indexKey (" + key + ") index=" + container.getQualifiedTableName()));
                RowLocation[] newValues2 = new RowLocation[newValues.length - 1];
                System.arraycopy(newValues, 0, newValues2, 0, index);
                newValues = newValues2;
                continue;
            }
            throw new IndexMaintenanceException((Throwable)GemFireXDUtils.newDuplicateEntryViolation(container.getQualifiedTableName(), existingValue, insertedValue));
        }
        newValues[0] = insertedValue;
        return newValues;
    }

    private static ConcurrentTHashSet<Object> replaceInHashSet(GemFireContainer container, Object key, Object oldValue, Object insertedValue, Object existingValue) throws IndexMaintenanceException {
        ConcurrentTHashSet set = (ConcurrentTHashSet)existingValue;
        if (set.replace(oldValue, insertedValue)) {
            return set;
        }
        throw new IndexMaintenanceException((Throwable)GemFireXDUtils.newOldValueNotFoundException(key, oldValue, set, container));
    }

    @Override
    public Compensation generateUndo(Transaction xact, LimitObjectInput in) throws StandardException, IOException {
        Object value = this.memcontainer.getBaseContainer().isOffHeap() ? Long.valueOf(((OffHeapRegionEntry)this.row).getAddress()) : this.row.getValueOrOffHeapEntry(this.memcontainer.getBaseContainer().getRegion());
        return new SortedMap2IndexDeleteOperation(this.memcontainer, this.key, this.row, this.isUnique, value);
    }

    static final class ReplaceValue
    extends SortedMap2IndexDeleteOperation.UpdateReplacementValue {
        private final boolean isPutDML;

        ReplaceValue(boolean isPutDML) {
            this.isPutDML = isPutDML;
        }

        public Object replaceValue(Object key, Object oldValue, Object existingValue, Object newValue, GemFireContainer container, Object deletedValue) {
            if (existingValue == null || existingValue == MemIndexOperation.TOK_INDEX_KEY_DEL) {
                return null;
            }
            Class<?> mapValueClass = existingValue.getClass();
            if (mapValueClass == RowLocation[].class) {
                return SortedMap2IndexInsertOperation.replaceRowLocationArray(container, key, oldValue, (RowLocation)newValue, (RowLocation[])existingValue, this.isPutDML);
            }
            if (mapValueClass == ConcurrentTHashSet.class) {
                return SortedMap2IndexInsertOperation.replaceInHashSet(container, key, oldValue, newValue, existingValue);
            }
            return newValue;
        }

        public Object onOperationFailed(Object key, Object oldValue, Object updatedValue, Object newValue, GemFireContainer container, Object params) {
            if (updatedValue instanceof ConcurrentTHashSet) {
                ((ConcurrentTHashSet)updatedValue).replace(newValue, oldValue);
            }
            return null;
        }
    }

    public static final class InsertOrUpdateValue
    extends MapCallbackAdapter<Object, Object, RowLocation, GemFireContainer> {
        private final boolean isPutDML;

        InsertOrUpdateValue(boolean isPutDML) {
            this.isPutDML = isPutDML;
        }

        public Object newValue(Object key, RowLocation value, GemFireContainer container, MapResult result) {
            return value;
        }

        public Object updateValue(Object key, Object oldValue, RowLocation value, GemFireContainer container) {
            if (oldValue == null || oldValue == MemIndexOperation.TOK_INDEX_KEY_DEL) {
                return null;
            }
            Class<?> oldValueClass = oldValue.getClass();
            if (oldValueClass == RowLocation[].class) {
                return SortedMap2IndexInsertOperation.insertToRowLocationArray(container, key, value, (RowLocation[])oldValue, this.isPutDML);
            }
            if (oldValueClass == ConcurrentTHashSet.class) {
                return SortedMap2IndexInsertOperation.insertToHashSet(container, key, value, oldValue, this.isPutDML);
            }
            if (RowLocation.class.isAssignableFrom(oldValueClass)) {
                return SortedMap2IndexInsertOperation.insertToRowLocation(container, key, value, (RowLocation)oldValue, this.isPutDML);
            }
            if (GemFireXDUtils.TracePersistIndex) {
                MemIndexOperation.dumpIndex(container, "Type of data structure is: " + oldValueClass);
            }
            GemFireXDUtils.throwAssert("Unknown Data Structure in the index: " + oldValueClass);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterUpdate(Object key, Object mapKey, Object newValue, RowLocation value) {
            CompactCompositeIndexKey ccik;
            Object vbs;
            if (value.getTXId() == null && mapKey.getClass() == CompactCompositeIndexKey.class && (vbs = (ccik = (CompactCompositeIndexKey)key).getValueByteSource()) != null) {
                try {
                    ((CompactCompositeIndexKey)mapKey).update(vbs, null);
                }
                finally {
                    ccik.releaseValueByteSource(vbs);
                }
            }
        }

        public Object onOperationFailed(Object key, Object oldValue, Object updatedValue, Object newValue, RowLocation value, GemFireContainer container) {
            if (updatedValue instanceof ConcurrentTHashSet) {
                ((ConcurrentTHashSet)updatedValue).remove((Object)value);
            }
            return null;
        }
    }
}

