/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access.operations;

import com.gemstone.gemfire.cache.wan.GatewayReceiver;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.operations.MemOperation;
import com.pivotal.gemfirexd.internal.engine.access.operations.ReceiverDropOperation;
import com.pivotal.gemfirexd.internal.engine.ddl.ServerGroupsTableAttribute;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.LimitObjectInput;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.GfxdGatewayReceiverDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Compensation;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import com.pivotal.gemfirexd.internal.shared.common.SharedUtils;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.IOException;

public final class ReceiverCreateOperation
extends MemOperation {
    final GatewayReceiver receiver;
    final ServerGroupsTableAttribute serverGroups;

    public ReceiverCreateOperation(GatewayReceiver receiver, ServerGroupsTableAttribute serverGroups) {
        super(null);
        this.receiver = receiver;
        this.serverGroups = serverGroups;
    }

    @Override
    public void doMe(Transaction xact, LogInstant instant, LimitObjectInput in) throws StandardException, IOException {
        GemFireTransaction tc = (GemFireTransaction)xact;
        LanguageConnectionContext lcc = tc.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        try {
            this.receiver.start();
        }
        catch (IllegalStateException e) {
            throw StandardException.newException("0A000.S", "No open port was found between " + this.receiver.getStartPort() + " and " + this.receiver.getEndPort());
        }
        int runningPort = this.receiver.getPort();
        UUID uuid = dd.getUUIDFactory().recreateUUID(String.valueOf(runningPort));
        String servers = SharedUtils.toCSV(this.serverGroups.getServerGroupSet());
        GfxdGatewayReceiverDescriptor ghd = new GfxdGatewayReceiverDescriptor(dd, uuid, this.receiver.getId(), servers, this.receiver.getStartPort(), this.receiver.getEndPort(), runningPort, this.receiver.getSocketBufferSize(), this.receiver.getMaximumTimeBetweenPings(), this.receiver.getBindAddress(), this.receiver.getHost());
        dd.addDescriptor(ghd, null, 23, false, tc);
        SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)("CreateGatewayReceiverNode:: inserted GatewayReceiver configuration for " + this.receiver.getId() + " in SYS table"));
    }

    @Override
    public Compensation generateUndo(Transaction xact, LimitObjectInput in) throws StandardException, IOException {
        return new ReceiverDropOperation(this.receiver.getId(), this.serverGroups, true);
    }
}

