/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access.operations;

import com.gemstone.gemfire.cache.RegionAttributes;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.MemConglomerate;
import com.pivotal.gemfirexd.internal.engine.access.operations.ContainerDropOperation;
import com.pivotal.gemfirexd.internal.engine.access.operations.MemOperation;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.LimitObjectInput;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Compensation;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerKey;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import java.io.IOException;
import java.util.Properties;

public final class ContainerCreateOperation
extends MemOperation {
    private final MemConglomerate conglom;
    private final Properties containerProps;

    public ContainerCreateOperation(MemConglomerate conglom, Properties props) {
        super(null);
        this.conglom = conglom;
        this.containerProps = props;
    }

    @Override
    public void doMe(Transaction xact, LogInstant instant, LimitObjectInput in) throws StandardException, IOException {
        this.memcontainer = ContainerCreateOperation.doMe((GemFireTransaction)xact, this.conglom, this.containerProps);
    }

    public static GemFireContainer doMe(GemFireTransaction tran, MemConglomerate conglom, Properties properties) throws StandardException {
        GemFireContainer container;
        ContainerKey containerKey = conglom.getId();
        if (conglom.requiresContainer()) {
            GemFireContainer.GFContainerLocking locking;
            if (!tran.skipLocks(conglom, null) && (locking = GemFireContainer.getContainerLockingPolicy(containerKey.getContainerId(), properties, tran.getLanguageConnectionContext())) != null) {
                locking.lockContainer(tran, null, true, true);
            }
            container = new GemFireContainer(containerKey, properties);
            RegionAttributes<?, ?> attrs = container.getRegionAttributes();
            if (container.getBaseId() != null || attrs == null || container.getSchemaName().equalsIgnoreCase("SYS") || container.getSchemaName().equalsIgnoreCase("SESSION") && attrs.getScope().isLocal()) {
                container.initialize(properties, null, null, null);
            }
        } else {
            container = null;
        }
        Misc.getMemStore().addConglomerate(containerKey, conglom);
        if (container != null) {
            container.setConglomerate(conglom);
            conglom.setGemFireContainer(container);
        }
        return container;
    }

    @Override
    public Compensation generateUndo(Transaction xact, LimitObjectInput in) throws StandardException, IOException {
        return new ContainerDropOperation(this.conglom.getId(), true);
    }

    @Override
    protected StringBuilder toStringBuilder(StringBuilder sb, String regionName) {
        return super.toStringBuilder(sb, regionName).append(" containerKey=").append(this.conglom.getId()).append(" containerProps=").append(this.containerProps);
    }
}

