/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine;

import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.internal.cache.Conflatable;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventImpl;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.pivotal.gemfirexd.internal.engine.ddl.DDLConflatable;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdDDLQueueEntry;
import com.pivotal.gemfirexd.internal.engine.ddl.ReplayableConflatable;
import com.pivotal.gemfirexd.internal.engine.ddl.catalog.messages.GfxdSystemProcedureMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public final class GfxdOpConflationHandler<TValue> {
    private final SortedMap<Conflatable, TValue> conflationIndex = new TreeMap<Conflatable, TValue>(new ConflatableComparator());
    private String logPrefix = "GfxdOpConflationHandler";

    public void addToConflationIndex(Conflatable key, TValue value) {
        this.conflationIndex.put(key, value);
    }

    public void removeFromConflationIndex(Conflatable key) {
        this.conflationIndex.remove(key);
    }

    public boolean doConflate(Conflatable confVal, Object confKey, TValue confValEntry, List<TValue> removeList, Collection<TValue> collection, boolean removeFromIndex, boolean skipExecuting) {
        if (confVal.shouldBeConflated()) {
            boolean result = this.applyConflate(confVal, confKey, confValEntry, removeList, null, collection, removeFromIndex, skipExecuting);
            if (removeList != null && (result || confVal instanceof DDLConflatable || confVal instanceof GfxdSystemProcedureMessage)) {
                removeList.add(confValEntry);
            }
            return result;
        }
        if (confVal.shouldBeMerged()) {
            ArrayList<Map.Entry<Conflatable, TValue>> removeConflatables = new ArrayList<Map.Entry<Conflatable, TValue>>();
            if (confVal instanceof DDLConflatable && ((DDLConflatable)confVal).isAlterTableDropFKConstraint()) {
                ArrayList removeListIgnored = new ArrayList();
                boolean merge = this.applyConflate(confVal, confKey, confValEntry, removeListIgnored, removeConflatables, null, false, skipExecuting);
                if (merge) {
                    Map.Entry<Conflatable, TValue> cEntry = null;
                    for (int index = 0; index < removeConflatables.size(); ++index) {
                        cEntry = removeConflatables.get(index);
                        cEntry.getKey().merge(confVal);
                    }
                }
            } else if (this.applyConflate(confVal, confKey, confValEntry, null, removeConflatables, null, false, skipExecuting)) {
                int index;
                ArrayList<TValue> rremoveList = null;
                if (removeList != null) {
                    rremoveList = new ArrayList<TValue>();
                }
                Map.Entry<Conflatable, TValue> cEntry = null;
                for (index = removeConflatables.size() - 1; index >= 0 && confVal.merge((cEntry = removeConflatables.get(index)).getKey()); --index) {
                    removeConflatables.remove(index);
                    if (rremoveList != null) {
                        rremoveList.add(cEntry.getValue());
                    }
                    if (collection != null) {
                        collection.remove(cEntry.getValue());
                    }
                    if (!removeFromIndex) continue;
                    this.conflationIndex.remove(cEntry.getKey());
                }
                if (removeList != null) {
                    for (index = rremoveList.size() - 1; index >= 0; --index) {
                        removeList.add(rremoveList.get(index));
                    }
                }
                if (cEntry != null) {
                    TValue firstValue = cEntry.getValue();
                    if (confValEntry instanceof GfxdDDLQueueEntry && firstValue instanceof GfxdDDLQueueEntry) {
                        GfxdDDLQueueEntry thisEntry = (GfxdDDLQueueEntry)confValEntry;
                        GfxdDDLQueueEntry firstEntry = (GfxdDDLQueueEntry)firstValue;
                        if (thisEntry.getSequenceId() <= 0L || thisEntry.getSequenceId() > firstEntry.getSequenceId()) {
                            thisEntry.setSequenceId(firstEntry.getSequenceId());
                        }
                    }
                }
                if (GemFireXDUtils.TraceConflation | DistributionManager.VERBOSE) {
                    SanityManager.DEBUG_PRINT((String)"TraceConflation", (String)(this.toString() + ": adding merged entry " + confValEntry));
                }
                this.addToConflationIndex(confVal, confValEntry);
            }
        }
        return false;
    }

    public boolean applyConflate(Conflatable confVal, Object confKey, Object confValEntry, List<TValue> removeList, List<Map.Entry<Conflatable, TValue>> removeConflatables, Collection<TValue> collection, boolean removeFromIndex, boolean skipExecuting) {
        boolean conflationDone = false;
        String regionName = confVal.getRegionToConflate();
        MinMaxConflatable sKey = new MinMaxConflatable(regionName, confKey, true);
        MinMaxConflatable eKey = new MinMaxConflatable(regionName, confKey, false);
        Iterator<Map.Entry<Conflatable, TValue>> sMapIter = this.conflationIndex.subMap(sKey, eKey).entrySet().iterator();
        if (removeList == null && collection == null) {
            while (sMapIter.hasNext()) {
                Conflatable conflatable = sMapIter.next().getKey();
                if (GfxdOpConflationHandler.skipConflation(confVal, conflatable)) continue;
                conflationDone = true;
                break;
            }
        } else {
            ArrayList<Conflatable> removeEntries = new ArrayList<Conflatable>(4);
            while (sMapIter.hasNext()) {
                Map.Entry<Conflatable, TValue> confEntry = sMapIter.next();
                Conflatable conflatable = confEntry.getKey();
                if (GfxdOpConflationHandler.skipConflation(confVal, conflatable)) continue;
                if (removeList != null) {
                    removeList.add(confEntry.getValue());
                }
                if (removeConflatables != null) {
                    removeConflatables.add(confEntry);
                }
                conflationDone = true;
                if (skipExecuting && conflatable instanceof ReplayableConflatable && ((ReplayableConflatable)conflatable).isExecuting()) continue;
                if (GemFireXDUtils.TraceConflation | DistributionManager.VERBOSE && (collection != null || removeFromIndex)) {
                    SanityManager.DEBUG_PRINT((String)"TraceConflation", (String)(this.logPrefix + ": conflating entry [" + confEntry.getValue() + "] for entry [" + confValEntry + ']'));
                }
                if (collection != null) {
                    collection.remove(confEntry.getValue());
                }
                if (!removeFromIndex) continue;
                removeEntries.add(conflatable);
            }
            if (removeEntries.size() > 0) {
                for (Conflatable c : removeEntries) {
                    this.conflationIndex.remove(c);
                }
            }
        }
        if (conflationDone && GemFireXDUtils.TraceConflation) {
            SanityManager.DEBUG_PRINT((String)"TraceConflation", (String)(this.logPrefix + ": conflated for entry [" + confValEntry + ']'));
        }
        return conflationDone;
    }

    private static boolean skipConflation(Conflatable current, Conflatable check) {
        return check.shouldBeConflated() && current.shouldBeMerged() == check.shouldBeMerged() && current.getClass().equals(check.getClass()) && ArrayUtils.objectEquals((Object)current.getRegionToConflate(), (Object)check.getRegionToConflate()) && ArrayUtils.objectEquals((Object)current.getKeyToConflate(), (Object)check.getKeyToConflate());
    }

    public TValue indexGet(Conflatable key) {
        return (TValue)this.conflationIndex.get(key);
    }

    public void close() {
        this.conflationIndex.clear();
    }

    public void setLogPrefix(String logPrefix) {
        this.logPrefix = logPrefix;
    }

    static final class ConflatableComparator
    implements Comparator<Conflatable> {
        ConflatableComparator() {
        }

        @Override
        public int compare(Conflatable first, Conflatable second) {
            if (first instanceof Comparable && second instanceof Comparable) {
                return ((Comparable)first).compareTo(second);
            }
            int res = first.getRegionToConflate().compareTo(second.getRegionToConflate());
            if (res != 0) {
                return res;
            }
            res = GemFireXDUtils.compareKeys(first.getKeyToConflate(), second.getKeyToConflate());
            if (res != 0) {
                return res;
            }
            assert (!(first instanceof GatewaySenderEventImpl));
            assert (!(second instanceof GatewaySenderEventImpl));
            res = GemFireXDUtils.compareKeys(first.getValueToConflate(), second.getValueToConflate());
            if (res != 0) {
                return res;
            }
            if (first.equals(second)) {
                return 0;
            }
            return first.hashCode() < second.hashCode() ? -1 : 1;
        }
    }

    static final class MinMaxConflatable
    implements Conflatable {
        private final String regionName;
        private final Object key;
        private final Object value;

        MinMaxConflatable(String regionName, Object key, boolean isMin) {
            this.regionName = regionName;
            this.key = key != null ? key : (isMin ? GemFireXDUtils.MIN_KEY : GemFireXDUtils.MAX_KEY);
            this.value = isMin ? GemFireXDUtils.MIN_KEY : GemFireXDUtils.MAX_KEY;
        }

        public String getRegionToConflate() {
            return this.regionName;
        }

        public Object getKeyToConflate() {
            return this.key;
        }

        public Object getValueToConflate() {
            return this.value;
        }

        public void setLatestValue(Object value) {
            throw new AssertionError((Object)"MinMaxConflatable#setLatestValue not expected to be invoked");
        }

        public boolean shouldBeConflated() {
            return false;
        }

        public boolean shouldBeMerged() {
            return false;
        }

        public boolean merge(Conflatable existing) {
            throw new AssertionError((Object)"not expected to be invoked");
        }

        public EventID getEventId() {
            throw new AssertionError((Object)"MinMaxConflatable#getEventId: not expected to be invoked");
        }

        public boolean equals(Object other) {
            if (other instanceof MinMaxConflatable) {
                MinMaxConflatable otherMinMax = (MinMaxConflatable)other;
                if (!ArrayUtils.objectEquals((Object)this.regionName, (Object)otherMinMax.regionName)) {
                    return false;
                }
                if (GemFireXDUtils.compareKeys(this.key, otherMinMax.key) != 0) {
                    return false;
                }
                return GemFireXDUtils.compareKeys(this.value, otherMinMax.value) == 0;
            }
            return false;
        }

        public String toString() {
            return "MinMaxConflatable: region=" + this.regionName + ", key=" + this.key + ", value=" + this.value;
        }
    }
}

