/* SQLMatcher.java */
/* Generated By:JavaCC: Do not edit this line. SQLMatcher.java */
package com.pivotal.gemfirexd.internal.engine.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.sql.Statement;
import com.pivotal.gemfirexd.internal.iapi.sql.StatementType;

/* aggregates */
import com.pivotal.gemfirexd.internal.impl.sql.compile.CountAggregateDefinition;
import com.pivotal.gemfirexd.internal.impl.sql.compile.MaxMinAggregateDefinition;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SumAvgAggregateDefinition;
import com.pivotal.gemfirexd.internal.engine.sql.compile.ParameterizedConstantNode;

import com.pivotal.gemfirexd.internal.impl.sql.compile.AggregateNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BinaryOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CallStatementNode;
import  com.pivotal.gemfirexd.internal.impl.sql.compile.CharConstantNode;
import  com.pivotal.gemfirexd.internal.impl.sql.compile.CastNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnDefinitionNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CursorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromBaseTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromSubquery;
import com.pivotal.gemfirexd.internal.impl.sql.compile.GroupByList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.HasNodeVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.JavaToSQLValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.JoinNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.MethodCallNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.NewInvocationNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.NumericConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.QueryTreeNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ReplaceAggregatesWithCRVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.OrderByList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.OrderByColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SelectNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableName;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TernaryOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ParameterNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PrivilegeNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ConstraintDefinitionNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.StatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableElementList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableElementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TablePrivilegesNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TriggerReferencingStruct;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UnionNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.IntersectOrExceptNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UnaryOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UntypedNullConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UpdateNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UserTypeConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNodeList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.GroupByColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CurrentDatetimeOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DDLStatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.AlterTableNode;

import com.pivotal.gemfirexd.internal.engine.sql.compile.ParseException;
import com.pivotal.gemfirexd.internal.engine.sql.compile.Token;
import com.pivotal.gemfirexd.internal.engine.sql.compile.TokenMgrError;
import com.pivotal.gemfirexd.internal.engine.sql.compile.SQLMatcherConstants;
import com.pivotal.gemfirexd.internal.engine.sql.compile.CharStream;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TablePrivilegeInfo;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TriggerDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ViewDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;

import com.pivotal.gemfirexd.internal.iapi.sql.conn.Authorizer;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionContext;

import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.TypeCompiler;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;

import com.pivotal.gemfirexd.internal.iapi.types.DateTimeDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeUtilities;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.iapi.types.StringDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;

import com.pivotal.gemfirexd.internal.iapi.reference.Property;
import com.pivotal.gemfirexd.internal.iapi.reference.SQLState;
import com.pivotal.gemfirexd.internal.iapi.reference.JDBC30Translation;
import com.pivotal.gemfirexd.internal.iapi.reference.JDBC40Translation;
import com.pivotal.gemfirexd.internal.iapi.reference.Limits;

import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.C_NodeTypes;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.TypeCompilerFactory;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;

import com.pivotal.gemfirexd.internal.iapi.sql.compile.NodeFactory;

import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;

import com.pivotal.gemfirexd.internal.catalog.AliasInfo;
import com.pivotal.gemfirexd.internal.catalog.TypeDescriptor;
import com.pivotal.gemfirexd.internal.catalog.types.RoutineAliasInfo;

import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableProperties;
//import com.pivotal.gemfirexd.internal.iapi.services.io.StoredFormatIds;
import com.pivotal.gemfirexd.internal.shared.common.StoredFormatIds;
import com.pivotal.gemfirexd.internal.iapi.util.ReuseFactory;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;

import java.sql.Types;
import java.util.List;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.lang.Character;

// GemStone changes BEGIN

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.RegionAttributes;

import com.pivotal.gemfirexd.internal.engine.GfxdConstants;

// GemStone changes END

public class SQLMatcher implements SQLMatcherConstants {
    private boolean m_isValue;
    // workaround for a weird error with some javacc generation
    private boolean jj_lookingAhead;
    private Token jj_scanpos;
        private static final String[] SAVEPOINT_CLAUSE_NAMES = {"UNIQUE", "ON ROLLBACK RETAIN LOCKS", "ON ROLLBACK RETAIN CURSORS"};
        private static final String[] ROUTINE_CLAUSE_NAMES =
                {null, "SPECIFIC", "RESULT SET", "LANGUAGE", "EXTERNAL NAME", "PARAMETER STYLE", "SQL", "ON NULL INPUT"};
        /**
	   Clauses required for Java routines. Numbers correspond
	   to offsets in ROUTINE_CLAUSE_NAMES.
	   3 - "LANGUAGE"
	   4 - "EXTERNAL NAME"
	   5 - "PARAMETER STYLE"
	*/
        private static final int[] JAVA_ROUTINE_CLAUSES = {3,4,5};
        private static final String[] TEMPORARY_TABLE_CLAUSE_NAMES = {"NOT LOGGED", "ON COMMIT", "ON ROLLBACK"};
        /* The default length of a char or bit if the length is omitted */
        private static final int        DEFAULT_STRING_COLUMN_LENGTH = 1;

        // Defines for ON or USING clauses
        private static final int        ON_OR_USING_CLAUSE_SIZE = 2;
        private static final int        ON_CLAUSE = 0;
        private static final int        USING_CLAUSE = 1;

        // Defines for optional table clauses
        private static final int        OPTIONAL_TABLE_CLAUSES_SIZE = 3;
        private static final int        OPTIONAL_TABLE_CLAUSES_TABLE_PROPERTIES = 0;
        private static final int        OPTIONAL_TABLE_CLAUSES_DERIVED_RCL = 1;
        private static final int        OPTIONAL_TABLE_CLAUSES_CORRELATION_NAME = 2;

        // Define for UTF8 max
        private static final int        MAX_UTF8_LENGTH = 65535;

    // Constants for set operator types
    private static final int NO_SET_OP = 0;
    private static final int UNION_OP = 1;
    private static final int UNION_ALL_OP = 2;
    private static final int EXCEPT_OP = 3;
    private static final int EXCEPT_ALL_OP = 4;
    private static final int INTERSECT_OP = 5;
    private static final int INTERSECT_ALL_OP = 6;

        private Object[]                                        paramDefaults;
        private String                                          statementSQLText;
        private NodeFactory                                     nodeFactory;
        private ContextManager                          cm;
        private CompilerContext                         compilerContext;

        static final String SINGLEQUOTES = "\'\'";
        static final String DOUBLEQUOTES = "\"\"";

    /* The number of the next constant in DML */
    private int         constantNumber = 0;

        public final void setCompilerContext(CompilerContext cc) {
                this.compilerContext = cc;
                this.cm = cc.getContextManager();
        }

        /**
	  *	Get the NodeFactory for this database.
	  *
	  *	@return	The NodeFactory for this database.
	  * @exception StandardException		Thrown on error
	  */
        private final NodeFactory       getNodeFactory()        throws StandardException
        {
                if ( nodeFactory == null )
                {
                        nodeFactory = getCompilerContext().getNodeFactory();
                }

                return  nodeFactory;
        }

        private final CompilerContext getCompilerContext()
        {
                return compilerContext;
        }

        private DataTypeDescriptor getDataTypeServices(int type, int precision, int scale,
                        int length)
        {
                return new DataTypeDescriptor(
                                        TypeId.getBuiltInTypeId(type),
                                        precision,
                                        scale,
                                        true, /* assume nullable for now, change it if not nullable */
                                        length
                                );
        }

    /*
	private DataTypeDescriptor getJavaClassDataTypeDescriptor(String javaClassName) 
	{
		return new DataTypeDescriptor(
					TypeId.getUserDefinedTypeId(
								javaClassName, 
								lastTokenDelimitedIdentifier.booleanValue()),
					true);
	}*/

        private LanguageConnectionContext getLanguageConnectionContext()
        {
                return (LanguageConnectionContext) getContextManager().getContext(
                                                                                LanguageConnectionContext.CONTEXT_ID);
        }

       private  TypeCompiler getTypeCompilerForLiteralToken(int tokKind, String tokImag)
              throws StandardException
        {
           TypeCompilerFactory tcf = getCompilerContext().getTypeCompilerFactory();
           TypeCompiler tc = null;
           switch(tokKind) {
           case STRING:
              tc = tcf.getTypeCompiler(TypeId.CHAR_ID);
              break;
           case   EXACT_NUMERIC:
              TypeId typeId = DataTypeUtilities.getNumericTypeIdForNumber(tokImag);
              tc = tcf.getTypeCompiler(typeId);
              break;
           case   APPROXIMATE_NUMERIC:
            //Assume Double.
            tc = tcf.getTypeCompiler(TypeId.getBuiltInTypeId(Types.DOUBLE));
            break;
          }
           return tc;
       }

        /**
	 * check if the type length is ok for the given type.
	 */
        private void checkTypeLimits(int type, int length)
                throws StandardException
        {
        boolean valid = true;


        switch (type) {
                case Types.BINARY:
                case Types.CHAR:
                        if (length  > Limits.DB2_CHAR_MAXWIDTH)
                                valid = false;
                        break;

                case Types.VARBINARY:
                case Types.VARCHAR:
                        if (length  > Limits.DB2_VARCHAR_MAXWIDTH)
                                valid = false;

                        break;
                default:
                        break;
        }
        if (!valid)  // If these limits are too big 
                {
                        DataTypeDescriptor charDTD =
                                DataTypeDescriptor.getBuiltInDataTypeDescriptor(type, length);

                        throw StandardException.newException(SQLState.LANG_DB2_LENGTH_PRECISION_SCALE_VIOLATION, charDTD.getSQLstring());
                }
        }



        // Get the current ContextManager
        private final ContextManager getContextManager()
        {
                return cm;
        }

        /*
	** Compress 2 adjacent (single or double) quotes into a single (s or d) quote when
	** found in the beginning, middle or end of a String.
	** NOTE:  """" or '''' will be compressed into "" or ''.
	** 		  This function assumes that the leading and trailing quote from a
	** 		  string or delimited identifier have already been removed.
    */
        private static String compressQuotes(String source, String quotes)
        {
                String  result = source;
                int             index;

                /* Find the first occurrence of adjacent quotes. */
                index = result.indexOf(quotes, 0);

                /* Replace each occurrence with a single quote and begin the
		 * search for the next occurrence from where we left off.
		 */
                while (index != -1 && index != source.length())
                {
                        result = result.substring(0, index + 1) + result.substring(index + 2);

                        index = result.indexOf(quotes, index + 1);
                }

                return result;
        }

        private static void verifyImageLength(String image) throws StandardException
                {
                // beetle 2758.  For right now throw an error for literals > 64K
                if (image.length() > MAX_UTF8_LENGTH)
                        {
                throw StandardException.newException(SQLState.LANG_INVALID_LITERAL_LENGTH);
                        }
                }

        /*
	** Converts a delimited id to a canonical form.
	** Post process delimited identifiers to eliminate leading and
	** trailing " and convert all occurrences of "" to ".
	*/
        private static String normalizeDelimitedID(String str)
        {
                str = compressQuotes(str, DOUBLEQUOTES);
                return str;
        }

        private static boolean isDATETIME(int val)
        {
                if (val == DATE || val == TIME || val == TIMESTAMP)
                        return true;
                else
                        return false;
        }

        /**
	 * Determine whether a sequence of tokens represents one of
	 * the common (built-in) datatypes.
	 *
	 * @param checkFollowingToken true if additonal token for NATIONAL
	 *        or LONG should be checked
	 * @param start starting token index of the sequence
	 * @return	TRUE iff the next set of tokens names a common datatype
	 */
        boolean commonDatatypeName(int start, boolean checkFollowingToken)
        {
                boolean retval = false;

                switch (getToken(start).kind)
                {
                  case CHARACTER:
                  case CHAR:
                  case VARCHAR:
                  case NVARCHAR:
                  case NCHAR:
                  case BIT:
                  case NUMERIC:
                  case DECIMAL:
                  case DEC:
                  case INTEGER:
                  case INT:
                  case SMALLINT:
                  case LONGINT:
                  case FLOAT:
                  case REAL:
                  case DATE:
                  case TIME:
                  case TIMESTAMP:
                  case BOOLEAN:
                  case DOUBLE:
                  case BLOB:
                  case CLOB:
                  case JSON:
                  case NCLOB:
                  case BINARY: // LARGE OBJECT
                  case XML:
                        retval = true;
                        break;

                  case LONG:
                        if (checkFollowingToken == true)
                        {
                                switch (getToken(start+1).kind)
                                {
                                  case VARCHAR:
                                  case NVARCHAR:
                                  case BINARY:
                                  case VARBINARY:
                                  case BIT:
                                        retval = true;
                                        break;
                                }
                                break;
                        }
                        else
                        {
                                retval = true;
                                break;
                        }

                  case NATIONAL:
                        if (checkFollowingToken == true)
                        {
                                switch (getToken(start+1).kind)
                                {
                                  case CHAR:
                                  case CHARACTER:
                                        retval = true;
                                        break;
                                }
                                break;
                        }
                        else
                        {
                                retval = true;
                                break;
                        }
                }

                return retval;
        }

        /**
	 * Determine whether the next token is the beginning of a propertyList(). 
	 * A properties list is the comment "--gemfirexd-properties" followed by a 
	 * dot-separated list, followed by an =, followed by a value all on that 
	 * comment line. This means that the comment should start with the word
	 * "gemfirexd-properties".
	 *
	 * @return	TRUE iff the next token is gemfirexd-properties 
	 */
        private boolean derbyPropertiesListFollows()
        {
                return
                        getToken(1).kind == GEMFIREXDDASHPROPERTIES;
        }

        /**
	 * Determine whether the next sequence of tokens can be the beginning
	 * of a newInvocation(). A newInvocation() begins with the word "new"
	 * followed by a dot-separated list of identifiers, followed
	 * by a left parenthesis.
	 *
	 * @param startToken	Token to look for new at
	 *
	 * @return	TRUE iff the next set of tokens is the beginning of a
	 *			newInvocation().
	 */
        private boolean newInvocationFollows(int startToken)
        {
                boolean retval = false;

                // newInvocation() starts with the word "new"
                if (getToken(startToken).kind == NEW)
                {
                        // Look at every other token. Ignore the identifiers, because
                        // they are hard to test for.
                        for (int i = 2 + startToken; true; i += 2)
                        {
                                int tokKind = getToken(i).kind;

                                // If we find a left parenthesis without any intervening
                                // cruft, we have found a newInvocation()
                                if (tokKind == LEFT_PAREN)
                                {
                                        retval = true;
                                        break;
                                }
                                else if (tokKind != PERIOD)
                                {
                                        // Anything other than a PERIOD is "cruft"
                                        break;
                                }
                        }
                }

                return retval;
        }
        /**
	 * Determine whether the next sequence of tokens is a class name
	 *
	 * @return	TRUE iff the next set of tokens is the java class name
	 */
        boolean javaClassFollows()
        {
                boolean retval = false;

                // Look at every other token. Ignore the identifiers, because
                // they are hard to test for.
                for (int i = 2; true; i += 2)
                {
                        int tokKind = getToken(i).kind;

                        // If we find a '::' without any intervening
                        // cruft, we have found a javaClass
                        if (tokKind == DOUBLE_COLON)
                        {
                                retval = true;
                                break;
                        }
                        else if (tokKind != PERIOD)
                        {
                                // Anything other than a PERIOD is "cruft"
                                break;
                        }
                }

                return retval;
        }

        /**
	 * Determine whether the next sequence of tokens can be the beginning
	 * of a FROM newInvocation(). A FROM newInvocation() begins with the words "from new"
	 * followed by a dot-separated list of identifiers, followed
	 * by a left parenthesis.
	 *
	 * @return	TRUE iff the next set of tokens is the beginning of a
	 *			FROM newInvocation().
	 */
        private boolean fromNewInvocationFollows()
        {
                boolean retval = false;

                // FROM newInvocation() starts with the words "from new"
                return (getToken(1).kind == FROM && newInvocationFollows(2));
        }

        /**
	 * Determine whether the next sequence of tokens can be the beginning
	 * of another element in a PROPERTY list. These elements are of the
	 * form:
	 *
	 *		COMMA dot.separated.list = ...
	 *
	 * Look for the COMMA, the dots in the dot-separated list, and the =
	 *
	 * @return	TRUE iff the next set of tokens is the beginning of a
	 *			another element in a PROPERTY list.
	 */
        private boolean anotherPropertyFollows()
        {
                boolean retval = false;

                // Element must start with COMMA
                if (getToken(1).kind == COMMA)
                {
                        // Rest of element is dot-separated list with = at end
                        int i = 3;
                        int tokKind;
                        do
                        {
                                tokKind = getToken(i).kind;

                                // If we've found nothing but PERIODs until the EQUALS_OPERATOR
                                // it is the beginning of another property list element.
                                if (tokKind == EQUALS_OPERATOR)
                                {
                                        retval = true;
                                        break;
                                }

                                i += 2;
                        } while (tokKind == PERIOD);
                }

                return retval;
        }

        private boolean isLiteralFollows()
        {
            Token tok = getToken(1);
                int tokenkind = tok.kind;

            switch(tok.kind)
            {
                case SQLMatcherConstants.STRING:
                case SQLMatcherConstants.HEX_STRING:
                case SQLMatcherConstants.APPROXIMATE_NUMERIC:
                case SQLMatcherConstants.INTERVAL_LITERAL:
                case SQLMatcherConstants.INTERVAL_STRING:
                case SQLMatcherConstants.INTERVAL_QUALIFIER:
                case SQLMatcherConstants.SINGLE_DATETIME_FIELD:
                case SQLMatcherConstants.NON_SECOND_DATETIME_FIELD:
                case SQLMatcherConstants.YEAR_MONTH_LITERAL:
                case SQLMatcherConstants.DAY_TIME_LITERAL:
                case SQLMatcherConstants.DAY_TIME_INTERVAL:
                case SQLMatcherConstants.SECONDS_VALUE:
                case SQLMatcherConstants.TIME_INTERVAL:
                   return true;
                case EOF: return false;
          }

      return false;
        }

            /**
	     * Determine if we are seeing an offsetClause or the identifier OFFSET
	     * (Derby does not make it a reserved word).  "n" must be an integer
	     * literal or a dynamic parameter specification.
	     *
	     * @return true if it is an offsetClause.
	     */
            private boolean seeingOffsetClause()
            {
                int nesting = 0;

                // Token number, i == 1: OFFSET
                int i = 1;

                int tokKind = getToken(i).kind;

                // check for integer literal or ? followed by ROW(S)
                if (tokKind == PLUS_SIGN ||
                    tokKind == MINUS_SIGN) {

                    tokKind = getToken(++i).kind;

                    // GemStone changes BEGIN
                    /*(original code) if (tokKind == EXACT_NUMERIC) {*/
                    if (tokKind == EXACT_NUMERIC || tokKind == QUESTION_MARK) {
                    // GemStone changes END

                        tokKind = getToken(++i).kind;

                        return (tokKind == ROW ||
                                tokKind == ROWS);
                    }
                // GemStone changes BEGIN
                /*(original code) } else if (tokKind == EXACT_NUMERIC) {*/
                } else if (tokKind == EXACT_NUMERIC || tokKind == QUESTION_MARK) {
                // GemStone changes END

                    tokKind = getToken(++i).kind;

                    return (tokKind == ROW ||
                            tokKind == ROWS);
                }

                return false;
            }

    /*
    final public TableName
    qualifiedName(int id_length_limit) throws ParseException, StandardException
    {
	return qualifiedName( C_NodeTypes.TABLE_NAME, id_length_limit);
    }*/

    private void initStatement( String statementSQLText, Object[] paramDefaults)
        throws StandardException
    {
        /* Do per-statement initialization here */
        this.statementSQLText = statementSQLText;
        this.paramDefaults = paramDefaults;
        nodeFactory = getNodeFactory();

        this.constantNumber = 0;

    } // End of initStatement

    private void checkIdentifierLengthLimit( String identifier, int identifier_length_limit)
        throws StandardException
    {
        if (identifier.length() > identifier_length_limit)
                throw StandardException.newException(SQLState.LANG_IDENTIFIER_TOO_LONG, identifier, String.valueOf(identifier_length_limit));
    }

    private ValueNode getJdbcIntervalNode( int intervalType) throws StandardException
    {
        return (ValueNode) nodeFactory.getNode( C_NodeTypes.INT_CONSTANT_NODE,
                                                ReuseFactory.getInteger( intervalType),
                                                getContextManager());
    }

    /**
        Check to see if the required claues have been added
        to a procedure or function defintion.
        
        @param required int array of require clauses
        @param  clauses the array of declared clauses.
    */
    void checkRequiredRoutineClause(int[] required, Object[] clauses)
        throws StandardException
    {
        for (int i = 0; i < required.length; i++)
        {
            int re = required[i];
            if (clauses[re] == null)
            {
                throw StandardException.newException(SQLState.LANG_SYNTAX_ERROR,
                                 ROUTINE_CLAUSE_NAMES[re]);
                    }
                }
    }

        boolean isPrivilegeKeywordExceptTrigger(int tokenKind) {
                return (tokenKind == SELECT ||
                                tokenKind == DELETE ||
                                tokenKind == INSERT ||
                                tokenKind == UPDATE ||
                                tokenKind == REFERENCES ||
                                tokenKind == EXECUTE ||
                                tokenKind == ALL);
        }

/*
 * <A NAME="Statement">Statement</A>
 */
  final public int Statement(String statementSQLText, Object[] paramDefaults) throws ParseException, StandardException {int     statementNode;

        initStatement(statementSQLText, paramDefaults);
    statementNode = StatementPart(null);
{if ("" != null) return statementNode;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="StatementPart">StatementPart</A>
 * 
 * @param tokenHolder returns the token that starts
 * the statement.  If null, ignored.
 */
  final public int StatementPart(Token[] tokenHolder) throws ParseException, StandardException {int     statementNode;
        /*
	** Grab the token preceding this production
	*/
        if (tokenHolder != null)
        {
                tokenHolder[0] = getToken(1);
        }
    statementNode = preparableSQLDataStatement();
{if ("" != null) return statementNode;}
    throw new Error("Missing return statement in function");
  }

  final public int preparableSQLDataStatement() throws ParseException, StandardException {int     dmlStatement;
    dmlStatement = getOptimizedLiteral();
{if ("" != null) return dmlStatement ;}
    throw new Error("Missing return statement in function");
  }

  int getOptimizedLiteral() throws ParseException, StandardException {Token firsttok = getNextToken();

  // handle <LOCAL>, <GLOBAL>, <COHORT> for queries inside procedure
  if (firsttok.kind == LESS_THAN_OPERATOR) {
    firsttok = getNextToken();
    if (firsttok.kind == LOCAL || firsttok.kind == GLOBAL
        || firsttok.kind == COHORT) {
      firsttok = getNextToken();
      if (firsttok.kind == GREATER_THAN_OPERATOR) {
        firsttok = getNextToken();
      }
      else {
        return -1;
      }
    }
    else {
      return -1;
    }
  }

  //for "insert into ... values(1),(2),(3)."
  boolean ignoreMultivalueInsert = false, insertTracingOn = false, valuesOn = false;
  if(firsttok.kind == INSERT)
  {

    getCompilerContext().pushDML(0);
    insertTracingOn = true;
  }
  else if (firsttok.kind != SELECT
   && firsttok.kind != UPDATE
   && firsttok.kind != DELETE)
  {
    return -1;
  }else {
     getCompilerContext().pushDML(0);
  }

  boolean ignoreLiteral = false, ignorePrecisionScale = false;
  boolean ignoreExplicitCast = false, xmlFunc = false;
  boolean oldIgnoreLiteral = false, oldIgnoreExplicitCast = false;
  int parens = 0, parensXmlFunc = 0, parensCast = -1;
  CompilerContext cc = getCompilerContext();
  Token tok = firsttok;//null;
  Token prevtok = null;
  outer:
  for(;;) {
    prevtok = tok;
    tok = getNextToken();

    ignoreSwitch:
    switch(tok.kind)
    {
        //for multi insert ignore case.
        case VALUES:
            if(insertTracingOn) {
              valuesOn = true;
            }
            break;
        case LEFT_PAREN:
            parens++;
            if (xmlFunc && parensXmlFunc == 0) {
              parensXmlFunc = parens;
              oldIgnoreLiteral = ignoreLiteral;
              ignoreLiteral = true;
            }
            if (ignoreMultivalueInsert) {
                return -1;
            }
            break;
        // end of multi insert ignore case.
        case FOR:
          tok = getNextToken();
          switch(tok.kind) {
            case UPDATE:
               prevtok = tok;
               tok = getNextToken();
               if(tok.kind != FOR) break ignoreSwitch;
            case READ:
            case FETCH:
               prevtok = tok;
               tok = getNextToken();
               if(tok.kind != ONLY) break ignoreSwitch;

            default: break ignoreSwitch;
          }
          //fall through
        case OFFSET:
          ignoreLiteral = seeingOffsetClause();
          break;
        case FETCH:
          ignoreLiteral = true;
          break;
        // Added VARCHAR and CHAR as CAST() expressions can have AS VARCHAR(...) and 
        // we want to ignore the length of the CHAR/VARCHAR as that is not a valid constant token
        // to differentiate queries
        case NUMERIC:
        case DEC:
        case DECIMAL:
        case VARCHAR:
        case CHAR:
          // We are inside a CAST, i.e.
          // CAST ( FOO AS CHAR )
          // CAST ( FOO AS CHAR(5))
          // Therefore, handle right parens correctly if directly 
          // following a typename and turn off explicit casting
          prevtok = tok;
          tok = getNextToken();
          if(tok.kind == LEFT_PAREN) {
            ignorePrecisionScale = true;
          }
          else if (tok.kind == RIGHT_PAREN) {
            if(ignoreExplicitCast) {
              ignoreExplicitCast = false;
            }
          }
          break;
        case CAST:
          prevtok = tok;
          tok = getNextToken();
          if(tok.kind == LEFT_PAREN) {
            ignoreExplicitCast = true;
            parens++;
            parensCast = parens;
          }
          break;
        case RIGHT_PAREN:
          if(ignorePrecisionScale) {
            ignorePrecisionScale = false;
          } else if(ignoreExplicitCast && parensCast == parens) {
              parensCast = -1;
              ignoreExplicitCast = false;
          } else {
            if(insertTracingOn && valuesOn && !ignoreExplicitCast) {
               prevtok = tok;
               tok = getNextToken();
               if(tok.kind == COMMA) {
                 ignoreMultivalueInsert = true;
               }
            }
            if (xmlFunc && parens == parensXmlFunc) {
              parensXmlFunc = 0;
              ignoreLiteral = oldIgnoreLiteral;
              xmlFunc = false;
            }
            parens--;
          }

          if(cc.popDML(parens)) {
            ignoreLiteral = cc.canOptimizeLiteral();
          }
          break;
        case GROUP:
        case ORDER:
              prevtok = tok;
              tok = getNextToken();
              switch(tok.kind) {
                case BY:
                  ignoreLiteral = true;
                  break; //and ignore constants in Group By/Order By
                default: break ignoreSwitch;
              }
           break;
        case FROM:
           break;
        case SELECT:
           cc.switchOptimizeLiteral(ignoreLiteral);
           cc.pushDML(parens);
        case WHERE:
        case JOIN:
        case HAVING:
           ignoreLiteral = false;
           break;

        case XMLEXISTS:
        case XMLQUERY:
        case XMLSERIALIZE:
          // don't use literal optimization for these (#42889)
          xmlFunc = true;
          break;

        case PASSING:
          if (xmlFunc && parens == parensXmlFunc) {
            parensXmlFunc = 0;
            ignoreLiteral = oldIgnoreLiteral;
            xmlFunc = false;
          }
          break;

        case EOF:
           break outer;
     }

     if(ignoreLiteral || ignorePrecisionScale || ignoreExplicitCast)
       continue;

     String sign = "";
     final int beginOffet = tok.beginOffset;

     //literal determination switch.
     literal:
     switch(tok.kind)
     {
        case STRING:

          verifyImageLength(tok.image);
        //there is a maximum limit on the length of the string
          if (tok.image.length() > Limits.DB2_MAX_CHARACTER_LITERAL_LENGTH)
            throw StandardException.newException(SQLState.LANG_DB2_STRING_CONSTANT_TOO_LONG, StringUtil.formatForPrint(tok.image));

          /* Trim off the leading and trailing ', and compress all '' to ' */
          String string = compressQuotes(tok.image, SINGLEQUOTES);


          tok.image = string;
          tok.endOffset = tok.endOffset+1;

          Integer constantInteger = ReuseFactory.getInteger(constantNumber);
          getCompilerContext().addConstantTokenToList(tok);
          getCompilerContext().storeTypeCompilerForParam(getTypeCompilerForLiteralToken(tok.kind, tok.image));
          constantNumber++;
          break literal;

        case PLUS_SIGN:
        case MINUS_SIGN:
          //selectively pick "-" or "+" SIGN as part of literal.
          if(prevtok == null)
          {//nothing found previously.
            sign = tok.image;
          }
          else
          {//check specific previous token for SIGN to be part of literal.
           //currently we honor following previous tokens.
           // a) arithmetic operators b) relational operators
           // c) logical operators d) assignment e) explicit parenthesis
           // f) comma delimiter g) between
            switch(prevtok.kind)
            {
              case LEFT_PAREN:
              case PLUS_SIGN:
              case MINUS_SIGN:
              case ASTERISK:
              case SOLIDUS:
              case CONCATENATION_OPERATOR:
              case EQUALS_OPERATOR:
              case NOT_EQUALS_OPERATOR:
              case NOT_EQUALS_OPERATOR2:
              case LESS_THAN_OPERATOR:
              case GREATER_THAN_OPERATOR:
              case LESS_THAN_OR_EQUALS_OPERATOR:
              case GREATER_THAN_OR_EQUALS_OPERATOR:
              case AND:
              case OR:
              case COMMA:
              case BETWEEN:
              case WHERE:
              case SELECT:
                sign = tok.image;
                prevtok = tok;
                tok = getNextToken();
                break;
            }
          }
          //no break, fall through and expect tok.kind to be number...

        case EXACT_NUMERIC:
           //check again, if falling through SIGN, next token should be numeric.
         if(tok.kind == EXACT_NUMERIC) {
            String num = tok.image;
            if (sign.equals("-"))
            {
               num = sign.concat(num);
               tok.beginOffset = beginOffet;
            }

            tok.image = num;
            tok.endOffset = tok.endOffset + 1;

            getCompilerContext().addConstantTokenToList(tok);
            getCompilerContext().storeTypeCompilerForParam(getTypeCompilerForLiteralToken(tok.kind, tok.image));
            constantNumber++;
            break literal;
         }

        case APPROXIMATE_NUMERIC:
           //check again, if falling through SIGN, next token should be numeric.
         if(tok.kind == APPROXIMATE_NUMERIC) {
            String num = tok.image;
            if (sign.equals("-"))
            {
               num = sign.concat(num);
               tok.beginOffset = beginOffet;
            }

            tok.image = num;
            tok.endOffset = tok.endOffset + 1;

            getCompilerContext().addConstantTokenToList(tok);
            getCompilerContext().storeTypeCompilerForParam(getTypeCompilerForLiteralToken(tok.kind, tok.image));
            constantNumber++;
            break literal;
         }
        case HEX_STRING:
          break literal;

        case EOF:
          break outer;
    }
  }

  return firsttok.kind;
  }

  final public int preparableSelectStatement(boolean checkParams) throws ParseException, StandardException {ResultSetNode     queryExpression = null;
        Vector  updateColumns = new Vector();
        int               forUpdateState = CursorNode.UNSPECIFIED;
        int                               isolationLevel = ExecutionContext.UNSPECIFIED_ISOLATION_LEVEL;
        OrderByList orderCols = null;
    NumericConstantNode offset = null;
    NumericConstantNode fetchFirst = null;
//    beginTokenSkip = System.currentTimeMillis();
   int retval = 0;
    retval = getOptimizedLiteral();
{if ("" != null) return retval ;}
    throw new Error("Missing return statement in function");
  }

  /** Generated Token Manager. */
  public SQLMatcherTokenManager token_source;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_gen;
  final private int[] jj_la1 = new int[0];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static private int[] jj_la1_5;
  static private int[] jj_la1_6;
  static private int[] jj_la1_7;
  static private int[] jj_la1_8;
  static private int[] jj_la1_9;
  static private int[] jj_la1_10;
  static private int[] jj_la1_11;
  static private int[] jj_la1_12;
  static private int[] jj_la1_13;
  static private int[] jj_la1_14;
  static private int[] jj_la1_15;
  static private int[] jj_la1_16;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
      jj_la1_init_3();
      jj_la1_init_4();
      jj_la1_init_5();
      jj_la1_init_6();
      jj_la1_init_7();
      jj_la1_init_8();
      jj_la1_init_9();
      jj_la1_init_10();
      jj_la1_init_11();
      jj_la1_init_12();
      jj_la1_init_13();
      jj_la1_init_14();
      jj_la1_init_15();
      jj_la1_init_16();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {};
   }
   private static void jj_la1_init_3() {
      jj_la1_3 = new int[] {};
   }
   private static void jj_la1_init_4() {
      jj_la1_4 = new int[] {};
   }
   private static void jj_la1_init_5() {
      jj_la1_5 = new int[] {};
   }
   private static void jj_la1_init_6() {
      jj_la1_6 = new int[] {};
   }
   private static void jj_la1_init_7() {
      jj_la1_7 = new int[] {};
   }
   private static void jj_la1_init_8() {
      jj_la1_8 = new int[] {};
   }
   private static void jj_la1_init_9() {
      jj_la1_9 = new int[] {};
   }
   private static void jj_la1_init_10() {
      jj_la1_10 = new int[] {};
   }
   private static void jj_la1_init_11() {
      jj_la1_11 = new int[] {};
   }
   private static void jj_la1_init_12() {
      jj_la1_12 = new int[] {};
   }
   private static void jj_la1_init_13() {
      jj_la1_13 = new int[] {};
   }
   private static void jj_la1_init_14() {
      jj_la1_14 = new int[] {};
   }
   private static void jj_la1_init_15() {
      jj_la1_15 = new int[] {};
   }
   private static void jj_la1_init_16() {
      jj_la1_16 = new int[] {};
   }

  /** Constructor with user supplied CharStream. */
  public SQLMatcher(CharStream stream) {
    token_source = new SQLMatcherTokenManager(stream);
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
  }

  /** Reinitialise. */
  public void ReInit(CharStream stream) {
    token_source.ReInit(stream);
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
  }

  /** Constructor with generated Token Manager. */
  public SQLMatcher(SQLMatcherTokenManager tm) {
    token_source = tm;
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
  }

  /** Reinitialise. */
  public void ReInit(SQLMatcherTokenManager tm) {
    token_source = tm;
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken = token;
    if ((token = jj_nt).next != null) jj_nt = jj_nt.next;
    else jj_nt = jj_nt.next = token_source.getNextToken();
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    jj_nt = token;
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if ((token = jj_nt).next != null) jj_nt = jj_nt.next;
    else jj_nt = jj_nt.next = token_source.getNextToken();
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[541];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 0; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
          if ((jj_la1_5[i] & (1<<j)) != 0) {
            la1tokens[160+j] = true;
          }
          if ((jj_la1_6[i] & (1<<j)) != 0) {
            la1tokens[192+j] = true;
          }
          if ((jj_la1_7[i] & (1<<j)) != 0) {
            la1tokens[224+j] = true;
          }
          if ((jj_la1_8[i] & (1<<j)) != 0) {
            la1tokens[256+j] = true;
          }
          if ((jj_la1_9[i] & (1<<j)) != 0) {
            la1tokens[288+j] = true;
          }
          if ((jj_la1_10[i] & (1<<j)) != 0) {
            la1tokens[320+j] = true;
          }
          if ((jj_la1_11[i] & (1<<j)) != 0) {
            la1tokens[352+j] = true;
          }
          if ((jj_la1_12[i] & (1<<j)) != 0) {
            la1tokens[384+j] = true;
          }
          if ((jj_la1_13[i] & (1<<j)) != 0) {
            la1tokens[416+j] = true;
          }
          if ((jj_la1_14[i] & (1<<j)) != 0) {
            la1tokens[448+j] = true;
          }
          if ((jj_la1_15[i] & (1<<j)) != 0) {
            la1tokens[480+j] = true;
          }
          if ((jj_la1_16[i] & (1<<j)) != 0) {
            la1tokens[512+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 541; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

}
