/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.thrift.server;

import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import io.snappydata.thrift.common.SnappyTSocket;
import io.snappydata.thrift.common.SocketParameters;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SnappyTServerSocket
extends TNonblockingServerTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)SnappyTServerSocket.class.getName());
    private final ServerSocketChannel serverSockChannel;
    private final SocketParameters socketParams;
    private final boolean useSSL;
    private final boolean clientBlocking;

    public SnappyTServerSocket(InetSocketAddress bindAddress, boolean useSSL, boolean blocking, boolean clientBlocking, SocketParameters params) throws TTransportException {
        this.useSSL = useSSL;
        this.clientBlocking = clientBlocking;
        this.socketParams = params;
        try {
            this.serverSockChannel = ServerSocketChannel.open();
            this.serverSockChannel.configureBlocking(blocking);
            ServerSocket socket = this.serverSockChannel.socket();
            socket.setReuseAddress(true);
            socket.bind(bindAddress);
        }
        catch (IOException ioe) {
            throw new TTransportException(1, "Could not bind to host:port " + bindAddress.toString(), (Throwable)ioe);
        }
    }

    public void listen() throws TTransportException {
        try {
            this.serverSockChannel.socket().setSoTimeout(0);
        }
        catch (SocketException se) {
            LOGGER.error("Could not set socket timeout to 0.", (Throwable)se);
        }
    }

    protected SnappyTSocket acceptImpl() throws TTransportException {
        try {
            SocketChannel srvChannel = this.serverSockChannel.accept();
            return new SnappyTSocket(srvChannel, this.useSSL, this.clientBlocking, this.socketParams);
        }
        catch (IOException ioe) {
            throw new TTransportException((Throwable)ioe);
        }
    }

    public void close() {
        try {
            this.serverSockChannel.socket().close();
        }
        catch (IOException ioe) {
            LOGGER.warn("Could not close server socket.", (Throwable)ioe);
        }
        try {
            this.serverSockChannel.close();
        }
        catch (IOException ioe) {
            LOGGER.warn("Could not close server channel.", (Throwable)ioe);
        }
    }

    public void interrupt() {
        this.close();
    }

    public ServerSocket getServerSocket() {
        return this.serverSockChannel.socket();
    }

    public ServerSocketChannel getServerSocketChannel() {
        return this.serverSockChannel;
    }

    public void registerSelector(Selector selector) {
        try {
            this.serverSockChannel.register(selector, 16);
        }
        catch (ClosedChannelException cce) {
            LOGGER.warn("Channel closed in selector register?", (Throwable)cce);
            throw new GemFireXDRuntimeException(cce);
        }
    }
}

