/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.jdbc;

import com.gemstone.gemfire.StatisticsFactory;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gnu.trove.THashMap;
import com.pivotal.gemfirexd.internal.engine.stats.ConnectionStats;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.iapi.db.Database;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.jdbc.AuthenticationService;
import com.pivotal.gemfirexd.internal.iapi.jdbc.ConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextService;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableProperties;
import com.pivotal.gemfirexd.internal.iapi.services.jmx.ManagementService;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleControl;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedDatabaseMetaData;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSet;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSetMetaData;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.jdbc.JDBC;
import com.pivotal.gemfirexd.internal.mbeans.JDBCMBean;
import com.pivotal.gemfirexd.internal.security.SystemPermission;
import java.security.AccessControlException;
import java.security.Permission;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public abstract class InternalDriver
implements ModuleControl {
    private static final Object syncMe = new Object();
    private static InternalDriver activeDriver;
    private Object mbean;
    protected boolean active;
    private ContextService contextServiceFactory = ContextService.getFactory();
    private AuthenticationService authenticationService;
    private volatile ConnectionStats connStats;

    public ConnectionStats getConnectionStats() {
        return this.connStats;
    }

    public void initialize(GemFireCacheImpl cache) {
        this.connStats = new ConnectionStats((StatisticsFactory)cache.getDistributedSystem(), "ConnectionStats");
    }

    public static final InternalDriver activeDriver() {
        return activeDriver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void boot(boolean create, Properties properties) throws StandardException {
        Object object = syncMe;
        synchronized (object) {
            activeDriver = this;
        }
        this.active = true;
        this.mbean = ((ManagementService)Monitor.getSystemModule("com.pivotal.gemfirexd.internal.iapi.services.jmx.ManagementService")).registerMBean(new JDBC(this), JDBCMBean.class, "type=JDBC");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = syncMe;
        synchronized (object) {
            activeDriver = null;
        }
        ((ManagementService)Monitor.getSystemModule("com.pivotal.gemfirexd.internal.iapi.services.jmx.ManagementService")).unregisterMBean(this.mbean);
        this.active = false;
        this.contextServiceFactory = null;
    }

    public boolean acceptsURL(String url) {
        return this.active && InternalDriver.embeddedDriverAcceptsURL(url);
    }

    public static boolean embeddedDriverAcceptsURL(String url) {
        return !url.startsWith("jdbc:derby:net:") && !url.startsWith("jdbc:gemfirexd://") && !url.startsWith("jdbc:snappydata://") && !url.startsWith("jdbc:gemfirexd:thrift://") && !url.startsWith("jdbc:gemfirexd:drda://") && !url.startsWith("jdbc:snappydata:drda://") && !url.startsWith("jdbc:snappydata:thrift://") && !url.startsWith("jdbc:sqlfire://") && (url.startsWith("jdbc:gemfirexd:") || url.equals("jdbc:default:connection") || url.equals("jdbc:default:gemfirexd:connection") || url.startsWith("jdbc:sqlfire:") || url.equals("jdbc:default:sqlfire:connection") || url.startsWith("jdbc:snappydata:") || url.equals("jdbc:default:snappydata:connection"));
    }

    public Connection connect(String url, Properties info) throws SQLException {
        return this.connect(url, info, 0);
    }

    public Connection connect(String url, Properties info, int isolationLevel) throws SQLException {
        long connectionID = -1L;
        ConnectionStats stats = this.connStats;
        if (!(stats == null || info != null && "true".equalsIgnoreCase(info.getProperty("gemfirexd.__rt.drdaClientConnection")) || url.equals("jdbc:default:connection") || url.equals("jdbc:default:gemfirexd:connection") || url.equals("jdbc:default:snappydata:connection") || url.equals("jdbc:default:sqlfire:connection"))) {
            stats.incPeerConnectionsAttempt();
        }
        long beginConnection = ConnectionStats.getStatTime();
        EmbedConnection conn = this.connect(url, info, connectionID, connectionID, false, isolationLevel);
        if (conn != null) {
            if (stats != null) {
                if (conn.isNestedConnection()) {
                    stats.incNestedConnectionsOpen();
                    stats.incNestedConnectionsOpened();
                } else if (!conn.isClientConnection()) {
                    stats.incPeerConnectionsOpen();
                    stats.incpeerConnectionsOpened();
                    stats.incPeerConnectionsOpenTime(beginConnection);
                }
            } else {
                conn.setSkipCloseStats();
            }
        }
        return conn;
    }

    public EmbedConnection connect(String url, Properties info, long connectionID, long incomingId, boolean isRemote, int isolationLevel) throws SQLException {
        boolean current;
        if (!this.acceptsURL(url)) {
            return null;
        }
        if (EmbedConnection.memoryState.isLowMemory()) {
            throw EmbedConnection.NO_MEM;
        }
        boolean bl = current = url.equals("jdbc:default:connection") || url.equals("jdbc:default:gemfirexd:connection") || url.equals("jdbc:default:sqlfire:connection") || url.equals("jdbc:default:snappydata:connection");
        if (current) {
            ConnectionContext connContext = this.getConnectionContext();
            if (connContext != null) {
                return (EmbedConnection)connContext.getNestedConnection(false);
            }
            return null;
        }
        FormatableProperties finfo = null;
        try {
            finfo = this.getAttributes(url, info);
            info = null;
            boolean shutdown = Boolean.valueOf(finfo.getProperty("shutdown"));
            if (shutdown) {
                String failure;
                if (this.getAuthenticationService() == null) {
                    throw Util.generateCsSQLException("08004", MessageService.getTextMessage("A001"));
                }
                GemFireStore store = GemFireStore.getBootingInstance();
                if (!(store != null && store.isShutdownAll() || (failure = this.getAuthenticationService().authenticate(null, finfo)) == null)) {
                    throw Util.generateCsSQLException("08004.C.1", MessageService.getTextMessage("A020", failure));
                }
                Monitor.getMonitor().shutdown();
                throw Util.generateCsSQLException("XJ015.M");
            }
            EmbedConnection conn = this.getNewEmbedConnection(url, finfo, connectionID, isRemote, incomingId);
            if (conn.isClosed()) {
                EmbedConnection embedConnection = null;
                return embedConnection;
            }
            if (isolationLevel == 0) {
                conn.setAutoCommit(false, false);
            } else {
                conn.setAutoCommit(true, false);
            }
            conn.setTransactionIsolation(isolationLevel);
            EmbedConnection embedConnection = conn;
            return embedConnection;
        }
        catch (OutOfMemoryError noMemory) {
            EmbedConnection.memoryState.setLowMemory();
            throw EmbedConnection.NO_MEM;
        }
        finally {
            if (finfo != null) {
                finfo.clearDefaults();
            }
        }
    }

    abstract void checkSystemPrivileges(String var1, Permission var2) throws Exception;

    private void checkShutdownPrivileges(String user) throws SQLException {
        if (System.getSecurityManager() == null) {
            return;
        }
        try {
            SystemPermission sp = new SystemPermission("engine", "shutdown");
            this.checkSystemPrivileges(user, sp);
        }
        catch (AccessControlException ace) {
            throw Util.generateCsSQLException("08004.C.9", (Object)user, (Object)ace);
        }
        catch (Exception e) {
            throw Util.generateCsSQLException("08004.C.9", (Object)user, (Object)e);
        }
    }

    public int getMajorVersion() {
        return Monitor.getMonitor().getEngineVersion().getMajorVersion();
    }

    public int getMinorVersion() {
        return Monitor.getMonitor().getEngineVersion().getMinorVersion();
    }

    public boolean jdbcCompliant() {
        return true;
    }

    protected FormatableProperties getAttributes(String url, Properties info) throws SQLException {
        FormatableProperties finfo = new FormatableProperties(info);
        info = null;
        StringTokenizer st = new StringTokenizer(url, ";");
        st.nextToken();
        while (st.hasMoreTokens()) {
            String v = st.nextToken();
            int eqPos = v.indexOf(61);
            if (eqPos == -1) {
                throw Util.generateCsSQLException("XJ028.C", url);
            }
            finfo.put(v.substring(0, eqPos).trim(), v.substring(eqPos + 1).trim());
        }
        InternalDriver.checkBoolean(finfo, "dataEncryption");
        InternalDriver.checkBoolean(finfo, "create");
        InternalDriver.checkBoolean(finfo, "shutdown");
        InternalDriver.checkBoolean(finfo, "upgrade");
        return finfo;
    }

    private static void checkBoolean(Properties set, String attribute) throws SQLException {
        String[] booleanChoices = new String[]{"true", "false"};
        InternalDriver.checkEnumeration(set, attribute, booleanChoices);
    }

    private static void checkEnumeration(Properties set, String attribute, String[] choices) throws SQLException {
        String value = set.getProperty(attribute);
        if (value == null) {
            return;
        }
        for (int i = 0; i < choices.length; ++i) {
            if (!value.toUpperCase(Locale.ENGLISH).equals(choices[i].toUpperCase(Locale.ENGLISH))) continue;
            return;
        }
        String choicesStr = "{";
        for (int i = 0; i < choices.length; ++i) {
            if (i > 0) {
                choicesStr = choicesStr + "|";
            }
            choicesStr = choicesStr + choices[i];
        }
        throw Util.generateCsSQLException("XJ05B.C", attribute, value, choicesStr + "}");
    }

    public static String getDatabaseName(String url, Properties info) {
        int snappyProto;
        if (url.equals("jdbc:default:connection") || url.equals("jdbc:default:gemfirexd:connection") || url.equals("jdbc:default:snappydata:connection") || url.equals("jdbc:default:sqlfire:connection")) {
            return "";
        }
        int attributeStart = url.indexOf(59);
        int sqlfireProto = url.indexOf("jdbc:sqlfire:");
        String dbname = attributeStart == -1 ? (sqlfireProto == -1 ? url.substring("jdbc:gemfirexd:".length()) : url.substring("jdbc:sqlfire:".length())) : (sqlfireProto == -1 ? url.substring("jdbc:gemfirexd:".length(), attributeStart) : url.substring("jdbc:sqlfire:".length(), attributeStart));
        if (dbname.length() == 0 && info != null) {
            dbname = info.getProperty("databaseName", dbname);
        }
        if ((dbname = dbname.trim()).length() == 0 || dbname.equalsIgnoreCase("gemfirexd") || dbname.equalsIgnoreCase("sqlfire")) {
            return "gemfirexd";
        }
        if ((dbname.length() == 0 || dbname.equals(":")) && (snappyProto = url.indexOf("jdbc:snappydata:")) >= 0) {
            return "snappydata";
        }
        return ":" + dbname;
    }

    public final ContextService getContextServiceFactory() {
        return this.contextServiceFactory;
    }

    public AuthenticationService getAuthenticationService() {
        if (this.authenticationService == null) {
            try {
                Database databaseObj = (Database)Monitor.findService("com.pivotal.gemfirexd.internal.database.Database", "gemfirexd");
                if (databaseObj == null) {
                    Properties props = new Properties();
                    this.authenticationService = (AuthenticationService)Monitor.bootServiceModule(false, null, "com.pivotal.gemfirexd.internal.iapi.jdbc.AuthenticationService", "authentication", props);
                } else {
                    this.authenticationService = databaseObj.getAuthenticationService();
                }
            }
            catch (StandardException standardException) {
                // empty catch block
            }
        }
        SanityManager.ASSERT((this.authenticationService != null ? 1 : 0) != 0, (String)"Unexpected - There is no valid authentication service!");
        return this.authenticationService;
    }

    protected abstract EmbedConnection getNewEmbedConnection(String var1, Properties var2, long var3, boolean var5, long var6) throws SQLException;

    private ConnectionContext getConnectionContext() {
        ContextManager cm = this.getCurrentContextManager();
        ConnectionContext localCC = null;
        if (cm != null) {
            localCC = (ConnectionContext)((Object)cm.getContext("JDBC_ConnectionContext"));
        }
        return localCC;
    }

    private ContextManager getCurrentContextManager() {
        return this.getContextServiceFactory().getCurrentContextManager();
    }

    public boolean isActive() {
        return this.active;
    }

    public abstract Connection getNewNestedConnection(EmbedConnection var1);

    public Statement newEmbedStatement(EmbedConnection conn, boolean forMetaData, int resultSetType, int resultSetConcurrency, int resultSetHoldability, long id) throws SQLException {
        return new EmbedStatement(conn, forMetaData, resultSetType, resultSetConcurrency, resultSetHoldability, id, 0L, 0);
    }

    public abstract PreparedStatement newEmbedPreparedStatement(EmbedConnection var1, String var2, boolean var3, int var4, int var5, int var6, int var7, int[] var8, String[] var9, long var10, short var12, THashMap var13, long var14, int var16) throws SQLException;

    public abstract CallableStatement newEmbedCallableStatement(EmbedConnection var1, String var2, int var3, int var4, int var5, long var6, short var8) throws SQLException;

    public DatabaseMetaData newEmbedDatabaseMetaData(EmbedConnection conn, String dbname) throws SQLException {
        return new EmbedDatabaseMetaData(conn, dbname);
    }

    public abstract EmbedResultSet newEmbedResultSet(EmbedConnection var1, ResultSet var2, boolean var3, EmbedStatement var4, boolean var5) throws SQLException;

    public EmbedResultSetMetaData newEmbedResultSetMetaData(ResultColumnDescriptor[] columnInfo) {
        return new EmbedResultSetMetaData(columnInfo);
    }

    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.1");
    }
}

