/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.jdbc;

import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.iapi.db.Database;
import com.pivotal.gemfirexd.internal.iapi.jdbc.ResourceAdapter;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.jdbc.Driver30;
import com.pivotal.gemfirexd.internal.jdbc.EmbeddedDataSource;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public class EmbeddedXADataSource
extends EmbeddedDataSource
implements XADataSource {
    private static final long serialVersionUID = -5715798975598379738L;
    private transient ResourceAdapter ra;

    @Override
    public final XAConnection getXAConnection() throws SQLException {
        if (this.ra == null || !this.ra.isActive()) {
            this.setupResourceAdapter(null, null, false);
        }
        return this.createXAConnection(this.ra, this.getUser(), this.getPassword(), false);
    }

    @Override
    public final XAConnection getXAConnection(String user, String password) throws SQLException {
        if (this.ra == null || !this.ra.isActive()) {
            this.setupResourceAdapter(user, password, true);
        }
        return this.createXAConnection(this.ra, user, password, true);
    }

    @Override
    void update() {
        this.ra = null;
        super.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupResourceAdapter(String user, String password, boolean requestPassword) throws SQLException {
        EmbeddedXADataSource embeddedXADataSource = this;
        synchronized (embeddedXADataSource) {
            if (this.ra == null || !this.ra.isActive()) {
                GemFireStore memStore;
                if (GemFireStore.getBootingInstance() == null) {
                    this.ra = null;
                    String dbName = this.getDatabaseName();
                    dbName = "gemfirexd";
                    Database database = null;
                    if (Monitor.getMonitor() != null) {
                        database = (Database)Monitor.findService("com.pivotal.gemfirexd.internal.database.Database", dbName);
                    }
                    if (database == null) {
                        if (requestPassword) {
                            this.getConnection(user, password).close();
                        } else {
                            this.getConnection().close();
                        }
                        database = (Database)Monitor.findService("com.pivotal.gemfirexd.internal.database.Database", dbName);
                    }
                }
                if (this.ra == null && (memStore = GemFireStore.getBootedInstance()) != null) {
                    this.ra = (ResourceAdapter)memStore.getDatabase().getResourceAdapter();
                }
                if (this.ra == null) {
                    throw new SQLException(MessageService.getTextMessage("I024"), "08006", 45000);
                }
                this.findDriver();
                if (this.driver == null) {
                    throw new SQLException(MessageService.getTextMessage("I025"), "08006", 45000);
                }
            }
        }
    }

    protected XAConnection createXAConnection(ResourceAdapter ra, String user, String password, boolean requestPassword) throws SQLException {
        return ((Driver30)this.findDriver()).getNewXAConnection(this, ra, user, password, requestPassword);
    }
}

