/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.raw.data;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.InputStreamUtil;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerKey;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.BaseContainerHandle;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.BaseDataFileFactory;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.FileContainer;
import com.pivotal.gemfirexd.internal.io.StorageFile;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

final class InputStreamContainer
extends FileContainer {
    private StorageFile containerPath;

    InputStreamContainer(BaseDataFileFactory factory) {
        super(factory);
        this.canUpdate = false;
    }

    @Override
    final boolean openContainer(ContainerKey newIdentity) throws StandardException {
        FilterInputStream dis = null;
        try {
            InputStream is = null;
            this.containerPath = this.dataFactory.getContainerPath(newIdentity, false);
            try {
                is = this.containerPath.getInputStream();
            }
            catch (IOException ioe) {
                this.containerPath = this.dataFactory.getContainerPath(newIdentity, true);
                try {
                    is = this.getInputStream();
                }
                catch (IOException ioe2) {
                    this.containerPath = null;
                    boolean bl = false;
                    if (dis != null) {
                        try {
                            dis.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return bl;
                }
            }
            dis = new DataInputStream(is);
            this.readHeader(this.getEmbryonicPage((DataInput)((Object)dis)));
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            throw StandardException.newException("XSDG3.D", (Throwable)ioe, (Object)this);
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    void closeContainer() {
        this.containerPath = null;
    }

    @Override
    public final void clean(boolean forRemove) throws StandardException {
    }

    @Override
    protected final int preAllocate(long lastPreallocPagenum, int preAllocSize) {
        return 0;
    }

    @Override
    protected void truncatePages(long lastValidPagenum) {
    }

    @Override
    void createContainer(ContainerKey newIdentity) throws StandardException {
    }

    @Override
    protected final void removeContainer(LogInstant instant, boolean leaveStub) throws StandardException {
    }

    @Override
    protected final void readPage(long pageNumber, byte[] pageData) throws IOException, StandardException {
        SanityManager.ASSERT((!this.getCommittedDropState() ? 1 : 0) != 0);
        long pageOffset = pageNumber * (long)this.pageSize;
        this.readPositionedPage(pageOffset, pageData);
        if (this.dataFactory.databaseEncrypted() && pageNumber != 0L) {
            this.decryptPage(pageData, this.pageSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readPositionedPage(long pageOffset, byte[] pageData) throws IOException {
        InputStream is = null;
        try {
            is = this.getInputStream();
            InputStreamUtil.skipFully((InputStream)is, (long)pageOffset);
            InputStreamUtil.readFully((InputStream)is, (byte[])pageData, (int)0, (int)this.pageSize);
            is.close();
            is = null;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    protected final void writePage(long pageNumber, byte[] pageData, boolean syncPage) throws IOException, StandardException {
    }

    @Override
    protected final void flushAll() {
    }

    protected InputStream getInputStream() throws IOException {
        return this.containerPath.getInputStream();
    }

    @Override
    protected void backupContainer(BaseContainerHandle handle, String backupLocation) throws StandardException {
        throw StandardException.newException("XSAI3.S");
    }

    @Override
    protected void encryptContainer(BaseContainerHandle handle, String newFilePath) throws StandardException {
        throw StandardException.newException("XSAI3.S");
    }
}

