/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.access.btree;

import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.BackingStoreHashtable;
import com.pivotal.gemfirexd.internal.iapi.store.access.DynamicCompiledOpenConglomInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.Qualifier;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowUtil;
import com.pivotal.gemfirexd.internal.iapi.store.access.ScanInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.StaticCompiledOpenConglomInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.Conglomerate;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.LogicalUndo;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.ScanManager;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.TransactionManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.FetchDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Page;
import com.pivotal.gemfirexd.internal.iapi.store.raw.RecordHandle;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.BTree;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.BTreeForwardScan;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.BTreeLockingPolicy;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.BTreeMaxScan;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.BTreePostCommit;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.BTreeRowPosition;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.BTreeScanInfo;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.ControlRow;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.LeafControlRow;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.OpenBTree;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.SearchParameters;
import com.pivotal.gemfirexd.internal.impl.store.access.conglomerate.TemplateRow;

public abstract class BTreeScan
extends OpenBTree
implements ScanManager {
    protected Transaction init_rawtran = null;
    protected boolean init_forUpdate;
    protected FormatableBitSet init_scanColumnList;
    protected DataValueDescriptor[] init_template;
    protected DataValueDescriptor[] init_startKeyValue;
    protected int init_startSearchOperator = 0;
    protected Qualifier[][] init_qualifier = null;
    protected DataValueDescriptor[] init_stopKeyValue;
    protected int init_stopSearchOperator = 0;
    protected boolean init_hold;
    protected FetchDescriptor init_fetchDesc;
    protected FetchDescriptor init_lock_fetch_desc;
    BTreeRowPosition scan_position;
    protected boolean init_useUpdateLocks = false;
    protected static final int SCAN_INIT = 1;
    protected static final int SCAN_INPROGRESS = 2;
    protected static final int SCAN_DONE = 3;
    protected static final int SCAN_HOLD_INIT = 4;
    protected static final int SCAN_HOLD_INPROGRESS = 5;
    protected int scan_state = 1;
    protected int stat_numpages_visited = 0;
    protected int stat_numrows_visited = 0;
    protected int stat_numrows_qualified = 0;
    protected int stat_numdeleted_rows_visited = 0;
    protected int lock_operation;
    protected DataValueDescriptor[][] fetchNext_one_slot_array = new DataValueDescriptor[1][];

    protected abstract int fetchRows(BTreeRowPosition var1, DataValueDescriptor[][] var2, RowLocation[] var3, BackingStoreHashtable var4, long var5, int[] var7) throws StandardException;

    private void initScanParams(DataValueDescriptor[] startKeyValue, int startSearchOperator, Qualifier[][] qualifier, DataValueDescriptor[] stopKeyValue, int stopSearchOperator) throws StandardException {
        this.init_startKeyValue = startKeyValue;
        if (RowUtil.isRowEmpty(this.init_startKeyValue)) {
            this.init_startKeyValue = null;
        }
        this.init_startSearchOperator = startSearchOperator;
        if (qualifier != null && qualifier.length == 0) {
            qualifier = null;
        }
        this.init_qualifier = qualifier;
        this.init_stopKeyValue = stopKeyValue;
        if (RowUtil.isRowEmpty(this.init_stopKeyValue)) {
            this.init_stopKeyValue = null;
        }
        this.init_stopSearchOperator = stopSearchOperator;
        this.scan_position = new BTreeRowPosition();
        this.scan_position.init();
        this.scan_position.current_lock_template = new DataValueDescriptor[this.init_template.length];
        this.scan_position.current_lock_row_loc = (RowLocation)((RowLocation)this.init_template[this.init_template.length - 1]).cloneObject();
        this.scan_position.current_lock_template[this.init_template.length - 1] = this.scan_position.current_lock_row_loc;
        if (this.init_scanColumnList != null) {
            int i;
            FormatableBitSet required_cols = qualifier != null ? RowUtil.getQualifierBitSet(qualifier) : new FormatableBitSet(0);
            if (this.init_startKeyValue != null) {
                required_cols.grow(this.init_startKeyValue.length);
                for (i = 0; i < this.init_startKeyValue.length; ++i) {
                    required_cols.set(i);
                }
            }
            if (this.init_stopKeyValue != null) {
                required_cols.grow(this.init_stopKeyValue.length);
                for (i = 0; i < this.init_stopKeyValue.length; ++i) {
                    required_cols.set(i);
                }
            }
            FormatableBitSet required_cols_and_scan_list = required_cols.clone();
            required_cols_and_scan_list.and(this.init_scanColumnList);
            required_cols.grow(this.init_scanColumnList.getLength());
            if (!required_cols_and_scan_list.equals(required_cols)) {
                SanityManager.THROWASSERT((String)("Some column specified in a Btree  qualifier/start/stop list is not represented in the scanColumnList.\n:required_cols_and_scan_list = " + required_cols_and_scan_list + "\n;required_cols = " + required_cols + "\n;init_scanColumnList = " + this.init_scanColumnList));
            }
        }
    }

    protected void positionAtStartForForwardScan(BTreeRowPosition pos) throws StandardException {
        SanityManager.ASSERT((this.scan_state == 1 || this.scan_state == 4 ? 1 : 0) != 0);
        SanityManager.ASSERT((pos.current_rh == null ? 1 : 0) != 0);
        SanityManager.ASSERT((pos.current_positionKey == null ? 1 : 0) != 0);
        SanityManager.ASSERT((pos.current_scan_protectionHandle == null ? 1 : 0) != 0);
        while (true) {
            boolean exact;
            ControlRow root = ControlRow.get(this, 1L);
            this.stat_numpages_visited += root.getLevel() + 1;
            boolean need_previous_lock = true;
            if (this.init_startKeyValue == null) {
                pos.current_leaf = (LeafControlRow)root.searchLeft(this);
                pos.current_slot = 0;
                exact = false;
            } else {
                SanityManager.ASSERT((this.init_startSearchOperator == 1 || this.init_startSearchOperator == -1 ? 1 : 0) != 0);
                SearchParameters sp = new SearchParameters(this.init_startKeyValue, this.init_startSearchOperator == 1 ? 1 : -1, this.init_template, this, false);
                pos.current_leaf = (LeafControlRow)root.search(sp);
                pos.current_slot = sp.resultSlot;
                exact = sp.resultExact;
                if (exact && this.init_startSearchOperator == 1) {
                    --pos.current_slot;
                    if (this.getConglomerate().nUniqueColumns < this.getConglomerate().nKeyFields) {
                        need_previous_lock = false;
                    }
                }
            }
            boolean latch_released = false;
            latch_released = need_previous_lock ? !this.getLockingPolicy().lockScanRow(this, this.getConglomerate(), pos, true, this.init_lock_fetch_desc, pos.current_lock_template, pos.current_lock_row_loc, true, this.init_forUpdate, this.lock_operation) : !this.getLockingPolicy().lockScan(pos.current_leaf, null, false, this.lock_operation);
            latch_released = BTreeScan.test_errors(this, "BTreeScan_positionAtStartPosition", true, this.getLockingPolicy(), pos.current_leaf, latch_released);
            if (!latch_released) break;
            pos.current_leaf = null;
        }
        this.scan_state = 2;
        pos.current_scan_protectionHandle = pos.current_leaf.page.getProtectionRecordHandle();
        SanityManager.ASSERT((pos.current_leaf != null ? 1 : 0) != 0);
    }

    protected void positionAtStartForBackwardScan(BTreeRowPosition pos) throws StandardException {
        SanityManager.ASSERT((this.scan_state == 1 || this.scan_state == 4 ? 1 : 0) != 0);
        SanityManager.ASSERT((pos.current_rh == null ? 1 : 0) != 0);
        SanityManager.ASSERT((pos.current_positionKey == null ? 1 : 0) != 0);
        SanityManager.ASSERT((pos.current_scan_protectionHandle == null ? 1 : 0) != 0);
        while (true) {
            boolean exact;
            ControlRow root = ControlRow.get(this, 1L);
            this.stat_numpages_visited += root.getLevel() + 1;
            if (this.init_startKeyValue == null) {
                pos.current_leaf = (LeafControlRow)root.searchRight(this);
                pos.current_slot = pos.current_leaf.page.recordCount();
                exact = false;
            } else {
                SanityManager.ASSERT((this.init_startSearchOperator == 1 || this.init_startSearchOperator == -1 ? 1 : 0) != 0);
                SearchParameters sp = new SearchParameters(this.init_startKeyValue, this.init_startSearchOperator == 1 ? -1 : 1, this.init_template, this, false);
                pos.current_leaf = (LeafControlRow)root.search(sp);
                pos.current_slot = sp.resultSlot;
                exact = sp.resultExact;
                if (exact) {
                    if (this.init_startSearchOperator == 1) {
                        ++pos.current_slot;
                    } else {
                        SanityManager.ASSERT((this.init_startSearchOperator == -1 ? 1 : 0) != 0);
                    }
                } else {
                    ++pos.current_slot;
                }
            }
            boolean latch_released = !this.getLockingPolicy().lockScanRow(this, this.getConglomerate(), pos, true, this.init_lock_fetch_desc, pos.current_lock_template, pos.current_lock_row_loc, true, this.init_forUpdate, this.lock_operation);
            latch_released = BTreeScan.test_errors(this, "BTreeScan_positionAtStartPosition", true, this.getLockingPolicy(), pos.current_leaf, latch_released);
            if (!latch_released) break;
            pos.current_leaf = null;
        }
        this.scan_state = 2;
        pos.current_scan_protectionHandle = pos.current_leaf.page.getProtectionRecordHandle();
        SanityManager.ASSERT((pos.current_leaf != null ? 1 : 0) != 0);
    }

    protected void positionAtNextPage(BTreeRowPosition pos) throws StandardException {
        SanityManager.ASSERT((pos.current_scan_protectionHandle != null ? 1 : 0) != 0);
        while ((pos.next_leaf = (LeafControlRow)pos.current_leaf.getRightSibling(this)) != null) {
            boolean latch_released;
            boolean bl = latch_released = !this.getLockingPolicy().lockScan(pos.next_leaf, null, false, 0);
            latch_released = BTreeScan.test_errors(this, "BTreeScan_positionAtNextPage", true, this.getLockingPolicy(), pos.next_leaf, latch_released);
            if (latch_released) continue;
            break;
        }
        if (pos.current_scan_protectionHandle.getPageNumber() != pos.current_leaf.page.getPageNumber()) {
            SanityManager.THROWASSERT((String)("pos.current_scan_protectionHandle = " + pos.current_scan_protectionHandle + "pos.current_leaf = " + pos.current_leaf));
        }
        if (pos.current_rh != null) {
            this.getLockingPolicy().unlockScanRecordAfterRead(pos, this.init_forUpdate);
        }
        this.unlockCurrentScan(pos);
        pos.current_leaf.release();
        pos.current_leaf = pos.next_leaf;
        pos.current_scan_protectionHandle = pos.current_leaf == null ? null : pos.current_leaf.page.getProtectionRecordHandle();
        pos.current_slot = 0;
        pos.current_rh = null;
    }

    abstract void positionAtStartPosition(BTreeRowPosition var1) throws StandardException;

    protected void positionAtDoneScanFromClose(BTreeRowPosition pos) throws StandardException {
        if (!(pos.current_rh == null || pos.current_rh_qualified || pos.current_leaf != null && pos.current_leaf.page != null)) {
            if (!this.reposition(pos, false)) {
                SanityManager.THROWASSERT((String)"can not fail while holding update row lock.");
            }
            this.getLockingPolicy().unlockScanRecordAfterRead(pos, this.init_forUpdate);
            pos.current_rh = null;
            pos.current_leaf.release();
            pos.current_leaf = null;
        }
        this.unlockCurrentScan(pos);
        pos.current_slot = -1;
        pos.current_rh = null;
        pos.current_positionKey = null;
        this.scan_state = 3;
    }

    protected void positionAtDoneScan(BTreeRowPosition pos) throws StandardException {
        this.unlockCurrentScan(pos);
        pos.current_slot = -1;
        pos.current_rh = null;
        pos.current_positionKey = null;
        this.scan_state = 3;
    }

    protected boolean process_qualifier(DataValueDescriptor[] row) throws StandardException {
        Qualifier q;
        boolean row_qualifies = true;
        SanityManager.ASSERT((this.init_qualifier != null ? 1 : 0) != 0);
        SanityManager.ASSERT((this.init_qualifier.length > 0 ? 1 : 0) != 0);
        for (int i = 0; i < this.init_qualifier[0].length; ++i) {
            row_qualifies = false;
            q = this.init_qualifier[0][i];
            DataValueDescriptor columnValue = row[q.getColumnId()];
            row_qualifies = columnValue.compare(q.getOperator(), q.getOrderable(), q.getOrderedNulls(), q.getUnknownRV());
            if (q.negateCompareResult()) {
                boolean bl = row_qualifies = !row_qualifies;
            }
            if (row_qualifies) continue;
            return false;
        }
        for (int and_idx = 1; and_idx < this.init_qualifier.length; ++and_idx) {
            row_qualifies = false;
            SanityManager.ASSERT((this.init_qualifier[and_idx].length > 0 ? 1 : 0) != 0);
            for (int or_idx = 0; or_idx < this.init_qualifier[and_idx].length; ++or_idx) {
                q = this.init_qualifier[and_idx][or_idx];
                DataValueDescriptor columnValue = row[q.getColumnId()];
                row_qualifies = columnValue.compare(q.getOperator(), q.getOrderable(), q.getOrderedNulls(), q.getUnknownRV());
                if (q.negateCompareResult()) {
                    boolean bl = row_qualifies = !row_qualifies;
                }
                if (row_qualifies) break;
            }
            if (!row_qualifies) break;
        }
        return row_qualifies;
    }

    protected boolean reposition(BTreeRowPosition pos, boolean missing_row_for_key_ok) throws StandardException {
        if (this.scan_state != 2) {
            throw StandardException.newException("XSCB4.S", new Integer(this.scan_state));
        }
        if (pos.current_rh == null != (pos.current_positionKey != null)) {
            SanityManager.THROWASSERT((String)("pos.current_rh  = (" + pos.current_rh + "), pos.current_positionKey = (" + pos.current_positionKey + ")."));
        }
        if (pos.current_rh == null != (pos.current_positionKey != null)) {
            throw StandardException.newException("XSCB7.S", (Object)new Boolean(pos.current_rh == null), (Object)new Boolean(pos.current_positionKey == null));
        }
        if (pos.current_positionKey == null) {
            SanityManager.ASSERT((pos.current_scan_protectionHandle != null ? 1 : 0) != 0);
            pos.current_leaf = (LeafControlRow)ControlRow.get(this, pos.current_rh.getPageNumber());
            pos.current_slot = pos.current_leaf.page.getSlotNumber(pos.current_rh);
        } else {
            boolean latch_released;
            SanityManager.ASSERT((pos.current_scan_protectionHandle == null ? 1 : 0) != 0);
            SearchParameters sp = new SearchParameters(pos.current_positionKey, 1, this.init_template, this, false);
            do {
                pos.current_leaf = (LeafControlRow)ControlRow.get(this, 1L).search(sp);
                if (!sp.resultExact && !missing_row_for_key_ok) {
                    pos.current_leaf.release();
                    pos.current_leaf = null;
                    return false;
                }
                latch_released = !this.getLockingPolicy().lockScan(pos.current_leaf, null, false, 0);
                latch_released = BTreeScan.test_errors(this, "BTreeScan_reposition", true, this.getLockingPolicy(), pos.current_leaf, latch_released);
            } while (latch_released);
            pos.current_scan_protectionHandle = pos.current_leaf.page.getProtectionRecordHandle();
            pos.current_slot = sp.resultSlot;
            pos.current_positionKey = null;
        }
        return true;
    }

    private void unlockCurrentScan(BTreeRowPosition pos) {
        if (pos.current_scan_protectionHandle != null) {
            this.getLockingPolicy().unlockScan(pos.current_scan_protectionHandle);
            pos.current_scan_protectionHandle = null;
        }
    }

    public void init(TransactionManager xact_manager, Transaction rawtran, boolean hold, int open_mode, int lock_level, BTreeLockingPolicy btree_locking_policy, FormatableBitSet scanColumnList, DataValueDescriptor[] startKeyValue, int startSearchOperator, Qualifier[][] qualifier, DataValueDescriptor[] stopKeyValue, int stopSearchOperator, BTree conglomerate, LogicalUndo undo, StaticCompiledOpenConglomInfo static_info, DynamicCompiledOpenConglomInfo dynamic_info) throws StandardException {
        super.init(xact_manager, xact_manager, null, rawtran, hold, open_mode, lock_level, btree_locking_policy, conglomerate, undo, dynamic_info);
        this.init_rawtran = rawtran;
        this.init_forUpdate = (open_mode & 4) == 4;
        this.init_useUpdateLocks = (open_mode & 0x1000) != 0;
        this.init_hold = hold;
        this.init_template = this.runtime_mem.get_template(this.getRawTran());
        this.init_scanColumnList = scanColumnList;
        this.init_lock_fetch_desc = RowUtil.getFetchDescriptorConstant(this.init_template.length - 1);
        SanityManager.ASSERT((this.init_lock_fetch_desc.getMaxFetchColumnId() == this.init_template.length - 1 ? 1 : 0) != 0);
        SanityManager.ASSERT((this.init_lock_fetch_desc.getValidColumnsArray()[this.init_template.length - 1] == 1 ? 1 : 0) != 0);
        this.init_fetchDesc = new FetchDescriptor(this.init_template.length, this.init_scanColumnList, null);
        this.initScanParams(startKeyValue, startSearchOperator, qualifier, stopKeyValue, stopSearchOperator);
        SanityManager.ASSERT((boolean)TemplateRow.checkColumnTypes(this.getRawTran().getDataValueFactory(), this.getConglomerate().format_ids, this.getConglomerate().collation_ids, this.init_template));
        int n = this.lock_operation = this.init_forUpdate ? 1 : 0;
        if (this.init_useUpdateLocks) {
            this.lock_operation |= 8;
        }
    }

    @Override
    public void close() throws StandardException {
        this.positionAtDoneScanFromClose(this.scan_position);
        super.close();
        this.init_rawtran = null;
        this.init_template = null;
        this.init_startKeyValue = null;
        this.init_qualifier = null;
        this.init_stopKeyValue = null;
        this.getXactMgr().closeMe(this);
    }

    @Override
    public boolean delete() throws StandardException {
        boolean ret_val = false;
        if (this.scan_state != 2) {
            throw StandardException.newException("XSAM5.S");
        }
        SanityManager.ASSERT((this.container != null ? 1 : 0) != 0, (String)"BTreeScan.delete() called on a closed scan.");
        SanityManager.ASSERT((boolean)this.init_forUpdate);
        try {
            if (!this.reposition(this.scan_position, false)) {
                throw StandardException.newException("XSAM6.S", (Object)new Long(this.err_containerid), (Object)new Long(this.scan_position.current_rh.getId()));
            }
            if (this.init_useUpdateLocks) {
                boolean latch_released;
                boolean bl = latch_released = !this.getLockingPolicy().lockScanRow(this, this.getConglomerate(), this.scan_position, false, this.init_lock_fetch_desc, this.scan_position.current_lock_template, this.scan_position.current_lock_row_loc, false, this.init_forUpdate, this.lock_operation);
                if (latch_released && this.reposition(this.scan_position, false)) {
                    throw StandardException.newException("XSAM6.S", (Object)new Long(this.err_containerid), (Object)new Long(this.scan_position.current_rh.getId()));
                }
            }
            SanityManager.ASSERT((this.container.getLockingPolicy().getMode() != 1 ? 1 : 0) != 0, (String)"Locking policy requires row locking.");
            if (this.scan_position.current_leaf.page.isDeletedAtSlot(this.scan_position.current_slot)) {
                ret_val = false;
            } else {
                this.scan_position.current_leaf.page.deleteAtSlot(this.scan_position.current_slot, true, this.btree_undo);
                ret_val = true;
            }
            if (!(this.scan_position.current_leaf.page.nonDeletedRecordCount() != 1 || this.scan_position.current_leaf.getIsRoot() && this.scan_position.current_leaf.getLevel() == 0)) {
                this.getXactMgr().addPostCommitWork(new BTreePostCommit(this.getXactMgr().getAccessManager(), this.getConglomerate(), this.scan_position.current_leaf.page.getPageNumber()));
            }
        }
        finally {
            if (this.scan_position.current_leaf != null) {
                this.scan_position.current_leaf.release();
                this.scan_position.current_leaf = null;
            }
        }
        return ret_val;
    }

    @Override
    public void didNotQualify() throws StandardException {
    }

    @Override
    public boolean doesCurrentPositionQualify() throws StandardException {
        if (this.scan_state != 2) {
            throw StandardException.newException("XSAM5.S");
        }
        SanityManager.ASSERT((this.container != null ? 1 : 0) != 0, (String)"BTreeScan.doesCurrentPositionQualify() called on a closed scan.");
        try {
            if (!this.reposition(this.scan_position, false)) {
                boolean bl = false;
                return bl;
            }
            SanityManager.ASSERT((this.scan_position.current_leaf.page.fetchNumFieldsAtSlot(this.scan_position.current_slot) > 1 ? 1 : 0) != 0);
            boolean bl = !this.scan_position.current_leaf.page.isDeletedAtSlot(this.scan_position.current_slot);
            return bl;
        }
        finally {
            if (this.scan_position.current_leaf != null) {
                this.scan_position.current_leaf.release();
                this.scan_position.current_leaf = null;
            }
        }
    }

    private void fetch(DataValueDescriptor[] row, boolean qualify) throws StandardException {
        if (this.scan_state != 2) {
            throw StandardException.newException("XSAM5.S");
        }
        SanityManager.ASSERT((this.container != null ? 1 : 0) != 0, (String)"BTreeScan.fetch() called on a closed scan.");
        TemplateRow.checkPartialColumnTypes(this.getConglomerate().format_ids, this.init_scanColumnList, null, row);
        try {
            if (!this.reposition(this.scan_position, false)) {
                throw StandardException.newException("XSAM6.S", (Object)new Long(this.err_containerid), (Object)new Long(this.scan_position.current_rh.getId()));
            }
            SanityManager.ASSERT((this.scan_position.current_leaf.page.fetchNumFieldsAtSlot(this.scan_position.current_slot) > 1 ? 1 : 0) != 0);
            this.scan_position.current_rh = this.scan_position.current_leaf.page.fetchFromSlot(null, this.scan_position.current_slot, row, qualify ? this.init_fetchDesc : null, true);
            if (this.scan_position.current_leaf.page.isDeletedAtSlot(this.scan_position.current_slot)) {
                SanityManager.ASSERT((boolean)false, (String)"positioned on deleted row");
            }
        }
        finally {
            if (this.scan_position.current_leaf != null) {
                this.scan_position.current_leaf.release();
                this.scan_position.current_leaf = null;
            }
        }
    }

    @Override
    public boolean isHeldAfterCommit() throws StandardException {
        return this.scan_state == 4 || this.scan_state == 5;
    }

    @Override
    public void fetch(DataValueDescriptor[] row) throws StandardException {
        this.fetch(row, true);
    }

    @Override
    public void fetchWithoutQualify(DataValueDescriptor[] row) throws StandardException {
        this.fetch(row, false);
    }

    @Override
    public ScanInfo getScanInfo() throws StandardException {
        return new BTreeScanInfo(this);
    }

    @Override
    public boolean isCurrentPositionDeleted() throws StandardException {
        boolean ret_val;
        if (this.scan_state != 2) {
            throw StandardException.newException("XSAM5.S");
        }
        SanityManager.ASSERT((this.container != null ? 1 : 0) != 0, (String)"BTreeScan.isCurrentPositionDeleted() called on closed scan.");
        try {
            if (this.reposition(this.scan_position, false)) {
                SanityManager.ASSERT((this.scan_position.current_leaf.page.fetchNumFieldsAtSlot(this.scan_position.current_slot) > 1 ? 1 : 0) != 0);
                ret_val = this.scan_position.current_leaf.page.isDeletedAtSlot(this.scan_position.current_slot);
            } else {
                ret_val = false;
            }
        }
        finally {
            if (this.scan_position.current_leaf != null) {
                this.scan_position.current_leaf.release();
                this.scan_position.current_leaf = null;
            }
        }
        return ret_val;
    }

    @Override
    public boolean isKeyed() {
        return true;
    }

    @Override
    public boolean positionAtRowLocation(RowLocation rLoc) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    @Override
    public boolean next() throws StandardException {
        this.fetchNext_one_slot_array[0] = this.runtime_mem.get_scratch_row(this.getRawTran());
        boolean ret_val = this.fetchRows(this.scan_position, this.fetchNext_one_slot_array, null, null, 1L, null) == 1;
        return ret_val;
    }

    @Override
    public boolean fetchNext(DataValueDescriptor[] row) throws StandardException {
        TemplateRow.checkPartialColumnTypes(this.getConglomerate().format_ids, this.init_scanColumnList, null, row);
        this.fetchNext_one_slot_array[0] = row;
        boolean ret_val = this.fetchRows(this.scan_position, this.fetchNext_one_slot_array, null, null, 1L, null) == 1;
        return ret_val;
    }

    @Override
    public void fetch(ExecRow row) throws StandardException {
        throw new AssertionError((Object)"should not be called");
    }

    @Override
    public ExecRow fetchRow(ExecRow row) throws StandardException {
        throw new AssertionError((Object)"should not be called");
    }

    @Override
    public void fetchWithoutQualify(ExecRow row) throws StandardException {
        throw new AssertionError((Object)"should not be called");
    }

    @Override
    public boolean fetchNext(ExecRow row) throws StandardException {
        throw new AssertionError((Object)"should not be called");
    }

    @Override
    public int getType() {
        throw new AssertionError((Object)"should not be called");
    }

    @Override
    public boolean isScanClosed() {
        throw new AssertionError((Object)"should not be called");
    }

    @Override
    public int getScanKeyGroupID() {
        throw new UnsupportedOperationException("not expected to be invoked");
    }

    @Override
    public int fetchNextGroup(DataValueDescriptor[][] row_array, RowLocation[] rowloc_array) throws StandardException {
        return this.fetchRows(this.scan_position, row_array, rowloc_array, null, row_array.length, null);
    }

    @Override
    public int fetchNextGroup(DataValueDescriptor[][] row_array, RowLocation[] old_rowloc_array, RowLocation[] new_rowloc_array) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    @Override
    public int fetchNextGroup(ExecRow[] row_array, RowLocation[] rowloc_array, Object[] indexKeys, int[] nodeVersions, int[] scanKeyGroupID, LocalRegion[] dataRegions) throws StandardException {
        throw new UnsupportedOperationException("should not be called");
    }

    @Override
    public void fetchSet(long max_rowcnt, int[] key_column_numbers, BackingStoreHashtable hash_table) throws StandardException {
        this.fetchRows(this.scan_position, null, null, hash_table, max_rowcnt, key_column_numbers);
    }

    @Override
    public final void reopenScan(DataValueDescriptor[] startKeyValue, int startSearchOperator, Qualifier[][] qualifier, DataValueDescriptor[] stopKeyValue, int stopSearchOperator, Activation activation) throws StandardException {
        if (!this.init_hold) {
            SanityManager.ASSERT((this.container != null ? 1 : 0) != 0, (String)"BTreeScan.reopenScan() called on non-held closed scan.");
        }
        SanityManager.ASSERT((this.scan_position.current_leaf == null ? 1 : 0) != 0);
        if (this.scan_position.current_rh != null) {
            if (!this.reposition(this.scan_position, false)) {
                SanityManager.THROWASSERT((String)"can not fail while holding update row lock.");
            }
            this.getLockingPolicy().unlockScanRecordAfterRead(this.scan_position, this.init_forUpdate);
            this.scan_position.current_rh = null;
            this.scan_position.current_leaf.release();
            this.scan_position.current_leaf = null;
        }
        this.unlockCurrentScan(this.scan_position);
        this.scan_position.current_slot = -1;
        this.scan_position.current_rh = null;
        this.scan_position.current_positionKey = null;
        this.initScanParams(startKeyValue, startSearchOperator, qualifier, stopKeyValue, stopSearchOperator);
        this.scan_state = !this.init_hold ? 1 : (this.container != null ? 1 : 4);
    }

    @Override
    public void reopenScanByRowLocation(RowLocation startRowLocation, Qualifier[][] qualifier) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    @Override
    public RowLocation fetchLocation(RowLocation templateLocation) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    @Override
    public RowLocation getCurrentRowLocation() throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    @Override
    public void upgradeCurrentRowLocationLockToWrite() throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    @Override
    public void releaseCurrentRowLocationReadLock() throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    @Override
    public RowLocation newRowLocationTemplate() throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    @Override
    public boolean replace(DataValueDescriptor[] row, FormatableBitSet validColumns) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    @Override
    public boolean closeForEndTransaction(boolean closeHeldScan) throws StandardException {
        if (!this.init_hold || closeHeldScan) {
            this.positionAtDoneScan(this.scan_position);
            super.close();
            this.init_rawtran = null;
            this.init_template = null;
            this.init_startKeyValue = null;
            this.init_qualifier = null;
            this.init_stopKeyValue = null;
            this.getXactMgr().closeMe(this);
            return true;
        }
        if (this.scan_state == 2) {
            SanityManager.ASSERT((this.scan_position != null ? 1 : 0) != 0);
            if (this.scan_position.current_positionKey == null) {
                this.savePosition();
            }
            this.scan_state = 5;
        } else if (this.scan_state == 1) {
            this.scan_state = 4;
        }
        super.close();
        return false;
    }

    private void savePosition() throws StandardException {
        if (this.scan_state == 2) {
            SanityManager.ASSERT((this.scan_position.current_rh == null == (this.scan_position.current_positionKey != null) ? 1 : 0) != 0);
            try {
                if (this.scan_position.current_rh != null) {
                    if (this.reposition(this.scan_position, false)) {
                        this.scan_position.current_positionKey = this.runtime_mem.get_row_for_export(this.getRawTran());
                        Page page = this.scan_position.current_leaf.getPage();
                        RecordHandle rh = page.fetchFromSlot(null, page.getSlotNumber(this.scan_position.current_rh), this.scan_position.current_positionKey, null, true);
                        SanityManager.ASSERT((rh != null ? 1 : 0) != 0);
                        this.scan_position.current_rh = null;
                        this.scan_position.current_slot = -1;
                        this.unlockCurrentScan(this.scan_position);
                    } else {
                        SanityManager.THROWASSERT((String)"Must always be able to reposition.");
                    }
                }
            }
            finally {
                if (this.scan_position.current_leaf != null) {
                    this.scan_position.current_leaf.release();
                    this.scan_position.current_leaf = null;
                }
            }
        }
    }

    @Override
    public void savePosition(Conglomerate conglom, Page page) throws StandardException {
        SanityManager.ASSERT((boolean)page.isLatched());
        if (this.getConglomerate() == conglom && this.scan_state == 2) {
            SanityManager.ASSERT((this.scan_position.current_rh == null == (this.scan_position.current_positionKey != null) ? 1 : 0) != 0);
            if (this.scan_position.current_rh != null && page.getPageNumber() == this.scan_position.current_rh.getPageNumber()) {
                this.scan_position.current_positionKey = this.runtime_mem.get_row_for_export(this.getRawTran());
                RecordHandle rh = page.fetchFromSlot(null, page.getSlotNumber(this.scan_position.current_rh), this.scan_position.current_positionKey, null, true);
                SanityManager.ASSERT((rh != null ? 1 : 0) != 0);
                this.scan_position.current_rh = null;
                this.scan_position.current_slot = -1;
                this.unlockCurrentScan(this.scan_position);
            }
        }
    }

    public RecordHandle getCurrentRecordHandleForDebugging() {
        return this.scan_position.current_rh;
    }

    public String toString() {
        String string = "\n\tbtree = " + this.getConglomerate() + "\n\tscan direction       = " + (this instanceof BTreeForwardScan ? "forward" : (this instanceof BTreeMaxScan ? "backward" : "illegal")) + "\n\t(scan_state:" + (this.scan_state == 1 ? "SCAN_INIT" : (this.scan_state == 2 ? "SCAN_INPROGRESS" : (this.scan_state == 3 ? "SCAN_DONE" : (this.scan_state == 4 ? "SCAN_HOLD_INIT" : (this.scan_state == 5 ? "SCAN_HOLD_INPROGRESS" : "BAD_SCAN_STATE"))))) + "\n\trh:" + this.scan_position.current_rh + "\n\tkey:" + this.scan_position.current_positionKey + ")\n\tinit_rawtran = " + this.init_rawtran + "\n\tinit_hold = " + this.init_hold + "\n\tinit_forUpdate = " + this.init_forUpdate + "\n\tinit_useUpdateLocks = " + this.init_useUpdateLocks + "\n\tinit_scanColumnList = " + this.init_scanColumnList + "\n\tinit_scanColumnList.size() = " + (this.init_scanColumnList != null ? this.init_scanColumnList.size() : 0) + "\n\tinit_template = " + RowUtil.toString(this.init_template) + "\n\tinit_startKeyValue = " + RowUtil.toString(this.init_startKeyValue) + "\n\tinit_startSearchOperator = " + (this.init_startSearchOperator == 1 ? "GE" : (this.init_startSearchOperator == -1 ? "GT" : Integer.toString(this.init_startSearchOperator))) + "\n\tinit_qualifier[]         = " + this.init_qualifier + "\n\tinit_stopKeyValue = " + RowUtil.toString(this.init_stopKeyValue) + "\n\tinit_stopSearchOperator = " + (this.init_stopSearchOperator == 1 ? "GE" : (this.init_stopSearchOperator == -1 ? "GT" : Integer.toString(this.init_stopSearchOperator))) + "\n\tstat_numpages_visited         = " + this.stat_numpages_visited + "\n\tstat_numrows_visited          = " + this.stat_numrows_visited + "\n\tstat_numrows_qualified        = " + this.stat_numrows_qualified + "\n\tstat_numdeleted_rows_visited  = " + this.stat_numdeleted_rows_visited;
        return string;
    }
}

