/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.jdbc.ConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.impl.sql.execute.NoRowsResultSetImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import java.sql.ResultSet;
import java.sql.SQLException;

class CallStatementResultSet
extends NoRowsResultSetImpl {
    private final GeneratedMethod methodCall;
    public boolean isSysProc = false;

    CallStatementResultSet(GeneratedMethod methodCall, Activation a) throws StandardException {
        super(a);
        this.methodCall = methodCall;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws StandardException {
        block8: {
            this.setup();
            LanguageConnectionContext lcc = this.activation.getLanguageConnectionContext();
            lcc.pushCaller(this.activation);
            this.activation.setNestedCurrentRole(lcc.getCurrentRoleId(this.activation));
            try {
                String schemaName;
                String objectName = this.activation.getObjectName();
                DataDictionary dd = lcc.getDataDictionary();
                int schemaIndex = objectName.indexOf(46);
                if (schemaIndex > 0 && dd.isSystemSchemaName(schemaName = objectName.substring(0, schemaIndex))) {
                    this.isSysProc = true;
                }
                if (this.isSysProc) {
                    this.methodCall.invoke(this.activation);
                    break block8;
                }
                TransactionController tc = lcc.getTransactionExecute();
                int readMode = dd.startReading(lcc);
                try {
                    GemFireXDUtils.lockObject(null, objectName, false, tc);
                    this.methodCall.invoke(this.activation);
                }
                finally {
                    GemFireXDUtils.unlockObject(null, objectName, false, false, tc);
                    dd.doneReading(readMode, lcc);
                }
            }
            finally {
                this.activation.getLanguageConnectionContext().popCaller();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean cleanupOnError) throws StandardException {
        super.close(cleanupOnError);
        ResultSet[][] dynamicResults = this.getActivation().getDynamicResults();
        if (dynamicResults != null) {
            StandardException errorOnClose = null;
            ConnectionContext jdbcContext = null;
            for (int i = 0; i < dynamicResults.length; ++i) {
                ResultSet drs;
                ResultSet[] param = dynamicResults[i];
                if (param == null || (drs = param[0]) == null) continue;
                if (jdbcContext == null) {
                    jdbcContext = (ConnectionContext)((Object)this.lcc.getContextManager().getContext("JDBC_ConnectionContext"));
                }
                try {
                    if (!jdbcContext.processInaccessibleDynamicResult(drs)) continue;
                    drs.close();
                    continue;
                }
                catch (SQLException e) {
                    StandardException se;
                    if (errorOnClose != null) continue;
                    errorOnClose = se = StandardException.plainWrapException(e);
                    continue;
                }
                finally {
                    param[0] = null;
                }
            }
            if (errorOnClose != null) {
                throw errorOnClose;
            }
        }
    }

    @Override
    public void cleanUp(boolean cleanupOnError) throws StandardException {
        this.close(cleanupOnError);
    }

    @Override
    public void accept(ResultSetStatisticsVisitor visitor) {
        visitor.setNumberOfChildren(0);
        visitor.visit(this);
    }
}

