/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.NcjHashMapWrapper;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.compile.CollectExpressionOperandsVisitor;
import com.pivotal.gemfirexd.internal.engine.sql.compile.DistributedHashFetchRowsJoinStrategy;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CostEstimate;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.OptimizablePredicateList;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizer;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.RequiredRowOrdering;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.util.JBitSet;
import com.pivotal.gemfirexd.internal.impl.sql.compile.AggregateDefinition;
import com.pivotal.gemfirexd.internal.impl.sql.compile.AggregateNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.AllResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.AndNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BaseColumnNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BinaryRelationalOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CollectAndEliminateColumnsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CollectNodesVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CountAggregateDefinition;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DMLStatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromBaseTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromSubquery;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromVTI;
import com.pivotal.gemfirexd.internal.impl.sql.compile.GroupByList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.GroupByNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.HashTableNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.JoinNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.OptimizerImpl;
import com.pivotal.gemfirexd.internal.impl.sql.compile.OrderByList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.Predicate;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ProjectRestrictNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.QueryTreeNodeVector;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.VerifyAggregateExpressionsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.WindowFunctionColumnNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.WindowNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Vector;

public class SelectNode
extends ResultSetNode {
    FromList fromList;
    FromTable targetTable;
    Vector selectAggregates;
    Vector whereAggregates;
    Vector havingAggregates;
    ValueNode whereClause;
    ValueNode originalWhereClause;
    GroupByList groupByList;
    private boolean wasGroupBy;
    OrderByList orderByList;
    boolean orderByQuery;
    PredicateList wherePredicates;
    SubqueryList selectSubquerys;
    SubqueryList whereSubquerys;
    SubqueryList havingSubquerys;
    private boolean bindTargetListOnly;
    private boolean isDistinct;
    private boolean orderByAndDistinctMerged;
    boolean originalWhereClauseHadSubqueries;
    private FromList preJoinFL;
    ValueNode havingClause;
    private int nestingLevel;
    private ResultSetNode topPRN;
    private boolean isPartOfSubQueryNode = false;
    private boolean convertCountToRegionSize = false;

    @Override
    public void init(Object selectList, Object aggregateVector, Object fromList, Object whereClause, Object groupByList, Object havingClause, Object isForDmlOp) throws StandardException {
        boolean isCompilationAsDataStoreNode;
        this.resultColumns = (ResultColumnList)selectList;
        if (this.resultColumns != null) {
            this.resultColumns.markInitialSize();
        }
        this.fromList = (FromList)fromList;
        this.whereClause = (ValueNode)whereClause;
        this.originalWhereClause = (ValueNode)whereClause;
        this.groupByList = (GroupByList)groupByList;
        this.havingClause = (ValueNode)havingClause;
        this.bindTargetListOnly = false;
        this.originalWhereClauseHadSubqueries = false;
        if (this.whereClause != null) {
            CollectNodesVisitor cnv = new CollectNodesVisitor(SubqueryNode.class, SubqueryNode.class);
            this.whereClause.accept(cnv);
            if (!cnv.getList().isEmpty()) {
                this.originalWhereClauseHadSubqueries = true;
            }
        }
        boolean bl = isCompilationAsDataStoreNode = this.getLanguageConnectionContext().isConnectionForRemote() && (Boolean)isForDmlOp == false;
        if (this.getCompilerContext().createQueryInfo() && isCompilationAsDataStoreNode) {
            this.getCompilerContext().disableQueryInfoCreation();
        }
        this.topPRN = this;
    }

    @Override
    public String toString() {
        return "isDistinct: " + this.isDistinct + "\ngroupByList: " + (this.groupByList != null ? this.groupByList.toString() : "null") + "\norderByList: " + (this.orderByList != null ? this.orderByList.toString() : "null") + "\n" + super.toString();
    }

    public String statementToString() {
        return "SELECT";
    }

    public void makeDistinct() {
        this.isDistinct = true;
    }

    public void clearDistinct() {
        this.isDistinct = false;
    }

    boolean hasDistinct() {
        return this.isDistinct;
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.selectSubquerys != null) {
            this.printLabel(depth, "selectSubquerys: ");
            this.selectSubquerys.treePrint(depth + 1);
        }
        this.printLabel(depth, "fromList: ");
        if (this.fromList != null) {
            this.fromList.treePrint(depth + 1);
        }
        if (this.whereClause != null) {
            this.printLabel(depth, "whereClause: ");
            this.whereClause.treePrint(depth + 1);
        }
        if (this.wherePredicates != null && this.wherePredicates.size() > 0) {
            this.printLabel(depth, "wherePredicates: ");
            this.wherePredicates.treePrint(depth + 1);
        }
        if (this.whereSubquerys != null) {
            this.printLabel(depth, "whereSubquerys: ");
            this.whereSubquerys.treePrint(depth + 1);
        }
        this.printLabel(depth, "preJoinFL: ");
        if (this.preJoinFL != null) {
            this.preJoinFL.treePrint(depth + 1);
        }
    }

    @Override
    public FromList getFromList() {
        return this.fromList;
    }

    public ColumnReference findColumnReferenceInResult(String colName) throws StandardException {
        if (this.fromList.size() != 1) {
            return null;
        }
        FromTable ft = (FromTable)this.fromList.elementAt(0);
        if (!(ft instanceof ProjectRestrictNode && ((ProjectRestrictNode)ft).getChildResult() instanceof FromBaseTable || ft instanceof FromBaseTable)) {
            return null;
        }
        int rclSize = this.resultColumns.size();
        for (int index = 0; index < rclSize; ++index) {
            ResultColumn rc = (ResultColumn)this.resultColumns.elementAt(index);
            if (!(rc.getExpression() instanceof ColumnReference)) {
                return null;
            }
            ColumnReference crNode = (ColumnReference)rc.getExpression();
            if (!crNode.columnName.equals(colName)) continue;
            return (ColumnReference)crNode.getClone();
        }
        return null;
    }

    public ValueNode getWhereClause() {
        return this.whereClause;
    }

    public PredicateList getWherePredicates() {
        return this.wherePredicates;
    }

    public SubqueryList getSelectSubquerys() {
        return this.selectSubquerys;
    }

    public SubqueryList getWhereSubquerys() {
        return this.whereSubquerys;
    }

    @Override
    public ResultSetNode bindNonVTITables(DataDictionary dataDictionary, FromList fromListParam) throws StandardException {
        int index;
        int fromListSize = this.fromList.size();
        this.wherePredicates = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        this.preJoinFL = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
        this.nestingLevel = fromListParam.size() == 0 ? 0 : ((FromTable)fromListParam.elementAt(0)).getLevel() + 1;
        this.fromList.setLevel(this.nestingLevel);
        for (index = 0; index < fromListSize; ++index) {
            fromListParam.insertElementAt(this.fromList.elementAt(index), 0);
        }
        this.fromList.bindTables(dataDictionary, fromListParam);
        for (index = 0; index < fromListSize; ++index) {
            fromListParam.removeElementAt(0);
        }
        return this;
    }

    public boolean satisfiesConditionsForRegionSizeOpt() throws StandardException {
        if (!(this.fromList.size() != 1 || this.whereClause != null || this.orderByList != null || this.isDistinct || this.groupByList != null && !this.groupByList.isDSIDOnly() || this.havingClause != null || this.resultColumns.containsWindowFunctionResultColumn())) {
            ResultSetNode rsn;
            if (this.fromList.elementAt(0) instanceof FromBaseTable) {
                return true;
            }
            if (this.fromList.elementAt(0) instanceof FromSubquery && (rsn = ((FromSubquery)this.fromList.elementAt(0)).getSubquery()) instanceof SelectNode && !this.fromList.hasJoins()) {
                return ((SelectNode)rsn).satisfiesConditionsForRegionSizeOpt();
            }
        }
        return false;
    }

    @Override
    public void bindExpressions(FromList fromListParam) throws StandardException {
        int numDistinctAggs;
        int index;
        int fromListParamSize = fromListParam.size();
        int fromListSize = this.fromList.size();
        SanityManager.ASSERT((this.fromList != null && this.resultColumns != null ? 1 : 0) != 0, (String)"Both fromList and resultColumns are expected to be non-null");
        if (!this.bindTargetListOnly) {
            this.fromList.bindExpressions(fromListParam);
        }
        this.selectSubquerys = (SubqueryList)this.getNodeFactory().getNode(11, this.getContextManager());
        this.selectAggregates = new Vector();
        for (index = 0; index < fromListSize; ++index) {
            fromListParam.insertElementAt(this.fromList.elementAt(index), index);
        }
        this.resultColumns.bindExpressions(fromListParam, this.selectSubquerys, this.selectAggregates);
        if (this.bindTargetListOnly) {
            for (index = 0; index < fromListSize; ++index) {
                fromListParam.removeElementAt(0);
            }
            return;
        }
        this.whereAggregates = new Vector();
        this.whereSubquerys = (SubqueryList)this.getNodeFactory().getNode(11, this.getContextManager());
        if (this.whereClause != null) {
            this.getCompilerContext().pushCurrentPrivType(0);
            this.whereClause = this.whereClause.bindExpression(fromListParam, this.whereSubquerys, this.whereAggregates);
            if (this.whereAggregates.size() > 0) {
                throw StandardException.newException("42903");
            }
            if (this.whereClause.isParameterNode()) {
                throw StandardException.newException("42X19", "PARAMETER");
            }
            this.whereClause = this.whereClause.checkIsBoolean();
            this.getCompilerContext().popCurrentPrivType();
        }
        if (this.havingClause != null) {
            this.havingAggregates = new Vector();
            this.havingSubquerys = (SubqueryList)this.getNodeFactory().getNode(11, this.getContextManager());
            this.havingClause.bindExpression(fromListParam, this.havingSubquerys, this.havingAggregates);
            this.havingClause = this.havingClause.checkIsBoolean();
        }
        for (index = 0; index < fromListSize; ++index) {
            fromListParam.removeElementAt(0);
        }
        SanityManager.ASSERT((fromListParam.size() == fromListParamSize ? 1 : 0) != 0, (String)("fromListParam.size() = " + fromListParam.size() + ", expected to be restored to " + fromListParamSize));
        SanityManager.ASSERT((this.fromList.size() == fromListSize ? 1 : 0) != 0, (String)("fromList.size() = " + this.fromList.size() + ", expected to be restored to " + fromListSize));
        if (this.groupByList != null) {
            Vector gbAggregateVector = new Vector();
            this.groupByList.bindGroupByColumns(this, gbAggregateVector);
            SanityManager.ASSERT((gbAggregateVector.size() == 0 ? 1 : 0) != 0, (String)"Unexpected Aggregate vector generated by Group By clause");
        }
        if (this.groupByList != null || this.selectAggregates.size() > 0) {
            VerifyAggregateExpressionsVisitor visitor = new VerifyAggregateExpressionsVisitor(this.groupByList);
            this.resultColumns.accept(visitor);
        }
        if ((numDistinctAggs = SelectNode.numDistinctAggregates(this.selectAggregates)) > 1) {
            throw StandardException.newException("42Z02");
        }
        if (this.selectAggregates.size() == 1 && this.satisfiesConditionsForRegionSizeOpt()) {
            AggregateDefinition ad;
            if (this.selectAggregates.size() > 1) {
                for (int i = 0; i < this.selectAggregates.size(); ++i) {
                    AggregateDefinition ad2 = ((AggregateNode)this.selectAggregates.elementAt(0)).getAggregateDefinition();
                    if (ad2 instanceof CountAggregateDefinition) continue;
                    SanityManager.THROWASSERT((String)"One or more occurances of aggregate other than count(*) not allowed ");
                }
            }
            if ((ad = ((AggregateNode)this.selectAggregates.elementAt(0)).getAggregateDefinition()) instanceof CountAggregateDefinition && ((CountAggregateDefinition)ad).isRegionSizeConvertible()) {
                if (this.getCompilerContext().createQueryInfo()) {
                    this.getCompilerContext().setOptimizeForWrite(true);
                } else {
                    this.convertCountToRegionSize = true;
                }
            }
        } else if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ && this.selectAggregates.size() > 1 && ((AggregateNode)this.selectAggregates.elementAt(0)).getAggregateDefinition() instanceof CountAggregateDefinition) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("Not converting count(*) to Region.size() optimization. groupBy list " + this.groupByList + " selectAggregates " + this.selectAggregates + " isDistinct " + this.isDistinct + " numTables " + this.getCompilerContext().getNumTables() + " isWindowFunction " + this.resultColumns.containsWindowFunctionResultColumn()));
        }
        GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
        if (observer != null) {
            observer.regionSizeOptimizationTriggered2(this);
        }
    }

    public boolean categorize(JBitSet referencedTabs, boolean simplePredsOnly) throws StandardException {
        int i;
        int size = this.resultColumns.size();
        for (i = 1; i <= size; ++i) {
            ResultColumn rc = this.resultColumns.getResultColumn(i);
            if (rc == null || rc.getReference() == null) continue;
            referencedTabs.or(rc.getReference().getTablesReferenced());
        }
        referencedTabs.or(this.referencedTableMap);
        size = this.wherePredicates.size();
        for (i = 0; i < size; ++i) {
            referencedTabs.or(((Predicate)this.wherePredicates.elementAt(i)).getReferencedSet());
        }
        return false;
    }

    @Override
    public void eliminateUnUsedColumns(ResultColumnList parentResultColumn, CollectAndEliminateColumnsVisitor finder) throws StandardException {
        if (parentResultColumn != null) {
            this.resultColumns = this.resultColumns.eliminateUnUsedColumns(this.resultColumns.mergeColumnList(parentResultColumn, new QueryTreeNodeVector[0]), finder);
        }
        this.fromList.eliminateUnUsedColumns(this.resultColumns, finder);
    }

    @Override
    public void bindExpressionsWithTables(FromList fromListParam) throws StandardException {
        this.bindExpressions(fromListParam);
    }

    @Override
    public void bindTargetExpressions(FromList fromListParam) throws StandardException {
        CollectNodesVisitor cnv = new CollectNodesVisitor(FromSubquery.class, FromSubquery.class);
        this.fromList.accept(cnv);
        this.bindTargetListOnly = cnv.getList().isEmpty();
        this.bindExpressions(fromListParam);
        this.bindTargetListOnly = false;
    }

    @Override
    public void bindResultColumns(FromList fromListParam) throws StandardException {
        this.fromList.bindResultColumns(fromListParam);
        super.bindResultColumns(fromListParam);
        if (this.resultColumns.size() > 1012) {
            throw StandardException.newException("54004", 1012);
        }
        if (this.fromList.hasOuterJoins()) {
            this.resultColumns.setNullability(true);
        }
    }

    @Override
    public void bindResultColumns(TableDescriptor targetTableDescriptor, FromVTI targetVTI, ResultColumnList targetColumnList, DMLStatementNode statement, FromList fromListParam) throws StandardException {
        this.fromList.bindResultColumns(fromListParam);
        super.bindResultColumns(targetTableDescriptor, targetVTI, targetColumnList, statement, fromListParam);
    }

    void pushExpressionsIntoSelect(Predicate predicate) throws StandardException {
        this.wherePredicates.pullExpressions(this.referencedTableMap.size(), predicate.getAndNode());
        this.fromList.pushPredicates(this.wherePredicates);
    }

    @Override
    public void verifySelectStarSubquery(FromList outerFromList, int subqueryType) throws StandardException {
        if (!((ResultColumn)this.resultColumns.elementAt(0) instanceof AllResultColumn)) {
            return;
        }
        if (subqueryType != 15) {
            throw StandardException.newException("42X38");
        }
        String fullTableName = ((AllResultColumn)this.resultColumns.elementAt(0)).getFullTableName();
        if (fullTableName != null && this.fromList.getFromTableByName(fullTableName, null, true) == null && outerFromList.getFromTableByName(fullTableName, null, true) == null && this.fromList.getFromTableByName(fullTableName, null, false) == null && outerFromList.getFromTableByName(fullTableName, null, false) == null) {
            throw StandardException.newException("42X10", fullTableName);
        }
    }

    @Override
    protected FromTable getFromTableByName(String name, String schemaName, boolean exactMatch) throws StandardException {
        return this.fromList.getFromTableByName(name, schemaName, exactMatch);
    }

    @Override
    public void rejectParameters() throws StandardException {
        super.rejectParameters();
        this.fromList.rejectParameters();
    }

    @Override
    void pushOrderByList(OrderByList orderByList) {
        this.orderByList = orderByList;
        this.orderByQuery = true;
    }

    @Override
    public ResultSetNode preprocess(int numTables, GroupByList gbl, FromList fl) throws StandardException {
        boolean isSenderNode;
        ResultSetNode newTop = this;
        OrderByList localOrderByList = this.orderByList;
        this.whereClause = SelectNode.normExpressions(this.whereClause);
        this.havingClause = SelectNode.normExpressions(this.havingClause);
        boolean anyChange = this.fromList.LOJ_reorderable(numTables);
        if (anyChange) {
            FromList afromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
            this.bindExpressions(afromList);
        }
        this.fromList.preprocess(numTables, this.groupByList, this.whereClause);
        SanityManager.ASSERT((this.selectSubquerys != null ? 1 : 0) != 0, (String)"selectSubquerys is expected to be non-null");
        this.resultColumns.preprocess(numTables, this.fromList, this.whereSubquerys, this.wherePredicates);
        if (this.whereClause != null) {
            if (this.whereSubquerys != null) {
                this.whereSubquerys.markWhereSubqueries();
            }
            this.whereClause = this.whereClause.preprocess(numTables, this.fromList, this.whereSubquerys, this.wherePredicates);
        }
        if (this.groupByList != null) {
            this.groupByList.preprocess(numTables, this.fromList, this.whereSubquerys, this.wherePredicates);
        }
        if (this.havingClause != null) {
            this.havingSubquerys.markHavingSubqueries();
            this.havingClause = this.havingClause.preprocess(numTables, this.fromList, this.havingSubquerys, this.wherePredicates);
        }
        if (this.whereClause != null) {
            this.wherePredicates.pullExpressions(numTables, this.whereClause);
            this.whereClause = null;
        }
        this.fromList.flattenFromTables(this.resultColumns, this.wherePredicates, this.whereSubquerys, this.groupByList);
        if (this.wherePredicates != null && this.wherePredicates.size() > 0 && this.fromList.size() > 0) {
            if (this.fromList.size() > 1) {
                this.performTransitiveClosure(numTables);
            }
            if (this.orderByList != null) {
                this.orderByList.removeConstantColumns(this.wherePredicates);
                if (this.orderByList.size() == 0) {
                    this.orderByList = null;
                }
            }
        }
        boolean bl = isSenderNode = !this.isPartOfSubQueryNode && !this.getCompilerContext().createQueryInfo();
        if (this.isDistinct && this.groupByList == null) {
            int distinctTable = this.resultColumns.allTopCRsFromSameTable();
            if (distinctTable != -1 && this.fromList.returnsAtMostSingleRow(this.resultColumns, this.whereClause, this.wherePredicates, this.getDataDictionary())) {
                this.isDistinct = false;
            }
            if (this.isDistinct && this.orderByList != null && this.orderByList.allAscending() && this.orderByList.isDistinctOrderable()) {
                if (this.orderByList.isInOrderPrefix(this.resultColumns)) {
                    this.orderByList = null;
                } else {
                    newTop = this.genProjectRestrictForReordering();
                    this.orderByList.resetToSourceRCs();
                    this.resultColumns = this.orderByList.reorderRCL(this.resultColumns);
                    newTop.getResultColumns().removeOrderByColumns();
                    this.orderByList = null;
                }
                this.orderByAndDistinctMerged = true;
            }
        }
        this.fromList.pushPredicates(this.wherePredicates);
        this.referencedTableMap = new JBitSet(numTables);
        int flSize = this.fromList.size();
        for (int index = 0; index < flSize; ++index) {
            this.referencedTableMap.or(((FromTable)this.fromList.elementAt(index)).getReferencedTableMap());
        }
        if (newTop != this) {
            newTop.setReferencedTableMap((JBitSet)this.referencedTableMap.clone());
        }
        if (this.orderByAndDistinctMerged && !isSenderNode) {
            newTop.getResultColumns().setColumnOrdering(localOrderByList.getColumnOrdering());
        }
        if (isSenderNode && !this.getCompilerContext().allTablesAreReplicatedOnRemote() && this.isDistinct) {
            this.resultColumns.mergeResultColumnList(newTop.getResultColumns(), true);
            this.resultColumns.unmarkAllGenerated();
        }
        if (isSenderNode && !this.getCompilerContext().allTablesAreReplicatedOnRemote() && !this.isDistinct && (this.groupByList != null || this.selectAggregates != null && this.selectAggregates.size() > 0)) {
            CollectExpressionOperandsVisitor substitute = new CollectExpressionOperandsVisitor(this.getLanguageConnectionContext(), new Vector[]{this.selectAggregates, this.havingAggregates}, isSenderNode);
            this.resultColumns.accept(substitute);
            if (this.havingClause != null) {
                this.havingClause.accept(substitute);
                if (substitute.getOtherExpressions() != null && substitute.getOtherExpressions().size() > 0) {
                    this.havingClause = null;
                }
            }
            this.resultColumns = substitute.getResultColumns();
        }
        if (this.groupByList != null && this.orderByList != null && isSenderNode && !this.getCompilerContext().allTablesAreReplicatedOnRemote()) {
            boolean nullifyOrderByList = true;
            if (this.getCompilerContext().isOffsetOrFetchNext() && !this.orderByList.hasAnyAgrregateInOrderByList(isSenderNode)) {
                nullifyOrderByList = false;
            }
            if (nullifyOrderByList) {
                this.orderByList = null;
                this.getCompilerContext().setOrderByListNullified();
            }
        }
        this.topPRN = newTop;
        return newTop;
    }

    private void performTransitiveClosure(int numTables) throws StandardException {
        this.wherePredicates.joinClauseTransitiveClosure(numTables, this.fromList, this.getCompilerContext());
        this.wherePredicates.searchClauseTransitiveClosure(numTables, this.fromList.hashJoinSpecified());
    }

    public static ValueNode normExpressions(ValueNode boolClause) throws StandardException {
        if (boolClause != null) {
            if (!(boolClause = boolClause.eliminateNots(false)).verifyEliminateNots()) {
                boolClause.treePrint();
                SanityManager.THROWASSERT((String)("boolClause in invalid form: " + boolClause));
            }
            if (!((boolClause = boolClause.putAndsOnTop()) instanceof AndNode) || !boolClause.verifyPutAndsOnTop()) {
                boolClause.treePrint();
                SanityManager.THROWASSERT((String)("boolClause in invalid form: " + boolClause));
            }
            if (!((boolClause = boolClause.changeToCNF(true)) instanceof AndNode) || !boolClause.verifyChangeToCNF()) {
                boolClause.treePrint();
                SanityManager.THROWASSERT((String)("boolClause in invalid form: " + boolClause));
            }
        }
        return boolClause;
    }

    @Override
    public ResultSetNode addNewPredicate(Predicate predicate) throws StandardException {
        this.wherePredicates.addPredicate(predicate);
        return this;
    }

    @Override
    public boolean flattenableInFromSubquery(FromList fromList) {
        if (this.isDistinct) {
            return false;
        }
        if (this.fromList.size() > 1) {
            return false;
        }
        if (this.selectSubquerys != null && this.selectSubquerys.size() > 0) {
            return false;
        }
        if (this.groupByList != null || this.havingClause != null) {
            return false;
        }
        if (!this.resultColumns.isCloneable()) {
            return false;
        }
        return this.selectAggregates == null || this.selectAggregates.size() <= 0;
    }

    @Override
    public ResultSetNode genProjectRestrict(int origFromListSize) throws StandardException {
        boolean eliminateSort = false;
        boolean hasWindowFunction = false;
        ResultColumnList originalRCL = this.resultColumns.copyListAndObjects();
        CompilerContext cc = this.getCompilerContext();
        boolean createQueryInfo = cc != null && cc.createQueryInfo();
        boolean isLoner = Misc.getDistributedSystem().isLoner();
        hasWindowFunction = this.resultColumns.containsWindowFunctionResultColumn();
        if (hasWindowFunction) {
            this.resultColumns.removeWindowFunctionColumns();
            if (this.orderByList != null) {
                this.orderByList.adjustForWindowFunctionColumns();
            }
        }
        ResultSetNode prnRSN = (ResultSetNode)this.getNodeFactory().getNode(151, this.fromList.elementAt(0), this.resultColumns, this.whereClause, this.wherePredicates, this.selectSubquerys, this.whereSubquerys, null, this.getContextManager());
        if (this.selectAggregates != null && this.selectAggregates.size() > 0 || this.groupByList != null) {
            Vector aggs = this.selectAggregates;
            if (this.havingAggregates != null && !this.havingAggregates.isEmpty()) {
                this.havingAggregates.addAll(this.selectAggregates);
                aggs = this.havingAggregates;
            }
            GroupByNode gbn = (GroupByNode)this.getNodeFactory().getNode(137, prnRSN, this.groupByList, aggs, this.havingClause, this.havingSubquerys, null, this.nestingLevel, this.getContextManager());
            gbn.considerPostOptimizeOptimizations(this.originalWhereClause != null);
            gbn.assignCostEstimate(this.optimizer.getOptimizedCost());
            this.groupByList = null;
            prnRSN = gbn.getParent();
            boolean bl = eliminateSort = eliminateSort || gbn.getIsInSortedOrder();
        }
        if (this.isDistinct && !hasWindowFunction) {
            this.resultColumns.verifyAllOrderable();
            boolean distinctScanPossible = false;
            boolean inSortedOrder = this.isOrderedResult(this.resultColumns, prnRSN, !this.orderByAndDistinctMerged);
            if (!inSortedOrder && origFromListSize == 1 && !this.orderByAndDistinctMerged) {
                boolean simpleColumns = true;
                HashSet<BaseColumnNode> distinctColumns = new HashSet<BaseColumnNode>();
                int size = this.resultColumns.size();
                for (int i = 1; i <= size; ++i) {
                    BaseColumnNode bc = this.resultColumns.getResultColumn(i).getBaseColumnNode();
                    if (bc == null) {
                        simpleColumns = false;
                        break;
                    }
                    distinctColumns.add(bc);
                }
                if (simpleColumns && prnRSN.isPossibleDistinctScan(distinctColumns)) {
                    prnRSN.markForDistinctScan();
                    distinctScanPossible = true;
                }
            }
            if (!distinctScanPossible) {
                prnRSN = (ResultSetNode)this.getNodeFactory().getNode(124, prnRSN, inSortedOrder, null, this.getContextManager());
                prnRSN.costEstimate = this.costEstimate.cloneMe();
                boolean bl = eliminateSort = eliminateSort || inSortedOrder;
            }
        }
        if (this.orderByList != null) {
            int orderBySelect;
            if (this.orderByList.getSortNeeded()) {
                prnRSN = (ResultSetNode)this.getNodeFactory().getNode(140, prnRSN, this.orderByList, null, this.getContextManager());
                prnRSN.costEstimate = this.costEstimate.cloneMe();
            }
            if ((orderBySelect = this.getResultColumns().getOrderBySelect()) > 0 && (createQueryInfo || !createQueryInfo && cc != null && cc.allTablesAreReplicatedOnRemote())) {
                ResultColumnList selectRCs = prnRSN.getResultColumns().copyListAndObjects();
                selectRCs.removeOrderByColumns();
                selectRCs.genVirtualColumnNodes(prnRSN, prnRSN.getResultColumns());
                prnRSN = (ResultSetNode)this.getNodeFactory().getNode(151, prnRSN, selectRCs, null, null, null, null, null, this.getContextManager());
                originalRCL.removeOrderByColumns();
            }
        }
        if (this.wasGroupBy && this.resultColumns.numGeneratedColumnsForGroupBy() > 0) {
            ResultColumnList newSelectList = prnRSN.getResultColumns().copyListAndObjects();
            newSelectList.removeGeneratedGroupingColumns();
            newSelectList.genVirtualColumnNodes(prnRSN, prnRSN.getResultColumns());
            prnRSN = (ResultSetNode)this.getNodeFactory().getNode(151, prnRSN, newSelectList, null, null, null, null, null, this.getContextManager());
        }
        if ((this.orderByList == null || !this.orderByList.getSortNeeded()) && this.orderByQuery) {
            eliminateSort = true;
        }
        if ((!createQueryInfo && !cc.allTablesAreReplicatedOnRemote() || isLoner) && eliminateSort) {
            prnRSN.adjustForSortElimination(this.orderByList);
        }
        prnRSN.costEstimate = this.costEstimate.cloneMe();
        if (hasWindowFunction) {
            int size = originalRCL.size();
            int windowFunctionLevel = 0;
            ResultColumnList windowFunctionRCL = originalRCL.copyListAndObjects();
            for (int index = 0; index < size; ++index) {
                ResultColumn rc = (ResultColumn)originalRCL.elementAt(index);
                if (!rc.expressionIsWindowFunction()) continue;
                WindowFunctionColumnNode wfcn = (WindowFunctionColumnNode)rc.getExpression();
                WindowNode windowNode = wfcn.getWindowNode();
                windowNode.setResultColumns(windowFunctionRCL);
                windowNode.setChildResult(prnRSN);
                windowNode.setWindowFunctionLevel(++windowFunctionLevel);
                windowNode.costEstimate = this.costEstimate.cloneMe();
                prnRSN = windowNode;
            }
            if (this.isDistinct) {
                prnRSN.getResultColumns().verifyAllOrderable();
                boolean inSortedOrder = this.isOrderedResult(prnRSN.getResultColumns(), prnRSN, !this.orderByAndDistinctMerged);
                prnRSN = (ResultSetNode)this.getNodeFactory().getNode(124, prnRSN, inSortedOrder, null, this.getContextManager());
                prnRSN.costEstimate = this.costEstimate.cloneMe();
            }
            ResultColumnList newRCL = prnRSN.getResultColumns().copyListAndObjects();
            newRCL.genVirtualColumnNodes(prnRSN, prnRSN.getResultColumns());
            prnRSN = (ResultSetNode)this.getNodeFactory().getNode(151, prnRSN, newRCL, null, null, null, null, null, this.getContextManager());
            prnRSN.costEstimate = this.costEstimate.cloneMe();
        }
        return prnRSN;
    }

    private boolean isOrderedResult(ResultColumnList resultColumns, ResultSetNode newTopRSN, boolean permuteOrdering) throws StandardException {
        int rclSize = resultColumns.size();
        int numCRs = 0;
        for (int index = 0; index < rclSize; ++index) {
            ResultColumn rc = (ResultColumn)resultColumns.elementAt(index);
            if (rc.getExpression() instanceof ColumnReference) {
                ++numCRs;
                continue;
            }
            if (rc.getExpression() instanceof ConstantNode) continue;
            return false;
        }
        if (numCRs == 0) {
            return true;
        }
        ColumnReference[] crs = new ColumnReference[numCRs];
        int crsIndex = 0;
        for (int index = 0; index < rclSize; ++index) {
            ResultColumn rc = (ResultColumn)resultColumns.elementAt(index);
            if (!(rc.getExpression() instanceof ColumnReference)) continue;
            crs[crsIndex++] = (ColumnReference)rc.getExpression();
        }
        return newTopRSN.isOrderedOn(crs, permuteOrdering, null);
    }

    @Override
    public ResultSetNode ensurePredicateList(int numTables) throws StandardException {
        return this;
    }

    @Override
    public ResultSetNode optimize(DataDictionary dataDictionary, PredicateList predicateList, double outerRows) throws StandardException {
        int i;
        SanityManager.ASSERT((this.selectSubquerys != null ? 1 : 0) != 0, (String)"selectSubquerys is expected to be non-null");
        if (this.wherePredicates != null) {
            for (int i2 = this.wherePredicates.size() - 1; i2 >= 0; --i2) {
                if (!((Predicate)this.wherePredicates.elementAt(i2)).isScopedForPush()) continue;
                this.wherePredicates.removeOptPredicate(i2);
            }
        }
        if (predicateList != null) {
            if (this.wherePredicates == null) {
                this.wherePredicates = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
            }
            Predicate pred = null;
            int sz = predicateList.size();
            for (i = sz - 1; i >= 0; --i) {
                pred = (Predicate)predicateList.getOptPredicate(i);
                if (!pred.isScopedToSourceResultSet()) continue;
                this.wherePredicates.addOptPredicate(pred);
                predicateList.removeOptPredicate(pred);
            }
        }
        Optimizer optimizer = this.getOptimizer(this.fromList, this.wherePredicates, dataDictionary, (RequiredRowOrdering)((Object)(this.orderByList == null ? this.groupByList : this.orderByList)));
        optimizer.setOuterRows(outerRows);
        CompilerContext cc = (CompilerContext)this.lcc.getContextManager().getContext("CompilerContext");
        if (Boolean.parseBoolean(PropertyUtil.getSystemProperty(GfxdConstants.OPTIMIZE_NON_COLOCATED_JOIN, "false")) && cc != null && cc.createQueryInfo()) {
            optimizer.determineColocation();
        }
        while (optimizer.getNextPermutation()) {
            while (optimizer.getNextDecoratedPermutation()) {
                optimizer.costPermutation();
            }
        }
        if (this.wherePredicates != null) {
            Predicate pred = null;
            for (i = this.wherePredicates.size() - 1; i >= 0; --i) {
                pred = (Predicate)this.wherePredicates.getOptPredicate(i);
                if (!pred.isScopedForPush()) continue;
                predicateList.addOptPredicate(pred);
                this.wherePredicates.removeOptPredicate(pred);
            }
        }
        this.costEstimate = optimizer.getOptimizedCost();
        if (this.selectAggregates != null && this.selectAggregates.size() > 0) {
            this.costEstimate.setEstimatedRowCount((long)outerRows);
            this.costEstimate.setSingleScanRowCount(1.0);
        }
        this.selectSubquerys.optimize(dataDictionary, this.costEstimate.rowCount());
        if (this.whereSubquerys != null && this.whereSubquerys.size() > 0) {
            this.whereSubquerys.optimize(dataDictionary, this.costEstimate.rowCount());
        }
        if (this.havingSubquerys != null && this.havingSubquerys.size() > 0) {
            this.havingSubquerys.optimize(dataDictionary, this.costEstimate.rowCount());
        }
        return this;
    }

    @Override
    public ResultSetNode modifyAccessPaths(PredicateList predList) throws StandardException {
        SanityManager.ASSERT((this.optimizer != null ? 1 : 0) != 0, (String)"SelectNode's optimizer not expected to be null when modifying access paths.");
        ((OptimizerImpl)this.optimizer).addScopedPredicatesToList(predList);
        return this.modifyAccessPaths();
    }

    @Override
    public ResultSetNode modifyAccessPaths() throws StandardException {
        int totalPullsExpected;
        int origFromListSize = this.fromList.size();
        if (this.convertCountToRegionSize && GemFireXDUtils.TraceQuery) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"Not converting count(*) to Region.size() despite flag being true");
        }
        this.optimizer.modifyAccessPaths();
        this.costEstimate = this.optimizer.getFinalCost();
        if (this.wherePredicates != null) {
            Predicate pred = null;
            for (int i = this.wherePredicates.size() - 1; i >= 0; --i) {
                pred = (Predicate)this.wherePredicates.getOptPredicate(i);
                if (!pred.isScopedForPush()) continue;
                SanityManager.THROWASSERT((String)("Found scoped predicate " + pred.binaryRelOpColRefsToString() + " in WHERE list when no scoped predicates were expected."));
            }
        }
        this.selectSubquerys.modifyAccessPaths();
        if (this.whereSubquerys != null && this.whereSubquerys.size() > 0) {
            this.whereSubquerys.modifyAccessPaths();
        }
        if (this.havingSubquerys != null && this.havingSubquerys.size() > 0) {
            this.havingSubquerys.modifyAccessPaths();
        }
        this.preJoinFL.removeAllElements();
        this.preJoinFL.nondestructiveAppend(this.fromList);
        int ncjCountPullDone = 0;
        CompilerContext cc = this.getCompilerContext();
        while (this.fromList.size() > 1) {
            ResultSetNode leftResultSet = (ResultSetNode)this.fromList.elementAt(0);
            ResultSetNode rightResultSet = (ResultSetNode)this.fromList.elementAt(1);
            boolean ncjPullJoinDone = false;
            if (cc.isNCJoinOnRemote()) {
                if (leftResultSet.isJoinNode()) {
                    ResultSetNode newResultSet = this.ncjHandleHigherLevelJoin(leftResultSet, rightResultSet);
                    if (newResultSet != null) {
                        leftResultSet = this.replaceWithNcjPullNode((ProjectRestrictNode)rightResultSet, true, false);
                        rightResultSet = newResultSet;
                        ++ncjCountPullDone;
                        ncjPullJoinDone = true;
                    }
                } else {
                    SanityManager.ASSERT((ncjCountPullDone == 0 ? 1 : 0) != 0, (String)"Should not be called at any higher level of join");
                    int pullCountAtFirstLevel = NcjHashMapWrapper.getNoOfTabsForPullAtFirstLevel(cc.getNCJMetaDataOnRemote());
                    if (pullCountAtFirstLevel > 0) {
                        if (this.ncjVerifyTablesInOrderAtFirstLevelJoin(leftResultSet, rightResultSet)) {
                            ResultSetNode newResultSet = this.ncjHandleFirstLevelJoin(leftResultSet, rightResultSet);
                            if (newResultSet != null) {
                                rightResultSet = newResultSet;
                                leftResultSet = this.replaceWithNcjPullNode((ProjectRestrictNode)leftResultSet, true, false);
                                ncjPullJoinDone = true;
                            } else {
                                SanityManager.THROWASSERT((String)("NCJ Join failed at first level (in-order) which have pull count = " + pullCountAtFirstLevel));
                            }
                        } else {
                            SanityManager.THROWASSERT((String)("NCJ Join failed at first level, since tables are not in order as expected, and have pull count = " + pullCountAtFirstLevel));
                        }
                    }
                    ncjCountPullDone += pullCountAtFirstLevel;
                }
            }
            ResultColumnList leftRCList = leftResultSet.getResultColumns();
            leftResultSet.setResultColumns(leftRCList.copyListAndObjects());
            leftRCList.genVirtualColumnNodes(leftResultSet, leftResultSet.resultColumns);
            ResultColumnList rightRCList = rightResultSet.getResultColumns();
            rightResultSet.setResultColumns(rightRCList.copyListAndObjects());
            rightRCList.genVirtualColumnNodes(rightResultSet, rightResultSet.resultColumns);
            rightRCList.adjustVirtualColumnIds(leftRCList.size());
            leftRCList.nondestructiveAppend(rightRCList);
            this.fromList.setElementAt(this.getNodeFactory().getNode(139, leftResultSet, rightResultSet, null, null, leftRCList, null, this.fromList.properties, this.getContextManager()), 0);
            this.fromList.removeElementAt(1);
            if (!cc.isNCJoinOnRemote()) continue;
            JoinNode jn = (JoinNode)this.fromList.elementAt(0);
            if (!ncjPullJoinDone) continue;
            jn.setJoinResultSetString(new DistributedHashFetchRowsJoinStrategy().joinResultSetMethodName());
        }
        if (cc.isNCJoinOnRemote() && (totalPullsExpected = NcjHashMapWrapper.getNoOfTabsForPull(cc.getNCJMetaDataOnRemote())) != ncjCountPullDone) {
            SanityManager.THROWASSERT((String)("JoinOrderList from QN has not been consumed fully. Expected Pulls" + totalPullsExpected + " ,Pulls Done=" + ncjCountPullDone));
        }
        return this.genProjectRestrict(origFromListSize);
    }

    @Override
    public CostEstimate getFinalCostEstimate() throws StandardException {
        return this.optimizer.getFinalCost();
    }

    @Override
    boolean isUpdatableCursor(DataDictionary dd) throws StandardException {
        if (this.isDistinct) {
            SanityManager.DEBUG((String)"DumpUpdateCheck", (String)"cursor select has distinct");
            return false;
        }
        if (this.selectAggregates == null || this.selectAggregates.size() > 0) {
            return false;
        }
        if (this.groupByList != null || this.havingClause != null) {
            return false;
        }
        SanityManager.ASSERT((this.fromList != null ? 1 : 0) != 0, (String)"select must have from tables");
        if (this.fromList.size() != 1) {
            SanityManager.DEBUG((String)"DumpUpdateCheck", (String)"cursor select has more than one from table");
            return false;
        }
        this.targetTable = (FromTable)this.fromList.elementAt(0);
        if (this.targetTable instanceof FromVTI) {
            return ((FromVTI)this.targetTable).isUpdatableCursor();
        }
        if (!(this.targetTable instanceof FromBaseTable)) {
            SanityManager.DEBUG((String)"DumpUpdateCheck", (String)"cursor select has non base table as target table");
            return false;
        }
        TableDescriptor targetTableDescriptor = this.getTableDescriptor(((FromBaseTable)this.targetTable).getBaseTableName(), this.getSchemaDescriptor(((FromBaseTable)this.targetTable).getTableNameField().getSchemaName()));
        if (targetTableDescriptor.getTableType() == 1) {
            SanityManager.DEBUG((String)"DumpUpdateCheck", (String)"cursor select is on system table");
            return false;
        }
        if (targetTableDescriptor.getTableType() == 2) {
            SanityManager.DEBUG((String)"DumpUpdateCheck", (String)"cursor select is on view");
            return false;
        }
        if (this.getSelectSubquerys() != null && this.getSelectSubquerys().size() != 0) {
            SanityManager.DEBUG((String)"DumpUpdateCheck", (String)"cursor select has subquery in SELECT list");
            return false;
        }
        if (this.getWhereSubquerys() != null && this.getWhereSubquerys().size() != 0) {
            SanityManager.DEBUG((String)"DumpUpdateCheck", (String)"cursor select has subquery in WHERE clause");
            return false;
        }
        return true;
    }

    @Override
    FromTable getCursorTargetTable() {
        SanityManager.ASSERT((this.targetTable != null ? 1 : 0) != 0, (String)"must call isUpdatableCursor() first, and must be updatable");
        return this.targetTable;
    }

    @Override
    public boolean referencesTarget(String name, boolean baseTable) throws StandardException {
        return this.fromList.referencesTarget(name, baseTable) || this.selectSubquerys != null && this.selectSubquerys.referencesTarget(name, baseTable) || this.whereSubquerys != null && this.whereSubquerys.referencesTarget(name, baseTable);
    }

    @Override
    public void disablePrivilegeCollection() {
        super.disablePrivilegeCollection();
        int fromListSize = this.fromList.size();
        for (int i = 0; i < fromListSize; ++i) {
            ((FromTable)this.fromList.elementAt(i)).disablePrivilegeCollection();
        }
    }

    @Override
    boolean subqueryReferencesTarget(String name, boolean baseTable) throws StandardException {
        return this.selectSubquerys != null && this.selectSubquerys.referencesTarget(name, baseTable) || this.whereSubquerys != null && this.whereSubquerys.referencesTarget(name, baseTable);
    }

    @Override
    public void bindUntypedNullsToResultColumns(ResultColumnList bindingRCL) throws StandardException {
        this.fromList.bindUntypedNullsToResultColumns(bindingRCL);
    }

    @Override
    void decrementLevel(int decrement) {
        this.fromList.decrementLevel(decrement);
        this.selectSubquerys.decrementLevel(decrement);
        this.whereSubquerys.decrementLevel(decrement);
        this.wherePredicates.decrementLevel(this.fromList, decrement);
    }

    boolean uniqueSubquery(boolean additionalEQ) throws StandardException {
        ColumnReference additionalCR = null;
        ResultColumn rc = (ResultColumn)this.getResultColumns().elementAt(0);
        if (additionalEQ && rc.getExpression() instanceof ColumnReference && (additionalCR = (ColumnReference)rc.getExpression()).getCorrelated()) {
            additionalCR = null;
        }
        return this.fromList.returnsAtMostSingleRow(additionalCR == null ? null : this.getResultColumns(), this.whereClause, this.wherePredicates, this.getDataDictionary());
    }

    @Override
    public int updateTargetLockMode() {
        return this.fromList.updateTargetLockMode();
    }

    @Override
    boolean returnsAtMostOneRow() {
        return this.groupByList == null && this.selectAggregates != null && this.selectAggregates.size() != 0;
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return this.fromList.referencesSessionSchema() || this.selectSubquerys != null && this.selectSubquerys.referencesSessionSchema() || this.whereSubquerys != null && this.whereSubquerys.referencesSessionSchema();
    }

    @Override
    public Visitable accept(Visitor v) throws StandardException {
        Visitable returnNode = v.visit(this);
        if (v.skipChildren(this)) {
            return returnNode;
        }
        if (!v.stopTraversal()) {
            super.accept(v);
        }
        if (this.fromList != null && !v.stopTraversal()) {
            this.fromList = (FromList)this.fromList.accept(v);
        }
        if (this.whereClause != null && !v.stopTraversal()) {
            this.whereClause = (ValueNode)this.whereClause.accept(v);
        }
        if (this.wherePredicates != null && !v.stopTraversal()) {
            this.wherePredicates = (PredicateList)this.wherePredicates.accept(v);
        }
        if (this.havingClause != null && !v.stopTraversal()) {
            this.havingClause = (ValueNode)this.havingClause.accept(v);
        }
        if (this.groupByList != null) {
            this.groupByList = (GroupByList)this.groupByList.accept(v);
        }
        return returnNode;
    }

    public boolean hasAggregatesInSelectList() {
        return !this.selectAggregates.isEmpty();
    }

    public void setParentSubQueryNodeFlag() {
        this.isPartOfSubQueryNode = true;
    }

    public int getNestingLevel() {
        return this.nestingLevel;
    }

    public boolean convertCountToRegionSize() {
        return this.convertCountToRegionSize;
    }

    private ResultSetNode replaceWithHashTableNode(int[] hashKeyColumns, ResultSetNode childResult, PredicateList joinQualifierList) throws StandardException {
        ResultColumnList htRCList = childResult.getResultColumns();
        childResult.setResultColumns(htRCList.copyListAndObjects());
        htRCList.genVirtualColumnNodes(childResult, childResult.getResultColumns(), false);
        joinQualifierList.markAllPredicatesQualifiers();
        HashTableNode newChildResult = (HashTableNode)this.getNodeFactory().getNode(148, childResult, null, htRCList, null, joinQualifierList, null, null, null, null, hashKeyColumns, this.getContextManager());
        newChildResult.isNCJCase = true;
        return newChildResult;
    }

    private ResultSetNode replaceWithNcjPullNode(ProjectRestrictNode childResult, boolean isRemoteScan, Object isAtSecondPosition) throws StandardException {
        ResultSetNode newChildResult = (ResultSetNode)this.getNodeFactory().getNode(145, childResult, isRemoteScan, isAtSecondPosition, childResult.tableProperties, this.getContextManager());
        return newChildResult;
    }

    int[] findHashKeyColumns(ResultSetNode resultSet, OptimizablePredicateList predList, int driverTabNum, int remoteTabNum, ArrayList<String> localJoinColNames, ArrayList<String> remoteJoinColNames) throws StandardException {
        if (predList == null) {
            return null;
        }
        SanityManager.ASSERT((remoteTabNum > NcjHashMapWrapper.MINUS_ONE ? 1 : 0) != 0);
        Vector hashKeyVector = new Vector();
        for (int idx = 0; idx < predList.size(); ++idx) {
            int localTabNum = NcjHashMapWrapper.MINUS_ONE;
            int localColNum = NcjHashMapWrapper.MINUS_ONE;
            int remoteColNum = NcjHashMapWrapper.MINUS_ONE;
            String nameLocalCol = null;
            String nameRemoteCol = null;
            Predicate pred = (Predicate)predList.getOptPredicate(idx);
            BinaryRelationalOperatorNode opNode = (BinaryRelationalOperatorNode)pred.getAndNode().getLeftOperand();
            ColumnReference leftOp = (ColumnReference)opNode.getLeftOperand();
            ColumnReference rightOp = (ColumnReference)opNode.getRightOperand();
            SanityManager.ASSERT((leftOp.getSourceLevel() == rightOp.getSourceLevel() ? 1 : 0) != 0);
            if (leftOp.getTableNumber() == remoteTabNum) {
                localTabNum = rightOp.getTableNumber();
                localColNum = rightOp.getColumnNumber();
                nameLocalCol = rightOp.getSource().getActualName();
                remoteColNum = leftOp.getColumnNumber();
                nameRemoteCol = leftOp.getSource().getActualName();
            } else if (rightOp.getTableNumber() == remoteTabNum) {
                localTabNum = leftOp.getTableNumber();
                localColNum = leftOp.getColumnNumber();
                nameLocalCol = leftOp.getSource().getActualName();
                remoteColNum = rightOp.getColumnNumber();
                nameRemoteCol = rightOp.getSource().getActualName();
            }
            if (remoteColNum == NcjHashMapWrapper.MINUS_ONE || localColNum == NcjHashMapWrapper.MINUS_ONE) continue;
            if (driverTabNum != NcjHashMapWrapper.MINUS_ONE) {
                SanityManager.ASSERT((localTabNum == driverTabNum ? 1 : 0) != 0);
            } else {
                SanityManager.ASSERT((localTabNum > NcjHashMapWrapper.MINUS_ONE ? 1 : 0) != 0);
            }
            if (localJoinColNames.contains(nameLocalCol) || remoteJoinColNames.contains(nameRemoteCol)) continue;
            remoteJoinColNames.add(nameRemoteCol);
            localJoinColNames.add(nameLocalCol);
            resultSet.collectHashKeyColumns(hashKeyVector, localTabNum, localColNum);
        }
        if (GemFireXDUtils.TraceNCJIter) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJIter", (String)("SelectNode#findHashKeyColumns. hashKeyVector=" + hashKeyVector + ""));
        }
        if (hashKeyVector.size() > 0) {
            int[] keyCols = new int[hashKeyVector.size()];
            for (int index = 0; index < keyCols.length; ++index) {
                keyCols[index] = (Integer)hashKeyVector.elementAt(index);
            }
            return keyCols;
        }
        return null;
    }

    public boolean isDistributedJoin() {
        return this.optimizer.hasNonColocatedTables();
    }

    private static boolean verifyLists(ArrayList<String> remoteList, ArrayList<String> localList) {
        int size = remoteList.size();
        if (size != localList.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (localList.get(i) == null && remoteList.get(i) == null || localList.get(i) != null && remoteList.get(i) != null) continue;
            return false;
        }
        return true;
    }

    private ResultSetNode ncjHandleFirstLevelJoin(ResultSetNode leftResultSet, ResultSetNode rightResultSet) throws StandardException {
        ResultSetNode retrunResultSet = null;
        CompilerContext cc = this.getCompilerContext();
        leftResultSet.assertProjectRestrictNode();
        FromBaseTable lFbTbl = leftResultSet.ncjGetOnlyOneFBTNode();
        if (lFbTbl != null && lFbTbl.isPartitionedRegion() && NcjHashMapWrapper.isTabAtFirstPosition(cc.getNCJMetaDataOnRemote(), lFbTbl.ncjGetCorrelationName()) && NcjHashMapWrapper.isTabForPull(cc.getNCJMetaDataOnRemote(), lFbTbl.ncjGetCorrelationName())) {
            rightResultSet.assertProjectRestrictNode();
            FromBaseTable rFbTbl = rightResultSet.ncjGetOnlyOneFBTNode();
            if (NcjHashMapWrapper.isTabAtSecondPosition(cc.getNCJMetaDataOnRemote(), rFbTbl.ncjGetCorrelationName())) {
                int driverTabNum = rFbTbl.getTableNumber();
                this.assertTableNumberIsValid(driverTabNum);
                PredicateList joinPredicateList = new PredicateList();
                ProjectRestrictNode rPrn = (ProjectRestrictNode)rightResultSet;
                int[] hashKeyColumns = new int[]{0};
                ArrayList<String> remoteJoinCols = new ArrayList<String>();
                ArrayList<String> localJoinCols = new ArrayList<String>();
                if (rPrn.restrictionList != null) {
                    rPrn.restrictionList.moveJoinPredicatesToOtherList(joinPredicateList, lFbTbl);
                    SanityManager.ASSERT((joinPredicateList.size() > 0 ? 1 : 0) != 0);
                    joinPredicateList.removeRedundantPredicates();
                    int remoteTabNum = lFbTbl.getTableNumber();
                    this.assertTableNumberIsValid(remoteTabNum);
                    hashKeyColumns = null;
                    hashKeyColumns = this.findHashKeyColumns(rightResultSet, joinPredicateList, driverTabNum, remoteTabNum, localJoinCols, remoteJoinCols);
                    SanityManager.ASSERT((hashKeyColumns != null ? 1 : 0) != 0);
                    SanityManager.ASSERT((boolean)SelectNode.verifyLists(remoteJoinCols, localJoinCols));
                    ProjectRestrictNode lPrn = (ProjectRestrictNode)leftResultSet;
                    lPrn.setRemoteInListCols(remoteJoinCols);
                }
                boolean rightIsPull = false;
                if (rFbTbl.isPartitionedRegion() && NcjHashMapWrapper.isTabForPull(cc.getNCJMetaDataOnRemote(), rFbTbl.ncjGetCorrelationName())) {
                    rightIsPull = true;
                }
                rightResultSet = this.replaceWithNcjPullNode((ProjectRestrictNode)rightResultSet, rightIsPull, true);
                retrunResultSet = this.replaceWithHashTableNode(hashKeyColumns, rightResultSet, joinPredicateList);
                if (GemFireXDUtils.TraceNCJ) {
                    SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("SelectNode#ncjHandleFirstLevelJoin. leftTab=" + lFbTbl.ncjGetCorrelationName() + " ,rightTab=" + rFbTbl.ncjGetCorrelationName() + " right-pull=" + rightIsPull + " remoteJoinCols=" + remoteJoinCols + " ,localJoinCols=" + localJoinCols));
                }
            }
        }
        return retrunResultSet;
    }

    private boolean ncjVerifyTablesInOrderAtFirstLevelJoin(ResultSetNode leftResultSet, ResultSetNode rightResultSet) throws StandardException {
        CompilerContext cc = this.getCompilerContext();
        leftResultSet.assertProjectRestrictNode();
        FromBaseTable lFbTbl = leftResultSet.ncjGetOnlyOneFBTNode();
        rightResultSet.assertProjectRestrictNode();
        FromBaseTable rFbTbl = rightResultSet.ncjGetOnlyOneFBTNode();
        if (lFbTbl != null && lFbTbl.isPartitionedRegion()) {
            if (NcjHashMapWrapper.isTabAtFirstPosition(cc.getNCJMetaDataOnRemote(), lFbTbl.ncjGetCorrelationName())) {
                if (NcjHashMapWrapper.isTabForPull(cc.getNCJMetaDataOnRemote(), lFbTbl.ncjGetCorrelationName())) {
                    if (NcjHashMapWrapper.isTabAtSecondPosition(cc.getNCJMetaDataOnRemote(), rFbTbl.ncjGetCorrelationName())) {
                        int driverTabNum = rFbTbl.getTableNumber();
                        this.assertTableNumberIsValid(driverTabNum);
                        if (GemFireXDUtils.TraceNCJ) {
                            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("SelectNode#ncjVerifyTablesAtFirstLevelJoin. Tables are in order leftTab=" + lFbTbl.ncjGetCorrelationName() + " ,rightTab=" + rFbTbl.ncjGetCorrelationName()));
                        }
                        return true;
                    }
                    if (GemFireXDUtils.TraceNCJ) {
                        SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("SelectNode#ncjVerifyTablesAtFirstLevelJoin. Right Table is not second table leftTab=" + lFbTbl.ncjGetCorrelationName() + " ,rightTab=" + rFbTbl.ncjGetCorrelationName()));
                    }
                } else if (GemFireXDUtils.TraceNCJ) {
                    SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("SelectNode#ncjVerifyTablesAtFirstLevelJoin. Left table is not for Pull.  leftTab=" + lFbTbl.ncjGetCorrelationName() + " ,rightTab=" + rFbTbl.ncjGetCorrelationName()));
                }
            } else if (GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("SelectNode#ncjVerifyTablesAtFirstLevelJoin. Left table is not at First Position.  leftTab=" + lFbTbl.ncjGetCorrelationName() + " ,rightTab=" + rFbTbl.ncjGetCorrelationName()));
            }
        } else if (GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("SelectNode#ncjVerifyTablesAtFirstLevelJoin. Left table is not a partitioned region.  leftTab=" + lFbTbl.ncjGetCorrelationName() + " ,rightTab=" + rFbTbl.ncjGetCorrelationName()));
        }
        return false;
    }

    private ResultSetNode ncjHandleHigherLevelJoin(ResultSetNode leftResultSet, ResultSetNode rightResultSet) throws StandardException {
        ResultSetNode returnRs = null;
        rightResultSet.assertProjectRestrictNode();
        FromBaseTable rFbTbl = rightResultSet.ncjGetOnlyOneFBTNode();
        if (rFbTbl != null && rFbTbl.isPartitionedRegion() && NcjHashMapWrapper.isTabForPull(this.getCompilerContext().getNCJMetaDataOnRemote(), rFbTbl.ncjGetCorrelationName())) {
            int remoteTabNum = rFbTbl.getTableNumber();
            this.assertTableNumberIsValid(remoteTabNum);
            PredicateList joinPredicateList = new PredicateList();
            ProjectRestrictNode rPrn = (ProjectRestrictNode)rightResultSet;
            rPrn.restrictionList.moveJoinPredicatesToOtherList(joinPredicateList, rFbTbl);
            SanityManager.ASSERT((joinPredicateList.size() > 0 ? 1 : 0) != 0);
            joinPredicateList.removeRedundantPredicates();
            ArrayList<String> remoteJoinCols = new ArrayList<String>();
            ArrayList<String> localJoinCols = new ArrayList<String>();
            int[] hashKeyColumns = this.findHashKeyColumns(leftResultSet, joinPredicateList, NcjHashMapWrapper.MINUS_ONE, remoteTabNum, localJoinCols, remoteJoinCols);
            SanityManager.ASSERT((hashKeyColumns != null ? 1 : 0) != 0);
            SanityManager.ASSERT((boolean)SelectNode.verifyLists(remoteJoinCols, localJoinCols));
            rPrn.setRemoteInListCols(remoteJoinCols);
            returnRs = this.replaceWithHashTableNode(hashKeyColumns, leftResultSet, joinPredicateList);
            if (GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("SelectNode#ncjHandleHigherLevelJoin. remoteJoinCols=" + remoteJoinCols + " ,localJoinCols=" + localJoinCols));
            }
        }
        return returnRs;
    }

    private void assertTableNumberIsValid(int tabNum) {
        SanityManager.ASSERT((tabNum >= 0 ? 1 : 0) != 0, (String)"TODO: Need TableName based solution");
    }
}

