/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.catalog.types.ReferencedColumnsDescriptorImpl;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableArrayHolder;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableIntHolder;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CostEstimate;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizer;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitor;
import com.pivotal.gemfirexd.internal.iapi.util.JBitSet;
import com.pivotal.gemfirexd.internal.impl.sql.compile.AccessPathImpl;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ActivationClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CollectAndEliminateColumnsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SingleChildResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;

public class HashTableNode
extends SingleChildResultSetNode {
    PredicateList searchPredicateList;
    PredicateList joinPredicateList;
    SubqueryList pSubqueryList;
    SubqueryList rSubqueryList;
    boolean isNCJCase = false;

    @Override
    public void init(Object childResult, Object tableProperties, Object resultColumns, Object searchPredicateList, Object joinPredicateList, Object accessPath, Object costEstimate, Object pSubqueryList, Object rSubqueryList, Object hashKeyColumns) {
        super.init(childResult, tableProperties);
        this.resultColumns = (ResultColumnList)resultColumns;
        this.searchPredicateList = (PredicateList)searchPredicateList;
        this.joinPredicateList = (PredicateList)joinPredicateList;
        this.trulyTheBestAccessPath = (AccessPathImpl)accessPath;
        this.costEstimate = (CostEstimate)costEstimate;
        this.pSubqueryList = (SubqueryList)pSubqueryList;
        this.rSubqueryList = (SubqueryList)rSubqueryList;
        this.setHashKeyColumns((int[])hashKeyColumns);
    }

    public Optimizable modifyAccessPath(JBitSet outerTables, Optimizer optimizer) throws StandardException {
        return this;
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.searchPredicateList != null) {
            this.printLabel(depth, "searchPredicateList: ");
            this.searchPredicateList.treePrint(depth + 1);
        }
        if (this.joinPredicateList != null) {
            this.printLabel(depth, "joinPredicateList: ");
            this.joinPredicateList.treePrint(depth + 1);
        }
    }

    @Override
    public void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.ASSERT((this.resultColumns != null ? 1 : 0) != 0, (String)"Tree structure bad");
        this.generateMinion(acb, mb, false);
    }

    @Override
    public void generateResultSet(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.generateMinion(acb, mb, true);
    }

    private void generateMinion(ExpressionClassBuilder acb, MethodBuilder mb, boolean genChildResultSet) throws StandardException {
        ValueNode searchClause = null;
        Object equijoinClause = null;
        this.verifyProperties(this.getDataDictionary());
        if (this.searchPredicateList != null) {
            this.searchPredicateList.removeRedundantPredicates();
            searchClause = this.searchPredicateList.restorePredicates();
            this.searchPredicateList = null;
        }
        int[] mapArray = this.resultColumns.mapSourceColumns();
        int mapArrayItem = acb.addItem(new ReferencedColumnsDescriptorImpl(mapArray));
        Object[] fihArray = FormatableIntHolder.getFormatableIntHolders(this.hashKeyColumns());
        FormatableArrayHolder hashKeyHolder = new FormatableArrayHolder(fihArray);
        int hashKeyItem = acb.addItem(hashKeyHolder);
        acb.pushGetResultSetFactoryExpression(mb);
        if (genChildResultSet) {
            this.childResult.generateResultSet(acb, mb);
        } else {
            this.childResult.generate((ActivationClassBuilder)acb, mb);
        }
        if (this.isNCJCase) {
            this.ncjAssignResultSetNumber(this.getCompilerContext().getNextResultSetNumber());
        } else {
            this.assignResultSetNumber();
        }
        if (this.pSubqueryList != null && this.pSubqueryList.size() > 0) {
            this.pSubqueryList.setPointOfAttachment(this.resultSetNumber);
            SanityManager.ASSERT((this.pSubqueryList.size() == 0 ? 1 : 0) != 0, (String)"pSubqueryList.size() expected to be 0");
        }
        if (this.rSubqueryList != null && this.rSubqueryList.size() > 0) {
            this.rSubqueryList.setPointOfAttachment(this.resultSetNumber);
            SanityManager.ASSERT((this.rSubqueryList.size() == 0 ? 1 : 0) != 0, (String)"rSubqueryList.size() expected to be 0");
        }
        this.costEstimate = this.childResult.getFinalCostEstimate();
        if (searchClause == null) {
            mb.pushNull("com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod");
        } else {
            MethodBuilder userExprFun = acb.newUserExprFun();
            searchClause.generateExpression(acb, userExprFun);
            userExprFun.methodReturn();
            userExprFun.complete();
            acb.pushMethodReference(mb, userExprFun);
        }
        this.joinPredicateList.generateQualifiers(acb, mb, (Optimizable)((Object)this.childResult), false);
        if (this.reflectionNeededForProjection()) {
            this.resultColumns.generateCore(acb, mb, false);
        } else {
            mb.pushNull("com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod");
        }
        mb.push(this.resultSetNumber);
        mb.push(mapArrayItem);
        mb.push(this.resultColumns.reusableResult());
        mb.push(hashKeyItem);
        mb.push(false);
        mb.push(-1L);
        mb.push(this.initialCapacity);
        mb.push(this.loadFactor);
        mb.push(this.costEstimate.singleScanRowCount());
        mb.push(this.costEstimate.getEstimatedCost());
        mb.push(this.isNCJCase);
        mb.callMethod((short)185, null, "getHashTableResultSet", "com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet", 15);
    }

    @Override
    public Visitable accept(Visitor v) throws StandardException {
        if (v.skipChildren(this)) {
            return v.visit(this);
        }
        Visitable returnNode = super.accept(v);
        if (this.searchPredicateList != null && !v.stopTraversal()) {
            this.searchPredicateList = (PredicateList)this.searchPredicateList.accept(v);
        }
        if (this.joinPredicateList != null && !v.stopTraversal()) {
            this.joinPredicateList = (PredicateList)this.joinPredicateList.accept(v);
        }
        return returnNode;
    }

    public final PredicateList getJoinPredicateList() {
        return this.joinPredicateList;
    }

    public final PredicateList getSearchPredicateList() {
        return this.searchPredicateList;
    }

    public final SubqueryList getPSubqueryList() {
        return this.pSubqueryList;
    }

    public final SubqueryList getRSubqueryList() {
        return this.rSubqueryList;
    }

    @Override
    public void eliminateUnUsedColumns(ResultColumnList parentResultColumn, CollectAndEliminateColumnsVisitor finder) throws StandardException {
        this.resultColumns = this.resultColumns.eliminateUnUsedColumns(this.resultColumns.mergeColumnList(parentResultColumn, this.joinPredicateList, this.searchPredicateList), finder);
        this.childResult.eliminateUnUsedColumns(this.resultColumns, finder);
    }

    @Override
    protected void optimizeForOffHeap(boolean shouldOptimize) {
        this.childResult.optimizeForOffHeap(false);
    }
}

