/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.catalog;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.store.ServerGroupUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.services.uuid.UUIDFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.CatalogRowFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDescriptorGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SystemColumn;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TupleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionFactory;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.SystemColumnImpl;
import com.pivotal.gemfirexd.internal.shared.common.SharedUtils;

public class SYSSCHEMASRowFactory
extends CatalogRowFactory {
    public static final String TABLENAME_STRING = "SYSSCHEMAS";
    public static final int SYSSCHEMAS_COLUMN_COUNT = 4;
    public static final int SYSSCHEMAS_SCHEMAID = 1;
    public static final int SYSSCHEMAS_SCHEMANAME = 2;
    public static final int SYSSCHEMAS_SCHEMAAID = 3;
    protected static final int SYSSCHEMAS_INDEX1_ID = 0;
    protected static final int SYSSCHEMAS_INDEX2_ID = 1;
    private static final int[][] indexColumnPositions = new int[][]{{2}, {1}};
    private static final boolean[] uniqueness = null;
    private static final String[] uuids = new String[]{"80000022-00d0-fd77-3ed8-000a0a0b1900", "8000002a-00d0-fd77-3ed8-000a0a0b1900", "80000024-00d0-fd77-3ed8-000a0a0b1900", "80000026-00d0-fd77-3ed8-000a0a0b1900"};

    SYSSCHEMASRowFactory(UUIDFactory uuidf, ExecutionFactory ef, DataValueFactory dvf) {
        super(uuidf, ef, dvf);
        this.initInfo(4, TABLENAME_STRING, indexColumnPositions, uniqueness, uuids);
    }

    @Override
    public ExecRow makeRow(TupleDescriptor td, TupleDescriptor parent) throws StandardException {
        String name = null;
        UUID oid = null;
        String uuid = null;
        String aid = null;
        if (td != null) {
            SchemaDescriptor schemaDescriptor = (SchemaDescriptor)td;
            name = schemaDescriptor.getSchemaName();
            oid = schemaDescriptor.getUUID();
            if (oid == null) {
                oid = this.getUUIDFactory().createUUID();
                schemaDescriptor.setUUID(oid);
            }
            uuid = oid.toString();
            aid = schemaDescriptor.getAuthorizationId();
        }
        ExecRow row = this.getExecutionFactory().getValueRow(4);
        row.setColumn(1, new SQLChar(uuid));
        row.setColumn(2, new SQLVarchar(name));
        row.setColumn(3, new SQLVarchar(aid));
        String defaultSGs = "";
        if (td != null) {
            defaultSGs = SharedUtils.toCSV(((SchemaDescriptor)td).getDefaultServerGroups());
        }
        row.setColumn(4, new SQLVarchar(defaultSGs));
        return row;
    }

    @Override
    public TupleDescriptor buildDescriptor(ExecRow row, TupleDescriptor parentTupleDescriptor, DataDictionary dd) throws StandardException {
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        SanityManager.ASSERT((row.nColumns() == 4 ? 1 : 0) != 0, (String)"Wrong number of columns for a SYSSCHEMAS row");
        DataValueDescriptor col = row.getColumn(1);
        String uuid = col.getString();
        UUID id = this.getUUIDFactory().recreateUUID(uuid);
        col = row.getColumn(2);
        String name = col.getString();
        col = row.getColumn(3);
        String aid = col.getString();
        SchemaDescriptor descriptor = ddg.newSchemaDescriptor(name, aid, id);
        col = row.getColumn(4);
        descriptor.setDefaultServerGroups(ServerGroupUtils.getServerGroups(col.toString()));
        return descriptor;
    }

    @Override
    public SystemColumn[] buildColumnList() throws StandardException {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("SCHEMAID", false), SystemColumnImpl.getIdentifierColumn("SCHEMANAME", false), SystemColumnImpl.getIdentifierColumn("AUTHORIZATIONID", false), SystemColumnImpl.getIdentifierColumn("DEFAULTSERVERGROUPS", false)};
    }
}

