/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.catalog;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.services.uuid.UUIDFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.CatalogRowFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDescriptorGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SubCheckConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SubConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SubKeyConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SystemColumn;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TupleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionFactory;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.SystemColumnImpl;

public class SYSCONSTRAINTSRowFactory
extends CatalogRowFactory {
    private static final String TABLENAME_STRING = "SYSCONSTRAINTS";
    protected static final int SYSCONSTRAINTS_COLUMN_COUNT = 7;
    protected static final int SYSCONSTRAINTS_CONSTRAINTID = 1;
    protected static final int SYSCONSTRAINTS_TABLEID = 2;
    protected static final int SYSCONSTRAINTS_CONSTRAINTNAME = 3;
    protected static final int SYSCONSTRAINTS_TYPE = 4;
    protected static final int SYSCONSTRAINTS_SCHEMAID = 5;
    protected static final int SYSCONSTRAINTS_STATE = 6;
    protected static final int SYSCONSTRAINTS_REFERENCECOUNT = 7;
    protected static final int SYSCONSTRAINTS_INDEX1_ID = 0;
    protected static final int SYSCONSTRAINTS_INDEX2_ID = 1;
    protected static final int SYSCONSTRAINTS_INDEX3_ID = 2;
    private static final boolean[] uniqueness = new boolean[]{true, true, false};
    private static final int[][] indexColumnPositions = new int[][]{{1}, {3, 5}, {2}};
    private static final String[] uuids = new String[]{"8000002f-00d0-fd77-3ed8-000a0a0b1900", "80000036-00d0-fd77-3ed8-000a0a0b1900", "80000031-00d0-fd77-3ed8-000a0a0b1900", "80000033-00d0-fd77-3ed8-000a0a0b1900", "80000035-00d0-fd77-3ed8-000a0a0b1900"};

    SYSCONSTRAINTSRowFactory(UUIDFactory uuidf, ExecutionFactory ef, DataValueFactory dvf) {
        super(uuidf, ef, dvf);
        this.initInfo(7, TABLENAME_STRING, indexColumnPositions, uniqueness, uuids);
    }

    @Override
    public ExecRow makeRow(TupleDescriptor td, TupleDescriptor parent) throws StandardException {
        String constraintSType = null;
        String constraintID = null;
        String tableID = null;
        String constraintName = null;
        String schemaID = null;
        boolean isEnabled = true;
        int referenceCount = 0;
        if (td != null) {
            ConstraintDescriptor constraint = (ConstraintDescriptor)td;
            UUID oid = constraint.getUUID();
            constraintID = oid.toString();
            oid = constraint.getTableId();
            tableID = oid.toString();
            constraintName = constraint.getConstraintName();
            int constraintIType = constraint.getConstraintType();
            switch (constraintIType) {
                case 2: {
                    constraintSType = "P";
                    break;
                }
                case 3: {
                    constraintSType = "U";
                    break;
                }
                case 4: {
                    constraintSType = "C";
                    break;
                }
                case 6: {
                    constraintSType = "F";
                    break;
                }
                default: {
                    SanityManager.THROWASSERT((String)"invalid constraint type");
                }
            }
            schemaID = constraint.getSchemaDescriptor().getUUID().toString();
            isEnabled = constraint.isEnabled();
            referenceCount = constraint.getReferenceCount();
        }
        ExecRow row = this.getExecutionFactory().getValueRow(7);
        row.setColumn(1, new SQLChar(constraintID));
        row.setColumn(2, new SQLChar(tableID));
        row.setColumn(3, new SQLVarchar(constraintName));
        row.setColumn(4, new SQLChar(constraintSType));
        row.setColumn(5, new SQLChar(schemaID));
        row.setColumn(6, new SQLChar(isEnabled ? "E" : "D"));
        row.setColumn(7, this.dvf.getDataValue(referenceCount));
        return row;
    }

    @Override
    public TupleDescriptor buildDescriptor(ExecRow row, TupleDescriptor parentTupleDescriptor, DataDictionary dd) throws StandardException {
        boolean constraintEnabled;
        ConstraintDescriptor constraintDesc = null;
        SanityManager.ASSERT((row.nColumns() == 7 ? 1 : 0) != 0, (String)"Wrong number of columns for a SYSCONSTRAINTS row");
        TableDescriptor td = null;
        int constraintIType = -1;
        int[] keyColumns = null;
        UUID referencedConstraintId = null;
        if (!(parentTupleDescriptor instanceof SubConstraintDescriptor)) {
            SanityManager.THROWASSERT((String)("parentTupleDescriptor expected to be instanceof SubConstraintDescriptor, not " + parentTupleDescriptor.getClass().getName()));
        }
        SubConstraintDescriptor scd = (SubConstraintDescriptor)parentTupleDescriptor;
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        DataValueDescriptor col = row.getColumn(1);
        String constraintUUIDString = col.getString();
        UUID constraintUUID = this.getUUIDFactory().recreateUUID(constraintUUIDString);
        col = row.getColumn(2);
        String tableUUIDString = col.getString();
        UUID tableUUID = this.getUUIDFactory().recreateUUID(tableUUIDString);
        if (scd != null) {
            td = scd.getTableDescriptor();
        }
        if (td == null) {
            td = dd.getTableDescriptor(tableUUID);
        }
        col = row.getColumn(3);
        String constraintName = col.getString();
        col = row.getColumn(4);
        String constraintSType = col.getString();
        SanityManager.ASSERT((constraintSType.length() == 1 ? 1 : 0) != 0, (String)"Fourth column type incorrect");
        boolean typeSet = false;
        switch (constraintSType.charAt(0)) {
            case 'P': {
                constraintIType = 2;
                typeSet = true;
            }
            case 'U': {
                if (!typeSet) {
                    constraintIType = 3;
                    typeSet = true;
                }
            }
            case 'F': {
                ConglomerateDescriptor conglomDesc;
                if (!typeSet) {
                    constraintIType = 6;
                }
                if (!(parentTupleDescriptor instanceof SubKeyConstraintDescriptor)) {
                    SanityManager.THROWASSERT((String)("parentTupleDescriptor expected to be instanceof SubKeyConstraintDescriptor, not " + parentTupleDescriptor.getClass().getName()));
                }
                if ((conglomDesc = td.getConglomerateDescriptor(((SubKeyConstraintDescriptor)parentTupleDescriptor).getIndexId())) == null) {
                    td = dd.getTableDescriptor(tableUUID);
                    if (scd != null) {
                        scd.setTableDescriptor(td);
                    }
                    conglomDesc = td.getConglomerateDescriptor(((SubKeyConstraintDescriptor)parentTupleDescriptor).getIndexId());
                }
                SanityManager.ASSERT((conglomDesc != null ? 1 : 0) != 0, (String)"conglomDesc is expected to be non-null for backing index");
                keyColumns = conglomDesc.getIndexDescriptor().baseColumnPositions();
                referencedConstraintId = ((SubKeyConstraintDescriptor)parentTupleDescriptor).getKeyConstraintId();
                keyColumns = conglomDesc.getIndexDescriptor().baseColumnPositions();
                break;
            }
            case 'C': {
                constraintIType = 4;
                if (parentTupleDescriptor instanceof SubCheckConstraintDescriptor) break;
                SanityManager.THROWASSERT((String)("parentTupleDescriptor expected to be instanceof SubCheckConstraintDescriptor, not " + parentTupleDescriptor.getClass().getName()));
                break;
            }
            default: {
                SanityManager.THROWASSERT((String)"Fourth column value invalid");
            }
        }
        col = row.getColumn(5);
        String schemaUUIDString = col.getString();
        UUID schemaUUID = this.getUUIDFactory().recreateUUID(schemaUUIDString);
        SchemaDescriptor schema = dd.getSchemaDescriptor(schemaUUID, null);
        col = row.getColumn(6);
        String constraintStateStr = col.getString();
        SanityManager.ASSERT((constraintStateStr.length() == 1 ? 1 : 0) != 0, (String)"Sixth column (state) type incorrect");
        switch (constraintStateStr.charAt(0)) {
            case 'E': {
                constraintEnabled = true;
                break;
            }
            case 'D': {
                constraintEnabled = false;
                break;
            }
            default: {
                constraintEnabled = true;
                SanityManager.THROWASSERT((String)("Invalidate state value '" + constraintStateStr + "' for constraint"));
            }
        }
        col = row.getColumn(7);
        int referenceCount = col.getInt();
        switch (constraintIType) {
            case 2: {
                constraintDesc = ddg.newPrimaryKeyConstraintDescriptor(td, constraintName, false, false, keyColumns, constraintUUID, ((SubKeyConstraintDescriptor)parentTupleDescriptor).getIndexId(), schema, constraintEnabled, referenceCount);
                break;
            }
            case 3: {
                constraintDesc = ddg.newUniqueConstraintDescriptor(td, constraintName, false, false, keyColumns, constraintUUID, ((SubKeyConstraintDescriptor)parentTupleDescriptor).getIndexId(), schema, constraintEnabled, referenceCount);
                break;
            }
            case 6: {
                SanityManager.ASSERT((referenceCount == 0 ? 1 : 0) != 0, (String)"REFERENCECOUNT column is nonzero for fk constraint");
                constraintDesc = ddg.newForeignKeyConstraintDescriptor(td, constraintName, false, false, keyColumns, constraintUUID, ((SubKeyConstraintDescriptor)parentTupleDescriptor).getIndexId(), schema, referencedConstraintId, constraintEnabled, ((SubKeyConstraintDescriptor)parentTupleDescriptor).getRaDeleteRule(), ((SubKeyConstraintDescriptor)parentTupleDescriptor).getRaUpdateRule());
                break;
            }
            case 4: {
                SanityManager.ASSERT((referenceCount == 0 ? 1 : 0) != 0, (String)"REFERENCECOUNT column is nonzero for check constraint");
                constraintDesc = ddg.newCheckConstraintDescriptor(td, constraintName, false, false, constraintUUID, ((SubCheckConstraintDescriptor)parentTupleDescriptor).getConstraintText(), ((SubCheckConstraintDescriptor)parentTupleDescriptor).getReferencedColumnsDescriptor(), schema, constraintEnabled);
            }
        }
        return constraintDesc;
    }

    protected UUID getConstraintId(ExecRow row) throws StandardException {
        DataValueDescriptor col = row.getColumn(1);
        String constraintUUIDString = col.getString();
        return this.getUUIDFactory().recreateUUID(constraintUUIDString);
    }

    protected String getConstraintName(ExecRow row) throws StandardException {
        DataValueDescriptor col = row.getColumn(3);
        String constraintName = col.getString();
        return constraintName;
    }

    protected UUID getSchemaId(ExecRow row) throws StandardException {
        DataValueDescriptor col = row.getColumn(5);
        String schemaUUIDString = col.getString();
        return this.getUUIDFactory().recreateUUID(schemaUUIDString);
    }

    protected UUID getTableId(ExecRow row) throws StandardException {
        DataValueDescriptor col = row.getColumn(2);
        String tableUUIDString = col.getString();
        return this.getUUIDFactory().recreateUUID(tableUUIDString);
    }

    protected int getConstraintType(ExecRow row) throws StandardException {
        int constraintIType;
        DataValueDescriptor col = row.getColumn(4);
        String constraintSType = col.getString();
        SanityManager.ASSERT((constraintSType.length() == 1 ? 1 : 0) != 0, (String)"Fourth column type incorrect");
        switch (constraintSType.charAt(0)) {
            case 'P': {
                constraintIType = 2;
                break;
            }
            case 'U': {
                constraintIType = 3;
                break;
            }
            case 'C': {
                constraintIType = 4;
                break;
            }
            case 'F': {
                constraintIType = 6;
                break;
            }
            default: {
                SanityManager.THROWASSERT((String)"Fourth column value invalid");
                constraintIType = -1;
            }
        }
        return constraintIType;
    }

    @Override
    public SystemColumn[] buildColumnList() {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("CONSTRAINTID", false), SystemColumnImpl.getUUIDColumn("TABLEID", false), SystemColumnImpl.getIdentifierColumn("CONSTRAINTNAME", false), SystemColumnImpl.getIndicatorColumn("TYPE"), SystemColumnImpl.getUUIDColumn("SCHEMAID", false), SystemColumnImpl.getIndicatorColumn("STATE"), SystemColumnImpl.getColumn("REFERENCECOUNT", 4, false)};
    }
}

