/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.services.bytecode;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.cache.CacheFactory;
import com.pivotal.gemfirexd.internal.iapi.services.cache.CacheManager;
import com.pivotal.gemfirexd.internal.iapi.services.cache.Cacheable;
import com.pivotal.gemfirexd.internal.iapi.services.cache.CacheableFactory;
import com.pivotal.gemfirexd.internal.iapi.services.classfile.ClassHolder;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.ClassBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.JavaFactory;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactory;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleControl;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.impl.services.bytecode.BCClass;
import com.pivotal.gemfirexd.internal.impl.services.bytecode.BCMethodDescriptor;
import com.pivotal.gemfirexd.internal.impl.services.bytecode.Type;
import com.pivotal.gemfirexd.internal.impl.services.bytecode.VMTypeIdCacheable;
import java.util.Properties;

public class BCJava
implements JavaFactory,
CacheableFactory,
ModuleControl {
    private CacheManager vmTypeIdCache;

    @Override
    public void boot(boolean create, Properties properties) throws StandardException {
        CacheFactory cf = (CacheFactory)Monitor.startSystemModule("com.pivotal.gemfirexd.internal.iapi.services.cache.CacheFactory");
        this.vmTypeIdCache = cf.newCacheManager(this, "VMTypeIdCache", 64, 256);
    }

    @Override
    public void stop() {
    }

    @Override
    public ClassBuilder newClassBuilder(ClassFactory cf, String packageName, int modifiers, String className, String superClass) {
        return new BCClass(cf, packageName, modifiers, className, superClass, this);
    }

    @Override
    public Cacheable newCacheable(CacheManager cm) {
        return new VMTypeIdCacheable();
    }

    Type type(String javaType) {
        try {
            VMTypeIdCacheable vtic = (VMTypeIdCacheable)this.vmTypeIdCache.find(javaType);
            Type retval = (Type)vtic.descriptor();
            this.vmTypeIdCache.release(vtic);
            return retval;
        }
        catch (StandardException se) {
            SanityManager.THROWASSERT((String)"Unexpected exception", (Throwable)se);
            Type retval = new Type(javaType, ClassHolder.convertToInternalDescriptor(javaType));
            return retval;
        }
    }

    String vmType(BCMethodDescriptor md) {
        String retval;
        try {
            VMTypeIdCacheable vtic = (VMTypeIdCacheable)this.vmTypeIdCache.find(md);
            retval = vtic.descriptor().toString();
            this.vmTypeIdCache.release(vtic);
        }
        catch (StandardException se) {
            SanityManager.THROWASSERT((String)"Unexpected exception", (Throwable)se);
            retval = md.buildMethodDescriptor();
        }
        return retval;
    }

    static short vmTypeId(String vmTypeS) {
        char vmTypeC = vmTypeS.charAt(0);
        switch (vmTypeC) {
            case 'L': {
                return 7;
            }
            case 'B': {
                return 0;
            }
            case 'C': {
                return 6;
            }
            case 'D': {
                return 5;
            }
            case 'F': {
                return 4;
            }
            case 'I': {
                return 2;
            }
            case 'J': {
                return 3;
            }
            case 'S': {
                return 1;
            }
            case 'Z': {
                return 2;
            }
            case '[': {
                return 7;
            }
            case 'V': {
                return -1;
            }
        }
        SanityManager.THROWASSERT((String)("No type match for " + vmTypeS));
        return -1;
    }
}

