/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.jdbc;

import com.gemstone.gemfire.GemFireException;
import com.gemstone.gnu.trove.THashMap;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.execute.SnappyActivation;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.jdbc.BrokeredConnectionControl;
import com.pivotal.gemfirexd.internal.iapi.jdbc.EngineParameterMetaData;
import com.pivotal.gemfirexd.internal.iapi.jdbc.EnginePreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ParameterValueSet;
import com.pivotal.gemfirexd.internal.iapi.sql.PreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultDescription;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecPreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RawToBinaryFormatStream;
import com.pivotal.gemfirexd.internal.iapi.types.ReaderToUTF8Stream;
import com.pivotal.gemfirexd.internal.iapi.types.VariableSizeDataValue;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedParameterSetMetaData;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSet;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSetMetaData;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import com.pivotal.gemfirexd.internal.impl.jdbc.TransactionResourceImpl;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.impl.sql.GenericActivationHolder;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import com.pivotal.gemfirexd.internal.shared.common.SingleHopInformation;
import io.snappydata.thrift.common.BufferedBlob;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;

public abstract class EmbedPreparedStatement
extends EmbedStatement
implements EnginePreparedStatement {
    protected ResultSetMetaData rMetaData;
    private String gcDuringGetMetaData;
    protected PreparedStatement preparedStatement;
    private BrokeredConnectionControl bcc = null;

    @Override
    protected FinalizePreparedStatement newFinalizer(EmbedStatement ps) {
        return new FinalizePreparedStatement(ps);
    }

    public EmbedPreparedStatement(EmbedConnection conn, String sql, boolean forMetaData, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int autoGeneratedKeys, int[] columnIndexes, String[] columnNames, long id, short execFlags, THashMap ncjMetaData, long rootID, int stmtLevel) throws SQLException {
        super(conn, forMetaData, resultSetType, resultSetConcurrency, resultSetHoldability, id, rootID, stmtLevel);
        this.isPoolable = true;
        if (sql == null) {
            throw this.newSQLException("XJ067.S");
        }
        this.SQLText = sql;
        if (resultSetConcurrency == 1007) {
            execFlags = GemFireXDUtils.set(execFlags, (short)1);
        }
        execFlags = GemFireXDUtils.set(execFlags, (short)16);
        if (this.lcc.getQueryHDFS()) {
            execFlags = GemFireXDUtils.set(execFlags, (short)256, true);
        }
        if (this.routeQueryEnabled(null)) {
            execFlags = GemFireXDUtils.set(execFlags, (short)1024, true);
        }
        try {
            this.preparedStatement = this.lcc.prepareInternalStatement(this.lcc.getDefaultSchema(), sql, forMetaData, execFlags, null, ncjMetaData);
            this.addWarning(this.preparedStatement.getCompileTimeWarnings());
            this.activation = this.preparedStatement.getActivation(this.lcc, resultSetType == 1004, null);
            this.activation.setIsPrepStmntQuery(true);
            this.activation.setStatementID(this.statementID);
            this.activation.setRootID(this.rootID);
            this.activation.setStatementLevel(this.statementLevel);
            this.checkRequiresCallableStatement(this.activation);
            this.stats = this.lcc.statsEnabled() ? this.preparedStatement.getStatementStats() : null;
            ((FinalizePreparedStatement)this.finalizer).activation = this.activation;
            if (autoGeneratedKeys == 1) {
                this.activation.setAutoGeneratedKeysResultsetInfo(columnIndexes, columnNames);
            }
        }
        catch (Throwable t) {
            throw this.handleException(t);
        }
    }

    @Override
    public Activation getActivation() {
        return this.activation;
    }

    @Override
    public final boolean execute(String sql) throws SQLException {
        throw this.newSQLException("XJ016.S", "execute(String)");
    }

    @Override
    public final boolean execute(String sql, int autoGenKeys) throws SQLException {
        throw this.newSQLException("XJ016.S", "execute(String, int)");
    }

    @Override
    public final boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw this.newSQLException("XJ016.S", "execute(String, int[])");
    }

    @Override
    public final boolean execute(String sql, String[] columnNames) throws SQLException {
        throw this.newSQLException("XJ016.S", "execute(String, String[])");
    }

    @Override
    public final java.sql.ResultSet executeQuery(String sql) throws SQLException {
        throw this.newSQLException("XJ016.S", "executeQuery(String)");
    }

    @Override
    public final int executeUpdate(String sql) throws SQLException {
        throw this.newSQLException("XJ016.S", "executeUpdate(String)");
    }

    @Override
    public final int executeUpdate(String sql, int autoGenKeys) throws SQLException {
        throw this.newSQLException("XJ016.S", "executeUpdate(String, int)");
    }

    @Override
    public final int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw this.newSQLException("XJ016.S", "executeUpdate(String, int[])");
    }

    @Override
    public final int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw this.newSQLException("XJ016.S", "executeUpdate(String, String[])");
    }

    @Override
    public final void addBatch(String sql) throws SQLException {
        throw this.newSQLException("XJ016.S", "addBatch(String)");
    }

    @Override
    void closeActions() throws SQLException {
        if (this.bcc != null) {
            java.sql.PreparedStatement ps_app = (java.sql.PreparedStatement)((Object)this.applicationStatement);
            this.bcc.onStatementClose(ps_app);
        }
        this.preparedStatement = null;
        try {
            this.setupContextStack(false);
        }
        catch (SQLException se) {
            return;
        }
        try {
            if (this.activation != null) {
                this.activation.close();
                this.executeDistributedClose();
                this.activation = null;
            }
        }
        catch (Throwable t) {
            throw this.handleException(t);
        }
        finally {
            this.restoreContextStack();
        }
    }

    @Override
    public final java.sql.ResultSet executeQuery() throws SQLException {
        try {
            this.executeStatement(this.activation, true, false, false);
        }
        catch (SQLException sqle) {
            this.checkStatementValidity(sqle);
        }
        if (this.results == null) {
            SanityManager.THROWASSERT((String)"no results returned on executeQuery()");
        }
        return this.results;
    }

    public final java.sql.ResultSet executeQueryByPassQueryInfo() throws SQLException {
        try {
            this.executeStatement(this.activation, true, false, true);
        }
        catch (SQLException sqle) {
            this.checkStatementValidity(sqle);
        }
        if (this.results == null) {
            SanityManager.THROWASSERT((String)"no results returned on executeQueryByPassQueryInfo()");
        }
        return this.results;
    }

    @Override
    public int getStatementType() {
        return ((GenericPreparedStatement)this.preparedStatement).getStatementType();
    }

    public DataTypeDescriptor[] getParameterTypes() {
        return this.preparedStatement.getParameterTypes();
    }

    @Override
    public final int executeUpdate() throws SQLException {
        try {
            this.executeStatement(this.activation, false, true, false);
        }
        catch (SQLException sqle) {
            this.checkStatementValidity(sqle);
        }
        return this.updateCount;
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkForSupportedDataType(sqlType);
        this.checkStatus();
        int jdbcTypeId = this.getParameterJDBCType(parameterIndex);
        if (sqlType == 0) {
            sqlType = jdbcTypeId;
        } else if (!DataTypeDescriptor.isJDBCTypeEquivalent(jdbcTypeId, sqlType)) {
            throw this.dataTypeConversion(parameterIndex, Util.typeName(sqlType));
        }
        try {
            this.getParms().getParameterForSet(parameterIndex - 1).setToNull();
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t, "parameter index " + parameterIndex);
        }
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(parameterIndex - 1).setValue(x);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t, "parameter index " + parameterIndex);
        }
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(parameterIndex - 1).setValue(x);
        }
        catch (Throwable t) {
            throw EmbedResultSet.noStateChangeException(t, "parameter index " + parameterIndex);
        }
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(parameterIndex - 1).setValue(x);
        }
        catch (Throwable t) {
            throw EmbedResultSet.noStateChangeException(t, "parameter index " + parameterIndex);
        }
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(parameterIndex - 1).setValue(x);
        }
        catch (Throwable t) {
            throw EmbedResultSet.noStateChangeException(t, "parameter index " + parameterIndex);
        }
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(parameterIndex - 1).setValue(x);
        }
        catch (Throwable t) {
            throw EmbedResultSet.noStateChangeException(t, "parameter index " + parameterIndex);
        }
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(parameterIndex - 1).setValue(x);
        }
        catch (Throwable t) {
            throw EmbedResultSet.noStateChangeException(t, "parameter index " + parameterIndex);
        }
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(parameterIndex - 1).setValue(x);
        }
        catch (Throwable t) {
            throw EmbedResultSet.noStateChangeException(t, "parameter index " + parameterIndex);
        }
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(parameterIndex - 1).setValue(x);
        }
        catch (Throwable t) {
            throw EmbedResultSet.noStateChangeException(t, "parameter index " + parameterIndex);
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(parameterIndex - 1).setValue(x);
        }
        catch (Throwable t) {
            throw EmbedResultSet.noStateChangeException(t, "parameter index " + parameterIndex);
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setDate(parameterIndex, x, this.getCal());
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setTime(parameterIndex, x, this.getCal());
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setTimestamp(parameterIndex, x, this.getCal());
    }

    @Override
    public final void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.checkAsciiStreamConditions(parameterIndex);
        InputStreamReader r = null;
        if (x != null) {
            try {
                r = new InputStreamReader(x, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException uee) {
                throw new SQLException(uee.getMessage());
            }
        }
        this.setCharacterStreamInternal(parameterIndex, r, false, length);
    }

    @Override
    public final void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setAsciiStream(parameterIndex, x, (long)length);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw Util.notImplemented("setUnicodeStream");
    }

    @Override
    public final void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkCharacterStreamConditions(parameterIndex);
        this.setCharacterStreamInternal(parameterIndex, reader, false, length);
    }

    @Override
    public final void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, (long)length);
    }

    private final void checkCharacterStreamConditions(int parameterIndex) throws SQLException {
        this.checkStatus();
        int jdbcTypeId = this.getParameterJDBCType(parameterIndex);
        if (!DataTypeDescriptor.isCharacterStreamAssignable(jdbcTypeId)) {
            throw this.dataTypeConversion(parameterIndex, "java.io.Reader");
        }
    }

    private final void checkAsciiStreamConditions(int parameterIndex) throws SQLException {
        this.checkStatus();
        int jdbcTypeId = this.getParameterJDBCType(parameterIndex);
        if (!DataTypeDescriptor.isAsciiStreamAssignable(jdbcTypeId)) {
            throw this.dataTypeConversion(parameterIndex, "java.io.InputStream(ASCII)");
        }
    }

    private void setCharacterStreamInternal(int parameterIndex, Reader reader, boolean lengthLess, long length) throws SQLException {
        if (!lengthLess && length < 0L) {
            throw this.newSQLException("XJ025.S");
        }
        int jdbcTypeId = this.getParameterJDBCType(parameterIndex);
        if (reader == null) {
            this.setNull(parameterIndex, jdbcTypeId);
            return;
        }
        if (!lengthLess && length > Integer.MAX_VALUE) {
            throw this.newSQLException("22003", this.getParameterSQLType(parameterIndex), parameterIndex);
        }
        try {
            ReaderToUTF8Stream utfIn;
            int colWidth;
            ParameterValueSet pvs = this.getParms();
            DataTypeDescriptor[] dtd = this.preparedStatement.getParameterTypes();
            int usableLength = colWidth = dtd[parameterIndex - 1].getMaximumWidth();
            if (!lengthLess) {
                int intLength = (int)length;
                int truncationLength = 0;
                usableLength = intLength;
                if (jdbcTypeId == 2005 && intLength > colWidth) {
                    usableLength = colWidth;
                    truncationLength = intLength - usableLength;
                }
                utfIn = new ReaderToUTF8Stream(reader, usableLength, truncationLength, this.getParameterSQLType(parameterIndex));
            } else {
                utfIn = new ReaderToUTF8Stream(reader, colWidth, this.getParameterSQLType(parameterIndex));
            }
            pvs.getParameterForSet(parameterIndex - 1).setValue(utfIn, usableLength);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t, "parameter index " + parameterIndex);
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.checkBinaryStreamConditions(parameterIndex);
        this.setBinaryStreamInternal(parameterIndex, x, true, -1L);
    }

    @Override
    public final void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.checkBinaryStreamConditions(parameterIndex);
        this.setBinaryStreamInternal(parameterIndex, x, false, length);
    }

    @Override
    public final void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, (long)length);
    }

    private void setBinaryStreamInternal(int parameterIndex, InputStream x, boolean lengthLess, long length) throws SQLException {
        if (!lengthLess && length < 0L) {
            throw this.newSQLException("XJ025.S");
        }
        int jdbcTypeId = this.getParameterJDBCType(parameterIndex);
        if (x == null) {
            this.setNull(parameterIndex, jdbcTypeId);
            return;
        }
        if (!lengthLess && length > Integer.MAX_VALUE) {
            throw this.newSQLException("22003", this.getEmbedParameterSetMetaData().getParameterTypeName(parameterIndex), parameterIndex);
        }
        try {
            RawToBinaryFormatStream rawStream;
            if (lengthLess) {
                length = -1L;
                DataTypeDescriptor[] dtd = this.preparedStatement.getParameterTypes();
                rawStream = new RawToBinaryFormatStream(x, dtd[parameterIndex - 1].getMaximumWidth(), dtd[parameterIndex - 1].getTypeName());
            } else {
                rawStream = new RawToBinaryFormatStream(x, (int)length);
            }
            this.getParms().getParameterForSet(parameterIndex - 1).setValue(rawStream, (int)length);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t, "parameter index " + parameterIndex);
        }
    }

    private final void checkBinaryStreamConditions(int parameterIndex) throws SQLException {
        this.checkStatus();
        int jdbcTypeId = this.getParameterJDBCType(parameterIndex);
        if (!DataTypeDescriptor.isBinaryStreamAssignable(jdbcTypeId)) {
            throw this.dataTypeConversion(parameterIndex, "java.io.InputStream");
        }
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(paramIndex, sqlType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch() throws SQLException {
        this.checkStatus();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            if (this.batchStatements == null) {
                this.batchStatements = new ArrayList();
            }
            try {
                if (this.executeBatchInProgress == 0) {
                    this.batchStatements.add(this.getParms().getClone());
                } else {
                    ParameterValueSet temp = this.getParms();
                    int numberOfParameters = temp.getParameterCount();
                    if (this.batchStatementCurrentIndex < this.batchStatements.size()) {
                        for (int j = 0; j < numberOfParameters; ++j) {
                            ((ParameterValueSet)this.batchStatements.get(this.batchStatementCurrentIndex)).getParameter(j).setValue(temp.getParameter(j));
                        }
                    } else {
                        this.batchStatements.add(this.getParms().getClone());
                    }
                }
                ++this.batchStatementCurrentIndex;
            }
            catch (Throwable t) {
                throw TransactionResourceImpl.wrapInSQLException(t);
            }
            this.clearParameters();
        }
    }

    @Override
    boolean executeBatchElement(Object batchElement) throws SQLException, StandardException {
        ParameterValueSet temp = (ParameterValueSet)batchElement;
        int numberOfParameters = temp.getParameterCount();
        for (int j = 0; j < numberOfParameters; ++j) {
            temp.getParameter(j).setInto(this, j + 1);
        }
        return super.executeStatement(this.activation, false, true, ((GenericPreparedStatement)this.preparedStatement).createQueryInfo(), false, false, true);
    }

    @Override
    protected void postBatchExecution() throws StandardException, SQLException {
        ResultSet rs = this.activation.getResultSet();
        if (rs != null) {
            GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
            if (observer != null) {
                observer.beforeFlushBatch(rs, this.lcc);
            }
            try {
                rs.flushBatch();
            }
            finally {
                rs.closeBatch();
                this.resetBatch();
            }
            if (observer != null) {
                observer.afterFlushBatch(rs, this.lcc);
            }
            if (rs.hasAutoGeneratedKeysResultSet()) {
                ResultSet autoRS = rs.getAutoGeneratedKeysResultset();
                autoRS.open();
                this.autoGeneratedKeysResultSet = this.factory.newEmbedResultSet(this.getEmbedConnection(), autoRS, false, this, this.activation.getPreparedStatement().isAtomic());
            }
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        ParameterValueSet pvs2;
        ParameterValueSet pvs = this.getParms();
        if (pvs != null) {
            pvs.clearParameters();
        }
        if (pvs != (pvs2 = this.pvs) && pvs2 != null) {
            pvs2.clearParameters();
        }
        this.checkStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkExecStatus();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            ExecPreparedStatement execp = (ExecPreparedStatement)this.preparedStatement;
            PreparedStatement preparedStatement = this.preparedStatement;
            synchronized (preparedStatement) {
                try {
                    if (!this.preparedStatement.upToDate()) {
                        while (((GenericPreparedStatement)this.preparedStatement).compilingStatement()) {
                            this.preparedStatement.wait();
                        }
                    }
                }
                catch (StandardException e) {
                    if (SanityManager.TraceSingleHop) {
                        SanityManager.DEBUG_PRINT((String)"TraceSingleHop", (String)("EmbedPreparedStatement::getMetaData got standard exception: " + e), (Throwable)e);
                    }
                    throw Util.generateCsSQLException(e);
                }
                catch (InterruptedException e) {
                    if (SanityManager.TraceSingleHop) {
                        SanityManager.DEBUG_PRINT((String)"TraceSingleHop", (String)("EmbedPreparedStatement::getMetaData got interrupted exception: " + e), (Throwable)e);
                    }
                    try {
                        Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress((Throwable)e);
                    }
                    catch (GemFireException ge) {
                        throw Util.generateCsSQLException(Misc.processGemFireException(ge, ge, "getMetadata", true));
                    }
                    throw Util.javaException(e);
                }
                this.setupContextStack(true);
                try {
                    if (!this.preparedStatement.isValid()) {
                        this.preparedStatement.rePrepare(this.lcc, this.getActivation());
                        this.rMetaData = null;
                    }
                    if (SanityManager.TraceSingleHop) {
                        SanityManager.DEBUG_PRINT((String)"TraceSingleHop", (String)("EmbedPreparedStatement::getMetaData execp is: " + execp + " and source is: " + execp.getStatement().getQueryStringForParse(this.lcc)));
                    }
                    if (SanityManager.TraceSingleHop) {
                        SanityManager.DEBUG_PRINT((String)"TraceSingleHop", (String)("EmbedPreparedStatement::getMetaData_ONE  gcDuringGetMetaData: " + this.gcDuringGetMetaData + ", excep: " + execp + " ac: " + (execp.getActivationClass() == null ? null : execp.getActivationClass()) + " acname: " + execp.getActivationClass().getName() + " source is: " + execp.getStatement().getSource()));
                    }
                    if (this.gcDuringGetMetaData == null || !this.gcDuringGetMetaData.equals(execp.getActivationClass().getName())) {
                        this.rMetaData = null;
                        if (SanityManager.TraceSingleHop) {
                            SanityManager.DEBUG_PRINT((String)"TraceSingleHop", (String)("EmbedPreparedStatement::getMetaData_TWO  gcDuringGetMetaData: " + this.gcDuringGetMetaData + ", excep: " + execp + " ac: " + (execp.getActivationClass() == null ? null : execp.getActivationClass()) + " acname: " + execp.getActivationClass().getName() + " statement is: " + execp.getStatement()));
                        }
                        this.gcDuringGetMetaData = execp.getActivationClass().getName();
                    }
                    Activation a = null;
                    if (this.getActivation() != null) {
                        if (this.getActivation() instanceof GenericActivationHolder) {
                            a = ((GenericActivationHolder)this.getActivation()).getActivation();
                        } else if (this.getActivation() instanceof Activation) {
                            a = this.getActivation();
                        }
                    }
                    if (this.rMetaData == null && !(a instanceof SnappyActivation)) {
                        Activation act = null;
                        if (this.getActivation() != null) {
                            if (this.getActivation() instanceof GenericActivationHolder) {
                                act = ((GenericActivationHolder)this.getActivation()).getActivation();
                            } else if (this.getActivation() instanceof Activation) {
                                act = this.getActivation();
                            }
                        }
                        if (act instanceof SnappyActivation) {
                            this.rMetaData = null;
                        } else {
                            ResultDescription resd = this.preparedStatement.getResultDescription();
                            if (resd != null) {
                                String statementType = resd.getStatementType();
                                this.rMetaData = statementType.equals("INSERT") || statementType.equals("UPDATE") || statementType.equals("DELETE") ? null : this.newEmbedResultSetMetaData(resd);
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    throw this.handleException(t);
                }
                finally {
                    this.restoreContextStack();
                }
            }
        }
        return this.rMetaData;
    }

    @Override
    public final void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, targetSqlType);
            return;
        }
        this.checkForSupportedDataType(targetSqlType);
        int paramJDBCType = this.getParameterJDBCType(parameterIndex);
        if (paramJDBCType != 2000 && !DataTypeDescriptor.isJDBCTypeEquivalent(paramJDBCType, targetSqlType)) {
            throw this.dataTypeConversion(parameterIndex, Util.typeName(targetSqlType));
        }
        this.setObject(parameterIndex, x);
        if (paramJDBCType == 3 || paramJDBCType == 2) {
            this.setScale(parameterIndex, scale);
        }
    }

    @Override
    public final void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType, 0);
    }

    @Override
    public final void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkStatus();
        int colType = this.getParameterJDBCType(parameterIndex);
        if (x == null) {
            this.setNull(parameterIndex, colType);
            return;
        }
        if (colType == 2000) {
            try {
                this.getParms().setParameterAsObject(parameterIndex - 1, x);
                return;
            }
            catch (Throwable t) {
                throw EmbedResultSet.noStateChangeException(t, "parameter index " + parameterIndex);
            }
        }
        if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
            return;
        }
        if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)x);
            return;
        }
        if (x instanceof Byte) {
            this.setByte(parameterIndex, (Byte)x);
            return;
        }
        if (x instanceof Short) {
            this.setShort(parameterIndex, (Short)x);
            return;
        }
        if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
            return;
        }
        if (x instanceof Long) {
            this.setLong(parameterIndex, (Long)x);
            return;
        }
        if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
            return;
        }
        if (x instanceof Double) {
            this.setDouble(parameterIndex, (Double)x);
            return;
        }
        if (x instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])x);
            return;
        }
        if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
            return;
        }
        if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
            return;
        }
        if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
            return;
        }
        if (x instanceof Blob) {
            this.setBlob(parameterIndex, (Blob)x);
            return;
        }
        if (x instanceof Clob) {
            this.setClob(parameterIndex, (Clob)x);
            return;
        }
        if (this.setObjectConvert(parameterIndex, x)) {
            return;
        }
        throw this.dataTypeConversion(parameterIndex, x.getClass().getName());
    }

    boolean setObjectConvert(int parameterIndex, Object x) throws SQLException {
        return false;
    }

    @Override
    public final boolean execute() throws SQLException {
        boolean ret = false;
        try {
            ret = this.executeStatement(this.activation, false, false, false);
        }
        catch (SQLException sqle) {
            this.checkStatementValidity(sqle);
        }
        return ret;
    }

    @Override
    public final void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(parameterIndex - 1).setValue(x, cal);
        }
        catch (Throwable t) {
            throw EmbedResultSet.noStateChangeException(t, "parameter index " + parameterIndex);
        }
    }

    @Override
    public final void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(parameterIndex - 1).setValue(x, cal);
        }
        catch (Throwable t) {
            throw EmbedResultSet.noStateChangeException(t, "parameter index " + parameterIndex);
        }
    }

    @Override
    public final void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(parameterIndex - 1).setValue(x, cal);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t, "parameter index " + parameterIndex);
        }
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        this.checkBlobConditions(i);
        if (x == null) {
            this.setNull(i, 2004);
        } else {
            if (x instanceof BufferedBlob) {
                try {
                    this.getParms().getParameterForSet(i - 1).setValue(x);
                    return;
                }
                catch (StandardException t) {
                    throw EmbedResultSet.noStateChangeException(t, "parameter index " + i);
                }
            }
            long streamLength = x.length();
            this.setBinaryStreamInternal(i, x.getBinaryStream(), false, streamLength);
        }
    }

    private final void checkClobConditions(int parameterIndex) throws SQLException {
        this.checkStatus();
        int colType = this.getParameterJDBCType(parameterIndex);
        switch (colType) {
            case 2005: 
            case 4002: {
                break;
            }
            default: {
                throw this.dataTypeConversion(parameterIndex, "java.sql.Clob");
            }
        }
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        this.checkClobConditions(i);
        if (x == null) {
            this.setNull(i, 2005);
        } else {
            long streamLength = x.length();
            this.setCharacterStreamInternal(i, x.getCharacterStream(), false, streamLength);
        }
    }

    public final ParameterValueSet getParms() {
        return this.activation.getParameterValueSet();
    }

    protected final DataTypeDescriptor[] getTypes(int parameterIndex) throws SQLException {
        DataTypeDescriptor[] types = this.preparedStatement.getParameterTypes();
        if (types == null) {
            throw this.newSQLException("07009");
        }
        if (parameterIndex < 1 || parameterIndex > types.length) {
            throw this.newSQLException("XCL13.S", new Integer(parameterIndex), new Integer(types.length));
        }
        return types;
    }

    protected int getParameterJDBCType(int parameterIndex) throws SQLException {
        DataTypeDescriptor[] types = this.getTypes(parameterIndex);
        int type = types[parameterIndex - 1] == null ? 1111 : types[parameterIndex - 1].getTypeId().getJDBCTypeId();
        return type;
    }

    protected final String getParameterSQLType(int parameterIndex) throws SQLException {
        DataTypeDescriptor[] pTypes = this.getTypes(parameterIndex);
        return pTypes[parameterIndex - 1].getTypeName();
    }

    private void setScale(int parameterIndex, int scale) throws SQLException {
        this.checkStatus();
        if (scale < 0) {
            throw this.newSQLException("XJ044.S", new Integer(scale));
        }
        try {
            ParameterValueSet pvs = this.getParms();
            DataValueDescriptor value = pvs.getParameter(parameterIndex - 1);
            int origvaluelen = value.getLength();
            ((VariableSizeDataValue)((Object)value)).setWidth(-1, scale, false);
            if (value.getLength() < origvaluelen) {
                this.activation.addWarning(StandardException.newWarning("01505", value.getString()));
            }
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t, "parameter index " + parameterIndex);
        }
    }

    private EngineParameterMetaData getEmbedParameterSetMetaData() throws SQLException {
        this.checkExecStatus();
        return new EmbedParameterSetMetaData(this.getParms(), this.preparedStatement.getParameterTypes());
    }

    @Override
    public final void setURL(int parameterIndex, URL x) throws SQLException {
        throw Util.notImplemented();
    }

    protected EmbedResultSetMetaData newEmbedResultSetMetaData(ResultDescription resultDesc) {
        return this.factory.newEmbedResultSetMetaData(resultDesc.getColumnInfo());
    }

    @Override
    public String toString() {
        if (this.activation != null) {
            return this.getClass().getSimpleName() + '@' + Integer.toHexString(System.identityHashCode(this)) + ", " + this.activation.getPreparedStatement().getSource() + ", UUIDString: " + this.activation.getPreparedStatement().getObjectName();
        }
        return super.toString();
    }

    public void transferParameters(EmbedPreparedStatement newStatement) throws SQLException {
        try {
            newStatement.activation.setParameters(this.getParms(), this.preparedStatement.getParameterTypes());
        }
        catch (StandardException se) {
            throw EmbedResultSet.noStateChangeException(se, null);
        }
    }

    boolean executeStatement(Activation a, boolean executeQuery, boolean executeUpdate, boolean skipContextRestore) throws SQLException {
        this.checkExecStatus();
        this.checkIfInMiddleOfBatch();
        this.clearResultSets();
        return super.executeStatement(a, executeQuery, executeUpdate, ((GenericPreparedStatement)this.preparedStatement).createQueryInfo(), false, skipContextRestore, false);
    }

    final SQLException dataTypeConversion(int column, String sourceType) throws SQLException {
        return Util.generateCsSQLException("22005", this.getEmbedParameterSetMetaData().getParameterTypeName(column), sourceType, column);
    }

    public void setBrokeredConnectionControl(BrokeredConnectionControl control) {
        this.bcc = control;
    }

    private void executeDistributedClose() {
        this.activation.distributeClose();
    }

    private void checkStatementValidity(SQLException sqle) throws SQLException {
        if (this.bcc != null && this.isClosed()) {
            this.bcc.onStatementErrorOccurred((java.sql.PreparedStatement)((Object)this.applicationStatement), sqle);
        }
        throw sqle;
    }

    private void checkForSupportedDataType(int dataType) throws SQLException {
        switch (dataType) {
            case -16: 
            case -15: 
            case -9: 
            case -8: 
            case 70: 
            case 2002: 
            case 2003: 
            case 2006: 
            case 2009: 
            case 2011: {
                throw this.newSQLException("0A000.S.7", Util.typeName(dataType));
            }
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.checkAsciiStreamConditions(parameterIndex);
        InputStreamReader asciiStream = null;
        if (x != null) {
            try {
                asciiStream = new InputStreamReader(x, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException uee) {
                throw new SQLException(uee.getMessage());
            }
        }
        this.setCharacterStreamInternal(parameterIndex, asciiStream, true, -1L);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.checkCharacterStreamConditions(parameterIndex);
        this.setCharacterStreamInternal(parameterIndex, reader, true, -1L);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.checkClobConditions(parameterIndex);
        this.setCharacterStreamInternal(parameterIndex, reader, true, -1L);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkClobConditions(parameterIndex);
        this.setCharacterStreamInternal(parameterIndex, reader, false, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.checkBlobConditions(parameterIndex);
        this.setBinaryStreamInternal(parameterIndex, inputStream, true, -1L);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.checkBlobConditions(parameterIndex);
        this.setBinaryStreamInternal(parameterIndex, inputStream, false, length);
    }

    private final void checkBlobConditions(int parameterIndex) throws SQLException {
        this.checkStatus();
        if (this.getParameterJDBCType(parameterIndex) != 2004) {
            throw this.dataTypeConversion(parameterIndex, "java.sql.Blob");
        }
    }

    @Override
    public final long getVersionCounter() throws SQLException {
        return this.preparedStatement.getVersionCounter();
    }

    @Override
    public boolean isPrepared() {
        return true;
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new AssertionError((Object)"should have been overridden in JDBC 4.0");
    }

    @Override
    public void setNString(int index, String value) throws SQLException {
        throw new AssertionError((Object)"should have been overridden in JDBC 4.0");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new AssertionError((Object)"should have been overridden in JDBC 4.0");
    }

    @Override
    public void setNCharacterStream(int index, Reader value, long length) throws SQLException {
        throw new AssertionError((Object)"should have been overridden in JDBC 4.0");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new AssertionError((Object)"should have been overridden in JDBC 4.0");
    }

    @Override
    public void setNClob(int index, NClob value) throws SQLException {
        throw new AssertionError((Object)"should have been overridden in JDBC 4.0");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new AssertionError((Object)"should have been overridden in JDBC 4.0");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new AssertionError((Object)"should have been overridden in JDBC 4.0");
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new AssertionError((Object)"should have been overridden in JDBC 4.0");
    }

    @Override
    public boolean isWrapperFor(Class<?> interfaces) throws SQLException {
        throw new AssertionError((Object)"should have been overridden in JDBC 4.0");
    }

    @Override
    public <T> T unwrap(Class<T> interfaces) throws SQLException {
        throw new AssertionError((Object)"should have been overridden in JDBC 4.0");
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new AssertionError((Object)"should have been overridden in JDBC 4.1");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new AssertionError((Object)"should have been overridden in JDBC 4.1");
    }

    public SingleHopInformation fillAndGetSingleHopInformation() {
        if (this.preparedStatement != null && this.preparedStatement instanceof GenericPreparedStatement) {
            return ((GenericPreparedStatement)this.preparedStatement).fillAndGetSingleHopInformation();
        }
        return null;
    }

    public GenericPreparedStatement getGPS() {
        if (this.preparedStatement != null && this.preparedStatement instanceof GenericPreparedStatement) {
            return (GenericPreparedStatement)this.preparedStatement;
        }
        return null;
    }

    protected static final class FinalizePreparedStatement
    extends EmbedStatement.FinalizeStatement {
        private Activation activation;

        public FinalizePreparedStatement(EmbedStatement ps) {
            super(ps);
        }

        @Override
        protected void clearThis() {
            this.activation = null;
        }

        @Override
        protected final boolean doFinalize() {
            super.doFinalize();
            Activation act = this.activation;
            if (act != null) {
                act.markUnused();
                this.activation = null;
            }
            return true;
        }
    }
}

