/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.drda;

import com.pivotal.gemfirexd.internal.engine.stats.ConnectionStats;
import com.pivotal.gemfirexd.internal.iapi.services.io.DynamicByteArrayOutputStream;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.impl.drda.CcsidManager;
import com.pivotal.gemfirexd.internal.impl.drda.DRDAConnThread;
import com.pivotal.gemfirexd.internal.impl.drda.DRDAProtocolException;
import com.pivotal.gemfirexd.internal.impl.drda.DRDAString;
import com.pivotal.gemfirexd.internal.impl.drda.DssTrace;
import com.pivotal.gemfirexd.internal.impl.drda.EXTDTAInputStream;
import com.pivotal.gemfirexd.internal.impl.drda.FdocaConstants;
import com.pivotal.gemfirexd.internal.impl.drda.NetworkServerControlImpl;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;

class DDMWriter {
    private static final int MAX_MARKS_NESTING = 10;
    private static final int DEFAULT_BUFFER_SIZE = Short.MAX_VALUE;
    private ByteBuffer buffer;
    private int[] markStack = new int[10];
    private int top;
    private CcsidManager ccsidManager;
    private DRDAConnThread agent;
    private int dssLengthLocation;
    private int correlationID;
    private int nextCorrelationID;
    private boolean isDRDAProtocol;
    private DssTrace dssTrace;
    private int prevHdrLocation;
    private int previousCorrId;
    private byte previousChainByte;
    private boolean isContinuationDss;
    private int lastDSSBeforeMark;
    private final CharsetEncoder encoder;
    volatile long totalByteCount = 0L;
    final AtomicLong bytesWritten = new AtomicLong(0L);

    DDMWriter(CcsidManager ccsidManager, DRDAConnThread agent, DssTrace dssTrace) {
        this.buffer = ByteBuffer.allocate(Short.MAX_VALUE);
        this.ccsidManager = ccsidManager;
        this.agent = agent;
        this.prevHdrLocation = -1;
        this.previousCorrId = -1;
        this.previousChainByte = 0;
        this.isContinuationDss = false;
        this.lastDSSBeforeMark = -1;
        this.reset(dssTrace);
        this.encoder = NetworkServerControlImpl.DEFAULT_CHARSET.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    protected void reset(DssTrace dssTrace) {
        this.buffer.clear();
        this.top = 0;
        this.dssLengthLocation = 0;
        this.nextCorrelationID = 1;
        this.correlationID = -1;
        this.isDRDAProtocol = true;
        this.dssTrace = dssTrace;
    }

    protected void setCMDProtocol() {
        this.isDRDAProtocol = false;
    }

    protected void createDssReply() {
        this.beginDss(2, true);
    }

    protected void createDssRequest() {
        this.beginDss(1, true);
    }

    protected void createDssObject() {
        this.beginDss(3, true);
    }

    private void markDssAsContinued(boolean forLob) {
        if (!forLob) {
            byte b = (byte)(this.buffer.get(this.dssLengthLocation) | 0x80);
            this.buffer.put(this.dssLengthLocation, b);
        }
        if (!this.isContinuationDss) {
            this.endDss(!forLob);
        }
    }

    protected void endDss(byte chainByte) {
        this.endDss(true);
        this.overrideChainByte(this.dssLengthLocation + 3, chainByte);
        this.previousChainByte = chainByte;
    }

    private void overrideChainByte(int pos, byte chainByte) {
        byte b = this.buffer.get(pos);
        b = (byte)(b & 0xF);
        b = (byte)(b | chainByte);
        this.buffer.put(pos, b);
    }

    protected void endDss() {
        this.endDss(true);
    }

    private void endDss(boolean finalizeLength) {
        if (finalizeLength) {
            this.finalizeDssLength();
        }
        if (this.isContinuationDss) {
            this.isContinuationDss = false;
            return;
        }
        this.previousCorrId = this.correlationID;
        this.prevHdrLocation = this.dssLengthLocation;
        this.previousChainByte = (byte)80;
    }

    protected void endDdmAndDss() {
        this.endDdm();
        this.endDss();
    }

    protected byte[] copyDSSDataToEnd(int start) {
        int length = this.buffer.position() - (start += this.dssLengthLocation);
        byte[] temp = new byte[length];
        this.buffer.position(start);
        this.buffer.get(temp);
        return temp;
    }

    protected void startDdm(int codePoint) {
        int offset = this.buffer.position();
        this.markStack[this.top++] = offset;
        this.ensureLength(4);
        this.buffer.position(offset + 2);
        this.buffer.putShort((short)codePoint);
    }

    protected void clearDdm() {
        this.buffer.position(this.markStack[this.top--]);
    }

    protected void clearBuffer() {
        this.buffer.clear();
        this.top = 0;
        this.dssLengthLocation = 0;
        this.correlationID = -1;
        this.nextCorrelationID = 1;
        this.isDRDAProtocol = true;
    }

    protected void endDdm() {
        int lengthLocation = this.markStack[--this.top];
        int length = this.buffer.position() - lengthLocation;
        int extendedLengthByteCount = this.calculateExtendedLengthByteCount(length);
        if (extendedLengthByteCount != 0) {
            this.ensureLength(extendedLengthByteCount);
            int extendedLength = length - 4;
            int extendedLengthLocation = lengthLocation + 4;
            this.buffer.position(extendedLengthLocation + extendedLengthByteCount);
            this.buffer.put(this.buffer.array(), extendedLengthLocation, extendedLength);
            for (int pos = extendedLengthLocation + extendedLengthByteCount - 1; pos >= extendedLengthLocation; --pos) {
                this.buffer.put(pos, (byte)extendedLength);
                extendedLength >>= 8;
            }
            length = extendedLengthByteCount + 4;
            length |= 0x8000;
        }
        this.buffer.putShort(lengthLocation, (short)length);
    }

    protected int getDSSLength() {
        return this.buffer.position() - this.dssLengthLocation;
    }

    protected void truncateDSS(int value) {
        this.buffer.position(this.dssLengthLocation + value);
    }

    protected void writeByte(int value) {
        if (value > 255) {
            SanityManager.THROWASSERT((String)("writeByte value: " + value + " may not be > 255"));
        }
        this.ensureLength(1);
        this.buffer.put((byte)value);
    }

    protected void writeNetworkShort(int value) {
        this.ensureLength(2);
        this.buffer.putShort((short)value);
    }

    protected void writeNetworkInt(int value) {
        this.ensureLength(4);
        this.buffer.putInt(value);
    }

    protected void writeBytes(byte[] buf, int length) {
        this.writeBytes(buf, 0, length);
    }

    protected void writeBytes(byte[] buf, int start, int length) {
        if (buf == null && length > 0) {
            SanityManager.THROWASSERT((String)"Buf is null");
        }
        if (length + start - 1 > buf.length) {
            SanityManager.THROWASSERT((String)"Not enough bytes in buffer");
        }
        this.ensureLength(length);
        this.buffer.put(buf, start, length);
    }

    protected void writeBytes(byte[] buf) {
        this.writeBytes(buf, buf.length);
    }

    protected void writeLDBytes(byte[] buf) {
        this.writeLDBytes(buf, 0);
    }

    protected void writeLDBytes(byte[] buf, int index) {
        int writeLen = buf.length;
        this.writeShort(writeLen);
        this.writeBytes(buf, 0, writeLen);
    }

    void writeCodePoint4Bytes(int codePoint, int value) {
        this.ensureLength(4);
        this.buffer.putShort((short)codePoint);
        this.buffer.putShort((short)value);
    }

    void writeScalar1Byte(int codePoint, int value) {
        this.ensureLength(5);
        this.buffer.putShort((short)5);
        this.buffer.putShort((short)codePoint);
        this.buffer.put((byte)value);
    }

    protected void writeScalar2Bytes(int codePoint, int value) {
        this.ensureLength(6);
        this.buffer.putShort((short)6);
        this.buffer.putShort((short)codePoint);
        this.buffer.putShort((short)value);
    }

    protected void writeScalar2Bytes(int value) {
        this.ensureLength(2);
        this.buffer.putShort((short)value);
    }

    protected void startDdm(int length, int codePoint) {
        this.ensureLength(4);
        this.buffer.putShort((short)length);
        this.buffer.putShort((short)codePoint);
    }

    protected void writeScalarBytes(int codePoint, byte[] buf, int length) {
        if (buf == null && length > 0) {
            SanityManager.THROWASSERT((String)"Buf is null");
        }
        if (length > buf.length) {
            SanityManager.THROWASSERT((String)"Not enough bytes in buffer");
        }
        this.ensureLength(length + 4);
        this.buffer.putShort((short)length);
        this.buffer.putShort((short)codePoint);
        this.buffer.put(buf, 0, length);
    }

    protected void writeScalarStream(boolean chainedWithSameCorrelator, int codePoint, EXTDTAInputStream in, boolean writeNullByte) throws DRDAProtocolException {
        int spareDssLength = this.prepScalarStream(chainedWithSameCorrelator, codePoint, writeNullByte);
        try {
            OutputStream out = DDMWriter.placeLayerBStreamingBuffer(this.agent.getOutputStream());
            boolean isLastSegment = false;
            while (!isLastSegment) {
                if (PropertyUtil.getSystemBoolean("gemfirexd.debug.suicideOfLayerBStreaming")) {
                    throw new IOException();
                }
                int offset = this.buffer.position();
                int bytesRead = in.read(this.buffer.array(), offset, Math.min(spareDssLength, this.buffer.remaining()));
                this.buffer.position(offset + bytesRead);
                boolean bl = isLastSegment = DDMWriter.peekStream(in) < 0;
                if (!isLastSegment && (spareDssLength -= bytesRead) != 0) continue;
                this.flushScalarStreamSegment(isLastSegment, out);
                if (isLastSegment) continue;
                spareDssLength = 32765;
            }
            out.flush();
        }
        catch (IOException e) {
            this.agent.markCommunicationsFailure(e, "DDMWriter.writeScalarStream()", "", e.getMessage(), "*");
        }
    }

    private void beginDss(boolean chainedToNextStructure, int dssType) {
        this.beginDss(dssType, false);
        this.buffer.putShort(this.dssLengthLocation, (short)-1);
        if (chainedToNextStructure) {
            dssType |= 0x50;
        }
        this.buffer.put(this.dssLengthLocation + 3, (byte)dssType);
    }

    private int prepScalarStream(boolean chainedWithSameCorrelator, int codePoint, boolean writeNullByte) throws DRDAProtocolException {
        this.ensureLength(Short.MAX_VALUE - this.buffer.position());
        int nullIndicatorSize = writeNullByte ? 1 : 0;
        try {
            this.sendBytes(this.agent.getOutputStream());
        }
        catch (IOException e) {
            this.agent.markCommunicationsFailure("DDMWriter.writeScalarStream()", "OutputStream.flush()", e.getMessage(), "*");
        }
        this.beginDss(chainedWithSameCorrelator, 3);
        this.writeLengthCodePoint(32772, codePoint);
        if (writeNullByte) {
            this.writeByte(0);
        }
        return 32757 - nullIndicatorSize;
    }

    protected boolean doesRequestContainData() {
        return this.buffer.position() != 0;
    }

    private void flushScalarStreamSegment(boolean lastSegment, OutputStream out) throws DRDAProtocolException {
        if (!lastSegment) {
            try {
                this.markDssAsContinued(true);
                this.sendBytes(out, false);
            }
            catch (IOException ioe) {
                this.agent.markCommunicationsFailure("DDMWriter.flushScalarStreamSegment()", "", ioe.getMessage(), "*");
            }
            this.dssLengthLocation = this.buffer.position();
            this.buffer.putShort((short)-1);
            this.isContinuationDss = true;
        } else {
            this.endDss();
        }
    }

    void writeLengthCodePoint(int length, int codePoint) {
        this.ensureLength(4);
        this.buffer.putShort((short)length);
        this.buffer.putShort((short)codePoint);
    }

    protected void writeScalarHeader(int codePoint, int dataLength) {
        this.ensureLength(dataLength + 4);
        this.buffer.putShort((short)(dataLength + 4));
        this.buffer.putShort((short)codePoint);
    }

    void writeScalarString(int codePoint, String string) {
        int stringLength = string.length();
        this.ensureLength(stringLength * 2 + 4);
        this.buffer.putShort((short)(stringLength + 4));
        this.buffer.putShort((short)codePoint);
        this.ccsidManager.convertFromUCS2(string, this.buffer);
    }

    void writeScalarPaddedString(int codePoint, String string, int paddedLength) {
        int stringLength = string.length();
        int fillLength = paddedLength - stringLength;
        this.ensureLength(paddedLength + 4);
        this.buffer.putShort((short)(paddedLength + 4));
        this.buffer.putShort((short)codePoint);
        this.ccsidManager.convertFromUCS2(string, this.buffer);
        this.padBytes(this.ccsidManager.space, fillLength);
    }

    protected void writeScalarPaddedString(String string, int paddedLength) {
        int stringLength = string.length();
        int fillLength = paddedLength - stringLength;
        this.ensureLength(paddedLength);
        this.ccsidManager.convertFromUCS2(string, this.buffer);
        this.padBytes(this.ccsidManager.space, fillLength);
    }

    protected void writeScalarPaddedString(DRDAString drdaString, int paddedLength) {
        int stringLength = drdaString.length();
        int fillLength = paddedLength - stringLength;
        this.ensureLength(paddedLength);
        this.buffer.put(drdaString.getBytes(), 0, stringLength);
        this.padBytes(this.ccsidManager.space, fillLength);
    }

    protected void writeScalarPaddedBytes(int codePoint, byte[] buf, int paddedLength, byte padByte) {
        this.ensureLength(paddedLength + 4);
        this.buffer.putShort((short)(paddedLength + 4));
        this.buffer.putShort((short)codePoint);
        this.buffer.put(buf);
        this.padBytes(padByte, paddedLength - buf.length);
    }

    protected void writeScalarPaddedBytes(byte[] buf, int paddedLength, byte padByte) {
        this.ensureLength(paddedLength);
        this.buffer.put(buf);
        this.padBytes(padByte, paddedLength - buf.length);
    }

    protected void writeScalarBytes(int codePoint, byte[] buf) {
        this.ensureLength(buf.length + 4);
        this.buffer.putShort((short)(buf.length + 4));
        this.buffer.putShort((short)codePoint);
        this.buffer.put(buf);
    }

    protected void writeScalarBytes(int codePoint, byte[] buf, int start, int length) {
        if (buf == null && length > start) {
            SanityManager.THROWASSERT((String)"Buf is null");
        }
        if (length - start > buf.length) {
            SanityManager.THROWASSERT((String)"Not enough bytes in buffer");
        }
        int numBytes = length - start;
        this.ensureLength(numBytes + 4);
        this.buffer.putShort((short)(numBytes + 4));
        this.buffer.putShort((short)codePoint);
        this.buffer.put(buf, start, length);
    }

    protected void writeShort(int v) {
        this.writeNetworkShort(v);
    }

    protected void writeShort(boolean b) {
        this.writeNetworkShort(b ? 1 : 0);
    }

    protected void writeInt(int v) {
        this.writeNetworkInt(v);
    }

    protected void writeLong(long v) {
        this.ensureLength(8);
        this.buffer.putLong(v);
    }

    protected void writeFloat(float v) {
        this.writeInt(Float.floatToIntBits(v));
    }

    protected void writeDouble(double v) {
        this.writeLong(Double.doubleToLongBits(v));
    }

    protected void writeBoolean(boolean v) {
        this.writeByte(v ? 1 : 0);
    }

    protected void writeLDString(String s) throws DRDAProtocolException {
        this.writeLDString(s, 0);
    }

    protected void writeUDT(Object val, int index) throws DRDAProtocolException {
        if (val == null) {
            SanityManager.THROWASSERT((String)"UDT is null");
        }
        byte[] buffer = null;
        int length = 0;
        try {
            DynamicByteArrayOutputStream dbaos = new DynamicByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream((OutputStream)((Object)dbaos));
            oos.writeObject(val);
            buffer = dbaos.getByteArray();
            length = dbaos.getUsed();
        }
        catch (IOException e) {
            this.agent.markCommunicationsFailure(e, "DDMWriter.writeUDT()", "", e.getMessage(), "");
        }
        if (length > Short.MAX_VALUE) {
            this.agent.markCommunicationsFailure("DDMWriter.writeUDT()", "User defined type is longer than 32767 bytes.", "", "");
        } else {
            this.writeShort(length);
            this.writeBytes(buffer, 0, length);
        }
    }

    private int maxEncodedLength(String s) {
        return (int)((double)s.length() * (double)this.encoder.maxBytesPerChar());
    }

    protected void writeLDString(String s, int index) throws DRDAProtocolException {
        int lengthPos = this.buffer.position();
        int stringPos = lengthPos + 2;
        int maxStrLen = Math.min(this.maxEncodedLength(s), FdocaConstants.LONGVARCHAR_MAX_LEN);
        this.ensureLength(2 + maxStrLen);
        this.buffer.position(stringPos);
        this.buffer.limit(stringPos + maxStrLen);
        CharBuffer input = CharBuffer.wrap(s);
        CoderResult res = this.encoder.encode(input, this.buffer, true);
        if (res != CoderResult.UNDERFLOW && res != CoderResult.OVERFLOW) {
            SanityManager.ASSERT((res == CoderResult.UNDERFLOW || res == CoderResult.OVERFLOW ? 1 : 0) != 0, (String)("Unexpected coder result: " + res));
        }
        this.buffer.putShort(lengthPos, (short)(maxStrLen - this.buffer.remaining()));
        this.buffer.limit(this.buffer.capacity());
    }

    protected void writeString(String s) throws DRDAProtocolException {
        this.ensureLength(this.maxEncodedLength(s));
        CharBuffer input = CharBuffer.wrap(s);
        CoderResult res = this.encoder.encode(input, this.buffer, true);
        if (res != CoderResult.UNDERFLOW) {
            SanityManager.ASSERT((res == CoderResult.UNDERFLOW ? 1 : 0) != 0, (String)("CharBuffer was not exhausted: res = " + res));
        }
    }

    protected void padBytes(byte val, int length) {
        int offset = this.buffer.position();
        int end = offset + length;
        Arrays.fill(this.buffer.array(), offset, end, val);
        this.buffer.position(end);
    }

    protected void flush() throws IOException {
        this.flush(this.agent.getOutputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flush(OutputStream socketOutputStream) throws IOException {
        byte[] bytes = this.buffer.array();
        int length = this.buffer.position();
        try {
            socketOutputStream.write(bytes, 0, length);
            socketOutputStream.flush();
        }
        finally {
            if (this.dssTrace != null && this.dssTrace.isComBufferTraceOn()) {
                this.dssTrace.writeComBufferData(bytes, 0, length, 1, "Reply", "flush", 5);
            }
            this.reset(this.dssTrace);
        }
        if (ConnectionStats.isSamplingEnabled()) {
            this.bytesWritten.addAndGet(length);
        }
        this.totalByteCount += (long)length;
    }

    private void beginDss(int dssType, boolean ensureLen) {
        this.dssLengthLocation = this.buffer.position();
        if (ensureLen) {
            this.ensureLength(6);
        }
        this.buffer.position(this.dssLengthLocation + 2);
        this.buffer.put((byte)-48);
        this.buffer.put((byte)(dssType | 0x50));
        this.correlationID = this.getCorrelationID();
        this.buffer.putShort((short)this.correlationID);
    }

    private void finalizeDssLength() {
        int offset = this.buffer.position();
        int totalSize = offset - this.dssLengthLocation;
        int bytesRequiringContDssHeader = totalSize - Short.MAX_VALUE;
        if (bytesRequiringContDssHeader > 0) {
            int dataToShift;
            int contDssHeaderCount = bytesRequiringContDssHeader / 32765;
            if (bytesRequiringContDssHeader % 32765 != 0) {
                ++contDssHeaderCount;
            }
            int dataByte = offset - 1;
            int shiftSize = contDssHeaderCount * 2;
            this.ensureLength(shiftSize);
            this.buffer.position(offset + shiftSize);
            boolean passOne = true;
            do {
                if ((dataToShift = bytesRequiringContDssHeader % 32765) == 0) {
                    dataToShift = 32765;
                }
                int startOfCopyData = dataByte - dataToShift + 1;
                byte[] bytes = this.buffer.array();
                System.arraycopy(bytes, startOfCopyData, bytes, startOfCopyData + shiftSize, dataToShift);
                dataByte -= dataToShift;
                int twoByteContDssHeader = dataToShift + 2;
                if (passOne) {
                    passOne = false;
                } else if (twoByteContDssHeader == Short.MAX_VALUE) {
                    twoByteContDssHeader |= 0x8000;
                }
                this.buffer.putShort(dataByte + shiftSize - 1, (short)twoByteContDssHeader);
                shiftSize -= 2;
            } while ((bytesRequiringContDssHeader -= dataToShift) > 0);
            totalSize = 65535;
        }
        this.buffer.putShort(this.dssLengthLocation, (short)totalSize);
    }

    protected void writeExtendedLength(long size) {
        int numbytes = this.calculateExtendedLengthByteCount(size);
        if (size > 0L) {
            this.writeInt(0x8000 | numbytes);
        } else {
            this.writeInt(numbytes);
        }
    }

    private int calculateExtendedLengthByteCount(long ddmSize) {
        if (ddmSize <= 32767L) {
            return 0;
        }
        if (ddmSize <= 0xFFFFFFFFL) {
            return 4;
        }
        if (ddmSize <= 0xFFFFFFFFFFFFL) {
            return 6;
        }
        if (ddmSize <= Long.MAX_VALUE) {
            return 8;
        }
        return 0;
    }

    private void ensureLength(int length) {
        if (this.buffer.remaining() < length) {
            if (this.agent.trace) {
                this.agent.trace("DANGER - Expensive expansion of  buffer");
            }
            int newLength = Math.max(this.buffer.capacity() * 2, this.buffer.position() + length);
            this.buffer.flip();
            this.buffer = ByteBuffer.allocate(newLength).put(this.buffer);
        }
    }

    void writeBigDecimal(BigDecimal b, int precision, int scale) throws SQLException {
        byte bt;
        int bigIndex;
        int declaredWholeIntegerLength;
        int encodedLength = precision / 2 + 1;
        this.ensureLength(encodedLength);
        int offset = this.buffer.position();
        this.buffer.position(offset + encodedLength);
        int declaredPrecision = precision;
        int declaredScale = scale;
        if (declaredPrecision > 127) {
            this.clearDdm();
            throw new SQLException("Packed decimal may only be up to 127 digits!");
        }
        String unscaledStr = b.unscaledValue().abs().toString();
        int bigPrecision = unscaledStr.length();
        if (bigPrecision > 127) {
            this.clearDdm();
            throw new SQLException("The numeric literal \"" + b.toString() + "\" unscaledValue=" + unscaledStr + " is not valid because its value is out of range.", "42820", -405);
        }
        int bigScale = b.scale();
        int bigWholeIntegerLength = bigPrecision - bigScale;
        if (bigWholeIntegerLength > 0 && !unscaledStr.equals("0") && bigWholeIntegerLength > (declaredWholeIntegerLength = declaredPrecision - declaredScale)) {
            this.clearDdm();
            throw new SQLException("Overflow occurred during numeric data type conversion of \"" + b.toString() + "\" actual integer length=" + bigWholeIntegerLength + ", declared integer length=" + declaredWholeIntegerLength + ", unscaledValue=" + unscaledStr + ", scale=" + bigScale + ".", "22003", -413);
        }
        int zeroBase = 48;
        int packedIndex = declaredPrecision - 1;
        byte signByte = (byte)(b.signum() >= 0 ? 12 : 13);
        if (bigScale >= declaredScale) {
            bigIndex = bigPrecision - 1 - (bigScale - declaredScale);
            if (bigIndex >= 0) {
                signByte = (byte)(signByte | unscaledStr.charAt(bigIndex) - zeroBase << 4);
            }
            this.buffer.put(offset + (packedIndex + 1) / 2, signByte);
            packedIndex -= 2;
            bigIndex -= 2;
        } else {
            bigIndex = declaredScale - bigScale - 1;
            this.buffer.put(offset + (packedIndex + 1) / 2, signByte);
            packedIndex -= 2;
            bigIndex -= 2;
            while (bigIndex >= 0) {
                this.buffer.put(offset + (packedIndex + 1) / 2, (byte)0);
                packedIndex -= 2;
                bigIndex -= 2;
            }
            if (bigIndex == -1) {
                bt = (byte)(unscaledStr.charAt(bigPrecision - 1) - zeroBase << 4);
                this.buffer.put(offset + (packedIndex + 1) / 2, bt);
                packedIndex -= 2;
                bigIndex = bigPrecision - 3;
            } else {
                bigIndex = bigPrecision - 2;
            }
        }
        while (bigIndex >= 0) {
            bt = (byte)(unscaledStr.charAt(bigIndex) - zeroBase << 4 | unscaledStr.charAt(bigIndex + 1) - zeroBase);
            this.buffer.put(offset + (packedIndex + 1) / 2, bt);
            packedIndex -= 2;
            bigIndex -= 2;
        }
        if (bigIndex == -1) {
            this.buffer.put(offset + (packedIndex + 1) / 2, (byte)(unscaledStr.charAt(0) - zeroBase));
            packedIndex -= 2;
        }
        while (packedIndex >= -1) {
            this.buffer.put(offset + (packedIndex + 1) / 2, (byte)0);
            packedIndex -= 2;
        }
    }

    public static String zeroPadString(String s, int precision) {
        if (s == null) {
            return s;
        }
        int slen = s.length();
        if (precision == slen) {
            return s;
        }
        if (precision > slen) {
            char[] ca = new char[precision - slen];
            Arrays.fill(ca, 0, precision - slen, '0');
            return new String(ca) + s;
        }
        return s.substring(0, precision);
    }

    private void sendBytes(OutputStream socketOutputStream) throws IOException {
        this.sendBytes(socketOutputStream, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBytes(OutputStream socketOutputStream, boolean flashStream) throws IOException {
        this.resetChainState();
        byte[] bytes = this.buffer.array();
        int length = this.buffer.position();
        try {
            socketOutputStream.write(bytes, 0, length);
            if (ConnectionStats.isSamplingEnabled()) {
                this.bytesWritten.addAndGet(length);
            }
            this.totalByteCount += (long)length;
            if (flashStream) {
                socketOutputStream.flush();
            }
        }
        finally {
            if (this.dssTrace != null && this.dssTrace.isComBufferTraceOn()) {
                this.dssTrace.writeComBufferData(bytes, 0, length, 1, "Reply", "flush", 5);
            }
            this.clearBuffer();
        }
    }

    protected String toDebugString(String indent) {
        String s = indent + "***** DDMWriter toDebugString ******\n";
        int len = this.buffer != null ? this.buffer.capacity() : 0;
        s = s + indent + "byte buffer length  = " + len + "\n";
        return s;
    }

    protected void resetChainState() {
        this.prevHdrLocation = -1;
    }

    private int getCorrelationID() {
        int cId = this.previousCorrId != -1 ? (this.previousChainByte == 80 ? this.previousCorrId : this.nextCorrelationID++) : this.nextCorrelationID++;
        return cId;
    }

    protected void finalizeChain(byte currChainByte, OutputStream socketOutputStream) throws DRDAProtocolException {
        if (this.prevHdrLocation != -1) {
            this.overrideChainByte(this.prevHdrLocation + 3, currChainByte);
        }
        this.previousChainByte = currChainByte;
        if (currChainByte != 0) {
            return;
        }
        if (this.agent != null && this.agent.trace) {
            this.agent.trace("Sending data");
        }
        this.resetChainState();
        if (this.doesRequestContainData()) {
            try {
                this.flush(socketOutputStream);
            }
            catch (IOException e) {
                this.agent.markCommunicationsFailure("DDMWriter.finalizeChain()", "OutputStream.flush()", e.getMessage(), "*");
            }
        }
    }

    protected int markDSSClearPoint() {
        this.lastDSSBeforeMark = this.prevHdrLocation;
        return this.buffer.position();
    }

    protected void clearDSSesBackToMark(int mark) {
        this.buffer.position(mark);
        this.nextCorrelationID = this.lastDSSBeforeMark == -1 ? 1 : (this.buffer.getShort(this.lastDSSBeforeMark + 4) & 0xFFFF) + 1;
    }

    private static int peekStream(InputStream in) throws IOException {
        in.mark(1);
        try {
            int n = in.read();
            return n;
        }
        finally {
            in.reset();
        }
    }

    private static int getLayerBStreamingBufferSize() {
        return PropertyUtil.getSystemInt("gemfirexd.drda.streamOutBufferSize", 0);
    }

    private static OutputStream placeLayerBStreamingBuffer(OutputStream original) {
        int size = DDMWriter.getLayerBStreamingBufferSize();
        if (size < 1) {
            return original;
        }
        return new BufferedOutputStream(original, size);
    }
}

