/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.store.access;

import com.pivotal.gemfirexd.internal.engine.access.index.SortedMap2IndexScanController;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapResourceHolder;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.Qualifier;
import com.pivotal.gemfirexd.internal.iapi.store.raw.FetchDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class RowUtil {
    public static final DataValueDescriptor[] EMPTY_ROW = new DataValueDescriptor[0];
    public static final FormatableBitSet EMPTY_ROW_BITSET = new FormatableBitSet(0);
    public static final FetchDescriptor EMPTY_ROW_FETCH_DESCRIPTOR = new FetchDescriptor(0);
    private static final FetchDescriptor[] ROWUTIL_FETCH_DESCRIPTOR_CONSTANTS = new FetchDescriptor[]{EMPTY_ROW_FETCH_DESCRIPTOR, new FetchDescriptor(1, 1), new FetchDescriptor(2, 2), new FetchDescriptor(3, 3), new FetchDescriptor(4, 4), new FetchDescriptor(5, 5), new FetchDescriptor(6, 6), new FetchDescriptor(7, 7)};

    private RowUtil() {
    }

    public static DataValueDescriptor getColumn(DataValueDescriptor[] row, FormatableBitSet columnList, int columnId) {
        if (columnList == null) {
            return columnId < row.length ? row[columnId] : null;
        }
        if (columnList.getLength() <= columnId || !columnList.isSet(columnId)) {
            return null;
        }
        return columnId < row.length ? row[columnId] : null;
    }

    public static Object getColumn(Object[] row, FormatableBitSet columnList, int columnId) {
        if (columnList == null) {
            return columnId < row.length ? row[columnId] : null;
        }
        if (columnList.getLength() <= columnId || !columnList.isSet(columnId)) {
            return null;
        }
        return columnId < row.length ? row[columnId] : null;
    }

    public static FormatableBitSet getQualifierBitSet(Qualifier[][] qualifiers) {
        FormatableBitSet qualifierColumnList = new FormatableBitSet();
        if (qualifiers != null) {
            for (int i = 0; i < qualifiers.length; ++i) {
                for (int j = 0; j < qualifiers[i].length; ++j) {
                    int colId = qualifiers[i][j].getColumnId();
                    qualifierColumnList.grow(colId + 1);
                    qualifierColumnList.set(colId);
                }
            }
        }
        return qualifierColumnList;
    }

    public static int getNumberOfColumns(int maxColumnNumber, FormatableBitSet columnList) {
        SanityManager.ASSERT((columnList != null ? 1 : 0) != 0);
        int max_col_number = columnList.getLength();
        if (maxColumnNumber > 0 && maxColumnNumber < max_col_number) {
            max_col_number = maxColumnNumber;
        }
        int ret_num_cols = 0;
        for (int i = 0; i < max_col_number; ++i) {
            if (!columnList.isSet(i)) continue;
            ++ret_num_cols;
        }
        return ret_num_cols;
    }

    public static boolean isRowEmpty(DataValueDescriptor[] row) {
        if (row == null) {
            return true;
        }
        return row.length == 0;
    }

    public static int columnOutOfRange(DataValueDescriptor[] row, FormatableBitSet columnList, int maxColumns) {
        if (columnList == null) {
            if (row.length > maxColumns) {
                return maxColumns;
            }
            return -1;
        }
        int size = columnList.getLength();
        for (int i = maxColumns; i < size; ++i) {
            if (!columnList.isSet(i)) continue;
            return i;
        }
        return -1;
    }

    public static int nextColumn(Object[] row, FormatableBitSet columnList, int startColumn) {
        if (columnList != null) {
            int size = columnList.getLength();
            while (startColumn < size) {
                if (columnList.isSet(startColumn)) {
                    return startColumn;
                }
                ++startColumn;
            }
            return -1;
        }
        if (row == null) {
            return -1;
        }
        return startColumn < row.length ? startColumn : -1;
    }

    public static final FetchDescriptor getFetchDescriptorConstant(int single_column_number) {
        if (single_column_number < ROWUTIL_FETCH_DESCRIPTOR_CONSTANTS.length) {
            return ROWUTIL_FETCH_DESCRIPTOR_CONSTANTS[single_column_number];
        }
        return new FetchDescriptor(single_column_number, single_column_number);
    }

    public static DataValueDescriptor[] newTemplate(DataValueFactory dvf, FormatableBitSet column_list, int[] format_ids, int[] collation_ids) throws StandardException {
        int num_cols = format_ids.length;
        DataValueDescriptor[] ret_row = new DataValueDescriptor[num_cols];
        int column_listSize = column_list == null ? 0 : column_list.getLength();
        for (int i = 0; i < num_cols; ++i) {
            if (column_list != null && (column_listSize <= i || !column_list.isSet(i))) continue;
            ret_row[i] = dvf.getNull(format_ids[i], collation_ids[i]);
        }
        return ret_row;
    }

    private static void newRowFromClassInfoTemplateError() {
        SanityManager.THROWASSERT((String)"unexpected error in newRowFromClassInfoTemplate()");
    }

    public static DataValueDescriptor[] newRowFromTemplate(DataValueDescriptor[] template) throws StandardException {
        DataValueDescriptor[] columns = new DataValueDescriptor[template.length];
        int column_index = template.length;
        while (column_index-- > 0) {
            if (template[column_index] == null) continue;
            columns[column_index] = template[column_index].getNewNull();
        }
        return columns;
    }

    public static String toString(Object[] row) {
        String str = new String();
        if (row != null) {
            if (row.length == 0) {
                str = "empty row";
            } else {
                for (int i = 0; i < row.length; ++i) {
                    str = str + " col[" + i + "]=" + row[i];
                }
            }
        } else {
            str = "row is null";
        }
        return str;
    }

    public static String toString(Hashtable hash_table) {
        String str = new String();
        Enumeration e = hash_table.elements();
        while (e.hasMoreElements()) {
            Object row_or_vector = e.nextElement();
            if (row_or_vector instanceof Object[]) {
                str = str + RowUtil.toString((Object[])row_or_vector);
                str = str + "\n";
                continue;
            }
            if (row_or_vector instanceof Vector) {
                Vector vec = (Vector)row_or_vector;
                for (int i = 0; i < vec.size(); ++i) {
                    str = str + "vec[" + i + "]:" + RowUtil.toString((Object[])vec.elementAt(i));
                    str = str + "\n";
                }
                continue;
            }
            str = str + "BAD ENTRY\n";
        }
        return str;
    }

    public static final boolean qualifyRow(DataValueDescriptor[] row, DataValueDescriptor dvd, Qualifier[][] qual_list, boolean allowPartialRow) throws StandardException {
        boolean row_qualifies = true;
        SanityManager.ASSERT((boolean)(row != null | dvd != null));
        SanityManager.ASSERT((qual_list != null ? 1 : 0) != 0);
        SanityManager.ASSERT((qual_list.length > 0 ? 1 : 0) != 0);
        for (int i = 0; i < qual_list[0].length; ++i) {
            DataValueDescriptor columnValue;
            row_qualifies = false;
            Qualifier q = qual_list[0][i];
            if (dvd != null) {
                SanityManager.ASSERT((q.getColumnId() == 0 ? 1 : 0) != 0);
                columnValue = dvd;
            } else {
                columnValue = row[q.getColumnId()];
            }
            boolean bl = allowPartialRow && columnValue == null ? !q.negateCompareResult() : (row_qualifies = columnValue.compare(q.getOperator(), q.getOrderable(), q.getOrderedNulls(), q.getUnknownRV()));
            if (q.negateCompareResult()) {
                boolean bl2 = row_qualifies = !row_qualifies;
            }
            if (row_qualifies) continue;
            return false;
        }
        for (int and_idx = 1; and_idx < qual_list.length; ++and_idx) {
            row_qualifies = false;
            SanityManager.ASSERT((qual_list[and_idx].length > 0 ? 1 : 0) != 0);
            for (int or_idx = 0; or_idx < qual_list[and_idx].length; ++or_idx) {
                DataValueDescriptor columnValue;
                Qualifier q = qual_list[and_idx][or_idx];
                int col_id = q.getColumnId();
                SanityManager.ASSERT((!(dvd != null && col_id != 0 || dvd == null && col_id >= row.length) ? 1 : 0) != 0, (String)"Qualifier is referencing a column not in the row.");
                if (dvd != null) {
                    SanityManager.ASSERT((q.getColumnId() == 0 ? 1 : 0) != 0);
                    columnValue = dvd;
                } else {
                    columnValue = row[q.getColumnId()];
                }
                if (columnValue == null && !allowPartialRow) {
                    int rowLen;
                    String rowStr;
                    if (dvd != null) {
                        rowStr = dvd.toString();
                        rowLen = 1;
                    } else {
                        rowStr = RowUtil.toString(row);
                        rowLen = row.length;
                    }
                    SanityManager.THROWASSERT((String)("1:row = " + rowStr + "row.length = " + rowLen + ";q.getColumnId() = " + q.getColumnId()));
                }
                boolean bl = allowPartialRow && columnValue == null ? !q.negateCompareResult() : (row_qualifies = columnValue.compare(q.getOperator(), q.getOrderable(), q.getOrderedNulls(), q.getUnknownRV()));
                if (q.negateCompareResult()) {
                    boolean bl3 = row_qualifies = !row_qualifies;
                }
                if (row_qualifies) break;
            }
            if (!row_qualifies) break;
        }
        return row_qualifies;
    }

    public static final int compare(DataValueDescriptor[] arg1, DataValueDescriptor[] arg2) throws StandardException {
        if (arg1.length > arg2.length) {
            return 1;
        }
        if (arg1.length < arg2.length) {
            return -1;
        }
        for (int i = 0; i < arg1.length; ++i) {
            int com = arg1[i].compare(arg2[i]);
            if (com == 0) continue;
            return com;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RowLocation fetch(RowLocation loc, ExecRow destRow, FormatableBitSet validColumns, boolean faultIn, GemFireContainer container, SortedMap2IndexScanController scanController, Object indexKey, int nodeVersion, OffHeapResourceHolder owner) throws StandardException {
        if (loc == null || loc.isNull()) {
            return null;
        }
        ExecRow rowFromLocation = faultIn ? loc.getRow(container) : loc.getRowWithoutFaultIn(container);
        boolean rowQualified = false;
        if (rowFromLocation != null) {
            try {
                if (scanController == null || scanController.qualifyRow(loc, rowFromLocation, indexKey, nodeVersion)) {
                    rowQualified = true;
                    destRow.setColumns(validColumns, rowFromLocation);
                    RowLocation rowLocation = loc;
                    return rowLocation;
                }
            }
            finally {
                if (container.isOffHeap()) {
                    Object bs = rowFromLocation.getByteSource();
                    if (bs instanceof OffHeapByteSource) {
                        OffHeapByteSource obs = (OffHeapByteSource)((Object)bs);
                        if (rowQualified) {
                            owner.addByteSource(obs);
                        } else {
                            obs.release();
                        }
                    } else if (rowQualified) {
                        owner.addByteSource(null);
                    }
                }
            }
        }
        return null;
    }
}

