/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.sql.dictionary;

import com.pivotal.gemfirexd.internal.catalog.AliasInfo;
import com.pivotal.gemfirexd.internal.catalog.DependableFinder;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.catalog.types.RoutineAliasInfo;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.DependencyManager;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.Dependent;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.Provider;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDescriptorGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TupleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.UniqueTupleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;

public final class AliasDescriptor
extends TupleDescriptor
implements UniqueTupleDescriptor,
Provider,
Dependent {
    private final UUID aliasID;
    private final String aliasName;
    private final UUID schemaID;
    private final String javaClassName;
    private final char aliasType;
    private final char nameSpace;
    private final boolean systemAlias;
    private final AliasInfo aliasInfo;
    private final String specificName;

    public AliasDescriptor(DataDictionary dataDictionary, UUID aliasID, String aliasName, UUID schemaID, String javaClassName, char aliasType, char nameSpace, boolean systemAlias, AliasInfo aliasInfo, String specificName) {
        super(dataDictionary);
        this.aliasID = aliasID;
        this.aliasName = aliasName;
        this.schemaID = schemaID;
        this.javaClassName = javaClassName;
        this.aliasType = aliasType;
        this.nameSpace = nameSpace;
        this.systemAlias = systemAlias;
        this.aliasInfo = aliasInfo;
        if (specificName == null) {
            specificName = dataDictionary.getSystemSQLName();
        }
        this.specificName = specificName;
    }

    @Override
    public UUID getUUID() {
        return this.aliasID;
    }

    public UUID getSchemaUUID() {
        return this.schemaID;
    }

    public String getSchemaName() throws StandardException {
        return this.getDataDictionary().getSchemaDescriptor(this.schemaID, null).getSchemaName();
    }

    public String getQualifiedName() throws StandardException {
        return this.quoteProtectName(this.getSchemaName()) + "." + this.quoteProtectName(this.aliasName);
    }

    public String getJavaClassName() {
        return this.javaClassName;
    }

    public char getAliasType() {
        return this.aliasType;
    }

    public char getNameSpace() {
        return this.nameSpace;
    }

    public boolean getSystemAlias() {
        return this.systemAlias;
    }

    public AliasInfo getAliasInfo() {
        return this.aliasInfo;
    }

    public String toString() {
        return "aliasID: " + this.aliasID + "\naliasName: " + this.aliasName + "\nschemaID: " + this.schemaID + "\njavaClassName: " + this.javaClassName + "\naliasType: " + this.aliasType + "\nnameSpace: " + this.nameSpace + "\nsystemAlias: " + this.systemAlias + "\naliasInfo: " + this.aliasInfo + "\n";
    }

    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof AliasDescriptor)) {
            return false;
        }
        AliasDescriptor other = (AliasDescriptor)otherObject;
        return this.aliasID.equals(other.getUUID());
    }

    public int hashCode() {
        return this.aliasID.hashCode();
    }

    @Override
    public DependableFinder getDependableFinder() {
        return this.getDependableFinder(136);
    }

    @Override
    public String getObjectName() {
        return this.aliasName;
    }

    @Override
    public UUID getObjectID() {
        return this.aliasID;
    }

    @Override
    public String getClassType() {
        return "Alias";
    }

    @Override
    public String getDescriptorType() {
        return AliasDescriptor.getAliasType(this.aliasType);
    }

    public static final String getAliasType(char nameSpace) {
        switch (nameSpace) {
            case 'P': {
                return "PROCEDURE";
            }
            case 'F': {
                return "FUNCTION";
            }
            case 'S': {
                return "SYNONYM";
            }
            case 'A': {
                return "TYPE";
            }
            case 'R': {
                return "PROCEDURE PROCESSOR";
            }
        }
        return null;
    }

    @Override
    public String getDescriptorName() {
        return this.aliasName;
    }

    public String getSpecificName() {
        return this.specificName;
    }

    @Override
    public boolean isDescriptorPersistent() {
        return !this.getSchemaUUID().toString().equals("c013800d-00fb-2642-07ec-000000134f30");
    }

    public boolean isTableFunction() {
        if (this.getAliasType() != 'F') {
            return false;
        }
        RoutineAliasInfo rai = (RoutineAliasInfo)this.getAliasInfo();
        return rai.getReturnType().isRowMultiSet();
    }

    public void drop(LanguageConnectionContext lcc) throws StandardException {
        DataDictionary dd = this.getDataDictionary();
        TransactionController tc = lcc.getTransactionExecute();
        DependencyManager dm = dd.getDependencyManager();
        int invalidationType = 0;
        switch (this.getAliasType()) {
            case 'F': 
            case 'P': {
                invalidationType = 6;
                break;
            }
            case 'S': {
                invalidationType = 43;
                break;
            }
            case 'A': {
                invalidationType = 50;
            }
        }
        dm.invalidateFor(this, invalidationType, lcc);
        if (this.getAliasType() == 'S') {
            SchemaDescriptor sd = dd.getSchemaDescriptor(this.schemaID, tc);
            DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
            TableDescriptor td = ddg.newTableDescriptor(this.aliasName, sd, 4, 'R');
            dd.dropTableDescriptor(td, sd, tc);
        } else {
            dd.dropAllRoutinePermDescriptors(this.getUUID(), tc);
        }
        dd.dropAliasDescriptor(this, tc);
    }

    @Override
    public synchronized boolean isValid() {
        return true;
    }

    @Override
    public void prepareToInvalidate(Provider p, int action, LanguageConnectionContext lcc) throws StandardException {
        DependencyManager dm = this.getDataDictionary().getDependencyManager();
        switch (action) {
            default: 
        }
        throw StandardException.newException("X0Y30.S", (Object)dm.getActionString(action), (Object)p.getObjectName(), (Object)this.getQualifiedName());
    }

    @Override
    public void makeInvalid(int action, LanguageConnectionContext lcc) throws StandardException {
        DependencyManager dm = this.getDataDictionary().getDependencyManager();
        SanityManager.THROWASSERT((String)("makeInvalid(" + dm.getActionString(action) + ") not expected to get called"));
    }
}

