/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.store.entry;

import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.query.internal.IndexUpdater;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.InternalStatisticsDisabledException;
import com.gemstone.gemfire.internal.cache.AbstractOperationMessage;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.InitialImageOperation;
import com.gemstone.gemfire.internal.cache.KeyWithRegionContext;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.ObjectEqualsHashingStrategy;
import com.gemstone.gemfire.internal.cache.RegionClearedException;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.THashMapWithKeyPair;
import com.gemstone.gemfire.internal.cache.TXEntryState;
import com.gemstone.gemfire.internal.cache.TXEntryStateFactory;
import com.gemstone.gemfire.internal.cache.TXRegionState;
import com.gemstone.gemfire.internal.cache.TXState;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.locks.LockMode;
import com.gemstone.gemfire.internal.cache.locks.LockingPolicy;
import com.gemstone.gemfire.internal.cache.versions.VersionSource;
import com.gemstone.gemfire.internal.cache.versions.VersionStamp;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.concurrent.ConcurrentSkipListMap;
import com.gemstone.gemfire.internal.offheap.ByteSource;
import com.gemstone.gemfire.internal.shared.Version;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.gemstone.gnu.trove.HashingStats;
import com.gemstone.gnu.trove.TObjectHashingStrategy;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.index.GfxdIndexManager;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdCallbackArgument;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.ExtraTableInfo;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeKey;
import com.pivotal.gemfirexd.internal.engine.store.ExtractingIndexKey;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.cache.ClassSize;
import com.pivotal.gemfirexd.internal.iapi.services.io.ArrayInputStream;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.types.BooleanDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.iapi.types.WrapperRowLocationForTxn;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;

public final class GfxdTXEntryState
extends TXEntryState
implements RowLocation,
RegionEntry {
    private static final TXEntryStateFactory factory = new TXEntryStateFactory(){

        public final GfxdTXEntryState createEntry(Object key, RegionEntry re, Object val, boolean doFullValueFlush, TXRegionState txrs) {
            return new GfxdTXEntryState(key, re, val, doFullValueFlush, txrs);
        }
    };
    private ArrayList<WrapperRowLocationForTxn> replacedEntriesForUniqIndexes;

    public static final TXEntryStateFactory getGfxdFactory() {
        return factory;
    }

    private GfxdTXEntryState(Object key, RegionEntry re, Object val, boolean doFullValueFlush, TXRegionState txrs) {
        super(key, re, val, doFullValueFlush, txrs);
        GemFireStore.VMKind myKind;
        assert ((myKind = GemFireXDUtils.getMyVMKind()) == GemFireStore.VMKind.DATASTORE) : "unexpected creation of GfxdTXEntryState on VM of kind " + myKind;
    }

    protected final void basicPutPart3(LocalRegion owner, EntryEventImpl event, boolean ifNew) throws TimeoutException {
        IndexUpdater indexUpdater = owner.getIndexUpdater();
        if (indexUpdater != null) {
            boolean success = false;
            try {
                indexUpdater.onEvent(owner, event, (RegionEntry)this);
                success = true;
            }
            catch (RuntimeException e) {
                if (GemFireXDUtils.isTXAbort(e) != GemFireXDUtils.TXAbortState.NOT_ABORTED) {
                    event.setSkipDistributionOps();
                }
                throw e;
            }
            finally {
                indexUpdater.postEvent(owner, event, (RegionEntry)this, success);
            }
        }
    }

    protected void destroyPart3(LocalRegion owner, EntryEventImpl event) throws EntryNotFoundException, TimeoutException {
        IndexUpdater indexUpdater = owner.getIndexUpdater();
        if (indexUpdater != null) {
            boolean success = false;
            try {
                indexUpdater.onEvent(owner, event, (RegionEntry)this);
                success = true;
            }
            catch (RuntimeException e) {
                if (GemFireXDUtils.isTXAbort(e) != GemFireXDUtils.TXAbortState.NOT_ABORTED) {
                    event.setSkipDistributionOps();
                }
                throw e;
            }
            finally {
                if (success) {
                    indexUpdater.postEvent(owner, event, (RegionEntry)this, success);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyBatchOperationOnNewEntry(TXState txState, LockingPolicy lockPolicy, TXRegionState txrs, LocalRegion region, LocalRegion dataRegion, Object regionValue, RegionEntry entry, boolean lockedForRead, boolean checkForTXFinish, EntryEventImpl event) {
        IndexUpdater indexUpdater = dataRegion.getIndexUpdater();
        if (this.isDirty() && indexUpdater != null) {
            if (Token.isRemoved((Object)regionValue)) {
                if (this.pendingDelta != null) {
                    Assert.fail((Object)("unexpected delta received for new region entry for key=" + this.regionKey + ", entry=" + entry + ", regionValue=" + regionValue + ", in region " + region.getFullPath() + ", dataRegion=" + dataRegion.getFullPath() + ": " + this.pendingDelta));
                }
                if (this.isOpDestroy()) {
                    super.applyBatchOperationOnNewEntry(txState, lockPolicy, txrs, region, dataRegion, regionValue, entry, lockedForRead, checkForTXFinish, event);
                    return;
                }
                if (this.pendingValue == null) {
                    Assert.fail((Object)("unexpected null new value for CREATE for key=" + this.regionKey + ", in region " + region.getFullPath() + ", dataRegion=" + dataRegion.getFullPath()));
                }
                event.setOperation(Operation.CREATE);
                event.setTXOldValue(null);
                event.setNewValue(this.pendingValue);
            } else if (this.isOpDestroy()) {
                if (this.pendingDelta != null || this.pendingValue != null) {
                    Assert.fail((Object)("unexpected delta or value received for destroyed key=" + this.regionKey + ", in region " + region.getFullPath() + ": " + this.toString()));
                }
                event.setOperation(Operation.DESTROY);
                event.setTXOldValue(regionValue);
                event.setNewValue(null);
            } else if (this.pendingDelta == null) {
                if (this.pendingValue == null) {
                    Assert.fail((Object)("unexpected null new value for UPDATE for key=" + this.regionKey + ", in region " + region.getFullPath() + ", dataRegion=" + dataRegion.getFullPath()));
                }
                event.setOperation(Operation.UPDATE);
                event.setTXOldValue(regionValue);
                event.setNewValue(this.pendingValue);
            } else {
                if (this.pendingValue != null) {
                    Assert.fail((Object)("unexpected full value received for existing region entry " + entry + ", in region " + region.getFullPath() + ", dataRegion=" + dataRegion.getFullPath() + ": " + this.pendingValue));
                }
                event.setOperation(Operation.UPDATE);
                event.setTXOldValue(regionValue);
                event.setNewDelta(this.pendingDelta);
            }
            event.setRegion(region);
            event.setKey(this.regionKey);
            event.setCallbackArgument(this.getCallbackArgument());
            event.setSkipDistributionOps();
            event.setContextObject(null);
            boolean success = false;
            try {
                indexUpdater.onEvent(dataRegion, event, (RegionEntry)this);
                success = true;
                super.applyBatchOperationOnNewEntry(txState, lockPolicy, txrs, region, dataRegion, regionValue, entry, lockedForRead, checkForTXFinish, event);
            }
            finally {
                indexUpdater.postEvent(dataRegion, event, (RegionEntry)this, success);
            }
        } else {
            super.applyBatchOperationOnNewEntry(txState, lockPolicy, txrs, region, dataRegion, regionValue, entry, lockedForRead, checkForTXFinish, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyBatchOperationOnExistingEntry(TXState txState, TXRegionState txrs, LocalRegion region, LocalRegion dataRegion, TXEntryState currentTXEntry, EntryEventImpl event, int lockFlags, AbstractOperationMessage msg) {
        IndexUpdater indexUpdater = dataRegion.getIndexUpdater();
        if (this.isDirty() && indexUpdater != null) {
            GfxdTXEntryState gfxdEntry = (GfxdTXEntryState)currentTXEntry;
            if (this.isOpDestroy()) {
                if (gfxdEntry.isOpDestroy() && gfxdEntry.op >= this.op) {
                    return;
                }
                if (this.pendingDelta != null || this.pendingValue != null) {
                    Assert.fail((Object)("unexpected delta or value received for destroyed key=" + this.regionKey + ", in region " + region.getFullPath() + ": " + this.toString()));
                }
                event.setOperation(Operation.DESTROY);
                event.setNewValue(null);
            } else if (gfxdEntry.isOpDestroy()) {
                if (this.pendingDelta != null) {
                    Assert.fail((Object)("unexpected delta received for previously destroyed key=" + this.regionKey + ", in region " + region.getFullPath() + ": " + this.pendingDelta));
                }
                event.setOperation(Operation.CREATE);
                event.setNewValue(this.pendingValue);
            } else {
                if (this.pendingValue != null) {
                    if (gfxdEntry.isOpCreate() || gfxdEntry.isOpPut()) {
                        return;
                    }
                    Assert.fail((Object)("unexpected full value received for existing entry " + currentTXEntry + ", in region " + region.getFullPath() + ": " + this.pendingValue));
                }
                event.setOperation(Operation.UPDATE);
                event.setNewDelta(this.pendingDelta);
            }
            event.setRegion(region);
            event.setKey(this.regionKey);
            event.setTXOldValue(gfxdEntry.getValueInTXOrRegion());
            event.setCallbackArgument(this.getCallbackArgument());
            event.setSkipDistributionOps();
            event.setContextObject(null);
            boolean success = false;
            try {
                indexUpdater.onEvent(dataRegion, event, (RegionEntry)gfxdEntry);
                success = true;
                super.applyBatchOperationOnExistingEntry(txState, txrs, region, dataRegion, currentTXEntry, event, lockFlags, msg);
            }
            finally {
                indexUpdater.postEvent(dataRegion, event, (RegionEntry)gfxdEntry, success);
            }
        } else {
            super.applyBatchOperationOnExistingEntry(txState, txrs, region, dataRegion, currentTXEntry, event, lockFlags, msg);
        }
    }

    @Override
    public RegionEntry getRegionEntry() {
        return this;
    }

    @Override
    public Object getValue(GemFireContainer baseContainer) {
        return super.getRetainedValueInTXOrRegion();
    }

    @Override
    public Object getValueWithoutFaultIn(GemFireContainer baseContainer) {
        return super.getRetainedValueInTXOrRegion();
    }

    @Override
    public final ExecRow getRow(GemFireContainer baseContainer) throws StandardException {
        Object value;
        RegionEntry entry = this.regionEntry;
        if (this.isDirty()) {
            Object value2 = this.getNearSidePendingValue();
            return baseContainer.newExecRow(entry, value2, baseContainer.getExtraTableInfo(), true);
        }
        if (entry != null && !Token.isRemoved((Object)(value = this.originalVersionId))) {
            return baseContainer.newExecRow(entry, value, (ExtraTableInfo)entry.getContainerInfo(), true);
        }
        return null;
    }

    @Override
    public final ExecRow getRowWithoutFaultIn(GemFireContainer baseContainer) throws StandardException {
        return this.getRow(baseContainer);
    }

    @Override
    public ExtraTableInfo getTableInfo(GemFireContainer baseContainer) {
        if (this.isDirty()) {
            return baseContainer.getExtraTableInfo();
        }
        if (this.regionEntry != null) {
            return (ExtraTableInfo)this.regionEntry.getContainerInfo();
        }
        return null;
    }

    public RowLocation getRegionRowLocation() {
        return (RowLocation)this.regionEntry;
    }

    @Override
    public int estimateMemoryUsage() {
        return ClassSize.refSize;
    }

    @Override
    public int getTypeFormatId() {
        return 96;
    }

    @Override
    public int getBucketID() {
        if (this.regionEntry != null) {
            return ((RowLocation)this.regionEntry).getBucketID();
        }
        return -1;
    }

    @Override
    public final Object cloneObject() {
        return this;
    }

    @Override
    public final RowLocation getClone() {
        return this;
    }

    @Override
    public final int compare(DataValueDescriptor other) {
        if (this == other) {
            return 0;
        }
        return this.hashCode() - other.hashCode();
    }

    @Override
    public DataValueDescriptor recycle() {
        return this;
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return DataValueFactory.DUMMY;
    }

    @Override
    public boolean isNull() {
        return this == DataValueFactory.DUMMY;
    }

    @Override
    public Object getObject() throws StandardException {
        return this;
    }

    public Object getValueInVMOrDiskWithoutFaultIn(LocalRegion owner) {
        return super.getRetainedValueInTXOrRegion();
    }

    public boolean isRemoved() {
        return !this.existsLocally();
    }

    @Override
    public boolean isDestroyedOrRemoved() {
        return !this.existsLocally();
    }

    public Object getValue(RegionEntryContext context) {
        return super.getRetainedValueInTXOrRegion();
    }

    public Object _getValue() {
        return super.getValueInTXOrRegion();
    }

    @Override
    public Object getKey() {
        return this.regionKey;
    }

    @Override
    public Object getKeyCopy() {
        return this.regionKey;
    }

    @Override
    public Object getRawKey() {
        return this.regionKey;
    }

    public Object _getValueRetain(RegionEntryContext context, boolean decompress) {
        return super.getRetainedValueInTXOrRegion();
    }

    public Token getValueAsToken() {
        Object v = super.getValueInTXOrRegion();
        return v instanceof Token ? (Token)v : null;
    }

    public Object getValueOffHeapOrDiskWithoutFaultIn(LocalRegion owner) {
        return super.getRetainedValueInTXOrRegion();
    }

    public boolean isValueNull() {
        return super.getValueInTXOrRegion() == null;
    }

    public boolean isInvalid() {
        return Token.isInvalid((Object)super.getValueInTXOrRegion());
    }

    public boolean isDestroyed() {
        return Token.isDestroyed((Object)super.getValueInTXOrRegion());
    }

    public boolean isDestroyedOrRemovedButNotTombstone() {
        Token o = this.getValueAsToken();
        return o == Token.DESTROYED || o == Token.REMOVED_PHASE1 || o == Token.REMOVED_PHASE2;
    }

    public boolean isInvalidOrRemoved() {
        return Token.isInvalidOrRemoved((Object)super.getValueInTXOrRegion());
    }

    public boolean isOffHeap() {
        return false;
    }

    protected final void setCallbackArgument(Object callbackArgument) {
        GfxdCallbackArgument sca;
        if (callbackArgument instanceof GfxdCallbackArgument && (sca = (GfxdCallbackArgument)callbackArgument).isThreadLocalInstance()) {
            Object currentCallbackArg = this.getCallbackArgument();
            if (currentCallbackArg != null && sca.equals(currentCallbackArg)) {
                return;
            }
            callbackArgument = sca.cloneObject();
        }
        super.setCallbackArgument(callbackArgument);
    }

    private void cleanupReplacedUniqEntries() {
        Object key = null;
        for (WrapperRowLocationForTxn e : this.replacedEntriesForUniqIndexes) {
            try {
                boolean replaced;
                if (e == null) continue;
                ConcurrentSkipListMap<Object, Object> skipListMap = e.getIndexContainer().getSkipListMap();
                assert (skipListMap != null);
                key = e.getIndexKey();
                if (GemFireXDUtils.TraceIndex) {
                    GfxdIndexManager.traceIndex("GfxdTXEntryState: replacing value of key=%s from wrapper=%s to %s in (%s) for TX: %s", key, e, this.regionEntry, e.getIndexContainer(), this.getTXId());
                }
                if (replaced = skipListMap.replace(key, (Object)e, (Object)this.regionEntry)) continue;
                SanityManager.THROWASSERT((String)("GfxdTXEntryState: failed to replace key=" + ArrayUtils.objectString((Object)key) + " from wrapper=" + e + " to " + this.regionEntry + " in (" + e.getIndexContainer() + ") for TX: " + this.getTXId()));
            }
            catch (Exception ex) {
                Misc.getCacheLogWriter().error("unexpected exception during reinstating indexes for key=" + ArrayUtils.objectString(key) + " in index = " + e.getIndexContainer(), (Throwable)ex);
            }
        }
        this.replacedEntriesForUniqIndexes = null;
    }

    protected final void cleanup(TXState txState, LocalRegion r, LockingPolicy lockPolicy, LockMode writeMode, boolean removeFromList, boolean removeFromMap, Boolean forCommit) {
        int change;
        if (this.replacedEntriesForUniqIndexes != null) {
            this.cleanupReplacedUniqEntries();
        }
        super.cleanup(txState, r, lockPolicy, writeMode, removeFromList, removeFromMap, forCommit);
        if (forCommit != null && forCommit.booleanValue() && (change = this.entryCountMod()) != 0) {
            this.getBaseContainer().updateNumRows(change < 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WrapperRowLocationForTxn wrapperForRollback(GemFireContainer indexContainer, Object oldKey) {
        if (this.wasCreatedByTX()) {
            return null;
        }
        if (!this.isOpPut() && !this.isOpDestroy() && GemFireXDUtils.TraceTran | GemFireXDUtils.TraceQuery) {
            SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("op is: " + this.op + " and opToString returns: " + this.opToString()));
        }
        boolean isOpDestroy = this.isOpDestroy();
        assert (this.isOpPut() || isOpDestroy);
        TXRegionState txrs = this.txRegionState;
        txrs.lock();
        try {
            int insertIndex;
            THashMapWithKeyPair reinstateMap = txrs.getToBeReinstatedIndexMap();
            if (reinstateMap == null) {
                reinstateMap = new THashMapWithKeyPair((TObjectHashingStrategy)ObjectEqualsHashingStrategy.getInstance(), (HashingStats)this.getDataRegion().getCachePerfStats());
                txrs.setToBeReinstatedIndexMap(reinstateMap);
                insertIndex = reinstateMap.insertionIndex((Object)this, (Object)indexContainer);
            } else {
                insertIndex = reinstateMap.insertionIndex((Object)this, (Object)indexContainer);
                if (insertIndex < 0) {
                    WrapperRowLocationForTxn wrapperRowLocationForTxn = null;
                    return wrapperRowLocationForTxn;
                }
            }
            WrapperRowLocationForTxn wrapper = new WrapperRowLocationForTxn(this, oldKey, !isOpDestroy);
            Object old = reinstateMap.putIfAbsent((Object)this, (Object)indexContainer, (Object)wrapper, insertIndex);
            WrapperRowLocationForTxn wrapperRowLocationForTxn = old == null ? wrapper : (WrapperRowLocationForTxn)old;
            return wrapperRowLocationForTxn;
        }
        finally {
            txrs.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateIndexInfos(GemFireContainer indexContainer, Object newKey) {
        TXRegionState txrs = this.txRegionState;
        txrs.lock();
        try {
            THashMapWithKeyPair indexInfoMap = txrs.getTransactionalIndexInfoMap();
            if (indexInfoMap == null) {
                indexInfoMap = new THashMapWithKeyPair((TObjectHashingStrategy)ObjectEqualsHashingStrategy.getInstance(), (HashingStats)this.getDataRegion().getCachePerfStats());
                txrs.setTransactionalIndexInfoMap(indexInfoMap);
            }
            indexInfoMap.put((Object)this, (Object)indexContainer, newKey);
        }
        finally {
            txrs.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearIndexInfos(GemFireContainer indexContainer) {
        TXRegionState txrs = this.txRegionState;
        txrs.lock();
        try {
            THashMapWithKeyPair indexInfoMap = txrs.getTransactionalIndexInfoMap();
            if (indexInfoMap != null) {
                indexInfoMap.removeKeyPair((Object)this, (Object)indexContainer);
            }
            if ((indexInfoMap = txrs.getUnaffectedIndexInfoMap()) != null) {
                indexInfoMap.removeKeyPair((Object)this, (Object)indexContainer);
            }
            if (this.replacedEntriesForUniqIndexes != null) {
                this.cleanupReplacedUniqEntries();
            }
        }
        finally {
            txrs.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUnaffectedIndexInfos(GemFireContainer indexContainer, ExtractingIndexKey indexKey) {
        TXRegionState txrs = this.txRegionState;
        txrs.lock();
        try {
            THashMapWithKeyPair indexInfoMap = txrs.getUnaffectedIndexInfoMap();
            if (indexInfoMap == null) {
                indexInfoMap = new THashMapWithKeyPair((TObjectHashingStrategy)ObjectEqualsHashingStrategy.getInstance(), (HashingStats)this.getDataRegion().getCachePerfStats());
                txrs.setUnaffectedIndexInfoMap(indexInfoMap);
            }
            indexInfoMap.put((Object)this, (Object)indexContainer, (Object)indexKey);
        }
        finally {
            txrs.unlock();
        }
    }

    public void addUniqIdxInfosForReplacedEntries(GemFireContainer indexContainer, Object key, WrapperRowLocationForTxn wrapper) {
        if (this.replacedEntriesForUniqIndexes == null) {
            this.replacedEntriesForUniqIndexes = new ArrayList(4);
        }
        wrapper.setIndexContainer(indexContainer);
        wrapper.setIndexKey(key);
        this.replacedEntriesForUniqIndexes.add(wrapper);
    }

    public Object getContainerInfo() {
        if (this.isDirty()) {
            return this.getBaseContainer().getExtraTableInfo();
        }
        if (this.regionEntry instanceof RowLocation) {
            return this.regionEntry.getContainerInfo();
        }
        return null;
    }

    public Object setContainerInfo(LocalRegion owner, Object val) {
        return null;
    }

    protected final GemFireContainer getBaseContainer() {
        return (GemFireContainer)this.getBaseRegion().getUserAttribute();
    }

    @Override
    public void checkHostVariable(int declaredLength) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public DataValueDescriptor coalesce(DataValueDescriptor[] list, DataValueDescriptor returnValue) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public int compare(DataValueDescriptor other, boolean nullsOrderedLow) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public boolean compare(int op, DataValueDescriptor other, boolean orderedNulls, boolean unknownRV) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public boolean compare(int op, DataValueDescriptor other, boolean orderedNulls, boolean nullsOrderedLow, boolean unknownRV) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public BooleanDataValue equals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public void fromDataForOptimizedResultHolder(DataInput dis) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public boolean getBoolean() throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public byte getByte() throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public byte[] getBytes() throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public Date getDate(Calendar cal) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public double getDouble() throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public float getFloat() throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public int getInt() throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public int getLength() throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public int getLengthInBytes(DataTypeDescriptor dtd) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public long getLong() throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public short getShort() throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public InputStream getStream() throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public String getString() throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public Time getTime(Calendar cal) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public Timestamp getTimestamp(Calendar cal) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public String getTraceString() throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public String getTypeName() {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public BooleanDataValue greaterOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public BooleanDataValue greaterThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public BooleanDataValue in(DataValueDescriptor left, DataValueDescriptor[] inList, boolean orderedList) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public BooleanDataValue isNotNull() {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public BooleanDataValue lessOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public BooleanDataValue lessThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public void normalize(DataTypeDescriptor dtd, DataValueDescriptor source) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public BooleanDataValue notEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public void readExternalFromArray(ArrayInputStream ais) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public void setBigDecimal(Number bigDecimal) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public void setInto(PreparedStatement ps, int position) throws SQLException, StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public void setInto(ResultSet rs, int position) throws SQLException, StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public void setObjectForCast(Object value, boolean instanceOfResultType, String resultTypeClassName) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public void setToNull() {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public void setValue(int theValue) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public void setValue(double theValue) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public void setValue(float theValue) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public void setValue(short theValue) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public void setValue(long theValue) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public void setValue(byte theValue) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public void setValue(boolean theValue) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public void setValue(Object theValue) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public void setValue(byte[] theValue) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public void setValue(String theValue) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public void setValue(Time theValue) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public void setValue(Time theValue, Calendar cal) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public void setValue(Timestamp theValue) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public void setValue(Timestamp theValue, Calendar cal) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public void setValue(Date theValue) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public void setValue(Date theValue, Calendar cal) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public void setValue(DataValueDescriptor theValue) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public void setValue(InputStream theStream, int valueLength) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public void setValue(Blob theValue) {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public void setValue(Clob theValue) {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) throws StandardException, SQLException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public void toDataForOptimizedResultHolder(DataOutput dos) throws IOException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public int typePrecedence() {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public int typeToBigDecimal() throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public int writeBytes(byte[] outBytes, int offset, DataTypeDescriptor dtd) {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public int computeHashCode(int maxWidth, int hash) {
        throw new UnsupportedOperationException("unexpected invocation for " + this.toString());
    }

    @Override
    public void restoreToNull() {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    public int getDSFID() {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    public void toData(DataOutput out) throws IOException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    public void setOwner(LocalRegion owner, Object previousOwner) {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    public boolean destroy(LocalRegion region, EntryEventImpl event, boolean inTokenMode, boolean cacheWrite, Object expectedOldValue, boolean forceDestroy, boolean removeRecoveredEntry) throws CacheWriterException, EntryNotFoundException, TimeoutException, RegionClearedException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    public boolean dispatchListenerEvents(EntryEventImpl event) throws InterruptedException {
        throw new UnsupportedOperationException("unexpected invocation for " + this.toString());
    }

    public boolean fillInValue(LocalRegion r, InitialImageOperation.Entry entry, DM mgr, Version targetVersion) {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    public long getHitCount() throws InternalStatisticsDisabledException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    public long getLastAccessed() throws InternalStatisticsDisabledException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    public long getLastModified() {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    public void _setLastModified(long lastModified) {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    public void setLastModified(long lastModified) {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    public boolean isLockedForCreate() {
        return true;
    }

    public long getMissCount() throws InternalStatisticsDisabledException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    public Object getSerializedValueOnDisk(LocalRegion localRegion) {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    public Object getValueInVM(RegionEntryContext context) {
        return this.getValueInVM(this.regionKey);
    }

    public Object getValueOnDisk(LocalRegion r) throws EntryNotFoundException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    public Object getValueOnDiskOrBuffer(LocalRegion r) throws EntryNotFoundException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    public boolean hasStats() {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    public boolean initialImageInit(LocalRegion region, long lastModified, Object newValue, boolean create, boolean wasRecovered, boolean acceptedVersionTag) throws RegionClearedException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    public boolean initialImagePut(LocalRegion region, long lastModified, Object newValue, boolean wasRecovered, boolean acceptedVersionTag) throws RegionClearedException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    public boolean isOverflowedToDisk(LocalRegion r, DistributedRegion.DiskPosition dp, boolean alwaysFetchPosition) {
        return false;
    }

    public boolean isRemovedPhase2() {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    public void removePhase1(LocalRegion r, boolean clear) throws RegionClearedException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    public void removePhase2(LocalRegion r) {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    public void resetCounts() throws InternalStatisticsDisabledException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    public void setRecentlyUsed() {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    public void setValue(RegionEntryContext context, Object value) throws RegionClearedException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    public void txDidDestroy(long lastModifiedTime) {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    public void updateStatsForGet(boolean hit, long time) {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    public void updateStatsForPut(long lastModifiedTime) {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    public VersionStamp<?> getVersionStamp() {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    public boolean isTombstone() {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    public VersionTag<?> generateVersionTag(VersionSource member, boolean isRemoteVersionSource, boolean withDelta, LocalRegion region, EntryEventImpl event) {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    public void makeTombstone(LocalRegion r, VersionTag isOperationRemote) {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public boolean isUpdateInProgress() {
        RegionEntry re = this.regionEntry;
        return re != null && re.isUpdateInProgress();
    }

    public void setUpdateInProgress(boolean underUpdate) {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    public boolean isMarkedForEviction() {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    public void setMarkedForEviction() {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    public void clearMarkedForEviction() {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    public boolean isCacheListenerInvocationInProgress() {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    public void setCacheListenerInvocationInProgress(boolean isListenerInvoked) {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public BooleanDataValue isNullOp() {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public final int nCols() {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public final DataValueDescriptor getKeyColumn(int index) {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public final void getKeyColumns(DataValueDescriptor[] keys) {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public final void getKeyColumns(Object[] keys) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public boolean compare(int op, ExecRow row, boolean byteArrayStore, int colIdx, boolean orderedNulls, boolean unknownRV) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public boolean compare(int op, CompactCompositeKey key, int colIdx, boolean orderedNulls, boolean unknownRV) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public boolean canCompareBytesToBytes() {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public int equals(RowFormatter rf, byte[] bytes, boolean isKeyBytes, int logicalPosition, int keyBytesPos, DataValueDescriptor[] outDVD) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    public void setRegionContext(LocalRegion region) {
        throw new UnsupportedOperationException("unexpected invocation for " + this.toString());
    }

    public Object prepareValueForCache(RegionEntryContext r, Object val, boolean isEntryUpdate, boolean valHasMetadataForGfxdOffHeapUpdate) {
        throw new UnsupportedOperationException("unexpected invocation for " + this.toString());
    }

    public final KeyWithRegionContext beforeSerializationWithValue(boolean valueIsToken) {
        throw new UnsupportedOperationException("unexpected invocation for " + this.toString());
    }

    public final void afterDeserializationWithValue(Object val) {
        throw new UnsupportedOperationException("unexpected invocation for " + this.toString());
    }

    public Object getOwnerId(Object context) {
        throw new UnsupportedOperationException("unexpected invocation for " + this.toString());
    }

    public boolean attemptLock(LockMode mode, int flags, LockingPolicy lockPolicy, long msecs, Object owner, Object context) {
        throw new UnsupportedOperationException("unexpected invocation for " + this.toString());
    }

    public void releaseLock(LockMode mode, boolean releaseAll, Object owner, Object context) {
        throw new UnsupportedOperationException("unexpected invocation for " + this.toString());
    }

    public int numSharedLocks() {
        throw new UnsupportedOperationException("unexpected invocation for " + this.toString());
    }

    public int numReadOnlyLocks() {
        throw new UnsupportedOperationException("unexpected invocation for " + this.toString());
    }

    public boolean hasExclusiveLock(Object owner, Object context) {
        throw new UnsupportedOperationException("unexpected invocation for " + this.toString());
    }

    public boolean hasExclusiveSharedLock(Object owner, Object context) {
        throw new UnsupportedOperationException("unexpected invocation for " + this.toString());
    }

    public int getState() {
        throw new UnsupportedOperationException("unexpected invocation for " + this.toString());
    }

    public boolean hasAnyLock() {
        throw new UnsupportedOperationException("unexpected invocation for " + this.toString());
    }

    @Override
    public byte getTypeId() {
        throw new UnsupportedOperationException("Implement the method for DataType=" + this);
    }

    @Override
    public void writeNullDVD(DataOutput out) throws IOException {
        throw new UnsupportedOperationException("Implement the method for DataType=" + this);
    }

    public void setValueWithTombstoneCheck(Object value, EntryEvent event) throws RegionClearedException {
        throw new UnsupportedOperationException("unexpected invocation for " + this.toString());
    }

    public void setValueToNull(RegionEntryContext context) {
        throw new UnsupportedOperationException("unexpected invocation for " + this.toString());
    }

    public void returnToPool() {
        throw new UnsupportedOperationException("unexpected invocation for " + this.toString());
    }

    @Override
    public int readBytes(byte[] inBytes, int offset, int columnWidth) {
        throw new UnsupportedOperationException("unexpected invocation for " + this.getClass());
    }

    @Override
    public int readBytes(long memOffset, int columnWidth, ByteSource bs) {
        throw new UnsupportedOperationException("unexpected invocation for " + this.getClass());
    }

    @Override
    public Object getValueWithoutFaultInOrOffHeapEntry(LocalRegion owner) {
        return super.getRetainedValueInTXOrRegion();
    }

    @Override
    public Object getValueOrOffHeapEntry(LocalRegion owner) {
        return this.getValue((RegionEntryContext)owner);
    }

    @Override
    public Object getRawValue() {
        return this._getValue();
    }

    @Override
    public void markDeleteFromIndexInProgress() {
    }

    @Override
    public void unmarkDeleteFromIndexInProgress() {
    }

    @Override
    public boolean useRowLocationForIndexKey() {
        return true;
    }

    @Override
    public void endIndexKeyUpdate() {
    }

    public Version[] getSerializationVersions() {
        return null;
    }
}

