/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.execute;

import com.gemstone.gemfire.GemFireException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.PartitionedRegionDistributionException;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.DMLQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.DynamicKey;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.reflect.GemFireActivationClass;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireActivation;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireResultSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.ActivationStatisticsVisitor;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireDeleteResultSet;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecPreparedStatement;

public final class GemFireDeleteActivation
extends AbstractGemFireActivation {
    private final GemFireContainer container;

    public GemFireDeleteActivation(ExecPreparedStatement st, LanguageConnectionContext _lcc, DMLQueryInfo qi, GemFireActivationClass gc) throws StandardException {
        super(st, _lcc, qi);
        this.container = (GemFireContainer)this.qInfo.getRegion().getUserAttribute();
    }

    @Override
    protected AbstractGemFireResultSet createResultSet(int resultsetNum) throws StandardException {
        return new GemFireDeleteResultSet(this);
    }

    @Override
    protected void executeWithResultSet(AbstractGemFireResultSet rs) throws StandardException {
        LanguageConnectionContext lcc = this.getLanguageConnectionContext();
        GemFireTransaction tran = (GemFireTransaction)lcc.getTransactionExecute();
        TXStateInterface tx = this.container.getActiveTXState(tran);
        boolean isTransactional = tx != null;
        Object pk = this.qInfo.getPrimaryKey();
        Object[] gfKeys = null;
        if (pk instanceof Object[]) {
            if (this.qInfo.isWhereClauseDynamic()) {
                Object[] pks = (Object[])pk;
                int len = pks.length;
                gfKeys = new Object[len];
                for (int i = 0; i < len; ++i) {
                    if (!(pks[i] instanceof DynamicKey)) continue;
                    DynamicKey dk = (DynamicKey)pks[i];
                    gfKeys[i] = dk.getEvaluatedPrimaryKey(this, this.container, isTransactional);
                }
            } else {
                gfKeys = (Object[])pk;
            }
        } else {
            gfKeys = new Object[1];
            if (this.qInfo.isWhereClauseDynamic()) {
                DynamicKey dk = (DynamicKey)pk;
                pk = dk.getEvaluatedPrimaryKey(this, this.container, isTransactional);
            }
            gfKeys[0] = pk;
        }
        if (this.observer != null) {
            this.observer.beforeGemFireResultSetExecuteOnActivation(this);
        }
        int numRowsModified = 0;
        for (int i = 0; i < gfKeys.length; ++i) {
            try {
                LocalRegion rgn;
                this.container.pkBasedDelete(gfKeys[i], tran, tx, lcc);
                if (isTransactional && (rgn = this.container.getRegion()).isSerialWanEnabled()) {
                    this.distributeBulkOpToDBSynchronizer(rgn, this.qInfo.isDynamic(), tran, this.lcc.isSkipListeners());
                }
                ++numRowsModified;
                continue;
            }
            catch (PartitionedRegionDistributionException prde) {
                if (prde.getCause() instanceof EntryNotFoundException) continue;
                throw prde;
            }
            catch (EntryNotFoundException enfe) {
                GemFireXDUtils.checkForInsufficientDataStore(this.container.getRegion());
                continue;
            }
            catch (GemFireException gfeex) {
                throw Misc.processGemFireException(gfeex, gfeex, "execution of " + this.preStmt.getSource(), true);
            }
        }
        if (this.observer != null) {
            this.observer.afterGemFireResultSetExecuteOnActivation(this);
        }
        rs.setNumRowsModified(numRowsModified);
    }

    @Override
    public void accept(ActivationStatisticsVisitor visitor) {
        visitor.visit(this);
    }
}

