/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.diag;

import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.execute.InternalResultSender;
import com.gemstone.gemfire.internal.shared.StringPrintWriter;
import com.pivotal.gemfirexd.FabricService;
import com.pivotal.gemfirexd.FabricServiceManager;
import com.pivotal.gemfirexd.internal.engine.GfxdVTITemplate;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.UpdateVTITemplate;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdDistributionAdvisor;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdListResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.message.GfxdConfigMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.engine.store.ServerGroupUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSetMetaData;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.impl.sql.GenericColumnDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.BaseActivation;
import com.pivotal.gemfirexd.internal.shared.common.SharedUtils;
import com.pivotal.gemfirexd.internal.vti.VTIEnvironment;
import java.io.PrintWriter;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public final class DistributedMembers
extends UpdateVTITemplate {
    private final DM dm = Misc.getDistributedSystem().getDistributionManager();
    private Iterator<InternalDistributedMember> memberIter;
    private volatile Map<DistributedMember, Properties[]> memberPropsMap;
    private InternalDistributedMember currentMember;
    private static final String NOT_AVAIL_TOKEN = "NOT AVAILABLE";
    private Activation activation;
    public static final String MEMBERID = "ID";
    public static final String VMKIND = "KIND";
    public static final String STATUS = "STATUS";
    public static final String HOSTDATA = "HOSTDATA";
    public static final String ISELDER = "ISELDER";
    public static final String IPADDRESS = "IPADDRESS";
    public static final String HOST = "HOST";
    public static final String PID = "PID";
    public static final String PORT = "PORT";
    public static final String ROLES = "ROLES";
    public static final String NETSERVERS = "NETSERVERS";
    public static final String THRIFTSERVERS = "THRIFTSERVERS";
    public static final String LOCATOR = "LOCATOR";
    public static final String SERVERGROUPS = "SERVERGROUPS";
    public static final String SYSTEMPROPS = "SYSTEMPROPS";
    public static final String GFEPROPS = "GEMFIREPROPS";
    public static final String GFXDPROPS = "BOOTPROPS";
    public static final String MANAGERINFO = "MANAGERINFO";
    private static final ResultColumnDescriptor[] columnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("ID", 12, false, 128), EmbedResultSetMetaData.getResultColumnDescriptor("KIND", 12, false, 24), EmbedResultSetMetaData.getResultColumnDescriptor("STATUS", 12, false, 24), new GenericColumnDescriptor("HOSTDATA", "SYS", "MEMBERS", -1, DataTypeDescriptor.getBuiltInDataTypeDescriptor(16, true), true, false), EmbedResultSetMetaData.getResultColumnDescriptor("ISELDER", 16, false), EmbedResultSetMetaData.getResultColumnDescriptor("IPADDRESS", 12, true, 64), EmbedResultSetMetaData.getResultColumnDescriptor("HOST", 12, true, 128), EmbedResultSetMetaData.getResultColumnDescriptor("PID", 4, false), EmbedResultSetMetaData.getResultColumnDescriptor("PORT", 4, false), EmbedResultSetMetaData.getResultColumnDescriptor("ROLES", 12, false, 128), EmbedResultSetMetaData.getResultColumnDescriptor("NETSERVERS", 12, false, 32672), EmbedResultSetMetaData.getResultColumnDescriptor("THRIFTSERVERS", 12, false, 32672), EmbedResultSetMetaData.getResultColumnDescriptor("LOCATOR", 12, true, 32672), new GenericColumnDescriptor("SERVERGROUPS", "SYS", "MEMBERS", -1, DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, false, 32672), true, false), EmbedResultSetMetaData.getResultColumnDescriptor("MANAGERINFO", 12, false, 128), EmbedResultSetMetaData.getResultColumnDescriptor("SYSTEMPROPS", 2005, false), EmbedResultSetMetaData.getResultColumnDescriptor("GEMFIREPROPS", 2005, false), EmbedResultSetMetaData.getResultColumnDescriptor("BOOTPROPS", 2005, false)};
    private static final ResultSetMetaData metadata = new EmbedResultSetMetaData(columnInfo);

    @Override
    public boolean next() throws SQLException {
        try {
            if (this.memberIter == null) {
                HashSet<InternalDistributedMember> allMembers = new HashSet<InternalDistributedMember>();
                if (this.activation != null && this.activation.getFunctionContext() != null && ((InternalResultSender)this.activation.getFunctionContext().getResultSender()).isLocallyExecuted()) {
                    Set allDMs = this.dm.getDistributionManagerIdsIncludingAdmin();
                    Set nonAdminDMs = this.dm.getDistributionManagerIds();
                    allMembers.addAll(allDMs);
                    allMembers.removeAll(nonAdminDMs);
                    allMembers.add(Misc.getMyId());
                } else {
                    allMembers.add(Misc.getMyId());
                }
                this.memberIter = allMembers.iterator();
            }
            if (this.memberIter.hasNext()) {
                this.currentMember = this.memberIter.next();
                this.wasNull = false;
                if (GemFireXDUtils.TraceMembers) {
                    SanityManager.DEBUG_PRINT((String)"TraceMembers", (String)("DistributedMembers#next: read new member [" + this.currentMember + "] with profile: " + GemFireXDUtils.getGfxdProfile((DistributedMember)this.currentMember)));
                }
                return true;
            }
        }
        catch (Throwable t) {
            throw Util.javaException(t);
        }
        this.activation = null;
        return false;
    }

    @Override
    public boolean getBoolean(int columnNumber) {
        ResultColumnDescriptor desc = columnInfo[columnNumber - 1];
        if (desc.getType().getJDBCTypeId() != 16) {
            this.dataTypeConversion("boolean", desc);
        }
        this.wasNull = false;
        String columnName = desc.getName();
        if (HOSTDATA.equals(columnName)) {
            GemFireStore.VMKind vmKind = GemFireXDUtils.getVMKind((DistributedMember)this.currentMember);
            if (vmKind != null) {
                return vmKind == GemFireStore.VMKind.DATASTORE;
            }
            this.wasNull = true;
            return false;
        }
        if (ISELDER.equals(columnName)) {
            return this.currentMember.equals(this.dm.getElderId());
        }
        throw new GemFireXDRuntimeException("unexpected columnName " + columnName);
    }

    @Override
    public int getInt(int columnNumber) {
        ResultColumnDescriptor desc = columnInfo[columnNumber - 1];
        if (desc.getType().getJDBCTypeId() != 4) {
            this.dataTypeConversion("integer", desc);
        }
        this.wasNull = false;
        String columnName = desc.getName();
        if (PID.equals(columnName)) {
            return this.currentMember.getProcessId();
        }
        if (PORT.equals(columnName)) {
            return this.currentMember.getPort();
        }
        throw new GemFireXDRuntimeException("unexpected columnName " + columnName);
    }

    @Override
    public Object getObjectForColumn(int columnNumber) throws SQLException {
        Object res;
        ResultColumnDescriptor desc = columnInfo[columnNumber - 1];
        String columnName = desc.getName();
        if (MEMBERID.equals(columnName)) {
            res = this.currentMember.getId();
        } else if (VMKIND.equals(columnName)) {
            GemFireStore.VMKind vmKind = GemFireXDUtils.getVMKind((DistributedMember)this.currentMember);
            StringBuilder sb = new StringBuilder();
            if (vmKind != null) {
                sb.append(vmKind.toString()).append('(');
            }
            switch (this.currentMember.getVmKind()) {
                case 10: {
                    sb.append("normal");
                    break;
                }
                case 12: {
                    sb.append("admin");
                    break;
                }
                case 13: {
                    sb.append("loner");
                    break;
                }
                default: {
                    sb.append("unknown[" + this.currentMember.getVmKind() + ']');
                }
            }
            if (vmKind != null) {
                sb.append(')');
            }
            res = sb.toString();
        } else if (STATUS.equals(columnName)) {
            FabricService service = FabricServiceManager.currentFabricServiceInstance();
            res = service != null ? service.serviceStatus().name() : "UNKNOWN";
        } else if (HOSTDATA.equals(columnName)) {
            GemFireStore.VMKind vmKind = GemFireXDUtils.getVMKind((DistributedMember)this.currentMember);
            res = vmKind != null ? Boolean.valueOf(vmKind == GemFireStore.VMKind.DATASTORE) : null;
        } else if (ISELDER.equals(columnName)) {
            res = this.currentMember.equals(this.dm.getElderId());
        } else if (IPADDRESS.equals(columnName)) {
            res = this.currentMember.getIpAddress().toString();
        } else if (HOST.equals(columnName)) {
            res = this.currentMember.getHost();
        } else if (PID.equals(columnName)) {
            res = this.currentMember.getProcessId();
        } else if (PORT.equals(columnName)) {
            res = this.currentMember.getPort();
        } else if (ROLES.equals(columnName)) {
            TreeSet sortedRoles = new TreeSet(this.currentMember.getRoles());
            res = SharedUtils.toCSV(sortedRoles);
        } else if (NETSERVERS.equals(columnName)) {
            String drdaServers;
            GfxdDistributionAdvisor advisor = GemFireXDUtils.getGfxdAdvisor();
            String thriftServers = advisor.getThriftServers((DistributedMember)this.currentMember);
            res = thriftServers.isEmpty() ? advisor.getDRDAServers((DistributedMember)this.currentMember) : ((drdaServers = advisor.getDRDAServers((DistributedMember)this.currentMember)).isEmpty() ? thriftServers : thriftServers + ',' + drdaServers);
        } else if (THRIFTSERVERS.equals(columnName)) {
            res = GemFireXDUtils.getGfxdAdvisor().getThriftServers((DistributedMember)this.currentMember);
        } else if (LOCATOR.equals(columnName)) {
            res = GemFireXDUtils.getGfxdAdvisor().getServerLocator((DistributedMember)this.currentMember);
        } else if (MANAGERINFO.equals(columnName)) {
            res = GemFireXDUtils.getManagerInfo((DistributedMember)this.currentMember);
        } else if (SERVERGROUPS.equals(columnName)) {
            SortedSet<String> groups = ServerGroupUtils.getServerGroups((DistributedMember)this.currentMember);
            res = SharedUtils.toCSV(groups);
        } else if (SYSTEMPROPS.equals(columnName)) {
            Properties[] memberRes = this.getMemberPropsMap().get(this.currentMember);
            if (memberRes != null) {
                StringPrintWriter pw = new StringPrintWriter();
                pw.println();
                res = GemFireXDUtils.dumpProperties(memberRes[0], "System Properties", "", true, (PrintWriter)pw).toString();
            } else {
                res = NOT_AVAIL_TOKEN;
            }
        } else if (GFEPROPS.equals(columnName)) {
            Properties[] memberRes = this.getMemberPropsMap().get(this.currentMember);
            if (memberRes != null) {
                StringPrintWriter pw = new StringPrintWriter();
                pw.println();
                res = GemFireXDUtils.dumpProperties(memberRes[1], "GemFire Properties", "", true, (PrintWriter)pw).toString();
            } else {
                res = NOT_AVAIL_TOKEN;
            }
        } else if (GFXDPROPS.equals(columnName)) {
            Properties[] memberRes = this.getMemberPropsMap().get(this.currentMember);
            if (memberRes != null) {
                StringPrintWriter pw = new StringPrintWriter();
                pw.println();
                res = GemFireXDUtils.dumpProperties(memberRes[2], "GemFireXD Properties", "", true, (PrintWriter)pw).toString();
            } else {
                res = "NOT GEMFIREXD";
            }
        } else {
            throw new GemFireXDRuntimeException("unexpected columnName " + columnName);
        }
        return res;
    }

    @Override
    public Activation getActivation() {
        return this.activation;
    }

    @Override
    public void setActivation(Activation act) {
        this.activation = act;
    }

    @Override
    public void updateRow(ExecRow row) throws StandardException {
        GemFireStore.VMKind vmKind = GemFireXDUtils.getVMKind((DistributedMember)this.currentMember);
        if (vmKind == null) {
            throw StandardException.newException("XJ124.S", new GemFireXDRuntimeException("Member with ID [" + this.currentMember.getId() + "] is not yet part of GemFireXD"));
        }
        BaseActivation activation = (BaseActivation)this.activation;
        boolean[] updatedColumns = activation.getUpdatedColumns();
        int[] projectMapping = activation.getProjectMapping();
        ArrayList<Integer> updatedColumnIndex = new ArrayList<Integer>();
        ArrayList<DataValueDescriptor> updatedDVDs = new ArrayList<DataValueDescriptor>();
        for (int colIndex = 0; colIndex < updatedColumns.length; ++colIndex) {
            if (!updatedColumns[colIndex]) continue;
            if (projectMapping != null) {
                updatedColumnIndex.add(projectMapping[colIndex] - 1);
                updatedDVDs.add(row.getColumn(colIndex + 1));
                continue;
            }
            updatedColumnIndex.add(colIndex);
            updatedDVDs.add(row.getColumn(colIndex + 1));
        }
        if (GemFireXDUtils.TraceMembers) {
            SanityManager.DEBUG_PRINT((String)"TraceMembers", (String)("DistributedMembers#updateRow: updating member [" + this.currentMember + "] having profile [" + GemFireXDUtils.getGfxdProfile((DistributedMember)this.currentMember) + " with new row: " + row));
        }
        for (int index = 0; index < updatedColumnIndex.size(); ++index) {
            int columnIndex = (Integer)updatedColumnIndex.get(index);
            ResultColumnDescriptor desc = columnInfo[columnIndex];
            String columnName = desc.getName();
            try {
                GfxdConfigMessage.Operation op;
                if (HOSTDATA.equals(columnName)) {
                    if (vmKind == GemFireStore.VMKind.LOCATOR) {
                        throw StandardException.newException("XJ124.S", new GemFireXDRuntimeException("Cannot update \"HOSTDATA\" column in GemFireXD locator with ID [" + this.currentMember.getId() + ']'));
                    }
                    op = GfxdConfigMessage.Operation.SET_CLIENT_OR_SERVER;
                } else if (SERVERGROUPS.equals(columnName)) {
                    if (vmKind == GemFireStore.VMKind.LOCATOR) {
                        throw StandardException.newException("XJ124.S", new GemFireXDRuntimeException("Cannot update \"SERVERGROUPS\" column in GemFireXD locator with ID [" + this.currentMember.getId() + ']'));
                    }
                    op = GfxdConfigMessage.Operation.SET_SERVERGROUPS;
                } else {
                    String cursorName = activation.getCursorName();
                    if (cursorName == null) {
                        activation.setCursorName(activation.getLanguageConnectionContext().getUniqueCursorName());
                        cursorName = activation.getCursorName();
                    }
                    throw StandardException.newException("42X31", (Object)columnName, (Object)cursorName);
                }
                DataValueDescriptor newDVD = (DataValueDescriptor)updatedDVDs.get(index);
                Object newVal = newDVD.isNull() ? null : newDVD.getObject();
                GfxdListResultCollector collector = new GfxdListResultCollector();
                GfxdConfigMessage<Object> msg = new GfxdConfigMessage<Object>(collector, Collections.singleton(this.currentMember), op, newVal, false);
                msg.executeFunction();
                continue;
            }
            catch (Throwable t) {
                throw StandardException.unexpectedUserException(t);
            }
        }
    }

    @Override
    public void close() throws SQLException {
        super.close();
        this.memberIter = null;
        this.memberPropsMap = null;
        this.currentMember = null;
        this.activation = null;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return metadata;
    }

    @Override
    public boolean isForUpdate() {
        return true;
    }

    @Override
    public double getEstimatedRowCount(VTIEnvironment vtiEnvironment) throws SQLException {
        return this.dm.getDistributionManagerIdsIncludingAdmin().size();
    }

    @Override
    public void setColumnDescriptorList(TableDescriptor td) {
        ColumnDescriptorList cdl = td.getColumnDescriptorList();
        for (int index = 0; index < columnInfo.length; ++index) {
            ResultColumnDescriptor rcd = columnInfo[index];
            ColumnDescriptor cd = new ColumnDescriptor(rcd.getName(), index + 1, rcd.getType(), null, null, td.getUUID(), null, 0L, 0L, 0L, false);
            cdl.add(cd);
        }
    }

    private Map<DistributedMember, Properties[]> getMemberPropsMap() throws SQLException {
        if (this.memberPropsMap == null) {
            try {
                GfxdVTITemplate.MemberSingleResultCollector collector = new GfxdVTITemplate.MemberSingleResultCollector();
                InternalDistributedMember myId = this.dm.getDistributionManagerId();
                GfxdConfigMessage msg = new GfxdConfigMessage(collector, Collections.singleton(myId), GfxdConfigMessage.Operation.GET_ALLPROPS, null, true);
                this.memberPropsMap = (Map)msg.executeFunction();
            }
            catch (Throwable t) {
                throw Util.javaException(t);
            }
        }
        return this.memberPropsMap;
    }
}

