/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ddl;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.Conflatable;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.shared.Version;
import com.pivotal.gemfirexd.internal.engine.GfxdDataSerializable;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdDDLPreprocess;
import com.pivotal.gemfirexd.internal.engine.ddl.ReplayableConflatable;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.AlterHDFSStoreConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.AlterTableConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ConstraintConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.CreateAliasConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.CreateConstraintConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.CreateHDFSStoreConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.CreateIndexConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.CreateSchemaConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.CreateTableConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DDLConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DropAliasConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DropConstraintConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DropSchemaConstantAction;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public final class DDLConflatable
extends GfxdDataSerializable
implements ReplayableConflatable,
GfxdDDLPreprocess {
    private static final long serialVersionUID = -7222789225768258894L;
    private static final byte HAS_AUTHID = 1;
    private static final byte HAS_AUTHID_IN_TABLE = 2;
    private static final byte HAS_ADDITIONAL_ARGS = 4;
    private static final byte IS_CREATE_TABLE = 8;
    private static final byte IS_DROP_TABLE = 16;
    private static final byte IS_ALTER_TABLE = 32;
    private static final byte IS_CREATE_INDEX = 64;
    private static final byte HAS_DDLID = -128;
    private static final byte PEEK_NONE = 0;
    private static final byte PEEK_EXECUTING = 1;
    private static final byte PEEK_SKIP = 2;
    private static final Pattern isCreateSchemaPattern = Pattern.compile("^\\s*CREATE\\s+SCHEMA\\s+.*$", 34);
    private boolean isDropStatement;
    private String fullTableName;
    private String defaultSchema;
    private String objectName;
    private String sqlText;
    private byte flags;
    private Object additionalArgs;
    private long ddlId;
    private volatile byte localState;
    private int additionalFlags;
    private String colocatedWithTable;
    private DDLConflatable implicitSchema;
    private long implicitSchemaSequenceId;
    private String tableName;
    private boolean isHDFSPersistent;
    private String hdfsStoreName;
    private short ddlVersion;
    private static final int F_HAS_COLOCATED_WITH = 1;
    private static final int F_HAS_IMPLICIT_SCHEMA = 2;
    private static final int F_IS_DROP_FK_CONSTRAINT = 4;
    private static final int F_IS_ADD_FK_CONSTRAINT = 8;
    private static final int F_DEFAULT_PERSISTENT = 16;
    private static final int F_METASTORE_IN_DD = 32;
    private String constraintName;
    private Set<String> droppedFKConstraints = null;
    private static final Version[] serializationVersions = new Version[]{Version.GFXD_1011, Version.GFXD_1302};

    public DDLConflatable() {
    }

    public DDLConflatable(String sqlText, String defaultSchema, DDLConstantAction constantAction, Object additionalArgs, DDLConflatable implicitSchema, long ddlId, boolean queueInitialized, LanguageConnectionContext lcc) {
        this.additionalFlags = 32;
        if (constantAction instanceof CreateTableConstantAction) {
            this.flags = GemFireXDUtils.set(this.flags, (byte)8);
            this.colocatedWithTable = ((CreateTableConstantAction)constantAction).getColocatedWithTable();
            if (this.colocatedWithTable != null) {
                this.additionalFlags = GemFireXDUtils.set(this.additionalFlags, 1);
            }
        }
        if (implicitSchema != null) {
            this.implicitSchema = implicitSchema;
            this.additionalFlags = GemFireXDUtils.set(this.additionalFlags, 2);
        }
        if (lcc != null && lcc.isDefaultPersistent()) {
            this.additionalFlags = GemFireXDUtils.set(this.additionalFlags, 16);
        }
        this.isDropStatement = constantAction.isDropStatement();
        if (constantAction instanceof AlterTableConstantAction && !((AlterTableConstantAction)constantAction).isTruncateTable()) {
            this.flags = GemFireXDUtils.set(this.flags, (byte)32);
            ConstraintConstantAction[] constraintConstantActions = ((AlterTableConstantAction)constantAction).getConstraintConstantActions();
            if (constraintConstantActions != null) {
                for (int i = 0; i < constraintConstantActions.length; ++i) {
                    ConstraintConstantAction c = constraintConstantActions[i];
                    if (c instanceof DropConstraintConstantAction && ((DropConstraintConstantAction)c).isForeignKeyConstraint()) {
                        this.additionalFlags = GemFireXDUtils.set(this.additionalFlags, 4);
                        this.constraintName = ((DropConstraintConstantAction)c).getConstraintName();
                        continue;
                    }
                    if (!(c instanceof CreateConstraintConstantAction) || ((CreateConstraintConstantAction)c).getConstraintType() != 6) continue;
                    this.additionalFlags = GemFireXDUtils.set(this.additionalFlags, 8);
                    this.constraintName = ((CreateConstraintConstantAction)c).getConstraintName();
                }
            }
        } else if (constantAction instanceof CreateIndexConstantAction) {
            this.flags = GemFireXDUtils.set(this.flags, (byte)64);
        }
        String schemaName = constantAction.getSchemaName();
        this.tableName = constantAction.getTableName();
        this.fullTableName = schemaName != null ? (this.tableName != null ? (this.tableName.indexOf(46) < 0 ? schemaName + '.' + this.tableName : this.tableName) : schemaName) : null;
        this.objectName = constantAction.getObjectName();
        if (this.isCreateTable()) {
            this.sqlText = ((CreateTableConstantAction)constantAction).getSQLTextForCTAS();
            if (this.sqlText != null && (GemFireXDUtils.TraceDDLQueue || GemFireXDUtils.TraceQuery)) {
                SanityManager.DEBUG_PRINT((String)"Info", (String)("DDLConflatable#ctor added internally generated sqlText for create table query. sqlText=" + ((CreateTableConstantAction)constantAction).getSQLTextForCTAS()));
            }
        }
        if (this.sqlText == null) {
            this.sqlText = sqlText;
        }
        this.defaultSchema = defaultSchema;
        if (additionalArgs != null) {
            this.additionalArgs = additionalArgs;
            this.flags = GemFireXDUtils.set(this.flags, (byte)4);
        }
        this.localState = (byte)(queueInitialized ? 0 : 2);
        this.ddlId = ddlId;
        this.isHDFSPersistent = this.checkifHDFSPersistent(constantAction);
        this.initDefaultFlags();
        this.ddlVersion = GemFireXDUtils.getCurrentDDLVersion().ordinal();
        assert (!this.isDropStatement || this.isDropStatement && constantAction.isDropIfExists() || this.fullTableName != null) : "Expected a non-null schema/table name when conflation is requested";
    }

    public boolean checkifHDFSPersistent(ConstantAction ddlAction) {
        if (ddlAction instanceof CreateTableConstantAction || ddlAction instanceof AlterTableConstantAction && !((AlterTableConstantAction)ddlAction).isTruncateTable() || ddlAction instanceof CreateAliasConstantAction || ddlAction instanceof DropAliasConstantAction || ddlAction instanceof DropSchemaConstantAction || ddlAction instanceof CreateSchemaConstantAction) {
            return true;
        }
        if (ddlAction instanceof CreateHDFSStoreConstantAction) {
            this.hdfsStoreName = ((CreateHDFSStoreConstantAction)ddlAction).getHDFSStoreName();
            return true;
        }
        if (ddlAction instanceof AlterHDFSStoreConstantAction) {
            this.hdfsStoreName = ((AlterHDFSStoreConstantAction)ddlAction).getHDFSStoreName();
            return true;
        }
        return false;
    }

    public boolean isHDFSPersistent() {
        return this.isHDFSPersistent;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getHDFSStoreName() {
        return this.hdfsStoreName;
    }

    private void initDefaultFlags() {
        this.flags = GemFireXDUtils.set(this.flags, (byte)1);
        this.flags = GemFireXDUtils.set(this.flags, (byte)-128);
    }

    public final boolean isCreateTable() {
        return GemFireXDUtils.isSet(this.flags, (byte)8);
    }

    public final boolean isDropStatement() {
        return this.isDropStatement;
    }

    public final boolean isAlterTable() {
        return GemFireXDUtils.isSet(this.flags, (byte)32);
    }

    public final boolean isAlterTableDropFKConstraint() {
        return GemFireXDUtils.isSet(this.additionalFlags, 4);
    }

    public final boolean isAlterTableAddFKConstraint() {
        return GemFireXDUtils.isSet(this.additionalFlags, 8);
    }

    public final boolean defaultPersistent() {
        return GemFireXDUtils.isSet(this.additionalFlags, 16);
    }

    public final boolean persistMetaStoreInDataDictionary() {
        return GemFireXDUtils.isSet(this.additionalFlags, 32);
    }

    public final boolean isCreateIndex() {
        return GemFireXDUtils.isSet(this.flags, (byte)64);
    }

    public boolean shouldBeConflated() {
        return this.isDropStatement;
    }

    public boolean shouldBeMerged() {
        return this.isAlterTableDropFKConstraint();
    }

    public boolean merge(Conflatable existing) {
        if (GemFireXDUtils.TraceConflation | DistributionManager.VERBOSE) {
            SanityManager.DEBUG_PRINT((String)"TraceConflation", (String)("DDLConflatable#merge called this=" + this + " existing conflatable=" + existing));
        }
        assert (((DDLConflatable)existing).isAlterTableDropFKConstraint());
        if (this.isCreateTable() || this.isAlterTableAddFKConstraint() && this.getConstraintName().equals(((DDLConflatable)existing).getConstraintName())) {
            this.addToDroppedFKConstraints(((DDLConflatable)existing).getConstraintName());
            return true;
        }
        return false;
    }

    public boolean shouldDelayRegionInitialization() {
        return GemFireXDUtils.isSet(this.flags, (byte)32);
    }

    public String getRegionToConflate() {
        return this.fullTableName;
    }

    public String getKeyToConflate() {
        return this.objectName;
    }

    public String getValueToConflate() {
        return this.sqlText;
    }

    public Object getAdditionalArgs() {
        return this.additionalArgs;
    }

    public long getId() {
        return this.ddlId;
    }

    public String getCurrentSchema() {
        if (GemFireXDUtils.isSet(this.flags, (byte)2)) {
            int dotIndex = this.fullTableName.indexOf(46);
            if (dotIndex == -1) {
                return this.fullTableName;
            }
            return this.fullTableName.substring(0, dotIndex);
        }
        return this.defaultSchema;
    }

    public String getSchemaForTable() {
        assert (this.isCreateTable() || this.isAlterTable());
        int dotIndex = this.fullTableName.indexOf(46);
        if (dotIndex == -1) {
            return null;
        }
        return this.fullTableName.substring(0, dotIndex);
    }

    public final String getColocatedWithTable() {
        return this.colocatedWithTable;
    }

    public final DDLConflatable getImplicitSchema() {
        return this.implicitSchema;
    }

    public final long getImplicitSchemaSequenceId() {
        return this.implicitSchemaSequenceId;
    }

    public final void setImplicitSchemaSequenceId(long sequenceId) {
        this.implicitSchemaSequenceId = sequenceId;
    }

    public void setLatestValue(Object value) {
        throw new AssertionError((Object)"DDLConflatable#setLatestValue: not expected to be invoked");
    }

    public EventID getEventId() {
        throw new AssertionError((Object)"DDLConflatable#getEventId: not expected to be invoked");
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public short getDDLVersion() {
        return this.ddlVersion;
    }

    @Override
    public final void markExecuting() {
        this.localState = (byte)(this.localState | 1);
    }

    @Override
    public final boolean isExecuting() {
        return (this.localState & 1) != 0;
    }

    @Override
    public final boolean skipInLocalExecution() {
        return (this.localState & 2) != 0;
    }

    private boolean hasAuthorizationId() {
        return GemFireXDUtils.isSet(this.flags, (byte)1);
    }

    public boolean isCreateSchemaText() {
        return isCreateSchemaPattern.matcher(this.sqlText).find();
    }

    @Override
    public boolean preprocess() {
        return this.isCreateSchemaText();
    }

    public int hashCode() {
        long id = this.ddlId;
        if (id != 0L) {
            return (int)(id ^ id >>> 32);
        }
        return this.sqlText.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof DDLConflatable) {
            DDLConflatable otherDDL = (DDLConflatable)other;
            if (this.ddlId != 0L && otherDDL.ddlId != 0L) {
                return this.ddlId == otherDDL.ddlId;
            }
            return this.sqlText.equals(otherDDL.sqlText);
        }
        return false;
    }

    public void addToDroppedFKConstraints(String fk) {
        if (this.droppedFKConstraints == null) {
            this.droppedFKConstraints = new HashSet<String>();
        }
        this.droppedFKConstraints.add(fk);
    }

    public Set<String> getDroppedFKConstraints() {
        return this.droppedFKConstraints;
    }

    @Override
    public void appendFields(StringBuilder sb) {
        sb.append(" [").append(this.ddlId).append(']');
        sb.append(" SQLText [").append(this.sqlText);
        sb.append("] fullTableName=").append(this.fullTableName);
        sb.append(";defaultSchema=").append(this.defaultSchema);
        sb.append(";objectName=").append(this.objectName);
        sb.append(";isCreateTable=").append(this.isCreateTable());
        sb.append(";isDropStatement=").append(this.isDropStatement());
        sb.append(";isAlterTable=").append(GemFireXDUtils.isSet(this.flags, (byte)32));
        sb.append(";isAlterTableDropFKConstraint=").append(this.isAlterTableDropFKConstraint());
        sb.append(";constraintName=").append(this.constraintName);
        sb.append(";droppedFKConstraints=").append(this.droppedFKConstraints);
        if (this.colocatedWithTable != null) {
            sb.append(";colocateWith=").append(this.colocatedWithTable);
        }
        if (this.implicitSchema != null) {
            sb.append(";implicitSchemaCreated=").append(this.implicitSchema.getRegionToConflate());
            sb.append(";implicitSchemaSequenceId=").append(this.implicitSchemaSequenceId);
        }
        sb.append(";flags=0x").append(Integer.toHexString(this.flags & 0xFF));
        sb.append(";additionalFlags=0x").append(Integer.toHexString(this.additionalFlags));
        if (this.additionalArgs != null) {
            sb.append(";additionalArgs=").append(this.additionalArgs);
        }
        sb.append(";skipLocalPeek=").append(this.localState);
        sb.append(";isHDFSPersistent=").append(this.isHDFSPersistent);
        sb.append(";hdfsstoreName=").append(this.hdfsStoreName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{DDLConflatable");
        this.appendFields(sb);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public byte getGfxdID() {
        return 82;
    }

    @Override
    public Version[] getSerializationVersions() {
        return serializationVersions;
    }

    private void toDataBase(DataOutput out) throws IOException {
        super.toData(out);
        out.writeBoolean(this.isDropStatement);
        DataSerializer.writeString((String)this.fullTableName, (DataOutput)out);
        DataSerializer.writeString((String)this.objectName, (DataOutput)out);
        DataSerializer.writeString((String)this.sqlText, (DataOutput)out);
        out.writeByte(this.flags);
        if (this.hasAuthorizationId()) {
            DataSerializer.writeString((String)this.defaultSchema, (DataOutput)out);
        }
        if (this.additionalArgs != null) {
            DataSerializer.writeObject((Object)this.additionalArgs, (DataOutput)out);
        }
        InternalDataSerializer.writeUnsignedVL((long)this.additionalFlags, (DataOutput)out);
        if (this.colocatedWithTable != null) {
            DataSerializer.writeString((String)this.colocatedWithTable, (DataOutput)out);
        }
        if (this.implicitSchema != null) {
            InternalDataSerializer.invokeToData((DataSerializableFixedID)this.implicitSchema, (DataOutput)out);
            out.writeLong(this.implicitSchemaSequenceId);
        }
        out.writeLong(this.ddlId);
        out.writeBoolean(this.isHDFSPersistent);
        if (this.isHDFSPersistent) {
            DataSerializer.writeString((String)this.tableName, (DataOutput)out);
            DataSerializer.writeString((String)this.hdfsStoreName, (DataOutput)out);
        }
    }

    private void checkAndSetPre1302HashingForTables() {
        ResolverUtils.setUsePre1302Hashing((boolean)true);
    }

    public void toDataPre_GFXD_1_0_1_1(DataOutput out) throws IOException {
        this.toDataBase(out);
        this.checkAndSetPre1302HashingForTables();
    }

    public void toDataPre_GFXD_1_3_0_2(DataOutput out) throws IOException {
        this.toDataPre_GFXD_1_0_1_1(out);
        if (this.isAlterTableDropFKConstraint() || this.isAlterTableAddFKConstraint()) {
            DataSerializer.writeString((String)this.constraintName, (DataOutput)out);
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        this.toDataBase(out);
        if (this.isAlterTableDropFKConstraint() || this.isAlterTableAddFKConstraint()) {
            DataSerializer.writeString((String)this.constraintName, (DataOutput)out);
        }
        out.writeShort(this.ddlVersion);
    }

    private void fromDataBase(DataInput in) throws IOException, ClassNotFoundException {
        Version v;
        super.fromData(in);
        byte b = in.readByte();
        boolean backward102case = false;
        switch (b) {
            case 0: {
                this.isDropStatement = false;
                break;
            }
            case 1: {
                this.isDropStatement = true;
                break;
            }
            default: {
                backward102case = true;
            }
        }
        this.fullTableName = backward102case ? InternalDataSerializer.readString((DataInput)in, (byte)b) : DataSerializer.readString((DataInput)in);
        this.objectName = DataSerializer.readString((DataInput)in);
        this.sqlText = DataSerializer.readString((DataInput)in);
        this.flags = in.readByte();
        if (backward102case) {
            boolean bl = this.isDropStatement = (this.flags & 0x10) != 0;
        }
        if (this.hasAuthorizationId()) {
            this.defaultSchema = DataSerializer.readString((DataInput)in);
        }
        if ((this.flags & 4) != 0) {
            this.additionalArgs = DataSerializer.readObject((DataInput)in);
        }
        if (Version.SQLF_1099.compareTo(v = InternalDataSerializer.getVersionForDataStream((DataInput)in)) <= 0) {
            this.additionalFlags = (int)InternalDataSerializer.readUnsignedVL((DataInput)in);
            if ((this.additionalFlags & 1) != 0) {
                this.colocatedWithTable = DataSerializer.readString((DataInput)in);
            }
            if ((this.additionalFlags & 2) != 0) {
                this.implicitSchema = new DDLConflatable();
                InternalDataSerializer.invokeFromData((DataSerializableFixedID)this.implicitSchema, (DataInput)in);
                this.implicitSchemaSequenceId = in.readLong();
            }
        }
        if ((this.flags & 0xFFFFFF80) != 0) {
            this.ddlId = in.readLong();
        }
        if (Version.GFXD_10.compareTo(v) <= 0) {
            this.isHDFSPersistent = in.readBoolean();
            if (this.isHDFSPersistent) {
                this.tableName = DataSerializer.readString((DataInput)in);
                this.hdfsStoreName = DataSerializer.readString((DataInput)in);
            }
        }
        this.ddlVersion = Version.GFXD_13.ordinal();
        this.initDefaultFlags();
    }

    public void fromDataPre_GFXD_1_0_1_1(DataInput in) throws IOException, ClassNotFoundException {
        this.fromDataBase(in);
        this.checkAndSetPre1302HashingForTables();
    }

    public void fromDataPre_GFXD_1_3_0_2(DataInput in) throws IOException, ClassNotFoundException {
        this.fromDataPre_GFXD_1_0_1_1(in);
        if (this.isAlterTableDropFKConstraint() || this.isAlterTableAddFKConstraint()) {
            this.constraintName = DataSerializer.readString((DataInput)in);
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.fromDataBase(in);
        if (this.isAlterTableDropFKConstraint() || this.isAlterTableAddFKConstraint()) {
            this.constraintName = DataSerializer.readString((DataInput)in);
        }
        this.ddlVersion = in.readShort();
        if (this.ddlVersion >= Version.GFXD_1302.ordinal()) {
            ResolverUtils.setUseGFXD1302Hashing((boolean)true);
        } else {
            this.checkAndSetPre1302HashingForTables();
        }
    }
}

