/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.jdbc;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.jdbc.ResourceAdapter;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleControl;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.access.AccessFactory;
import com.pivotal.gemfirexd.internal.iapi.store.access.xa.XAResourceManager;
import com.pivotal.gemfirexd.internal.iapi.store.access.xa.XAXactId;
import com.pivotal.gemfirexd.internal.jdbc.XATransactionState;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.transaction.xa.Xid;

public class ResourceAdapterImpl
implements ResourceAdapter,
ModuleControl {
    private boolean active;
    private XAResourceManager rm;
    private Hashtable connectionTable;

    @Override
    public void boot(boolean create, Properties properties) throws StandardException {
        this.connectionTable = new Hashtable();
        AccessFactory af = (AccessFactory)Monitor.findServiceModule(this, "com.pivotal.gemfirexd.internal.iapi.store.access.AccessFactory");
        this.rm = (XAResourceManager)af.getXAResourceManager();
        this.active = true;
    }

    @Override
    public void stop() {
        this.active = false;
        Enumeration e = this.connectionTable.elements();
        while (e.hasMoreElements()) {
            XATransactionState tranState = (XATransactionState)e.nextElement();
            try {
                tranState.conn.close();
            }
            catch (SQLException sQLException) {}
        }
        this.active = false;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public synchronized Object findConnection(XAXactId xid) {
        return this.connectionTable.get(xid);
    }

    @Override
    public synchronized boolean addConnection(XAXactId xid, Object conn) {
        if (this.connectionTable.get(xid) != null) {
            return false;
        }
        this.connectionTable.put(xid, conn);
        return true;
    }

    @Override
    public synchronized Object removeConnection(XAXactId xid) {
        return this.connectionTable.remove(xid);
    }

    @Override
    public XAResourceManager getXAResourceManager() {
        return this.rm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Xid[] recover(int flags) throws StandardException {
        Xid[] ret_xid_list;
        if ((flags & 0x1000000) != 0) {
            int i;
            XAXactId[] xid_list = new XAXactId[this.connectionTable.size()];
            int num_prepared = 0;
            Hashtable hashtable = this.connectionTable;
            synchronized (hashtable) {
                i = 0;
                Enumeration e = this.connectionTable.elements();
                while (e.hasMoreElements()) {
                    XATransactionState xaTxnState = (XATransactionState)e.nextElement();
                    if (xaTxnState.isPrepared()) {
                        xid_list[i] = xaTxnState.getXId();
                        ++num_prepared;
                    }
                    ++i;
                }
            }
            ret_xid_list = new XAXactId[num_prepared];
            int ret_index = 0;
            i = xid_list.length;
            while (i-- > 0) {
                if (xid_list[i] == null) continue;
                ret_xid_list[ret_index++] = xid_list[i];
            }
            SanityManager.ASSERT((ret_index == num_prepared ? 1 : 0) != 0);
        } else {
            ret_xid_list = new XAXactId[]{};
        }
        return ret_xid_list;
    }
}

