/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.access.sort;

import com.gemstone.gemfire.internal.util.Enumerator;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.SortObserver;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.ScanControllerRowSource;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.TransactionManager;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.store.access.sort.ArraySorter;
import com.pivotal.gemfirexd.internal.impl.store.access.sort.Scan;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;

public final class ArraySortScan
extends Scan
implements ScanControllerRowSource {
    protected Enumerator sortIterator;
    protected SortObserver sortObserver;
    protected ExecRow currentRow;
    protected final TransactionManager tran;
    protected final boolean hold;

    protected ArraySortScan(ArraySorter sort, TransactionManager tran, boolean hold) {
        this.sortIterator = sort.enumerator();
        this.sortObserver = sort.sortObserver;
        this.tran = tran;
        this.hold = hold;
    }

    @Override
    public boolean next() throws StandardException {
        Enumerator iter = this.sortIterator;
        if (iter != null) {
            try {
                ExecRow row = (ExecRow)iter.nextElement();
                if (row != null) {
                    this.currentRow = row;
                    return true;
                }
                this.currentRow = null;
                return false;
            }
            catch (GemFireXDRuntimeException re) {
                if (re.getCause() instanceof StandardException) {
                    throw (StandardException)re.getCause();
                }
                throw re;
            }
        }
        throw StandardException.newException("XJ012.S", "SortScan");
    }

    @Override
    public final boolean fetchNext(DataValueDescriptor[] row) throws StandardException {
        if (this.next()) {
            this.fetch(row);
            return true;
        }
        return false;
    }

    @Override
    public boolean fetchNext(ExecRow destRow) throws StandardException {
        if (this.next()) {
            this.fetch(destRow);
            return true;
        }
        return false;
    }

    @Override
    public final void fetch(DataValueDescriptor[] result) throws StandardException {
        ExecRow row = this.currentRow;
        if (row == null) {
            if (this.sortIterator != null) {
                throw StandardException.newException("XSAS1.S");
            }
            throw StandardException.newException("XJ012.S", "SortScan");
        }
        System.arraycopy(row.getRowArray(), 0, result, 0, result.length);
    }

    @Override
    public void fetch(ExecRow destRow) throws StandardException {
        ExecRow row = this.currentRow;
        if (row != null) {
            int nCols = destRow.nColumns();
            if (nCols == row.nColumns()) {
                destRow.setRowArray(row);
            } else {
                destRow.setColumns(nCols, row);
            }
        } else {
            if (this.sortIterator != null) {
                throw StandardException.newException("XSAS1.S");
            }
            throw StandardException.newException("XJ012.S", "SortScan");
        }
        destRow.setAllRegionAndKeyInfo(row.getAllRegionAndKeyInfo());
    }

    @Override
    public ExecRow fetchRow(ExecRow destRow) throws StandardException {
        ExecRow row = this.currentRow;
        if (row != null) {
            return row;
        }
        if (this.sortIterator != null) {
            throw StandardException.newException("XSAS1.S");
        }
        throw StandardException.newException("XJ012.S", "SortScan");
    }

    @Override
    public ExecRow getNextRowFromRowSource() throws StandardException {
        Enumerator iter = this.sortIterator;
        if (iter != null) {
            try {
                ExecRow row = (ExecRow)iter.nextElement();
                if (row != null) {
                    return row;
                }
                return null;
            }
            catch (GemFireXDRuntimeException re) {
                if (re.getCause() instanceof StandardException) {
                    throw (StandardException)re.getCause();
                }
                throw re;
            }
        }
        throw StandardException.newException("XJ012.S", "SortScan");
    }

    @Override
    public final void fetchWithoutQualify(DataValueDescriptor[] result) throws StandardException {
        throw StandardException.newException("XSAS0.S");
    }

    @Override
    public void fetchWithoutQualify(ExecRow destRow) throws StandardException {
        throw StandardException.newException("XSAS0.S");
    }

    @Override
    public void close() {
        this.sortIterator = null;
        this.sortObserver = null;
        this.currentRow = null;
        this.tran.closeMe(this);
    }

    @Override
    public boolean closeForEndTransaction(boolean closeHeldScan) throws StandardException {
        if (closeHeldScan || !this.hold) {
            this.close();
            return true;
        }
        return false;
    }

    @Override
    public boolean needsRowLocation() {
        return false;
    }

    @Override
    public boolean needsToClone() {
        return false;
    }

    @Override
    public void rowLocation(RowLocation rl) throws StandardException {
        SanityManager.THROWASSERT((String)"unexpected call to RowSource.rowLocation");
    }

    @Override
    public FormatableBitSet getValidColumns() {
        return null;
    }

    @Override
    public void closeRowSource() {
        this.close();
    }
}

