/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute.xplain;

import com.pivotal.gemfirexd.internal.catalog.SystemProcedures;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.procedure.cohort.OutgoingResultSetImpl;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireResultSet;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.ConnectionUtil;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.xplain.XPLAINFactoryIF;
import com.pivotal.gemfirexd.internal.impl.sql.execute.AbstractPolymorphicStatisticsCollector;
import com.pivotal.gemfirexd.internal.impl.sql.execute.BasicNoPutResultSetImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.NoRowsResultSetImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.StatementPlanCollector;
import com.pivotal.gemfirexd.internal.impl.sql.execute.StatementStatisticsCollector;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TemporaryRowHolderResultSet;
import java.sql.SQLException;

public class XPLAINFactory
implements XPLAINFactoryIF {
    private static final ResultSetStatisticsVisitor NO_OP = new NoOpCollector();
    private ResultSetStatisticsVisitor currentVisitor = null;
    private String currentSchema = null;

    @Override
    public ResultSetStatisticsVisitor getXPLAINVisitor(LanguageConnectionContext lcc, boolean statsEnabled, boolean explainConnection) throws StandardException {
        ResultSetStatisticsVisitor result = null;
        if (explainConnection) {
            result = new StatementPlanCollector(result);
        }
        if (statsEnabled) {
            result = new StatementStatisticsCollector(result);
        }
        if (result == null && !lcc.getRunTimeStatisticsModeExplicit()) {
            lcc.setRunTimeStatisticsMode(false, true);
            result = NO_OP;
        }
        if (GemFireXDUtils.TracePlanGeneration) {
            SanityManager.DEBUG_PRINT((String)"fine:TracePlanGeneration", (String)("XPLAINFacory: Returning with statistical visitor : " + result));
        }
        return result == null ? NO_OP : result;
    }

    @Override
    public void freeResources() {
        this.currentVisitor = null;
        this.currentSchema = null;
    }

    @Override
    public final synchronized void applyXPLAINMode(String key, Object value) throws StandardException {
        if (value != null) {
            if ("gemfirexd.distributedsystem.statement-statistics-mode".equals(key)) {
                this.constructVisitor(new StatementStatisticsCollector(this.currentVisitor));
            } else if ("gemfirexd.distributedsystem.statement-explain-mode".equals(key)) {
                if (this.currentSchema != null && this.currentSchema.equals(value.toString())) {
                    return;
                }
                this.currentSchema = value.toString();
                try {
                    SystemProcedures.SET_EXPLAIN_SCHEMA(ConnectionUtil.getCurrentLCC());
                }
                catch (SQLException e) {
                    throw StandardException.unexpectedUserException(e);
                }
                this.constructVisitor(new StatementPlanCollector(this.currentVisitor));
            }
        } else if ("gemfirexd.distributedsystem.statement-statistics-mode".equals(key)) {
            this.removeVisitor(StatementStatisticsCollector.class);
        } else if ("gemfirexd.distributedsystem.statement-explain-mode".equals(key)) {
            this.currentSchema = null;
            try {
                SystemProcedures.SET_EXPLAIN_SCHEMA(ConnectionUtil.getCurrentLCC());
            }
            catch (SQLException e) {
                throw StandardException.unexpectedUserException(e);
            }
            this.removeVisitor(StatementPlanCollector.class);
        }
    }

    private void constructVisitor(ResultSetStatisticsVisitor target) {
        ResultSetStatisticsVisitor current;
        Class<?> targetClass = target.getClass();
        for (current = this.currentVisitor; current != null && !targetClass.isInstance(current); current = current.getNextCollector()) {
        }
        if (current == null) {
            this.currentVisitor = target;
        }
    }

    private void removeVisitor(Class<? extends ResultSetStatisticsVisitor> target) {
        ResultSetStatisticsVisitor current;
        ResultSetStatisticsVisitor parent = null;
        for (current = this.currentVisitor; current != null && !target.isInstance(current); current = current.getNextCollector()) {
            parent = current;
        }
        if (current == null) {
            return;
        }
        if (parent != null) {
            parent.setNextCollector(current.getNextCollector());
        } else {
            this.currentVisitor = current.getNextCollector();
        }
    }

    private static class NoOpCollector
    extends AbstractPolymorphicStatisticsCollector {
        private NoOpCollector() {
        }

        @Override
        public void visitVirtual(NoRowsResultSetImpl rs) {
        }

        @Override
        public void visitVirtual(BasicNoPutResultSetImpl rs) {
        }

        @Override
        public void visitVirtual(AbstractGemFireResultSet rs) {
        }

        @Override
        public void visitVirtual(OutgoingResultSetImpl rs) {
        }

        @Override
        public void visitVirtual(TemporaryRowHolderResultSet rs) {
        }

        public Object clone() {
            return this;
        }

        @Override
        public final ResultSetStatisticsVisitor getClone() {
            return this;
        }
    }
}

