/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.internal.cache.TXState;
import com.pivotal.gemfirexd.internal.engine.distributed.message.RegionExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.RegionAndKey;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.sql.execute.BasicNoPutResultSetImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.NoPutResultSetImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;

class SetOpResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    private final NoPutResultSet leftSource;
    private final NoPutResultSet rightSource;
    private final Activation activation;
    private final int opType;
    private final boolean all;
    private final int resultSetNumber;
    private DataValueDescriptor[] prevCols;
    private int rightDuplicateCount;
    private ExecRow leftInputRow;
    private ExecRow rightInputRow;
    private boolean addRegionAndKey;
    private boolean consumeLeftInputRow;
    private boolean consumeRightInputRow;
    private boolean ignoreLeftSourceIfReplicate;
    private boolean ignoreRightSourceIfReplicate;
    private final int[] intermediateOrderByColumns;
    private final int[] intermediateOrderByDirection;
    private final boolean[] intermediateOrderByNullsLow;
    private int rowsSeenLeft;
    private int rowsSeenRight;
    private int rowsReturned;

    SetOpResultSet(NoPutResultSet leftSource, NoPutResultSet rightSource, Activation activation, int resultSetNumber, long optimizerEstimatedRowCount, double optimizerEstimatedCost, int opType, boolean all, int intermediateOrderByColumnsSavedObject, int intermediateOrderByDirectionSavedObject, int intermediateOrderByNullsLowSavedObject) {
        super(activation, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.leftSource = leftSource;
        this.rightSource = rightSource;
        this.activation = activation;
        this.resultSetNumber = resultSetNumber;
        this.opType = opType;
        this.all = all;
        this.intermediateOrderByColumns = (int[])activation.getSavedObject(intermediateOrderByColumnsSavedObject);
        this.intermediateOrderByDirection = (int[])activation.getSavedObject(intermediateOrderByDirectionSavedObject);
        this.intermediateOrderByNullsLow = (boolean[])activation.getSavedObject(intermediateOrderByNullsLowSavedObject);
        this.recordConstructorTime();
        this.printResultSetHierarchy();
    }

    @Override
    public void openCore() throws StandardException {
        FunctionContext fc;
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        SanityManager.ASSERT((!this.isOpen ? 1 : 0) != 0, (String)"SetOpResultSet already open");
        this.isOpen = true;
        this.leftSource.openCore();
        this.rightSource.openCore();
        this.initLocalTXState();
        if (this.lcc.isConnectionForRemote() && (fc = this.activation.getFunctionContext()) != null && !((RegionExecutorMessage)fc).allTablesAreReplicatedOnRemote()) {
            this.consumeLeftInputRow = true;
            this.consumeRightInputRow = true;
            if (!(fc instanceof RegionExecutorMessage)) {
                SanityManager.THROWASSERT((String)("Given FunctionContext is expected to be of type RegionExecutorMessage but got " + fc));
            }
            if (((RegionExecutorMessage)fc).doIgnoreReplicatesIfSetOperatorsOnRemote()) {
                SanityManager.ASSERT((boolean)(this.leftSource instanceof BasicNoPutResultSetImpl), (String)"Member 'leftSource' is expected to be of type BasicNoPutResultSetImpl");
                this.ignoreLeftSourceIfReplicate = ((BasicNoPutResultSetImpl)this.leftSource).isReplicateIfSetOpSupported();
                SanityManager.ASSERT((boolean)(this.rightSource instanceof BasicNoPutResultSetImpl), (String)"Member 'rightSource' is expected to be of type BasicNoPutResultSetImpl");
                this.ignoreRightSourceIfReplicate = ((BasicNoPutResultSetImpl)this.rightSource).isReplicateIfSetOpSupported();
            }
            this.addRegionAndKey = true;
        } else {
            this.rightInputRow = this.rightSource.getNextRowCore();
            if (this.rightInputRow != null) {
                ++this.rowsSeenRight;
            }
        }
        ++this.numOpens;
        if (this.statisticsTimingOn) {
            this.openTime += this.getElapsedNanos(this.beginTime);
        }
    }

    private ExecRow getNextRowCoreForRemote() throws StandardException {
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (this.isOpen) {
            if (this.consumeLeftInputRow && !this.ignoreLeftSourceIfReplicate) {
                this.leftInputRow = this.leftSource.getNextRowCore();
                if (this.leftInputRow != null) {
                    ++this.rowsSeenLeft;
                }
                this.consumeLeftInputRow = false;
            }
            if (this.consumeRightInputRow && !this.ignoreRightSourceIfReplicate) {
                this.rightInputRow = this.rightSource.getNextRowCore();
                if (this.rightInputRow != null) {
                    ++this.rowsSeenRight;
                }
                this.consumeRightInputRow = false;
            }
            if (this.leftInputRow != null) {
                if (this.rightInputRow != null && this.compare(this.leftInputRow.getRowArray(), this.rightInputRow.getRowArray()) > 0) {
                    this.setCurrentRow(this.rightInputRow);
                    this.updateCurrentRowWithRegionAndKey(false);
                    this.consumeRightInputRow = true;
                } else {
                    this.setCurrentRow(this.leftInputRow);
                    this.updateCurrentRowWithRegionAndKey(true);
                    this.consumeLeftInputRow = true;
                }
            } else if (this.rightInputRow != null) {
                this.setCurrentRow(this.rightInputRow);
                this.updateCurrentRowWithRegionAndKey(false);
                this.consumeRightInputRow = true;
            } else {
                this.setCurrentRow(null);
            }
        }
        if (this.currentRow != null) {
            ++this.rowsReturned;
        }
        if (this.statisticsTimingOn) {
            this.nextTime += this.getElapsedNanos(this.beginTime);
        }
        return this.currentRow;
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.lcc.isConnectionForRemote() && this.activation.getFunctionContext() != null && !((RegionExecutorMessage)this.activation.getFunctionContext()).allTablesAreReplicatedOnRemote()) {
            return this.getNextRowCoreForRemote();
        }
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (this.isOpen) {
            TXState localTXState = this.localTXState;
            while ((this.leftInputRow = this.leftSource.getNextRowCore()) != null) {
                ++this.rowsSeenLeft;
                DataValueDescriptor[] leftColumns = this.leftInputRow.getRowArray();
                if (!this.all) {
                    if (this.isDuplicate(leftColumns)) continue;
                    this.prevCols = this.leftInputRow.getRowArrayClone();
                }
                int compare = 0;
                while (this.rightInputRow != null && (compare = this.compare(leftColumns, this.rightInputRow.getRowArray())) > 0) {
                    this.rightSource.filteredRowLocationPostRead(localTXState);
                    this.rightInputRow = this.rightSource.getNextRowCore();
                    if (this.rightInputRow == null) continue;
                    ++this.rowsSeenRight;
                }
                if (this.rightInputRow == null || compare < 0) {
                    if (this.opType != 2) continue;
                    break;
                }
                SanityManager.ASSERT((this.rightInputRow != null && compare == 0 ? 1 : 0) != 0, (String)"Intersect/Except execution has gotten confused.");
                if (this.all) {
                    this.rightSource.filteredRowLocationPostRead(localTXState);
                    this.rightInputRow = this.rightSource.getNextRowCore();
                    if (this.rightInputRow != null) {
                        ++this.rowsSeenRight;
                    }
                }
                if (this.opType != 1) continue;
                break;
            }
        }
        this.setCurrentRow(this.leftInputRow);
        if (this.currentRow != null) {
            ++this.rowsReturned;
        }
        if (this.statisticsTimingOn) {
            this.nextTime += this.getElapsedNanos(this.beginTime);
        }
        return this.currentRow;
    }

    private void advanceRightPastDuplicates(DataValueDescriptor[] leftColumns) throws StandardException {
        while ((this.rightInputRow = this.rightSource.getNextRowCore()) != null) {
            ++this.rowsSeenRight;
            if (this.compare(leftColumns, this.rightInputRow.getRowArray()) != 0) continue;
        }
    }

    private int compare(DataValueDescriptor[] leftCols, DataValueDescriptor[] rightCols) throws StandardException {
        for (int i = 0; i < this.intermediateOrderByColumns.length; ++i) {
            int colIdx = this.intermediateOrderByColumns[i];
            if (leftCols[colIdx].compare(1, rightCols[colIdx], true, this.intermediateOrderByNullsLow[i], false)) {
                return -1 * this.intermediateOrderByDirection[i];
            }
            if (leftCols[colIdx].compare(2, rightCols[colIdx], true, this.intermediateOrderByNullsLow[i], false)) continue;
            return this.intermediateOrderByDirection[i];
        }
        return 0;
    }

    private boolean isDuplicate(DataValueDescriptor[] curColumns) throws StandardException {
        if (this.prevCols == null) {
            return false;
        }
        for (int i = 0; i < this.intermediateOrderByColumns.length; ++i) {
            int colIdx = this.intermediateOrderByColumns[i];
            if (curColumns[colIdx].compare(2, this.prevCols[colIdx], true, false)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ExecRow getCurrentRow() {
        return this.currentRow;
    }

    @Override
    public void close(boolean cleanupOnError) throws StandardException {
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (this.isOpen) {
            this.clearCurrentRow();
            this.prevCols = null;
            this.leftSource.close(cleanupOnError);
            this.rightSource.close(cleanupOnError);
            super.close(cleanupOnError);
        } else {
            SanityManager.DEBUG((String)"CloseRepeatInfo", (String)"Close of SetOpResultSet repeated");
        }
        if (this.statisticsTimingOn) {
            this.closeTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public void finish() throws StandardException {
        this.leftSource.finish();
        this.rightSource.finish();
        this.finishAndRTS();
    }

    @Override
    public final long getTimeSpent(int type, int timeType) {
        long time = PlanUtils.getTimeSpent(this.constructorTime, this.openTime, this.nextTime, this.closeTime, timeType);
        if (type == 0) {
            return time - this.leftSource.getTimeSpent(1, timeType) - this.rightSource.getTimeSpent(1, timeType);
        }
        return timeType == 0 ? time - this.constructorTime : time;
    }

    @Override
    public RowLocation getRowLocation() throws StandardException {
        return ((CursorResultSet)((Object)this.leftSource)).getRowLocation();
    }

    public int getOpType() {
        return this.opType;
    }

    public int getResultSetNumber() {
        return this.resultSetNumber;
    }

    public NoPutResultSet getLeftSourceInput() {
        return this.leftSource;
    }

    public NoPutResultSet getRightSourceInput() {
        return this.rightSource;
    }

    public int getRowsSeenLeft() {
        return this.rowsSeenLeft;
    }

    public int getRowsSeenRight() {
        return this.rowsSeenRight;
    }

    public int getRowsReturned() {
        return this.rowsReturned;
    }

    @Override
    public void updateRowLocationPostRead() throws StandardException {
        this.leftSource.updateRowLocationPostRead();
    }

    @Override
    public void filteredRowLocationPostRead(TXState localTXState) throws StandardException {
        this.leftSource.filteredRowLocationPostRead(localTXState);
    }

    @Override
    public void accept(ResultSetStatisticsVisitor visitor) {
        int noOfChildren = 0;
        if (this.leftSource != null) {
            ++noOfChildren;
        }
        if (this.rightSource != null) {
            ++noOfChildren;
        }
        visitor.setNumberOfChildren(noOfChildren);
        visitor.visit(this);
        if (this.leftSource != null) {
            this.leftSource.accept(visitor);
        }
        if (this.rightSource != null) {
            this.rightSource.accept(visitor);
        }
    }

    @Override
    public void resetStatistics() {
        this.rowsSeenLeft = 0;
        this.rowsSeenRight = 0;
        this.rowsReturned = 0;
        super.resetStatistics();
        this.leftSource.resetStatistics();
        this.rightSource.resetStatistics();
    }

    public final void updateCurrentRowWithRegionAndKey(boolean isLeftSideTreeOfSetOperatorNode) {
        if (this.currentRow == null) {
            SanityManager.THROWASSERT((String)"Set Operator handling: currentRow should not be null");
        }
        if (this.currentRow.getAllRegionAndKeyInfo() != null) {
            SanityManager.THROWASSERT((String)" Set Operator handling: currentRow should have no region and key information ");
        }
        if (this.addRegionAndKey) {
            this.currentRow.addRegionAndKey(isLeftSideTreeOfSetOperatorNode ? RegionAndKey.TRUE : RegionAndKey.FALSE);
        }
    }

    @Override
    public StringBuilder buildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
        super.buildQueryPlan(builder, context);
        String operator = this.opType == 1 ? (this.all ? "INTERSECTALL" : "INTERSECT") : (this.all ? "EXCEPTALL" : "EXCEPT");
        PlanUtils.xmlAttribute(builder, "operator", operator);
        PlanUtils.xmlTermTag(builder, context, "EXCEPT");
        if (this.leftSource != null) {
            this.leftSource.buildQueryPlan(builder, context.pushContext());
        }
        if (this.rightSource != null) {
            PlanUtils.xmlAddTag(builder, context, "setop");
            this.rightSource.buildQueryPlan(builder, context.pushContext());
        }
        PlanUtils.xmlCloseTag(builder, context, this);
        return builder;
    }

    @Override
    public void printResultSetHierarchy() {
        if (GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("ResultSet Created: " + this.getClass().getSimpleName() + " with resultSetNumber=" + this.resultSetNumber + " with left-source = " + (this.leftSource != null ? this.leftSource.getClass().getSimpleName() : null) + " and left-source ResultSetNumber = " + (this.leftSource != null ? this.leftSource.resultSetNumber() : -1) + " with right-source = " + (this.rightSource != null ? this.rightSource.getClass().getSimpleName() : null) + " and right-source ResultSetNumber = " + (this.rightSource != null ? this.rightSource.resultSetNumber() : -1)));
        }
    }
}

