/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.ServerGroupUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecIndexRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.DataDictionaryImpl;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.TabInfoImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DDLConstantAction;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.util.List;
import java.util.Set;

public class DropGatewaySenderConstantAction
extends DDLConstantAction {
    final String id;
    final boolean onlyIfExists;

    DropGatewaySenderConstantAction(String id, boolean onlyIfExists) {
        this.id = id;
        this.onlyIfExists = onlyIfExists;
    }

    @Override
    public boolean isDropIfExists() {
        return this.onlyIfExists;
    }

    @Override
    public final String getSchemaName() {
        return "SYS";
    }

    @Override
    public final String getTableName() {
        return "__GFXD_INTERNAL_GATEWAYSENDER_" + this.id;
    }

    @Override
    public final boolean isDropStatement() {
        return true;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        int rowsDeleted = 0;
        if (!ServerGroupUtils.isDataStore()) {
            return;
        }
        List<GemFireContainer> containers = Misc.getMemStore().getAllContainers();
        for (GemFireContainer container : containers) {
            Set senderIds;
            if (container.getRegion() == null || !container.isApplicationTable() || (senderIds = container.getRegionAttributes().getGatewaySenderIds()) == null || senderIds.isEmpty() || !senderIds.contains(this.id)) continue;
            throw StandardException.newException("X0Y25.S", "DROP", (Object)("GatewaySender " + this.id), (Object)"table", (Object)container.getQualifiedTableName());
        }
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionaryImpl dd = (DataDictionaryImpl)lcc.getDataDictionary();
        TransactionController tc = lcc.getTransactionExecute();
        dd.startWriting(lcc);
        ExecIndexRow keyRow = dd.getExecutionFactory().getIndexableRow(1);
        TabInfoImpl ti = dd.getNonCoreTI(21);
        keyRow.setColumn(1, new SQLVarchar(this.id));
        rowsDeleted = ti.deleteRow(tc, keyRow, 0);
        if (rowsDeleted == 0) {
            if (this.onlyIfExists) {
                return;
            }
            throw StandardException.newException("42Y55", (Object)"DROP GATEWAYSENDER", (Object)this.id);
        }
        SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)("DropGatewaySender:: removed GatewaySender " + this.id + " from SYS table"));
        GatewaySender sender = Misc.getGemFireCache().getGatewaySender(this.id);
        if (sender != null) {
            try {
                Misc.getGemFireCache().removeGatewaySender(sender);
                sender.destroy();
            }
            catch (Exception ex) {
                throw StandardException.newException("X0Z22.S", ex, (Object)this.id, (Object)ex.toString());
            }
        }
    }

    @Override
    public boolean isCancellable() {
        return false;
    }

    public String toString() {
        return this.constructToString("DROP GATEWAYSENDER ", this.id);
    }
}

