/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.types.UserDataValue;
import com.pivotal.gemfirexd.internal.impl.sql.execute.BasicSortObserver;
import com.pivotal.gemfirexd.internal.impl.sql.execute.GenericAggregator;

public class AggregateSortObserver
extends BasicSortObserver {
    protected GenericAggregator[] aggsToProcess;
    protected GenericAggregator[] aggsToInitialize;
    private int firstAggregatorColumn;

    public AggregateSortObserver(boolean doClone, GenericAggregator[] aggsToProcess, GenericAggregator[] aggsToInitialize, ExecRow execRow) {
        super(doClone, false, execRow, true);
        this.aggsToProcess = aggsToProcess;
        this.aggsToInitialize = aggsToInitialize;
        SanityManager.ASSERT((aggsToInitialize != null ? 1 : 0) != 0, (String)"aggsToInitialize argument to AggregateSortObserver is null");
        SanityManager.ASSERT((aggsToProcess != null ? 1 : 0) != 0, (String)"aggsToProcess argument to AggregateSortObserver is null");
        if (aggsToInitialize.length > 0) {
            this.firstAggregatorColumn = aggsToInitialize[0].aggregatorColumnId;
        }
    }

    @Override
    public ExecRow insertNonDuplicateKey(ExecRow insertRow) throws StandardException {
        ExecRow returnRow = super.insertNonDuplicateKey(insertRow);
        if (this.aggsToInitialize.length > 0 && returnRow.isNull(this.firstAggregatorColumn + 1) == -7L) {
            for (int i = 0; i < this.aggsToInitialize.length; ++i) {
                GenericAggregator aggregator = this.aggsToInitialize[i];
                UserDataValue wrapper = (UserDataValue)returnRow.getColumn(aggregator.aggregatorColumnId + 1);
                if (!wrapper.isNull()) {
                    SanityManager.THROWASSERT((String)("during aggregate initialization, all wrappers expected to be empty; however, the wrapper for the following aggregate was not empty:" + aggregator + ".  The value stored is " + wrapper.getObject()));
                }
                wrapper.setValue(aggregator.getAggregatorInstance());
                aggregator.accumulate(returnRow, returnRow);
            }
        }
        return returnRow;
    }

    @Override
    public ExecRow insertDuplicateKey(ExecRow insertRow, ExecRow existingRow) throws StandardException {
        if (this.aggsToProcess.length == 0) {
            return null;
        }
        for (int i = 0; i < this.aggsToProcess.length; ++i) {
            GenericAggregator aggregator = this.aggsToProcess[i];
            if (insertRow.isNull(aggregator.getColumnId() + 1) == -7L) {
                aggregator.accumulate(insertRow, existingRow);
                continue;
            }
            aggregator.merge(insertRow, existingRow);
        }
        return null;
    }

    @Override
    public boolean eliminateDuplicate(Object insertRow, Object existingRow) {
        try {
            return this.insertDuplicateKey((ExecRow)insertRow, (ExecRow)existingRow) == null;
        }
        catch (StandardException se) {
            throw new GemFireXDRuntimeException(se);
        }
    }

    @Override
    public boolean canSkipDuplicate() {
        return true;
    }
}

