/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.catalog.types.DefaultInfoImpl;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Parser;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DefaultDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CursorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromBaseTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.RowResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.StatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import java.util.Vector;

public class DefaultNode
extends ValueNode {
    private String columnName;
    private String defaultText;
    private ValueNode defaultTree;

    @Override
    public void init(Object defaultTree, Object defaultText) {
        this.defaultTree = (ValueNode)defaultTree;
        this.defaultText = (String)defaultText;
    }

    @Override
    public void init(Object columnName) {
        this.columnName = (String)columnName;
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    ValueNode getDefaultTree() {
        return this.defaultTree;
    }

    @Override
    public String toString() {
        return "defaultTree: " + this.defaultTree + "\ndefaultText: " + this.defaultText + "\n" + super.toString();
    }

    @Override
    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        TableDescriptor td;
        ColumnDescriptor cd;
        SanityManager.ASSERT((fromList.size() != 0 ? 1 : 0) != 0, (String)"fromList expected to be non-empty");
        if (!(fromList.elementAt(0) instanceof FromBaseTable)) {
            SanityManager.THROWASSERT((String)("fromList.elementAt(0) expected to be instanceof FromBaseTable, not " + fromList.elementAt(0).getClass().getName()));
        }
        SanityManager.ASSERT(((cd = (td = ((FromBaseTable)fromList.elementAt(0)).getTableDescriptor()).getColumnDescriptor(this.columnName)) != null ? 1 : 0) != 0, (String)"cd expected to be non-null");
        DefaultInfoImpl defaultInfo = (DefaultInfoImpl)cd.getDefaultInfo();
        if (defaultInfo != null) {
            String defaultText = defaultInfo.getDefaultText();
            ValueNode defaultTree = DefaultNode.parseDefault(defaultText, this.getLanguageConnectionContext(), this.getCompilerContext());
            DefaultDescriptor defaultDescriptor = cd.getDefaultDescriptor(this.getDataDictionary());
            this.getCompilerContext().createDependency(defaultDescriptor);
            return defaultTree.bindExpression(fromList, subqueryList, aggregateVector);
        }
        ValueNode nullNode = (ValueNode)this.getNodeFactory().getNode(13, this.getContextManager());
        return nullNode;
    }

    public static ValueNode parseDefault(String defaultText, LanguageConnectionContext lcc, CompilerContext cc) throws StandardException {
        CursorNode cn;
        String values = "VALUES " + defaultText;
        CompilerContext newCC = lcc.pushCompilerContext();
        if (cc.isPreparedStatement()) {
            newCC.setPreparedStatement();
        }
        newCC.allowOptimizeLiteral(false);
        Parser p = newCC.getParser();
        StatementNode qt = p.parseStatement(values);
        if (!(qt instanceof CursorNode)) {
            SanityManager.THROWASSERT((String)("qt expected to be instanceof CursorNode, not " + qt.getClass().getName()));
        }
        if (!((cn = (CursorNode)qt).getResultSetNode() instanceof RowResultSetNode)) {
            SanityManager.THROWASSERT((String)("cn.getResultSetNode() expected to be instanceof RowResultSetNode, not " + cn.getResultSetNode().getClass().getName()));
        }
        ValueNode defaultTree = ((ResultColumn)((CursorNode)qt).getResultSetNode().getResultColumns().elementAt(0)).getExpression();
        lcc.popCompilerContext(newCC);
        return defaultTree;
    }

    @Override
    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.THROWASSERT((String)"generateExpression not expected to be called");
    }

    @Override
    protected boolean isEquivalent(ValueNode other) {
        return false;
    }
}

