/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ComparisonQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoContext;
import com.pivotal.gemfirexd.internal.engine.sql.compile.ParameterizedConstantNode;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizable;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.iapi.util.JBitSet;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BaseTableNumbersVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BinaryComparisonOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BinaryOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BooleanConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CastNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromBaseTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.InListOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.NcjPullScanNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ParameterNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.RelationalOperator;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UnaryOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.VirtualColumnNode;

public class BinaryRelationalOperatorNode
extends BinaryComparisonOperatorNode
implements RelationalOperator {
    private int operatorType;
    private BaseTableNumbersVisitor btnVis;
    JBitSet optBaseTables;
    JBitSet valNodeBaseTables;
    private InListOperatorNode inListProbeSource = null;
    protected static final int LEFT = -1;
    protected static final int NEITHER = 0;
    protected static final int RIGHT = 1;

    @Override
    public void init(Object leftOperand, Object rightOperand) {
        String methodName = "";
        String operatorName = "";
        switch (this.getNodeType()) {
            case 41: {
                methodName = "equals";
                operatorName = "=";
                this.operatorType = 1;
                break;
            }
            case 42: {
                methodName = "greaterOrEquals";
                operatorName = ">=";
                this.operatorType = 4;
                break;
            }
            case 43: {
                methodName = "greaterThan";
                operatorName = ">";
                this.operatorType = 3;
                break;
            }
            case 44: {
                methodName = "lessOrEquals";
                operatorName = "<=";
                this.operatorType = 6;
                break;
            }
            case 45: {
                methodName = "lessThan";
                operatorName = "<";
                this.operatorType = 5;
                break;
            }
            case 47: {
                methodName = "notEquals";
                operatorName = "<>";
                this.operatorType = 2;
                break;
            }
            default: {
                SanityManager.THROWASSERT((String)("init for BinaryRelationalOperator called with wrong nodeType = " + this.getNodeType()));
            }
        }
        super.init(leftOperand, rightOperand, operatorName, methodName);
        this.btnVis = null;
    }

    @Override
    public void init(Object leftOperand, Object rightOperand, Object inListOp) {
        this.init(leftOperand, rightOperand);
        this.inListProbeSource = (InListOperatorNode)inListOp;
    }

    protected InListOperatorNode getInListOp() {
        if (this.inListProbeSource != null) {
            this.inListProbeSource.setLeftOperand(this.leftOperand);
        }
        return this.inListProbeSource;
    }

    @Override
    public ColumnReference getColumnOperand(Optimizable optTable, int columnPosition) {
        ColumnReference cr;
        FromTable ft = (FromTable)optTable;
        boolean walkSubtree = true;
        if (this.leftOperand instanceof ColumnReference) {
            cr = (ColumnReference)this.leftOperand;
            if (this.valNodeReferencesOptTable(cr, ft, false, walkSubtree) && cr.getSource().getColumnPosition() == columnPosition) {
                return cr;
            }
            walkSubtree = false;
        }
        if (this.rightOperand instanceof ColumnReference && this.valNodeReferencesOptTable(cr = (ColumnReference)this.rightOperand, ft, false, walkSubtree) && cr.getSource().getColumnPosition() == columnPosition) {
            return cr;
        }
        return null;
    }

    @Override
    public ValueNode getOtherOperand(ValueNode thisOperand) {
        if (this.rightOperand == thisOperand) {
            return this.leftOperand;
        }
        if (this.leftOperand == thisOperand) {
            return this.rightOperand;
        }
        return null;
    }

    @Override
    public ColumnReference getColumnOperand(Optimizable optTable) {
        ColumnReference cr;
        boolean walkSubtree = true;
        if (this.leftOperand instanceof ColumnReference) {
            cr = (ColumnReference)this.leftOperand;
            if (this.valNodeReferencesOptTable(cr, (FromTable)optTable, false, walkSubtree)) {
                return cr;
            }
            walkSubtree = false;
        }
        if (this.rightOperand instanceof ColumnReference && this.valNodeReferencesOptTable(cr = (ColumnReference)this.rightOperand, (FromTable)optTable, false, walkSubtree)) {
            return cr;
        }
        return null;
    }

    @Override
    public ValueNode getExpressionOperand(int tableNumber, int columnPosition, FromTable ft) {
        ColumnReference cr;
        boolean walkSubtree = true;
        if (this.leftOperand instanceof ColumnReference) {
            cr = (ColumnReference)this.leftOperand;
            if (this.valNodeReferencesOptTable(cr, ft, false, walkSubtree) && cr.getSource().getColumnPosition() == columnPosition) {
                return this.rightOperand;
            }
            walkSubtree = false;
        }
        if (this.rightOperand instanceof ColumnReference && this.valNodeReferencesOptTable(cr = (ColumnReference)this.rightOperand, ft, false, walkSubtree) && cr.getSource().getColumnPosition() == columnPosition) {
            return this.leftOperand;
        }
        return null;
    }

    @Override
    public ValueNode getOperand(ColumnReference cRef, int refSetSize, boolean otherSide) {
        this.initBaseTableVisitor(refSetSize, true);
        try {
            ColumnReference cr;
            this.btnVis.setTableMap(this.optBaseTables);
            cRef.accept(this.btnVis);
            this.btnVis.setTableMap(this.valNodeBaseTables);
            if (this.leftOperand instanceof ColumnReference) {
                cr = (ColumnReference)this.leftOperand;
                cr.accept(this.btnVis);
                this.valNodeBaseTables.and(this.optBaseTables);
                if (this.valNodeBaseTables.getFirstSetBit() != -1 && cr.getSource().getColumnPosition() == cRef.getColumnNumber()) {
                    if (otherSide) {
                        return this.rightOperand;
                    }
                    return this.leftOperand;
                }
            }
            if (this.rightOperand instanceof ColumnReference) {
                this.valNodeBaseTables.clearAll();
                cr = (ColumnReference)this.rightOperand;
                cr.accept(this.btnVis);
                this.valNodeBaseTables.and(this.optBaseTables);
                if (this.valNodeBaseTables.getFirstSetBit() != -1 && cr.getSource().getColumnPosition() == cRef.getColumnNumber()) {
                    if (otherSide) {
                        return this.leftOperand;
                    }
                    return this.rightOperand;
                }
            }
        }
        catch (StandardException se) {
            SanityManager.THROWASSERT((String)"Failed when trying to find base table number for column reference check:", (Throwable)se);
        }
        return null;
    }

    @Override
    public void generateExpressionOperand(Optimizable optTable, int columnPosition, ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.ASSERT((boolean)(optTable instanceof FromBaseTable));
        FromBaseTable ft = (FromBaseTable)optTable;
        ValueNode exprOp = this.getExpressionOperand(ft.getTableNumber(), columnPosition, ft);
        if (exprOp == null) {
            SanityManager.THROWASSERT((String)("ColumnReference for correct column (columnPosition = " + columnPosition + ", exposed table name = " + ft.getExposedName() + ") not found on either side of BinaryRelationalOperator"));
        }
        exprOp.generateExpression(acb, mb);
    }

    @Override
    public boolean selfComparison(ColumnReference cr) throws StandardException {
        ValueNode otherSide;
        if (this.leftOperand == cr) {
            otherSide = this.rightOperand;
        } else if (this.rightOperand == cr) {
            otherSide = this.leftOperand;
        } else {
            otherSide = null;
            SanityManager.THROWASSERT((String)"ColumnReference not found on either side of binary comparison.");
        }
        JBitSet tablesReferenced = otherSide.getTablesReferenced();
        return tablesReferenced.get(cr.getTableNumber());
    }

    @Override
    public boolean usefulStartKey(Optimizable optTable) {
        int columnSide = this.columnOnOneSide(optTable);
        if (columnSide == 0) {
            return false;
        }
        return this.usefulStartKey(columnSide == -1);
    }

    protected boolean keyColumnOnLeft(Optimizable optTable) {
        ColumnReference cr;
        boolean left = false;
        if (this.leftOperand instanceof ColumnReference && this.valNodeReferencesOptTable(cr = (ColumnReference)this.leftOperand, (FromTable)optTable, false, true)) {
            left = true;
        }
        if (!left) {
            SanityManager.ASSERT((this.rightOperand instanceof ColumnReference && this.valNodeReferencesOptTable((ColumnReference)this.rightOperand, (FromTable)optTable, false, true) ? 1 : 0) != 0, (String)"Key column not found on either side.");
        }
        return left;
    }

    protected int columnOnOneSide(Optimizable optTable) {
        ColumnReference cr;
        boolean left = false;
        boolean walkSubtree = true;
        if (this.leftOperand instanceof ColumnReference) {
            cr = (ColumnReference)this.leftOperand;
            if (this.valNodeReferencesOptTable(cr, (FromTable)optTable, false, walkSubtree)) {
                return -1;
            }
            walkSubtree = false;
        }
        if (this.rightOperand instanceof ColumnReference && this.valNodeReferencesOptTable(cr = (ColumnReference)this.rightOperand, (FromTable)optTable, false, walkSubtree)) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean usefulStopKey(Optimizable optTable) {
        int columnSide = this.columnOnOneSide(optTable);
        if (columnSide == 0) {
            return false;
        }
        return this.usefulStopKey(columnSide == -1);
    }

    private ColumnReference getColumnReference(Optimizable optTable) {
        ColumnReference cr = this.keyColumnOnLeft(optTable) ? (ColumnReference)this.leftOperand : (ColumnReference)this.rightOperand;
        return cr;
    }

    @Override
    public void generateAbsoluteColumnId(MethodBuilder mb, Optimizable optTable) {
        int columnPosition = this.getAbsoluteColumnPosition(optTable);
        ColumnReference columnRef = this.getColumnReference(optTable);
        String columnName = columnRef.getColumnName();
        mb.push(columnPosition);
        mb.push(columnName);
    }

    @Override
    public void generateRelativeColumnId(MethodBuilder mb, Optimizable optTable) {
        ColumnReference columnRef = this.getColumnReference(optTable);
        int columnPosition = this.getAbsoluteColumnPosition(optTable);
        columnPosition = optTable.convertAbsoluteToRelativeColumnPosition(columnPosition, columnRef);
        String columnName = columnRef.getColumnName();
        mb.push(columnPosition);
        mb.push(columnName);
    }

    private int getAbsoluteColumnPosition(Optimizable optTable) {
        ConglomerateDescriptor bestCD = null;
        ColumnReference cr = this.keyColumnOnLeft(optTable) ? (ColumnReference)this.leftOperand : (ColumnReference)this.rightOperand;
        if (optTable.getTrulyTheBestAccessPath() != null) {
            bestCD = optTable.getTrulyTheBestAccessPath().getConglomerateDescriptor();
        }
        int columnPosition = cr.getSource().getColumnPosition();
        if (this.getCompilerContext().isNCJoinOnRemote() && optTable instanceof NcjPullScanNode && ((NcjPullScanNode)optTable).isAtSecondPosition()) {
            bestCD = null;
        }
        if (bestCD != null && bestCD.isIndex()) {
            columnPosition = bestCD.getIndexDescriptor().getKeyColumnPosition(columnPosition);
            SanityManager.ASSERT((columnPosition > 0 ? 1 : 0) != 0, (String)"Base column not found in index");
        }
        return columnPosition - 1;
    }

    @Override
    public void generateQualMethod(ExpressionClassBuilder acb, MethodBuilder mb, Optimizable optTable) throws StandardException {
        MethodBuilder qualMethod = acb.newUserExprFun();
        if (this.keyColumnOnLeft(optTable)) {
            this.rightOperand.generateExpression(acb, qualMethod);
        } else {
            this.leftOperand.generateExpression(acb, qualMethod);
        }
        qualMethod.methodReturn();
        qualMethod.complete();
        acb.pushMethodReference(mb, qualMethod);
    }

    @Override
    public void generateOrderedNulls(MethodBuilder mb) {
        mb.push(false);
    }

    @Override
    public boolean orderedNulls() {
        return false;
    }

    @Override
    public boolean isQualifier(Optimizable optTable, boolean forPush) throws StandardException {
        if (this.isInListProbeNode()) {
            return false;
        }
        ValueNode otherSide = null;
        ColumnReference cr = null;
        boolean found = false;
        boolean walkSubtree = true;
        FromTable ft = (FromTable)optTable;
        if (this.leftOperand instanceof ColumnReference) {
            cr = (ColumnReference)this.leftOperand;
            if (this.valNodeReferencesOptTable(cr, ft, forPush, walkSubtree)) {
                otherSide = this.rightOperand;
                found = true;
            }
            walkSubtree = false;
        }
        if (!found && this.rightOperand instanceof ColumnReference && this.valNodeReferencesOptTable(cr = (ColumnReference)this.rightOperand, ft, forPush, walkSubtree)) {
            otherSide = this.leftOperand;
            found = true;
        }
        if (!found) {
            return false;
        }
        return !this.valNodeReferencesOptTable(otherSide, ft, forPush, true);
    }

    @Override
    public int getOrderableVariantType(Optimizable optTable) throws StandardException {
        if (this.keyColumnOnLeft(optTable)) {
            return this.rightOperand.getOrderableVariantType();
        }
        return this.leftOperand.getOrderableVariantType();
    }

    @Override
    public boolean compareWithKnownConstant(Optimizable optTable, boolean considerParameters) {
        ValueNode node = null;
        ValueNode valueNode = node = this.keyColumnOnLeft(optTable) ? this.rightOperand : this.leftOperand;
        if (considerParameters) {
            return node instanceof ConstantNode || node instanceof ParameterizedConstantNode || node.requiresTypeFromContext() && ((ParameterNode)node).getDefaultValue() != null;
        }
        return node instanceof ConstantNode;
    }

    @Override
    public boolean compareWithParameterNode(Optimizable optTable) {
        ValueNode node = null;
        node = this.keyColumnOnLeft(optTable) ? this.rightOperand : this.leftOperand;
        return node.requiresTypeFromContext();
    }

    @Override
    public DataValueDescriptor getCompareValue(Optimizable optTable) throws StandardException {
        ValueNode node = null;
        ValueNode valueNode = node = this.keyColumnOnLeft(optTable) ? this.rightOperand : this.leftOperand;
        if (node instanceof ConstantNode) {
            return ((ConstantNode)node).getValue();
        }
        if (node.requiresTypeFromContext()) {
            if (node instanceof UnaryOperatorNode) {
                ValueNode pn = ((UnaryOperatorNode)node).getParameterOperand();
                if (pn instanceof ParameterNode) {
                    return ((ParameterNode)pn).getDefaultValue();
                }
                if (pn instanceof ParameterizedConstantNode) {
                    return ((ParameterizedConstantNode)pn).constantNode().getValue();
                }
            } else {
                if (node instanceof ParameterNode) {
                    return ((ParameterNode)node).getDefaultValue();
                }
                if (node instanceof ParameterizedConstantNode) {
                    return ((ParameterizedConstantNode)node).constantNode().getValue();
                }
            }
        } else {
            return null;
        }
        return null;
    }

    protected double booleanSelectivity(Optimizable optTable) throws StandardException {
        TypeId typeId = null;
        double retval = -1.0;
        int columnSide = this.columnOnOneSide(optTable);
        if (columnSide == -1) {
            typeId = this.leftOperand.getTypeId();
        } else if (columnSide == 1) {
            typeId = this.rightOperand.getTypeId();
        }
        if (typeId != null && (typeId.getJDBCTypeId() == -7 || typeId.getJDBCTypeId() == 16)) {
            retval = 0.5;
        }
        return retval;
    }

    @Override
    public String getReceiverInterfaceName() {
        return "com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor";
    }

    @Override
    BinaryOperatorNode getNegation(ValueNode leftOperand, ValueNode rightOperand) throws StandardException {
        SanityManager.ASSERT((this.getTypeServices() != null ? 1 : 0) != 0, (String)"dataTypeServices is expected to be non-null");
        BinaryOperatorNode negation = (BinaryOperatorNode)this.getNodeFactory().getNode(this.getNegationNode(), leftOperand, rightOperand, this.getContextManager());
        negation.setType(this.getTypeServices());
        return negation;
    }

    private int getNegationNode() {
        switch (this.getNodeType()) {
            case 41: {
                return 47;
            }
            case 42: {
                return 45;
            }
            case 43: {
                return 44;
            }
            case 45: {
                return 42;
            }
            case 44: {
                return 43;
            }
            case 47: {
                return 41;
            }
        }
        SanityManager.THROWASSERT((String)("getNegationNode called with invalid nodeType: " + this.getNodeType()));
        return -1;
    }

    protected boolean usefulStartKey(boolean columnOnLeft) {
        switch (this.operatorType) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 3: 
            case 4: {
                return columnOnLeft;
            }
            case 5: 
            case 6: {
                return !columnOnLeft;
            }
        }
        return false;
    }

    protected boolean usefulStopKey(boolean columnOnLeft) {
        switch (this.operatorType) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 3: 
            case 4: {
                return !columnOnLeft;
            }
            case 5: 
            case 6: {
                return columnOnLeft;
            }
        }
        return false;
    }

    @Override
    public int getStartOperator(Optimizable optTable) {
        switch (this.operatorType) {
            case 1: 
            case 4: 
            case 6: {
                return 1;
            }
            case 3: 
            case 5: {
                return -1;
            }
            case 2: {
                SanityManager.THROWASSERT((String)"!= cannot be a start operator");
                return 0;
            }
        }
        return 0;
    }

    @Override
    public int getStopOperator(Optimizable optTable) {
        switch (this.operatorType) {
            case 1: 
            case 4: 
            case 6: {
                return -1;
            }
            case 3: 
            case 5: {
                return 1;
            }
            case 2: {
                SanityManager.THROWASSERT((String)"!= cannot be a stop operator");
                return 0;
            }
        }
        return 0;
    }

    @Override
    public void generateOperator(MethodBuilder mb, Optimizable optTable) {
        switch (this.operatorType) {
            case 1: {
                mb.push(2);
                break;
            }
            case 2: {
                mb.push(2);
                break;
            }
            case 4: 
            case 5: {
                mb.push(this.keyColumnOnLeft(optTable) ? 1 : 3);
                break;
            }
            case 3: 
            case 6: {
                mb.push(this.keyColumnOnLeft(optTable) ? 3 : 1);
            }
        }
    }

    @Override
    public void generateNegate(MethodBuilder mb, Optimizable optTable) {
        switch (this.operatorType) {
            case 1: {
                mb.push(false);
                break;
            }
            case 2: {
                mb.push(true);
                break;
            }
            case 5: 
            case 6: {
                mb.push(!this.keyColumnOnLeft(optTable));
                break;
            }
            case 3: 
            case 4: {
                mb.push(this.keyColumnOnLeft(optTable));
            }
        }
    }

    @Override
    public int getOperator() {
        return this.operatorType;
    }

    @Override
    public double selectivity(Optimizable optTable) throws StandardException {
        double retval = this.booleanSelectivity(optTable);
        if (retval >= 0.0) {
            return retval;
        }
        switch (this.operatorType) {
            case 1: {
                return 0.1;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                if (this.getBetweenSelectivity()) {
                    return 0.5;
                }
            }
            case 3: {
                return 0.33;
            }
        }
        return 0.0;
    }

    @Override
    public RelationalOperator getTransitiveSearchClause(ColumnReference otherCR) throws StandardException {
        return (RelationalOperator)((Object)this.getNodeFactory().getNode(this.getNodeType(), otherCR, this.rightOperand, this.getContextManager()));
    }

    @Override
    public boolean equalsComparisonWithConstantExpression(Optimizable optTable) {
        if (this.operatorType != 1) {
            return false;
        }
        boolean retval = false;
        Object comparand = null;
        int side = this.columnOnOneSide(optTable);
        if (side == -1) {
            retval = this.rightOperand.isConstantExpression();
        } else if (side == 1) {
            retval = this.leftOperand.isConstantExpression();
        }
        return retval;
    }

    @Override
    public boolean isRelationalOperator() {
        return !this.isInListProbeNode();
    }

    @Override
    public boolean isBinaryEqualsOperatorNode() {
        return !this.isInListProbeNode() && this.operatorType == 1;
    }

    @Override
    public boolean isInListProbeNode() {
        return this.inListProbeSource != null;
    }

    @Override
    public boolean optimizableEqualityNode(Optimizable optTable, int columnNumber, boolean isNullOkay) throws StandardException {
        if (this.operatorType != 1) {
            return false;
        }
        if (this.isInListProbeNode()) {
            return false;
        }
        ColumnReference cr = this.getColumnOperand(optTable, columnNumber);
        if (cr == null) {
            return false;
        }
        if (this.selfComparison(cr)) {
            return false;
        }
        return !this.implicitVarcharComparison();
    }

    private boolean implicitVarcharComparison() throws StandardException {
        TypeId leftType = this.leftOperand.getTypeId();
        TypeId rightType = this.rightOperand.getTypeId();
        if (leftType.isStringTypeId() && !rightType.isStringTypeId()) {
            return true;
        }
        return rightType.isStringTypeId() && !leftType.isStringTypeId();
    }

    @Override
    public ValueNode genSQLJavaSQLTree() throws StandardException {
        if (this.operatorType == 1) {
            return this;
        }
        return super.genSQLJavaSQLTree();
    }

    public ValueNode getScopedOperand(int whichSide, JBitSet parentRSNsTables, ResultSetNode childRSN, int[] whichRC) throws StandardException {
        ResultColumn rc = null;
        ColumnReference cr = whichSide == -1 ? (ColumnReference)this.leftOperand : (ColumnReference)this.rightOperand;
        JBitSet crTables = new JBitSet(parentRSNsTables.size());
        BaseTableNumbersVisitor btnVis = new BaseTableNumbersVisitor(crTables);
        cr.accept(btnVis);
        if (!parentRSNsTables.contains(crTables)) {
            return cr.getClone();
        }
        if (whichRC[0] == -1) {
            int[] sourceColPos = new int[]{-1};
            ResultSetNode sourceRSN = cr.getSourceResultSet(sourceColPos);
            SanityManager.ASSERT((sourceRSN != null ? 1 : 0) != 0, (String)("Failed to find source result set when trying to scope column reference '" + cr.getTableName() + "." + cr.getColumnName()));
            rc = childRSN.getResultColumns().getResultColumn(sourceColPos[0], sourceRSN, whichRC);
        } else {
            rc = childRSN.getResultColumns().getResultColumn(whichRC[0]);
        }
        SanityManager.ASSERT((rc != null ? 1 : 0) != 0, (String)("Failed to locate scope target result column when trying to scope operand '" + cr.getTableName() + "." + cr.getColumnName() + "'."));
        if (rc.getExpression() instanceof ColumnReference) {
            ColumnReference cRef = (ColumnReference)((ColumnReference)rc.getExpression()).getClone();
            cRef.markAsScoped();
            return cRef;
        }
        return rc.getExpression();
    }

    public boolean valNodeReferencesOptTable(ValueNode valNode, FromTable optTable, boolean forPush, boolean walkOptTableSubtree) {
        this.initBaseTableVisitor(optTable.getReferencedTableMap().size(), walkOptTableSubtree);
        boolean found = false;
        try {
            if (walkOptTableSubtree) {
                this.buildTableNumList(optTable, forPush);
            }
            this.btnVis.setTableMap(this.valNodeBaseTables);
            valNode.accept(this.btnVis);
            this.valNodeBaseTables.and(this.optBaseTables);
            found = this.valNodeBaseTables.getFirstSetBit() != -1;
        }
        catch (StandardException se) {
            SanityManager.THROWASSERT((String)"Failed when trying to find base table numbers for reference check:", (Throwable)se);
        }
        return found;
    }

    private void initBaseTableVisitor(int numTablesInQuery, boolean initOptBaseTables) {
        if (this.valNodeBaseTables == null) {
            this.valNodeBaseTables = new JBitSet(numTablesInQuery);
        } else {
            this.valNodeBaseTables.clearAll();
        }
        if (initOptBaseTables) {
            if (this.optBaseTables == null) {
                this.optBaseTables = new JBitSet(numTablesInQuery);
            } else {
                this.optBaseTables.clearAll();
            }
        }
        if (this.btnVis == null) {
            this.btnVis = new BaseTableNumbersVisitor(this.valNodeBaseTables);
        }
    }

    private void buildTableNumList(FromTable ft, boolean forPush) throws StandardException {
        if (ft.getTableNumber() >= 0) {
            this.optBaseTables.set(ft.getTableNumber());
        }
        if (forPush) {
            return;
        }
        this.optBaseTables.or(ft.getReferencedTableMap());
        this.btnVis.setTableMap(this.optBaseTables);
        ft.accept(this.btnVis);
    }

    @Override
    public QueryInfo computeQueryInfo(QueryInfoContext qic) throws StandardException {
        if (this.inListProbeSource != null) {
            return this.inListProbeSource.computeQueryInfo(qic);
        }
        if (this.leftOperand instanceof VirtualColumnNode || this.rightOperand instanceof VirtualColumnNode || this.leftOperand instanceof CastNode || this.rightOperand instanceof CastNode) {
            return null;
        }
        return new ComparisonQueryInfo(this.leftOperand.computeQueryInfo(qic), this.rightOperand.computeQueryInfo(qic), this.operatorType);
    }

    @Override
    public String printExplainInfo() {
        String explainString = "(" + this.leftOperand.printExplainInfo() + " " + this.operator;
        explainString = this.inListProbeSource != null ? explainString + " " + this.inListProbeSource.printExplainInfo() : explainString + " " + this.rightOperand.printExplainInfo() + ")";
        return explainString;
    }

    public int columnOnOneSide(FromTable optTable) {
        return 0;
    }

    @Override
    public int setColocatedWith(Optimizable src, Optimizable tgt, JBitSet srcPCols, JBitSet tgtPCols) throws StandardException {
        if (this.operatorType != 1) {
            return -1;
        }
        JBitSet srcCols = new JBitSet(srcPCols.size());
        JBitSet tgtCols = new JBitSet(tgtPCols.size());
        int leftRet = this.leftOperand.setColocatedWith(src, tgt, srcCols, tgtCols);
        assert (srcCols.isEmpty() || tgtCols.isEmpty()) : "Only one table's partitioning information is expected to be set. srcCols=" + srcCols + " tgt=" + tgtCols;
        if (leftRet == 0 || leftRet == -1) {
            return leftRet;
        }
        if (this.rightOperand instanceof BooleanConstantNode) {
            return leftRet;
        }
        int rightRet = this.rightOperand.setColocatedWith(src, tgt, srcCols, tgtCols);
        if (rightRet == 0 || rightRet == -1) {
            return rightRet;
        }
        if (srcCols.equals(tgtCols)) {
            srcPCols.or(srcCols);
            tgtPCols.or(tgtCols);
            return 1;
        }
        if (leftRet == 3 && rightRet == 3) {
            srcPCols.or(srcCols);
            tgtPCols.or(tgtCols);
            return 2;
        }
        return 0;
    }

    @Override
    public String ncjGenerateSql() {
        if (this.inListProbeSource != null) {
            return this.inListProbeSource.ncjGenerateSql();
        }
        return super.ncjGenerateSql();
    }
}

