/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.services.uuid;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.uuid.UUIDFactory;
import com.pivotal.gemfirexd.internal.impl.services.uuid.BasicUUID;

public final class BasicUUIDFactory
implements UUIDFactory {
    private long majorId;
    private long timemillis;
    private static final long MODULUS = 0x100000000L;
    private static final long MULTIPLIER = 16385L;
    private static final long STEP = 0x8000001L;
    private static final long INITIAL_VALUE = 2551218188L;
    private long currentValue;

    public BasicUUIDFactory() {
        Object env = Monitor.getMonitor().getEnvironment();
        if (env != null) {
            String s = env.toString();
            if (s != null) {
                env = s;
            }
            this.majorId = env.hashCode();
        } else {
            this.majorId = Runtime.getRuntime().freeMemory();
        }
        this.majorId &= 0xFFFFFFFFFFFFL;
        this.resetCounters();
    }

    @Override
    public synchronized UUID createUUID() {
        this.currentValue = (16385L * this.currentValue + 0x8000001L) % 0x100000000L;
        long cv = this.currentValue;
        if (cv == 2551218188L) {
            this.bumpMajor();
        }
        int sequence = (int)cv;
        return new BasicUUID(this.majorId, this.timemillis, sequence);
    }

    @Override
    public synchronized UUID createUUID(long baseid, int sequence) {
        return new BasicUUID(baseid, -1L, sequence);
    }

    @Override
    public UUID recreateUUID(String uuidstring) {
        return new BasicUUID(uuidstring);
    }

    @Override
    public UUID recreateUUID(byte[] b) {
        return new BasicUUID(b);
    }

    private void bumpMajor() {
        this.majorId = this.majorId + 1L & 0xFFFFFFFFFFFFL;
        if (this.majorId == 0L) {
            this.resetCounters();
        }
    }

    private void resetCounters() {
        this.timemillis = System.currentTimeMillis();
        this.currentValue = 2551218188L;
    }
}

